/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.components.net;

import com.cognos.org.apache.axis.AxisProperties;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.components.net.SecureSocketFactory;
import com.cognos.org.apache.axis.components.net.SocketFactory;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class SocketFactoryFactory {
    protected static Log log = LogFactory.getLog(SocketFactoryFactory.class.getName());
    private static Hashtable factories = new Hashtable();
    private static final Class[] classes = new Class[]{Hashtable.class};

    public static synchronized SocketFactory getFactory(String protocol, Hashtable attributes) {
        SocketFactory theFactory = (SocketFactory)factories.get(protocol);
        if (theFactory == null) {
            Object[] objects = new Object[]{attributes};
            if (protocol.equalsIgnoreCase("http")) {
                theFactory = (SocketFactory)AxisProperties.newInstance(SocketFactory.class, classes, objects);
            } else if (protocol.equalsIgnoreCase("https")) {
                theFactory = (SecureSocketFactory)AxisProperties.newInstance(SecureSocketFactory.class, classes, objects);
            }
            if (theFactory != null) {
                factories.put(protocol, theFactory);
            }
        }
        return theFactory;
    }

    static {
        AxisProperties.setClassOverrideProperty(SocketFactory.class, "com.cognos.axis.socketFactory");
        AxisProperties.setClassDefault(SocketFactory.class, "com.cognos.org.apache.axis.components.net.DefaultSocketFactory");
        AxisProperties.setClassOverrideProperty(SecureSocketFactory.class, "com.cognos.axis.socketSecureFactory");
        AxisProperties.setClassDefault(SecureSocketFactory.class, "com.cognos.org.apache.axis.components.net.JSSESocketFactory");
    }
}

