/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.components.uuid;

import com.cognos.org.apache.axis.components.uuid.UUIDGen;
import com.cognos.org.apache.axis.i18n.Messages;

public abstract class UUIDGenFactory {
    private static final String defaultUUIDGenClassName = "com.cognos.org.apache.axis.components.uuid.SimpleUUIDGen";

    public static UUIDGen getUUIDGen(String uuidgenClassName) {
        UUIDGen uuidgen = null;
        if (uuidgenClassName == null || uuidgenClassName.length() == 0) {
            uuidgenClassName = defaultUUIDGenClassName;
        }
        Class<?> uuidgenClass = null;
        try {
            uuidgenClass = Class.forName(uuidgenClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.getMessage("uuidGenFactoryCNFE00", uuidgenClassName));
        }
        try {
            uuidgen = (UUIDGen)uuidgenClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getMessage("uuidGenFactoryException02", uuidgenClass.getName(), e.getMessage()));
        }
        return uuidgen;
    }

    public static void destroyUUIDGen(UUIDGen uuidgen) {
        if (uuidgen != null) {
            uuidgen.destroy();
        }
    }
}

