/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.configuration;

import com.cognos.org.apache.axis.AxisProperties;
import com.cognos.org.apache.axis.ConfigurationException;
import com.cognos.org.apache.axis.EngineConfiguration;
import com.cognos.org.apache.axis.EngineConfigurationFactory;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.configuration.EngineConfigurationFactoryDefault;
import com.cognos.org.apache.axis.configuration.FileProvider;
import com.cognos.org.apache.axis.server.AxisServer;
import com.cognos.org.apache.axis.utils.ClassUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.io.File;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryServlet
extends EngineConfigurationFactoryDefault {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryServlet.class.getName());
    private ServletContext ctx;

    public static EngineConfigurationFactory newFactory(Object param) {
        return param instanceof ServletContext ? new EngineConfigurationFactoryServlet((ServletContext)param) : null;
    }

    protected EngineConfigurationFactoryServlet(ServletContext ctx) {
        this.ctx = ctx;
    }

    public EngineConfiguration getServerEngineConfig() {
        return EngineConfigurationFactoryServlet.getServerEngineConfig(this.ctx);
    }

    private static EngineConfiguration getServerEngineConfig(ServletContext ctx) {
        String configFile = AxisProperties.getProperty("axis.ServerConfigFile");
        if (configFile == null) {
            configFile = "server-config.wsdd";
        }
        String appWebInfPath = "/WEB-INF";
        FileProvider config = null;
        String realWebInfPath = ctx.getRealPath(appWebInfPath);
        if (realWebInfPath == null || !new File(realWebInfPath, configFile).exists()) {
            String name = appWebInfPath + "/" + configFile;
            InputStream is = ctx.getResourceAsStream(name);
            if (is != null) {
                config = new FileProvider(is);
            }
            if (config == null) {
                log.error((Object)Messages.getMessage("servletEngineWebInfError03", name));
            }
        }
        if (config == null && realWebInfPath != null) {
            try {
                config = new FileProvider(realWebInfPath, configFile);
            }
            catch (ConfigurationException e) {
                log.error((Object)Messages.getMessage("servletEngineWebInfError00"), (Throwable)e);
            }
        }
        if (config == null) {
            log.warn((Object)Messages.getMessage("servletEngineWebInfWarn00"));
            try {
                InputStream is = ClassUtils.getResourceAsStream(AxisServer.class, "server-config.wsdd");
                config = new FileProvider(is);
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("servletEngineWebInfError02"), (Throwable)e);
            }
        }
        return config;
    }
}

