/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.deployment.wsdd;

import com.cognos.org.apache.axis.ConfigurationException;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.deployment.wsdd.WSDDConstants;
import com.cognos.org.apache.axis.deployment.wsdd.WSDDDeployment;
import com.cognos.org.apache.axis.deployment.wsdd.WSDDException;
import com.cognos.org.apache.axis.deployment.wsdd.WSDDUndeployment;
import com.cognos.org.apache.axis.encoding.SerializationContext;
import com.cognos.org.apache.axis.encoding.SerializationContextImpl;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.utils.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument
extends WSDDConstants {
    protected static Log log = LogFactory.getLog(WSDDDocument.class.getName());
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;

    public WSDDDocument() {
    }

    public WSDDDocument(Document doc) throws WSDDException {
        this.doc = doc;
        Element docEl = doc.getDocumentElement();
        if ("undeployment".equals(docEl.getLocalName())) {
            this.undeployment = new WSDDUndeployment(docEl);
        } else {
            this.deployment = new WSDDDeployment(docEl);
        }
    }

    public WSDDDocument(Element e) throws WSDDException {
        this.doc = e.getOwnerDocument();
        if ("undeployment".equals(e.getLocalName())) {
            this.undeployment = new WSDDUndeployment(e);
        } else {
            this.deployment = new WSDDDeployment(e);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws ConfigurationException {
        StringWriter writer = new StringWriter();
        SerializationContextImpl context = new SerializationContextImpl(writer, null);
        context.setPretty(true);
        try {
            this.deployment.writeToContext(context);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
        }
        try {
            writer.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(writer.getBuffer().toString())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        this.getDeployment().writeToContext(context);
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.deployment = null;
    }

    public void deploy(WSDDDeployment registry) throws ConfigurationException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(registry);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(registry);
        }
    }
}

