/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding;

import com.cognos.org.apache.axis.AxisEngine;
import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.Message;
import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.attachments.Attachments;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.description.OperationDesc;
import com.cognos.org.apache.axis.description.TypeDesc;
import com.cognos.org.apache.axis.encoding.DefaultTypeMappingImpl;
import com.cognos.org.apache.axis.encoding.SerializationContext;
import com.cognos.org.apache.axis.encoding.Serializer;
import com.cognos.org.apache.axis.encoding.SerializerFactory;
import com.cognos.org.apache.axis.encoding.SimpleValueSerializer;
import com.cognos.org.apache.axis.encoding.TypeMapping;
import com.cognos.org.apache.axis.encoding.TypeMappingImpl;
import com.cognos.org.apache.axis.encoding.TypeMappingRegistry;
import com.cognos.org.apache.axis.encoding.ser.BaseSerializerFactory;
import com.cognos.org.apache.axis.enum.Use;
import com.cognos.org.apache.axis.handlers.soap.SOAPService;
import com.cognos.org.apache.axis.schema.SchemaVersion;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.types.HexBinary;
import com.cognos.org.apache.axis.utils.IDKey;
import com.cognos.org.apache.axis.utils.Mapping;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.utils.NSStack;
import com.cognos.org.apache.axis.utils.XMLUtils;
import com.cognos.org.apache.axis.wsdl.symbolTable.SchemaUtils;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContextImpl
implements SerializationContext {
    protected static Log log = LogFactory.getLog(SerializationContextImpl.class.getName());
    private NSStack nsStack = new NSStack();
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private boolean startOfDocument = true;
    private Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private QName currentXMLType;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private boolean pretty = false;
    private static QName multirefQName = new QName("", "multiRef");
    private static Class[] getSerializerClasses = new Class[]{String.class, Class.class, QName.class};
    private boolean doMultiRefs = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private boolean sendMinimizedElements = true;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private boolean noNamespaceMappings = true;
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    HashMap preferredPrefixes = new HashMap();

    public SerializationContextImpl(Writer writer) {
        this.writer = writer;
        this.initialize();
    }

    private void initialize() {
        this.preferredPrefixes.put(this.soapConstants.getEncodingURI(), "soapenc");
        this.preferredPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.preferredPrefixes.put(this.schemaVersion.getXsdURI(), "xsd");
        this.preferredPrefixes.put(this.schemaVersion.getXsiURI(), "xsi");
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext) {
        this.writer = writer;
        this.msgContext = msgContext;
        AxisEngine optionSource = null;
        if (msgContext != null) {
            OperationDesc operation;
            Boolean opt;
            Boolean shouldSendMinimized;
            Boolean shouldSendMultiRefs;
            this.soapConstants = msgContext.getSOAPConstants();
            if (optionSource == null) {
                optionSource = msgContext.getAxisEngine();
            }
            this.schemaVersion = msgContext.getSchemaVersion();
            Boolean shouldSendDecl = (Boolean)optionSource.getOption("sendXMLDeclaration");
            if (shouldSendDecl != null) {
                this.sendXMLDecl = shouldSendDecl;
            }
            if ((shouldSendMultiRefs = (Boolean)msgContext.getProperty("sendMultiRefs")) == null) {
                shouldSendMultiRefs = (Boolean)optionSource.getOption("sendMultiRefs");
            }
            if (shouldSendMultiRefs != null) {
                this.doMultiRefs = shouldSendMultiRefs;
            }
            if ((shouldSendMinimized = (Boolean)optionSource.getOption("axis.sendMinimizedElements")) != null) {
                this.sendMinimizedElements = shouldSendMinimized;
            }
            if (!msgContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((opt = (Boolean)optionSource.getOption("sendXsiTypes")) != null && opt.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            if ((operation = msgContext.getOperation()) != null) {
                if (operation.getUse() != Use.ENCODED) {
                    this.sendXSIType = false;
                    this.doMultiRefs = false;
                }
            } else {
                SOAPService service = msgContext.getService();
                if (service != null && service.getUse() != Use.ENCODED) {
                    this.sendXSIType = false;
                    this.doMultiRefs = false;
                }
            }
        }
        this.initialize();
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public boolean getDoMultiRefs() {
        return this.doMultiRefs;
    }

    public void setDoMultiRefs(boolean shouldDo) {
        this.doMultiRefs = shouldDo;
    }

    public void setSendDecl(boolean sendDecl) {
        this.sendXMLDecl = sendDecl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.getSingleton();
        }
        String encodingStyle = this.msgContext.getEncodingStyle();
        if (encodingStyle == null) {
            encodingStyle = this.soapConstants.getEncodingURI();
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        return this.getPrefixForURI(uri, defaultPrefix, false);
    }

    public String getPrefixForURI(String uri, String defaultPrefix, boolean attribute) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.nsStack.getPrefix(uri, attribute);
        if (prefix == null) {
            prefix = (String)this.preferredPrefixes.get(uri);
            if (prefix == null) {
                prefix = defaultPrefix == null ? "ns" + this.lastPrefixIndex++ : defaultPrefix;
            }
            this.registerPrefixForURI(prefix, uri);
        }
        return prefix;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("register00", prefix, uri));
        }
        if (uri != null && prefix != null) {
            if (this.noNamespaceMappings) {
                this.nsStack.push();
                this.noNamespaceMappings = false;
            }
            this.nsStack.add(uri, prefix);
        }
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String qName2String(QName qName, boolean writeNS) {
        String prefix = null;
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceURI.length() == 0) {
            String defaultNS;
            if (writeNS && (defaultNS = this.nsStack.getNamespaceURI("")) != null && defaultNS.length() > 0) {
                this.registerPrefixForURI("", "");
            }
        } else {
            prefix = this.getPrefixForURI(namespaceURI);
        }
        if (prefix == null || prefix.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(':');
        sb.append(qName.getLocalPart());
        return sb.toString();
    }

    public String qName2String(QName qName) {
        return this.qName2String(qName, false);
    }

    public String attributeQName2String(QName qName) {
        String prefix = null;
        if (qName.getNamespaceURI().length() > 0) {
            prefix = this.getPrefixForURI(qName.getNamespaceURI(), null, true);
        }
        if (prefix == null || prefix.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(':');
        sb.append(qName.getLocalPart());
        return sb.toString();
    }

    public QName getQNameForClass(Class cls) {
        return this.getTypeMapping().getTypeQName(cls);
    }

    public boolean isPrimitive(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> javaType = value.getClass();
        if (javaType.isPrimitive()) {
            return true;
        }
        if (javaType == String.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (HexBinary.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (Element.class.isAssignableFrom(javaType)) {
            return true;
        }
        if (javaType == [B.class) {
            return true;
        }
        if (javaType.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(javaType);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && SchemaUtils.isSimpleSchemaType(qName);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value) throws IOException {
        this.serialize(elemQName, attributes, value, null, true, null);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, boolean sendNull, Boolean sendType) throws IOException {
        Attachments attachments;
        boolean shouldSendType;
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value == null) {
            if (sendNull) {
                AttributesImpl attrs = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attrs.setAttributes(attributes);
                }
                if (shouldSendType) {
                    attrs = (AttributesImpl)this.setTypeAttribute(attrs, xmlType);
                }
                String nil = this.schemaVersion.getNilQName().getLocalPart();
                attrs.addAttribute(this.schemaVersion.getXsiURI(), nil, "xsi:" + nil, "CDATA", "true");
                this.startElement(elemQName, attrs);
                this.endElement();
            }
            return;
        }
        Message msg = this.getCurrentMessage();
        if (null != msg && null != (attachments = this.getCurrentMessage().getAttachmentsImpl()) && attachments.isAttachment(value)) {
            this.serializeActual(elemQName, attributes, value, xmlType, sendType);
            return;
        }
        if (this.doMultiRefs && (this.msgContext == null || this.msgContext.isEncoded()) && value != this.forceSer && !this.isPrimitive(value)) {
            String id;
            MultiRefItem mri;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((mri = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(value))) == null) {
                ++this.multiRefIndex;
                id = "id" + this.multiRefIndex;
                mri = new MultiRefItem(id, xmlType, sendType, value);
                this.multiRefValues.put(this.getIdentityKey(value), mri);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attrs = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attrs.setAttributes(attributes);
                    }
                    attrs.addAttribute("", "id", "id", "CDATA", id);
                    this.serializeActual(elemQName, attrs, value, xmlType, sendType);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(value));
                }
            } else {
                id = mri.id;
            }
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("", this.soapConstants.getAttrHref(), this.soapConstants.getAttrHref(), "CDATA", '#' + id);
            this.startElement(elemQName, attrs);
            this.endElement();
            return;
        }
        if (value == this.forceSer) {
            this.forceSer = null;
        }
        this.serializeActual(elemQName, attributes, value, xmlType, sendType);
    }

    private IDKey getIdentityKey(Object value) {
        return new IDKey(value);
    }

    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "", "", "", "");
        String encodingURI = this.soapConstants.getEncodingURI();
        String prefix = this.getPrefixForURI(encodingURI);
        String root = prefix + ":root";
        attrs.addAttribute(encodingURI, "root", root, "CDATA", "0");
        String encodingStyle = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        String encStyle = this.getPrefixForURI(this.soapConstants.getEnvelopeURI()) + ':' + "encodingStyle";
        attrs.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", encStyle, "CDATA", encodingStyle);
        HashSet keys = new HashSet();
        keys.addAll(this.multiRefValues.keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            while (i.hasNext()) {
                Object val = i.next();
                MultiRefItem mri = (MultiRefItem)this.multiRefValues.get(val);
                attrs.setAttribute(0, "", "id", "id", "CDATA", mri.id);
                this.forceSer = mri.value;
                this.serialize(multirefQName, attrs, mri.value, mri.xmlType, true, Boolean.TRUE);
            }
            if (this.secondLevelObjects == null) continue;
            i = this.secondLevelObjects.iterator();
            this.secondLevelObjects = null;
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        ArrayList<String> vecQNames = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        String elementQName = this.qName2String(qName, true);
        this.writer.write(60);
        this.writer.write(elementQName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qname = attributes.getQName(i);
                this.writer.write(32);
                String prefix = "";
                String uri = attributes.getURI(i);
                if (uri != null && uri.length() > 0) {
                    if (qname.length() == 0) {
                        prefix = this.getPrefixForURI(uri);
                    } else {
                        int idx = qname.indexOf(58);
                        if (idx > -1) {
                            prefix = qname.substring(0, idx);
                            prefix = this.getPrefixForURI(uri, prefix, true);
                        }
                    }
                    qname = prefix.length() > 0 ? prefix + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    qname = attributes.getQName(i);
                    if (qname.length() == 0) {
                        qname = attributes.getLocalName(i);
                    }
                }
                if (qname.startsWith("xmlns")) {
                    if (vecQNames == null) {
                        vecQNames = new ArrayList<String>();
                    }
                    vecQNames.add(qname);
                }
                this.writer.write(qname);
                this.writer.write("=\"");
                this.writer.write(XMLUtils.xmlEncodeString(attributes.getValue(i)));
                this.writer.write(34);
            }
        }
        if (this.noNamespaceMappings) {
            this.nsStack.push();
        } else {
            Mapping map = this.nsStack.topOfFrame();
            while (map != null) {
                StringBuffer sb = new StringBuffer("xmlns");
                if (map.getPrefix().length() > 0) {
                    sb.append(':');
                    sb.append(map.getPrefix());
                }
                if (vecQNames == null || vecQNames.indexOf(sb.toString()) == -1) {
                    this.writer.write(32);
                    sb.append("=\"");
                    sb.append(map.getNamespaceURI());
                    sb.append('\"');
                    this.writer.write(sb.toString());
                }
                map = this.nsStack.next();
            }
            this.noNamespaceMappings = true;
        }
        this.writingStartTag = true;
        this.elementStack.push(elementQName);
        this.onlyXML = true;
    }

    public void endElement() throws IOException {
        String elementQName = (String)this.elementStack.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("endElem00", "" + elementQName));
        }
        this.nsStack.pop();
        if (this.writingStartTag) {
            if (this.sendMinimizedElements) {
                this.writer.write("/>");
            } else {
                this.writer.write("></");
                this.writer.write(elementQName);
                this.writer.write(62);
            }
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
        }
        this.writer.write("</");
        this.writer.write(elementQName);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.onlyXML = true;
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(p1, p2, p3));
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.onlyXML = false;
    }

    public void writeSafeString(String string) throws IOException {
        this.writeString(XMLUtils.xmlEncodeString(string));
    }

    public void writeDOMElement(Element el) throws IOException {
        AttributesImpl attributes = null;
        NamedNodeMap attrMap = el.getAttributes();
        if (attrMap.getLength() > 0) {
            attributes = new AttributesImpl();
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String tmp = attr.getNamespaceURI();
                if (tmp != null && tmp.equals("http://www.w3.org/2000/xmlns/")) {
                    String prefix = attr.getLocalName();
                    if (prefix == null) continue;
                    if (prefix.equals("xmlns")) {
                        prefix = "";
                    }
                    String nsURI = attr.getValue();
                    this.registerPrefixForURI(prefix, nsURI);
                    continue;
                }
                attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
            }
        }
        String namespaceURI = el.getNamespaceURI();
        String localPart = el.getLocalName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            localPart = el.getNodeName();
        }
        QName qName = new QName(namespaceURI, localPart);
        this.startElement(qName, attributes);
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.writeDOMElement((Element)child);
                continue;
            }
            if (child instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)child).getData());
                this.writeString("]]>");
                continue;
            }
            if (child instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)child).getData());
                this.writeString("-->");
                continue;
            }
            if (!(child instanceof Text)) continue;
            this.writeSafeString(((Text)child).getData());
        }
        this.endElement();
    }

    public final Serializer getSerializerForJavaType(Class javaType) {
        SerializerFactory serF = null;
        Serializer ser = null;
        try {
            serF = (SerializerFactory)this.getTypeMapping().getSerializer(javaType);
            if (serF != null) {
                ser = (Serializer)serF.getSerializerAs("Axis SAX Mechanism");
            }
        }
        catch (JAXRPCException e) {
            // empty catch block
        }
        return ser;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        if (type == null || type.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attrs.setAttributes(attributes);
        }
        String prefix = this.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":type", "CDATA", this.attributeQName2String(type));
        return attrs;
    }

    private void serializeActual(QName elemQName, Attributes attributes, Object value, QName xmlType, Boolean sendType) throws IOException {
        boolean shouldSendType;
        boolean bl = shouldSendType = sendType == null ? this.shouldSendXSIType() : sendType.booleanValue();
        if (value != null) {
            QNameHolder actualXMLType;
            Serializer ser;
            Class<?> javaType = value.getClass();
            TypeMapping tm = this.getTypeMapping();
            if (tm == null) {
                throw new IOException(Messages.getMessage("noSerializer00", value.getClass().getName(), "" + this));
            }
            this.currentXMLType = xmlType;
            if (Constants.equals(Constants.XSD_ANYTYPE, xmlType)) {
                xmlType = null;
                shouldSendType = true;
            }
            if ((ser = this.getSerializer(javaType, xmlType, actualXMLType = new QNameHolder())) != null) {
                if (shouldSendType || xmlType != null && !xmlType.equals(actualXMLType.value)) {
                    attributes = this.setTypeAttribute(attributes, actualXMLType.value);
                }
                ser.serialize(elemQName, attributes, value, this);
                return;
            }
            try {
                Method method = value.getClass().getMethod("getSerializer", getSerializerClasses);
                if (method != null) {
                    QName qname;
                    Serializer serializer = (Serializer)method.invoke(value, "", value.getClass(), elemQName);
                    TypeDesc typedesc = TypeDesc.getTypeDescForClass(value.getClass());
                    if (typedesc != null && (qname = typedesc.getXmlType()) != null) {
                        attributes = this.setTypeAttribute(attributes, qname);
                    }
                    serializer.serialize(elemQName, attributes, value, this);
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new IOException(Messages.getMessage("noSerializer00", value.getClass().getName(), "" + tm));
        }
    }

    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class javaType, QName xmlType, TypeMapping tm) {
        SerializerFactory serFactory = null;
        Class<?>[] interfaces = javaType.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> iface = interfaces[i];
                serFactory = (SerializerFactory)tm.getSerializer(iface, xmlType);
                if (serFactory == null) {
                    serFactory = this.getSerializerFactoryFromInterface(iface, xmlType, tm);
                }
                if (serFactory != null) break;
            }
        }
        return serFactory;
    }

    private Serializer getSerializer(Class javaType, QName xmlType, QNameHolder actualXMLType) {
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        if (actualXMLType != null) {
            actualXMLType.value = null;
        }
        while (javaType != null && (serFactory = (SerializerFactory)tm.getSerializer(javaType, xmlType)) == null && (serFactory = this.getSerializerFactoryFromInterface(javaType, xmlType, tm)) == null) {
            javaType = javaType.getSuperclass();
        }
        Serializer ser = null;
        if (serFactory != null) {
            ser = (Serializer)serFactory.getSerializerAs("Axis SAX Mechanism");
            if (actualXMLType != null) {
                if (serFactory instanceof BaseSerializerFactory) {
                    actualXMLType.value = ((BaseSerializerFactory)serFactory).getXMLType();
                }
                if (actualXMLType.value == null) {
                    actualXMLType.value = ((TypeMappingImpl)tm).getXMLType(javaType, xmlType);
                }
            }
        }
        return ser;
    }

    public String getValueAsString(Object value, QName xmlType) throws IOException {
        Serializer ser = this.getSerializer(value.getClass(), xmlType, null);
        if (!(ser instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage("needSimpleValueSer", ser.getClass().getName()));
        }
        SimpleValueSerializer simpleSer = (SimpleValueSerializer)ser;
        return simpleSer.getValueAsString(value, this);
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;

        MultiRefItem(String id, QName xmlType, Boolean sendType, Object value) {
            this.id = id;
            this.xmlType = xmlType;
            this.sendType = sendType;
            this.value = value;
        }
    }
}

