/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.description.FieldDesc;
import com.cognos.org.apache.axis.description.TypeDesc;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.Deserializer;
import com.cognos.org.apache.axis.encoding.DeserializerImpl;
import com.cognos.org.apache.axis.encoding.TypeMapping;
import com.cognos.org.apache.axis.encoding.ser.ArrayDeserializer;
import com.cognos.org.apache.axis.encoding.ser.BeanDeserializerFactory;
import com.cognos.org.apache.axis.encoding.ser.BeanPropertyTarget;
import com.cognos.org.apache.axis.encoding.ser.SimpleDeserializer;
import com.cognos.org.apache.axis.message.MessageElement;
import com.cognos.org.apache.axis.message.SOAPHandler;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.BeanPropertyDescriptor;
import com.cognos.org.apache.axis.utils.Messages;
import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl
implements Serializable {
    protected static Log log = LogFactory.getLog(BeanDeserializer.class.getName());
    QName xmlType;
    Class javaType;
    protected Map propertyMap = null;
    protected QName prevQName;
    protected TypeDesc typeDesc = null;
    protected int collectionIndex = -1;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public BeanDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this(javaType, xmlType, typeDesc, BeanDeserializerFactory.getProperties(javaType, typeDesc));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc, Map propertyMap) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyMap = propertyMap;
        try {
            this.value = javaType.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.value == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception e) {
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
        super.startElement(namespace, localName, prefix, attributes, context);
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        Deserializer dSer;
        BeanPropertyDescriptor propDesc = null;
        FieldDesc fieldDesc = null;
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        String encodingStyle = context.getMessageContext().getEncodingStyle();
        boolean isEncoded = Constants.isSOAP_ENC(encodingStyle);
        QName elemQName = new QName(namespace, localName);
        if (this.prevQName == null || !this.prevQName.equals(elemQName)) {
            this.collectionIndex = -1;
        }
        this.prevQName = elemQName;
        if (context.isNil(attributes)) {
            return null;
        }
        if (this.typeDesc != null) {
            String fieldName = this.typeDesc.getFieldNameForElement(elemQName, isEncoded);
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
            fieldDesc = this.typeDesc.getFieldByName(fieldName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(localName);
        }
        if (propDesc == null && (propDesc = this.getAnyPropertyDesc()) != null) {
            try {
                MessageElement thisEl;
                MessageElement[] curElements = (MessageElement[])propDesc.get(this.value);
                int length = 0;
                if (curElements != null) {
                    length = curElements.length;
                }
                MessageElement[] newElements = new MessageElement[length + 1];
                if (curElements != null) {
                    System.arraycopy(curElements, 0, newElements, 0, length);
                }
                newElements[length] = thisEl = context.getCurElement();
                propDesc.set(this.value, newElements);
                if (!localName.equals(thisEl.getName())) {
                    return new SOAPHandler(newElements, length);
                }
                return new SOAPHandler();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (propDesc == null) {
            throw new SAXException(Messages.getMessage("badElem00", this.javaType.getName(), localName));
        }
        QName childXMLType = context.getTypeFromAttributes(namespace, localName, attributes);
        String href = attributes.getValue(soapConstants.getAttrHref());
        if (childXMLType == null && fieldDesc != null && href == null) {
            childXMLType = fieldDesc.getXmlType();
        }
        if ((dSer = this.getDeserializer(childXMLType, propDesc.getType(), href, context)) == null) {
            dSer = new DeserializerImpl();
            return (SOAPHandler)((Object)dSer);
        }
        if (propDesc.isWriteable()) {
            if (propDesc.isIndexed() && !(dSer instanceof ArrayDeserializer)) {
                ++this.collectionIndex;
                dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc, this.collectionIndex));
            } else {
                this.collectionIndex = -1;
                dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc));
            }
        }
        this.addChildDeserializer(dSer);
        return (SOAPHandler)((Object)dSer);
    }

    public BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.typeDesc == null) {
            return null;
        }
        return this.typeDesc.getAnyDesc();
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.value == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception e) {
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName == null || (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) == null || !bpd.isWriteable() || bpd.isIndexed()) continue;
            Deserializer dSer = this.getDeserializer(null, bpd.getType(), null, context);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage("unregistered00", bpd.getType().toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), bpd.getType().toString()));
            }
            try {
                dSer.onStartElement(namespace, localName, prefix, attributes, context);
                Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                bpd.set(this.value, val);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    protected Deserializer getDeserializer(QName xmlType, Class javaType, String href, DeserializationContext context) {
        if (this.cacheStringDSer != null && String.class.equals(javaType) && href == null && (this.cacheXMLType == null && xmlType == null || this.cacheXMLType != null && this.cacheXMLType.equals(xmlType))) {
            this.cacheStringDSer.reset();
            return this.cacheStringDSer;
        }
        Deserializer dSer = null;
        if (xmlType != null && href == null) {
            dSer = context.getDeserializerForType(xmlType);
        } else {
            TypeMapping tm = context.getTypeMapping();
            QName defaultXMLType = tm.getTypeQName(javaType);
            if (href == null) {
                dSer = context.getDeserializer(javaType, defaultXMLType);
            } else {
                dSer = new DeserializerImpl();
                dSer.setDefaultType(defaultXMLType);
            }
        }
        if (javaType.equals(String.class) && dSer instanceof SimpleDeserializer) {
            this.cacheStringDSer = (SimpleDeserializer)dSer;
            this.cacheXMLType = xmlType;
        }
        return dSer;
    }
}

