/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.DeserializerImpl;
import com.cognos.org.apache.axis.message.MessageElement;
import com.cognos.org.apache.axis.utils.Messages;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class ElementDeserializer
extends DeserializerImpl {
    protected static Log log = LogFactory.getLog(ElementDeserializer.class.getName());
    public static final String DESERIALIZE_CURRENT_ELEMENT = "DeserializeCurrentElement";

    public final void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        try {
            MessageElement msgElem = context.getCurElement();
            if (msgElem != null) {
                MessageContext messageContext = context.getMessageContext();
                Boolean currentElement = (Boolean)messageContext.getProperty(DESERIALIZE_CURRENT_ELEMENT);
                if (currentElement != null && currentElement.booleanValue()) {
                    this.value = msgElem.getAsDOM();
                    messageContext.setProperty(DESERIALIZE_CURRENT_ELEMENT, Boolean.FALSE);
                    return;
                }
                ArrayList children = msgElem.getChildren();
                if (children != null && (msgElem = (MessageElement)children.get(0)) != null) {
                    this.value = msgElem.getAsDOM();
                }
            }
        }
        catch (Exception exp) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exp);
            throw new SAXException(exp);
        }
    }
}

