/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.description.TypeDesc;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.Deserializer;
import com.cognos.org.apache.axis.encoding.DeserializerImpl;
import com.cognos.org.apache.axis.encoding.SimpleType;
import com.cognos.org.apache.axis.encoding.TypeMapping;
import com.cognos.org.apache.axis.message.SOAPHandler;
import com.cognos.org.apache.axis.utils.BeanPropertyDescriptor;
import com.cognos.org.apache.axis.utils.BeanUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.io.CharArrayWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends DeserializerImpl {
    private final CharArrayWriter val = new CharArrayWriter();
    private Constructor constructor = null;
    private Map propertyMap = null;
    private HashMap attributeMap = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public SimpleDeserializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.init();
    }

    public SimpleDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.init();
    }

    private void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType)) {
            if (this.typeDesc == null) {
                this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
            }
            if (this.typeDesc != null) {
                this.propertyMap = this.typeDesc.getPropertyDescriptorMap();
            } else {
                BeanPropertyDescriptor[] pd = BeanUtils.getPd(this.javaType, null);
                this.propertyMap = new HashMap();
                for (int i = 0; i < pd.length; ++i) {
                    BeanPropertyDescriptor descriptor = pd[i];
                    this.propertyMap.put(descriptor.getName(), descriptor);
                }
            }
        }
    }

    public void reset() {
        this.val.reset();
        this.attributeMap = null;
        this.isNil = false;
        this.isEnded = false;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets.clear();
        }
    }

    public void setConstructor(Constructor c) {
        this.constructor = c;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(char[] chars, int start, int end) throws SAXException {
        this.val.write(chars, start, end);
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable realException = ite.getTargetException();
            if (realException instanceof Exception) {
                throw new SAXException((Exception)realException);
            }
            throw new SAXException(ite.getMessage());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String source) throws Exception {
        if (this.javaType == Boolean.TYPE || this.javaType == Boolean.class) {
            switch (source.charAt(0)) {
                case '0': 
                case 'F': 
                case 'f': {
                    return Boolean.FALSE;
                }
                case '1': 
                case 'T': 
                case 't': {
                    return Boolean.TRUE;
                }
            }
            throw new NumberFormatException(Messages.getMessage("badBool00"));
        }
        if (this.javaType == Float.TYPE || this.javaType == Float.class) {
            if (source.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (source.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
        }
        if (this.javaType == Double.TYPE || this.javaType == Double.class) {
            if (source.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (source.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        return this.constructor.newInstance(source);
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Class type;
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName == null || (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) == null || !bpd.isWriteable() || bpd.isIndexed()) continue;
            TypeMapping tm = context.getTypeMapping();
            QName qn = tm.getTypeQName(type = bpd.getType());
            if (qn == null) {
                throw new SAXException(Messages.getMessage("unregistered00", type.toString()));
            }
            Deserializer dSer = context.getDeserializerForType(qn);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage("noDeser00", type.toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
            }
            if (this.attributeMap == null) {
                this.attributeMap = new HashMap();
            }
            try {
                Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                this.attributeMap.put(fieldName, val);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        if (!SimpleType.class.isAssignableFrom(this.javaType) || this.attributeMap == null) {
            return;
        }
        Set entries = this.attributeMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object val = entry.getValue();
            BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(name);
            if (!bpd.isWriteable() || bpd.isIndexed()) continue;
            try {
                bpd.set(this.value, val);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }
}

