/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.handlers;

import com.cognos.org.apache.axis.utils.ClassUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;

public class HandlerChainImpl
extends ArrayList
implements HandlerChain {
    private String[] _roles;
    private int falseIndex = -1;
    protected List handlerInfos = new ArrayList();
    String[] roles = null;

    public String[] getRoles() {
        return this._roles;
    }

    public void setRoles(String[] roles) {
        this._roles = roles;
    }

    public void init(Map map) {
    }

    public HandlerChainImpl() {
    }

    public HandlerChainImpl(List handlerInfos) {
        this.handlerInfos = handlerInfos;
        for (int i = 0; i < handlerInfos.size(); ++i) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
        }
    }

    public void addNewHandler(String className, Map config) {
        try {
            HandlerInfo handlerInfo = new HandlerInfo(ClassUtils.forName(className), config, null);
            this.handlerInfos.add(handlerInfo);
            this.add(this.newHandler(handlerInfo));
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", className);
            throw new JAXRPCException(messageText, (Throwable)ex);
        }
    }

    public boolean handleFault(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.getHandlerInstance(i).handleFault((MessageContext)context)) continue;
            return false;
        }
        return true;
    }

    public boolean handleRequest(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        this.falseIndex = -1;
        for (int i = 0; i < this.size(); ++i) {
            Handler currentHandler = this.getHandlerInstance(i);
            if (currentHandler.handleRequest((MessageContext)context)) continue;
            this.falseIndex = i;
            return false;
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        int endIdx = this.size() - 1;
        if (this.falseIndex != -1) {
            endIdx = this.falseIndex;
        }
        for (int i = endIdx; i >= 0; --i) {
            if (this.getHandlerInstance(i).handleResponse(context)) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        for (int i = 0; i < this.size(); ++i) {
            this.getHandlerInstance(i).destroy();
        }
        this.clear();
    }

    private Handler getHandlerInstance(int index) {
        return (Handler)this.get(index);
    }

    private HandlerInfo getHandlerInfo(int index) {
        return (HandlerInfo)this.handlerInfos.get(index);
    }

    private Handler newHandler(HandlerInfo handlerInfo) {
        try {
            Handler handler = (Handler)handlerInfo.getHandlerClass().newInstance();
            handler.init(handlerInfo);
            return handler;
        }
        catch (Exception ex) {
            String messageText = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString());
            throw new JAXRPCException(messageText, (Throwable)ex);
        }
    }
}

