/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.message.SOAPEnvelope;
import com.cognos.org.apache.axis.message.SOAPHandler;
import com.cognos.org.apache.axis.message.SOAPHeader;
import com.cognos.org.apache.axis.message.SOAPHeaderElement;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HeaderBuilder
extends SOAPHandler {
    protected static Log log = LogFactory.getLog(HeaderBuilder.class.getName());
    private SOAPHeaderElement header;
    private SOAPEnvelope envelope;

    HeaderBuilder(SOAPEnvelope envelope) {
        this.envelope = envelope;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Header"), null, null, null);
            throw new SAXException(fault);
        }
        if (!context.isDoneParsing()) {
            if (this.myElement == null) {
                try {
                    this.myElement = new SOAPHeader(namespace, localName, prefix, attributes, context, this.envelope.getSOAPConstants());
                }
                catch (AxisFault axisFault) {
                    throw new SAXException(axisFault);
                }
                this.envelope.setHeader((SOAPHeader)this.myElement);
            }
            context.pushNewElement(this.myElement);
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        try {
            this.header = new SOAPHeaderElement(namespace, localName, prefix, attributes, context);
        }
        catch (AxisFault axisFault) {
            throw new SAXException(axisFault);
        }
        SOAPHandler handler = new SOAPHandler();
        handler.myElement = this.header;
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
    }
}

