/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.description.OperationDesc;
import com.cognos.org.apache.axis.description.ParameterDesc;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.Deserializer;
import com.cognos.org.apache.axis.encoding.DeserializerImpl;
import com.cognos.org.apache.axis.encoding.MethodTarget;
import com.cognos.org.apache.axis.message.MessageElement;
import com.cognos.org.apache.axis.message.RPCElement;
import com.cognos.org.apache.axis.message.RPCParam;
import com.cognos.org.apache.axis.message.SOAPHandler;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCHandler
extends SOAPHandler {
    protected static Log log = LogFactory.getLog(RPCHandler.class.getName());
    private RPCElement rpcElem;
    private RPCParam currentParam = null;
    private boolean isResponse;
    private OperationDesc operation;
    private boolean isHeaderElement;

    public RPCHandler(RPCElement rpcElem, boolean isResponse) throws SAXException {
        this.rpcElem = rpcElem;
        this.isResponse = isResponse;
    }

    public void setOperation(OperationDesc myOperation) {
        this.operation = myOperation;
    }

    public void setHeaderElement(boolean value) {
        this.isHeaderElement = true;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        super.startElement(namespace, localName, prefix, attributes, context);
        this.currentParam = null;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: RPCHandler.onStartChild()");
        }
        if (!context.isDoneParsing()) {
            try {
                context.pushNewElement(new MessageElement(namespace, localName, prefix, attributes, context));
            }
            catch (AxisFault axisFault) {
                throw new SAXException(axisFault);
            }
        }
        MessageElement curEl = context.getCurElement();
        QName type = null;
        QName qname = new QName(namespace, localName);
        ParameterDesc paramDesc = null;
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && Constants.QNAME_RPC_RESULT.equals(qname)) {
            return new DeserializerImpl();
        }
        Vector params = this.rpcElem.getParams();
        if (this.currentParam == null || !this.currentParam.getQName().getNamespaceURI().equals(namespace) || !this.currentParam.getQName().getLocalPart().equals(localName)) {
            this.currentParam = new RPCParam(namespace, localName, null);
            this.rpcElem.addParam(this.currentParam);
        }
        if ((type = curEl.getType()) == null) {
            type = context.getTypeFromAttributes(namespace, localName, attributes);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("typeFromAttr00", "" + type));
        }
        Class destClass = null;
        if (this.operation != null) {
            paramDesc = this.isResponse ? this.operation.getOutputParamByQName(qname) : this.operation.getInputParamByQName(qname);
            if (paramDesc == null) {
                paramDesc = this.isResponse ? this.operation.getReturnParamDesc() : this.operation.getParameter(params.size() - 1);
            }
            if (paramDesc == null) {
                throw new SAXException(Messages.getMessage("noParmDesc"));
            }
            if (!this.isHeaderElement && (this.isResponse && paramDesc.isOutHeader() || !this.isResponse && paramDesc.isInHeader())) {
                throw new SAXException(Messages.getMessage("expectedHeaderParam", paramDesc.getQName().toString()));
            }
            destClass = paramDesc.getJavaType();
            this.currentParam.setParamDesc(paramDesc);
            if (type == null) {
                type = paramDesc.getTypeQName();
            }
        }
        if (context.isNil(attributes)) {
            DeserializerImpl nilDSer = new DeserializerImpl();
            nilDSer.registerValueTarget(new MethodTarget((Object)this.currentParam, RPCParam.getValueSetMethod()));
            return nilDSer;
        }
        Deserializer dser = null;
        dser = type == null && namespace != null && !namespace.equals("") ? context.getDeserializerForType(qname) : context.getDeserializer(destClass, type);
        if (dser == null) {
            if (type != null) {
                Class xsiClass;
                dser = context.getDeserializerForType(type);
                if (null != destClass && dser == null && destClass.isAssignableFrom(Element.class)) {
                    dser = context.getDeserializerForType(Constants.SOAP_ELEMENT);
                }
                if (dser == null) {
                    throw new SAXException(Messages.getMessage("noDeser01", localName, "" + type));
                }
                if (paramDesc != null && paramDesc.getJavaType() != null && null != (xsiClass = context.getTypeMapping().getClassForQName(type)) && !JavaUtils.isConvertable(xsiClass, destClass)) {
                    throw new SAXException("Bad types (" + xsiClass + " -> " + destClass + ")");
                }
            } else {
                dser = new DeserializerImpl();
                if (dser == null) {
                    throw new SAXException(Messages.getMessage("noDeser01", localName, "" + type));
                }
            }
        }
        dser.setDefaultType(type);
        dser.registerValueTarget(new MethodTarget((Object)this.currentParam, RPCParam.getValueSetMethod()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: RPCHandler.onStartChild()");
        }
        return (SOAPHandler)((Object)dser);
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("setProp00", "MessageContext", "RPCHandler.endElement()."));
        }
        context.getMessageContext().setProperty("RPC", this.rpcElem);
    }
}

