/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.description.ParameterDesc;
import com.cognos.org.apache.axis.encoding.SerializationContext;
import com.cognos.org.apache.axis.message.RPCElement;
import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class RPCParam
implements Serializable {
    protected static Log log = LogFactory.getLog(RPCParam.class.getName());
    RPCElement myCall;
    private transient QName qname;
    private Object value = null;
    private int countSetCalls = 0;
    private ParameterDesc paramDesc;
    private Boolean wantXSIType = null;
    private static Method valueSetMethod;

    public RPCParam(String name, Object value) {
        this.qname = new QName("", name);
        this.value = value;
    }

    public RPCParam(QName qname, Object value) {
        this.qname = qname;
        this.value = value;
    }

    public RPCParam(String namespace, String name, Object value) {
        this.qname = new QName(namespace, name);
        this.value = value;
    }

    public void setRPCCall(RPCElement call) {
        this.myCall = call;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void set(Object newValue) {
        ++this.countSetCalls;
        if (this.countSetCalls == 1) {
            this.value = newValue;
            return;
        }
        if (this.countSetCalls == 2) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.value);
            this.value = list;
        }
        ((ArrayList)this.value).add(newValue);
    }

    public String getName() {
        return this.qname.getLocalPart();
    }

    public QName getQName() {
        return this.qname;
    }

    public static Method getValueSetMethod() {
        return valueSetMethod;
    }

    public ParameterDesc getParamDesc() {
        return this.paramDesc;
    }

    public void setParamDesc(ParameterDesc paramDesc) {
        this.paramDesc = paramDesc;
    }

    public void setXSITypeGeneration(Boolean value) {
        this.wantXSIType = value;
    }

    public Boolean getXSITypeGeneration() {
        return this.wantXSIType;
    }

    public void serialize(SerializationContext context) throws IOException {
        Class javaType = this.value == null ? null : this.value.getClass();
        QName xmlType = null;
        if (this.paramDesc != null) {
            if (javaType == null) {
                javaType = this.paramDesc.getJavaType() != null ? this.paramDesc.getJavaType() : javaType;
            } else if (!javaType.equals(this.paramDesc.getJavaType()) && !javaType.equals(JavaUtils.getHolderValueType(this.paramDesc.getJavaType()))) {
                this.wantXSIType = Boolean.TRUE;
            }
            xmlType = this.paramDesc.getTypeQName();
        }
        context.serialize(this.qname, null, this.value, xmlType, true, this.wantXSIType);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.qname == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.qname.getNamespaceURI());
            out.writeObject(this.qname.getLocalPart());
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.qname = in.readBoolean() ? new QName((String)in.readObject(), (String)in.readObject()) : null;
        in.defaultReadObject();
    }

    static {
        Class cls = RPCParam.class;
        try {
            valueSetMethod = cls.getMethod("set", Object.class);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)Messages.getMessage("noValue00", "" + e));
            System.exit(-1);
        }
    }
}

