/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.description.FaultDesc;
import com.cognos.org.apache.axis.description.OperationDesc;
import com.cognos.org.apache.axis.encoding.Callback;
import com.cognos.org.apache.axis.encoding.CallbackTarget;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.Deserializer;
import com.cognos.org.apache.axis.encoding.DeserializerImpl;
import com.cognos.org.apache.axis.message.SOAPFaultBuilder;
import com.cognos.org.apache.axis.message.SOAPHandler;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.ClassUtils;
import com.cognos.org.apache.axis.utils.Messages;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultDetailsBuilder
extends SOAPHandler
implements Callback {
    protected SOAPFaultBuilder builder;

    public SOAPFaultDetailsBuilder(SOAPFaultBuilder builder) {
        this.builder = builder;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Detail"), null, null, null);
            throw new SAXException(fault);
        }
        super.startElement(namespace, localName, prefix, attributes, context);
    }

    public SOAPHandler onStartChild(String namespace, String name, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName qn = new QName(namespace, name);
        if (name.equals("exceptionName")) {
            Deserializer dser = context.getDeserializerForType(Constants.XSD_STRING);
            dser.registerValueTarget(new CallbackTarget(this, "exceptionName"));
            return (SOAPHandler)((Object)dser);
        }
        MessageContext msgContext = context.getMessageContext();
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        OperationDesc op = msgContext.getOperation();
        Class faultClass = null;
        QName faultXmlType = null;
        if (op != null) {
            FaultDesc faultDesc = op.getFaultByQName(qn);
            if (faultDesc == null) {
                faultXmlType = context.getTypeFromAttributes(namespace, name, attributes);
                if (faultXmlType != null) {
                    faultDesc = op.getFaultByXmlType(faultXmlType);
                }
            } else {
                faultXmlType = faultDesc.getXmlType();
            }
            if (faultDesc != null) {
                try {
                    faultClass = ClassUtils.forName(faultDesc.getClassName());
                }
                catch (ClassNotFoundException e) {}
            }
        } else {
            faultXmlType = context.getTypeFromAttributes(namespace, name, attributes);
            faultClass = context.getTypeMapping().getClassForQName(faultXmlType);
        }
        if (faultClass != null && faultXmlType != null) {
            this.builder.setFaultClass(faultClass);
            this.builder.setWaiting(true);
            Deserializer dser = null;
            if (attributes.getValue(soapConstants.getAttrHref()) == null) {
                dser = context.getDeserializerForType(faultXmlType);
            } else {
                dser = new DeserializerImpl();
                dser.setDefaultType(faultXmlType);
            }
            if (dser != null) {
                dser.registerValueTarget(new CallbackTarget(this, "faultData"));
            }
            return (SOAPHandler)((Object)dser);
        }
        return null;
    }

    public void setValue(Object value, Object hint) {
        if ("faultData".equals(hint)) {
            this.builder.setFaultData(value);
        } else if ("exceptionName".equals(hint)) {
            String faultClassName = (String)value;
            try {
                Class faultClass = ClassUtils.forName(faultClassName);
                this.builder.setFaultClass(faultClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }
}

