/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Constants;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.TypeMappingRegistry;
import com.cognos.org.apache.axis.message.MessageElement;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPHandler
extends DefaultHandler {
    public MessageElement myElement = null;
    private MessageElement[] myElements;
    private int myIndex = 0;

    public SOAPHandler() {
    }

    public SOAPHandler(MessageElement[] elements, int index) {
        this.myElements = elements;
        this.myIndex = index;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        TypeMappingRegistry tmr;
        String encodingStyle;
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (!(soapConstants != SOAPConstants.SOAP12_CONSTANTS || (encodingStyle = attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle")) == null || encodingStyle.equals("") || encodingStyle.equals("http://www.w3.org/2002/12/soap-envelope/encoding/none") || Constants.isSOAP_ENC(encodingStyle) || (tmr = context.getTypeMappingRegistry()).getTypeMapping(encodingStyle) != tmr.getDefaultTypeMapping())) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_DATAENCODINGUNKNOWN, null, Messages.getMessage("invalidEncodingStyle"), null, null, null);
            throw new SAXException(fault);
        }
        if (!context.isDoneParsing() && !context.isProcessingRef()) {
            if (this.myElement == null) {
                try {
                    this.myElement = this.makeNewElement(namespace, localName, prefix, attributes, context);
                }
                catch (AxisFault axisFault) {
                    throw new SAXException(axisFault);
                }
            }
            context.pushNewElement(this.myElement);
        }
    }

    public MessageElement makeNewElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        return new MessageElement(namespace, localName, prefix, attributes, context);
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.myElement != null) {
            if (this.myElements != null) {
                this.myElements[this.myIndex] = this.myElement;
            }
            this.myElement.setEndIndex(context.getCurrentRecordPos());
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPHandler handler = new SOAPHandler();
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
    }
}

