/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.message;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.encoding.DeserializationContext;
import com.cognos.org.apache.axis.encoding.SerializationContext;
import com.cognos.org.apache.axis.message.MessageElement;
import com.cognos.org.apache.axis.message.SOAPHeader;
import com.cognos.org.apache.axis.soap.SOAP11Constants;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.Messages;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SOAPHeaderElement
extends MessageElement
implements javax.xml.soap.SOAPHeaderElement {
    protected boolean processed = false;
    protected String actor = null;
    protected boolean mustUnderstand = false;
    protected boolean relay = false;
    boolean alreadySerialized = false;

    public SOAPHeaderElement(String namespace, String localPart) {
        super(namespace, localPart);
    }

    public SOAPHeaderElement(Name name) {
        super(name);
    }

    public SOAPHeaderElement(String namespace, String localPart, Object value) {
        super(namespace, localPart, value);
    }

    public SOAPHeaderElement(Element elem) {
        super(elem);
        SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        String NSURI = this.getNamespaceURI();
        if (NSURI != null && NSURI.equals(SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI())) {
            soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        String val = elem.getAttributeNS(soapConstants.getEnvelopeURI(), "mustUnderstand");
        this.mustUnderstand = soapConstants == SOAPConstants.SOAP12_CONSTANTS ? val != null && (val.equals("true") || val.equals("1")) : val != null && val.equals("1");
        QName roleQName = soapConstants.getRoleAttributeQName();
        this.actor = elem.getAttributeNS(roleQName.getNamespaceURI(), roleQName.getLocalPart());
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            String relayVal = elem.getAttributeNS(soapConstants.getEnvelopeURI(), "relay");
            this.relay = relayVal != null && (relayVal.equals("true") || relayVal.equals("1"));
        }
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        if (!(parent instanceof SOAPHeader)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        try {
            super.setParentElement(parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPHeader)this.parent).removeHeader(this);
        super.detachNode();
    }

    public SOAPHeaderElement(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        SOAP11Constants soapConstants = context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : context.getMessageContext().getSOAPConstants();
        String val = attributes.getValue(soapConstants.getEnvelopeURI(), "mustUnderstand");
        this.mustUnderstand = soapConstants == SOAPConstants.SOAP12_CONSTANTS ? val != null && (val.equals("true") || val.equals("1")) : val != null && val.equals("1");
        QName roleQName = soapConstants.getRoleAttributeQName();
        this.actor = attributes.getValue(roleQName.getNamespaceURI(), roleQName.getLocalPart());
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            String relayVal = attributes.getValue(soapConstants.getEnvelopeURI(), "relay");
            this.relay = relayVal != null && (relayVal.equals("true") || relayVal.equals("1"));
        }
        this.processed = false;
        this.alreadySerialized = true;
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(boolean b) {
        this.mustUnderstand = b;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String a) {
        this.actor = a;
    }

    public String getRole() {
        return this.actor;
    }

    public void setRole(String a) {
        this.actor = a;
    }

    public boolean getRelay() {
        return this.relay;
    }

    public void setRelay(boolean relay) {
        this.relay = relay;
    }

    public void setProcessed(boolean value) {
        this.processed = value;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        if (!this.alreadySerialized) {
            SOAPConstants soapVer = this.getEnvelope().getSOAPConstants();
            QName roleQName = soapVer.getRoleAttributeQName();
            if (this.actor != null) {
                this.setAttribute(roleQName.getNamespaceURI(), roleQName.getLocalPart(), this.actor);
            }
            String val = context.getMessageContext() != null && context.getMessageContext().getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS ? (this.mustUnderstand ? "true" : "false") : (this.mustUnderstand ? "1" : "0");
            this.setAttribute(soapVer.getEnvelopeURI(), "mustUnderstand", val);
            if (soapVer == SOAPConstants.SOAP12_CONSTANTS && this.relay) {
                this.setAttribute(soapVer.getEnvelopeURI(), "relay", "true");
            }
        }
        super.outputImpl(context);
    }
}

