/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.providers.java;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.description.OperationDesc;
import com.cognos.org.apache.axis.i18n.Messages;
import com.cognos.org.apache.axis.message.SOAPBodyElement;
import com.cognos.org.apache.axis.message.SOAPEnvelope;
import com.cognos.org.apache.axis.providers.java.JavaProvider;
import java.lang.reflect.Method;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MsgProvider
extends JavaProvider {
    public void processMessage(MessageContext msgContext, SOAPEnvelope reqEnv, SOAPEnvelope resEnv, Object obj) throws Exception {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null) {
            throw new AxisFault(Messages.getMessage("noOperationForQName", reqEnv.getFirstBody().getQName().toString()));
        }
        Method method = operation.getMethod();
        int methodType = operation.getMessageOperationStyle();
        if (methodType != 2) {
            Vector bodies = reqEnv.getBodyElements();
            Object[] argObjects = new Object[1];
            switch (methodType) {
                case 1: {
                    SOAPBodyElement[] bodyElements = new SOAPBodyElement[bodies.size()];
                    bodies.toArray(bodyElements);
                    argObjects[0] = bodyElements;
                    SOAPBodyElement[] bodyResult = (SOAPBodyElement[])method.invoke(obj, argObjects);
                    if (bodyResult != null) {
                        for (int i = 0; i < bodyResult.length; ++i) {
                            SOAPBodyElement bodyElement = bodyResult[i];
                            resEnv.addBodyElement(bodyElement);
                        }
                    }
                    return;
                }
                case 3: {
                    Element[] elements = new Element[bodies.size()];
                    for (int i = 0; i < elements.length; ++i) {
                        SOAPBodyElement body = (SOAPBodyElement)bodies.get(i);
                        elements[i] = body.getAsDOM();
                    }
                    argObjects[0] = elements;
                    Element[] elemResult = (Element[])method.invoke(obj, argObjects);
                    if (elemResult != null) {
                        for (int i = 0; i < elemResult.length; ++i) {
                            if (elemResult[i] == null) continue;
                            resEnv.addBodyElement(new SOAPBodyElement(elemResult[i]));
                        }
                    }
                    return;
                }
                case 4: {
                    Document doc = ((SOAPBodyElement)bodies.get(0)).getAsDocument();
                    argObjects[0] = doc;
                    Document resultDoc = (Document)method.invoke(obj, argObjects);
                    if (resultDoc != null) {
                        resEnv.addBodyElement(new SOAPBodyElement(resultDoc.getDocumentElement()));
                    }
                    return;
                }
            }
        } else {
            Object[] argObjects = new Object[]{reqEnv, resEnv};
            method.invoke(obj, argObjects);
            return;
        }
        throw new AxisFault(Messages.getMessage("badMsgMethodStyle"));
    }
}

