/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.serviceContext;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Message;
import com.cognos.org.apache.axis.client.Call;
import com.cognos.org.apache.axis.message.SOAPEnvelope;
import com.cognos.org.apache.axis.message.SOAPHeaderElement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ServiceContext {
    private Hashtable implicitHeaders = new Hashtable();
    private Vector explicitHeaders = new Vector();

    public void setHeader(String namespace, String partName, Object headerValue) {
        this.setImplicitHeader(partName, headerValue);
    }

    public void setHeader(SOAPHeaderElement header) {
        this.setExplicitHeader(header);
    }

    public void setImplicitHeader(String partName, Object headerValue) {
        this.implicitHeaders.put(partName, headerValue);
    }

    public void setExplicitHeader(SOAPHeaderElement header) {
        this.explicitHeaders.add(header);
    }

    public Object getHeaderObject(String namespace, String partName) {
        return this.getImplicitHeaderObject(namespace, partName);
    }

    public SOAPHeaderElement getHeader(String namespace, String partName) {
        if (this.isAnImplicitHeader(namespace, partName)) {
            return this.getImplicitHeader(namespace, partName);
        }
        return this.getExplicitHeader(namespace, partName);
    }

    public SOAPHeaderElement getExplicitHeader(String namespace, String partName) {
        for (int i = 0; i < this.explicitHeaders.size(); ++i) {
            SOAPHeaderElement header = (SOAPHeaderElement)this.explicitHeaders.get(i);
            if (!header.getNamespaceURI().equals(namespace) || !header.getName().equals(partName)) continue;
            return header;
        }
        return null;
    }

    public Object getImplicitHeaderObject(String namespace, String partName) {
        return this.implicitHeaders.get(partName);
    }

    public SOAPHeaderElement getImplicitHeader(String namespace, String partName) {
        return new SOAPHeaderElement(namespace, partName, this.getImplicitHeaderObject(namespace, partName));
    }

    public SOAPHeaderElement[] getExplicitHeaders() {
        Object[] array = new SOAPHeaderElement[this.explicitHeaders.size()];
        this.explicitHeaders.copyInto(array);
        return array;
    }

    private boolean isAnImplicitHeader(String namespace, String partName) {
        return this.implicitHeaders.containsKey(partName);
    }

    private boolean isAnExplicitHeader(SOAPHeaderElement header) {
        String namespace = header.getNamespaceURI();
        String partName = header.getName();
        for (int i = 0; i < this.explicitHeaders.size(); ++i) {
            SOAPHeaderElement aHeader = (SOAPHeaderElement)this.explicitHeaders.get(i);
            if (!aHeader.getNamespaceURI().equals(namespace) || !aHeader.getName().equals(partName)) continue;
            return true;
        }
        return false;
    }

    public void updateExplicitHeaders(Call call) throws AxisFault {
        Message response = call.getMessageContext().getResponseMessage();
        SOAPEnvelope env = response.getSOAPEnvelope();
        if (env != null) {
            Iterator iterator = env.getHeaders().iterator();
            while (iterator.hasNext()) {
                SOAPHeaderElement header = (SOAPHeaderElement)iterator.next();
                if (!this.isAnExplicitHeader(header)) continue;
                this.setHeader(header);
            }
        }
    }

    public void updateImplicitHeader(Call call, String namespace, String partName) throws AxisFault {
        Object theHeader;
        SOAPHeaderElement header;
        Message response = call.getMessageContext().getResponseMessage();
        SOAPEnvelope env = response.getSOAPEnvelope();
        if (env != null && (header = env.getHeaderByName(namespace, partName, true)) != null && (theHeader = header.getObjectValue()) != null) {
            this.setHeader(namespace, partName, theHeader);
        }
    }

    public void clearHeaders() {
        this.implicitHeaders.clear();
        this.explicitHeaders.clear();
    }
}

