/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.soap;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Message;
import com.cognos.org.apache.axis.attachments.Attachments;
import com.cognos.org.apache.axis.client.Call;
import com.cognos.org.apache.axis.message.SOAPEnvelope;
import com.cognos.org.apache.axis.utils.Messages;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPConnectionImpl
extends SOAPConnection {
    boolean closed = false;

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            Call call = new Call(endpoint.toString());
            ((Message)request).setMessageContext(call.getMessageContext());
            SOAPEnvelope env = ((Message)request).getSOAPEnvelope();
            Attachments attachments = ((Message)request).getAttachmentsImpl();
            if (attachments != null) {
                Iterator iterator = attachments.getAttachments().iterator();
                while (iterator.hasNext()) {
                    Object attachment = iterator.next();
                    call.addAttachmentPart(attachment);
                }
            }
            call.setReturnClass(SOAPMessage.class);
            call.invoke(env);
            return call.getResponseMessage();
        }
        catch (MalformedURLException mue) {
            throw new SOAPException((Throwable)mue);
        }
        catch (AxisFault af) {
            throw new SOAPException((Throwable)af);
        }
        catch (RemoteException re) {
            throw new SOAPException((Throwable)re);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }
}

