/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.types;

import com.cognos.org.apache.axis.utils.Messages;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class UnsignedLong
extends Number
implements Comparable {
    protected Double lValue = new Double(0.0);
    private Object __equalsCalc = null;

    public UnsignedLong() {
    }

    public UnsignedLong(double lValue) throws NumberFormatException {
        this.setValue(lValue);
    }

    public UnsignedLong(String stValue) throws NumberFormatException {
        this.setValue(Double.parseDouble(stValue));
    }

    public void setValue(double lValue) throws NumberFormatException {
        if (!this.isValid(lValue)) {
            throw new NumberFormatException(Messages.getMessage("badUnsignedLong00") + String.valueOf(lValue) + "]");
        }
        this.lValue = new Double(lValue);
    }

    private String convertDoubleToUnsignedLong(Double lValue) {
        if (lValue != null) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            StringBuffer buf = new StringBuffer();
            FieldPosition pos = new FieldPosition(0);
            nf.format(lValue, buf, pos);
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        return this.convertDoubleToUnsignedLong(this.lValue);
    }

    public int hashCode() {
        if (this.lValue != null) {
            return this.lValue.hashCode();
        }
        return 0;
    }

    public boolean isValid(double lValue) {
        return !(lValue < 0.0) && !(lValue > 1.8446744073709552E19);
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UnsignedLong)) {
            return false;
        }
        UnsignedLong other = (UnsignedLong)obj;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == obj;
        }
        this.__equalsCalc = obj;
        boolean _equals = this.lValue == null && other.lValue == null || this.lValue != null && this.lValue.equals(other.lValue);
        this.__equalsCalc = null;
        return _equals;
    }

    public int compareTo(Object obj) {
        if (this.lValue != null) {
            return this.lValue.compareTo(obj);
        }
        if (this.equals(obj)) {
            return 0;
        }
        return 1;
    }

    public byte byteValue() {
        return this.lValue.byteValue();
    }

    public short shortValue() {
        return this.lValue.shortValue();
    }

    public int intValue() {
        return this.lValue.intValue();
    }

    public long longValue() {
        return this.lValue.longValue();
    }

    public double doubleValue() {
        return this.lValue;
    }

    public float floatValue() {
        return this.lValue.floatValue();
    }
}

