/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.wsdl.gen.Generator;
import com.cognos.org.apache.axis.wsdl.symbolTable.BindingEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaImplWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaInterfaceWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaSkelWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaStubWriter;
import com.cognos.org.apache.axis.wsdl.toJava.Utils;
import java.io.IOException;
import javax.wsdl.Binding;

public class JavaBindingWriter
implements Generator {
    protected Generator stubWriter = null;
    protected Generator skelWriter = null;
    protected Generator implWriter = null;
    protected Generator interfaceWriter = null;
    protected Emitter emitter;
    protected Binding binding;
    protected SymbolTable symbolTable;
    public static String INTERFACE_NAME = "interface name";

    public JavaBindingWriter(Emitter emitter, Binding binding, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.binding = binding;
        this.symbolTable = symbolTable;
    }

    protected Generator getJavaInterfaceWriter(Emitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable st) {
        return new JavaInterfaceWriter(emitter, ptEntry, bEntry, st);
    }

    protected Generator getJavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new JavaStubWriter(emitter, bEntry, st);
    }

    protected Generator getJavaSkelWriter(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new JavaSkelWriter(emitter, bEntry, st);
    }

    protected Generator getJavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        return new JavaImplWriter(emitter, bEntry, st);
    }

    public void generate() throws IOException {
        this.setGenerators();
        if (this.interfaceWriter != null) {
            this.interfaceWriter.generate();
        }
        if (this.stubWriter != null) {
            this.stubWriter.generate();
        }
        if (this.skelWriter != null) {
            this.skelWriter.generate();
        }
        if (this.implWriter != null) {
            this.implWriter.generate();
        }
    }

    protected void setGenerators() {
        BindingEntry bEntry = this.symbolTable.getBindingEntry(this.binding.getQName());
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(this.binding.getPortType().getQName());
        if (ptEntry.isReferenced()) {
            this.interfaceWriter = this.getJavaInterfaceWriter(this.emitter, ptEntry, bEntry, this.symbolTable);
        }
        if (bEntry.isReferenced()) {
            this.stubWriter = this.getJavaStubWriter(this.emitter, bEntry, this.symbolTable);
            if (this.emitter.isServerSide()) {
                if (this.emitter.isSkeletonWanted()) {
                    this.skelWriter = this.getJavaSkelWriter(this.emitter, bEntry, this.symbolTable);
                }
                String fileName = Utils.getJavaLocalName(bEntry.getName()) + "Impl.java";
                try {
                    if (Utils.fileExists(fileName, this.binding.getQName().getNamespaceURI(), this.emitter.getNamespaces())) {
                        System.out.println(Messages.getMessage("wontOverwrite", fileName));
                    } else {
                        this.implWriter = this.getJavaImplWriter(this.emitter, bEntry, this.symbolTable);
                    }
                }
                catch (IOException ioe) {
                    System.err.println(Messages.getMessage("fileExistError00", fileName));
                }
            }
        }
    }
}

