/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.wsdl.symbolTable.TypeEntry;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class JavaEnumTypeWriter
extends JavaClassWriter {
    private Vector elements;

    protected JavaEnumTypeWriter(Emitter emitter, TypeEntry type, Vector elements) {
        super(emitter, type.getName(), "enumType");
        this.elements = elements;
    }

    protected String getImplementsText() {
        return "implements java.io.Serializable ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        int i;
        String baseType;
        String javaName = this.getClassName();
        String baseClass = baseType = ((TypeEntry)this.elements.get(0)).getName();
        if (baseType.indexOf("int") == 0) {
            baseClass = "java.lang.Integer";
        } else if (baseType.indexOf("char") == 0) {
            baseClass = "java.lang.Character";
        } else if (baseType.indexOf("short") == 0) {
            baseClass = "java.lang.Short";
        } else if (baseType.indexOf("long") == 0) {
            baseClass = "java.lang.Long";
        } else if (baseType.indexOf("double") == 0) {
            baseClass = "java.lang.Double";
        } else if (baseType.indexOf("float") == 0) {
            baseClass = "java.lang.Float";
        } else if (baseType.indexOf("byte") == 0) {
            baseClass = "java.lang.Byte";
        }
        Vector<String> values = new Vector<String>();
        for (int i2 = 1; i2 < this.elements.size(); ++i2) {
            String value = (String)this.elements.get(i2);
            if (baseClass.equals("java.lang.String")) {
                value = "\"" + value + "\"";
            } else if (baseClass.equals("java.lang.Character")) {
                value = "'" + value + "'";
            } else if (baseClass.equals("java.lang.Float")) {
                if (!value.endsWith("F") && !value.endsWith("f")) {
                    value = value + "F";
                }
            } else if (baseClass.equals("java.lang.Long")) {
                if (!value.endsWith("L") && !value.endsWith("l")) {
                    value = value + "L";
                }
            } else if (baseClass.equals(baseType)) {
                value = "new " + baseClass + "(\"" + value + "\")";
            }
            values.add(value);
        }
        Vector ids = JavaEnumTypeWriter.getEnumValueIds(this.elements);
        pw.println("    private " + baseType + " _value_;");
        pw.println("    private static java.util.HashMap _table_ = new java.util.HashMap();");
        pw.println("");
        pw.println("    // " + Messages.getMessage("ctor00"));
        pw.println("    protected " + javaName + "(" + baseType + " value) {");
        pw.println("        _value_ = value;");
        if (baseClass.equals("java.lang.String") || baseClass.equals(baseType)) {
            pw.println("        _table_.put(_value_,this);");
        } else {
            pw.println("        _table_.put(new " + baseClass + "(_value_),this);");
        }
        pw.println("    }");
        pw.println("");
        for (i = 0; i < ids.size(); ++i) {
            pw.println("    public static final " + baseType + " _" + ids.get(i) + " = " + values.get(i) + ";");
        }
        for (i = 0; i < ids.size(); ++i) {
            pw.println("    public static final " + javaName + " " + ids.get(i) + " = new " + javaName + "(_" + ids.get(i) + ");");
        }
        pw.println("    public " + baseType + " getValue() { return _value_;}");
        pw.println("    public static " + javaName + " fromValue(" + baseType + " value)");
        pw.println("          throws java.lang.IllegalStateException {");
        pw.println("        " + javaName + " enum = (" + javaName + ")");
        if (baseClass.equals("java.lang.String") || baseClass.equals(baseType)) {
            pw.println("            _table_.get(value);");
        } else {
            pw.println("            _table_.get(new " + baseClass + "(value));");
        }
        pw.println("        if (enum==null) throw new java.lang.IllegalStateException();");
        pw.println("        return enum;");
        pw.println("    }");
        pw.println("    public static " + javaName + " fromString(java.lang.String value)");
        pw.println("          throws java.lang.IllegalStateException {");
        if (baseClass.equals("java.lang.String")) {
            pw.println("        return fromValue(value);");
        } else if (baseClass.equals(baseType)) {
            pw.println("        try {");
            pw.println("            return fromValue(new " + baseClass + "(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalStateException();");
            pw.println("        }");
        } else if (baseClass.equals("java.lang.Character")) {
            pw.println("        if (value != null && value.length() == 1);");
            pw.println("            return fromValue(value.charAt(0));");
            pw.println("        throw new java.lang.IllegalStateException();");
        } else if (baseClass.equals("java.lang.Integer")) {
            pw.println("        try {");
            pw.println("            return fromValue(java.lang.Integer.parseInt(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalStateException();");
            pw.println("        }");
        } else {
            String parse = "parse" + baseClass.substring(baseClass.lastIndexOf(".") + 1);
            pw.println("        try {");
            pw.println("            return fromValue(" + baseClass + "." + parse + "(value));");
            pw.println("        } catch (Exception e) {");
            pw.println("            throw new java.lang.IllegalStateException();");
            pw.println("        }");
        }
        pw.println("    }");
        pw.println("    public boolean equals(java.lang.Object obj) {return (obj == this);}");
        pw.println("    public int hashCode() { return toString().hashCode();}");
        if (baseClass.equals("java.lang.String")) {
            pw.println("    public java.lang.String toString() { return _value_;}");
        } else if (baseClass.equals(baseType)) {
            pw.println("    public java.lang.String toString() { return _value_.toString();}");
        } else {
            pw.println("    public java.lang.String toString() { return java.lang.String.valueOf(_value_);}");
        }
        pw.println("    public java.lang.Object readResolve() throws java.io.ObjectStreamException { return fromValue(_value_);}");
    }

    public static Vector getEnumValueIds(Vector bv) {
        boolean validJava = true;
        for (int i = 1; i < bv.size() && validJava; ++i) {
            String value = (String)bv.get(i);
            if (JavaUtils.isJavaId(value)) continue;
            validJava = false;
        }
        Vector<String> ids = new Vector<String>();
        for (int i = 1; i < bv.size(); ++i) {
            if (!validJava) {
                ids.add("value" + i);
                continue;
            }
            ids.add((String)bv.get(i));
        }
        return ids;
    }
}

