/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.encoding.DefaultTypeMappingImpl;
import com.cognos.org.apache.axis.encoding.TypeMapping;
import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.wsdl.gen.Generator;
import com.cognos.org.apache.axis.wsdl.gen.GeneratorFactory;
import com.cognos.org.apache.axis.wsdl.gen.NoopGenerator;
import com.cognos.org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import com.cognos.org.apache.axis.wsdl.symbolTable.BindingEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.Element;
import com.cognos.org.apache.axis.wsdl.symbolTable.FaultInfo;
import com.cognos.org.apache.axis.wsdl.symbolTable.MessageEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.Parameter;
import com.cognos.org.apache.axis.wsdl.symbolTable.Parameters;
import com.cognos.org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SchemaUtils;
import com.cognos.org.apache.axis.wsdl.symbolTable.ServiceEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymTabEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.symbolTable.Type;
import com.cognos.org.apache.axis.wsdl.symbolTable.TypeEntry;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaBindingWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaDefinitionWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaDeployWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaServiceWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaTypeWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaUndeployWriter;
import com.cognos.org.apache.axis.wsdl.toJava.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaGeneratorFactory
implements GeneratorFactory {
    protected Emitter emitter;
    protected SymbolTable symbolTable;
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_CLASS_NAME = "ExceptionClassName";
    public static String EXCEPTION_DATA_TYPE = "ExceptionDataType";
    private Writers messageWriters = new Writers();
    private Writers portTypeWriters = new Writers();
    protected Writers bindingWriters = new Writers();
    protected Writers serviceWriters = new Writers();
    private Writers typeWriters = new Writers();
    private Writers defWriters = new Writers();
    BaseTypeMapping btm = null;
    static /* synthetic */ Class class$com$cognos$org$apache$axis$wsdl$toJava$Emitter;
    static /* synthetic */ Class class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.emitter = emitter;
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    protected void addMessageGenerators() {
    }

    protected void addPortTypeGenerators() {
    }

    protected void addBindingGenerators() {
    }

    protected void addServiceGenerators() {
    }

    protected void addTypeGenerators() {
    }

    protected void addDefinitionGenerators() {
        this.addGenerator(Definition.class, JavaDefinitionWriter.class);
        this.addGenerator(Definition.class, JavaDeployWriter.class);
        this.addGenerator(Definition.class, JavaUndeployWriter.class);
    }

    public void generatorPass(Definition def, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.javifyNames(symbolTable);
        this.setFaultContext(symbolTable);
        this.resolveNameClashes(symbolTable);
        this.determineInterfaceNames(symbolTable);
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue();
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.determineIfHoldersNeeded(symbolTable);
    }

    public Generator getGenerator(Message message, SymbolTable symbolTable) {
        MessageEntry mEntry = symbolTable.getMessageEntry(message.getQName());
        this.messageWriters.addStuff((Generator)new NoopGenerator(), mEntry, symbolTable);
        return this.messageWriters;
    }

    public Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
        this.portTypeWriters.addStuff((Generator)new NoopGenerator(), ptEntry, symbolTable);
        return this.portTypeWriters;
    }

    public Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        JavaBindingWriter writer = new JavaBindingWriter(this.emitter, binding, symbolTable);
        BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
        this.bindingWriters.addStuff((Generator)writer, bEntry, symbolTable);
        return this.bindingWriters;
    }

    public Generator getGenerator(Service service, SymbolTable symbolTable) {
        JavaServiceWriter writer = new JavaServiceWriter(this.emitter, service, symbolTable);
        ServiceEntry sEntry = symbolTable.getServiceEntry(service.getQName());
        this.serviceWriters.addStuff((Generator)writer, sEntry, symbolTable);
        return this.serviceWriters;
    }

    public Generator getGenerator(TypeEntry type, SymbolTable symbolTable) {
        JavaTypeWriter writer = new JavaTypeWriter(this.emitter, type, symbolTable);
        this.typeWriters.addStuff((Generator)writer, type, symbolTable);
        return this.typeWriters;
    }

    public Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        this.defWriters.addStuff(null, definition, symbolTable);
        return this.defWriters;
    }

    public void addGenerator(Class wsdlClass, Class generator) {
        if (Message.class.isAssignableFrom(wsdlClass)) {
            this.messageWriters.addGenerator(generator);
        } else if (PortType.class.isAssignableFrom(wsdlClass)) {
            this.portTypeWriters.addGenerator(generator);
        } else if (Binding.class.isAssignableFrom(wsdlClass)) {
            this.bindingWriters.addGenerator(generator);
        } else if (Service.class.isAssignableFrom(wsdlClass)) {
            this.serviceWriters.addGenerator(generator);
        } else if (TypeEntry.class.isAssignableFrom(wsdlClass)) {
            this.typeWriters.addGenerator(generator);
        } else if (Definition.class.isAssignableFrom(wsdlClass)) {
            this.defWriters.addGenerator(generator);
        }
    }

    protected void javifyNames(SymbolTable symbolTable) {
        int uniqueNum = 0;
        HashMap<QName, QName> anonQNames = new HashMap<QName, QName>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry.getName() != null) continue;
                if (entry instanceof TypeEntry) {
                    TypeEntry tEntry = (TypeEntry)entry;
                    String dims = tEntry.getDimensions();
                    TypeEntry refType = tEntry.getRefType();
                    while (refType != null) {
                        tEntry = refType;
                        dims = dims + tEntry.getDimensions();
                        refType = tEntry.getRefType();
                    }
                    if (tEntry.getName() == null) {
                        QName typeQName = tEntry.getQName();
                        if (typeQName.getLocalPart().indexOf(">") < 0) {
                            tEntry.setName(this.emitter.getJavaName(typeQName));
                        } else {
                            String localName = typeQName.getLocalPart();
                            StringBuffer sb = new StringBuffer(localName);
                            int aidx = -1;
                            while ((aidx = sb.toString().indexOf(">")) > -1) {
                                sb.replace(aidx, aidx + ">".length(), "_");
                            }
                            localName = sb.toString();
                            typeQName = new QName(typeQName.getNamespaceURI(), localName);
                            symbolTable.getType(typeQName);
                            if (anonQNames.get(typeQName) != null) {
                                localName = localName + "Type" + uniqueNum++;
                                typeQName = new QName(typeQName.getNamespaceURI(), localName);
                            }
                            anonQNames.put(typeQName, typeQName);
                            tEntry.setName(this.emitter.getJavaName(typeQName));
                        }
                    }
                    entry.setName(tEntry.getName() + dims);
                    continue;
                }
                entry.setName(this.emitter.getJavaName(entry.getQName()));
            }
        }
    }

    private void setFaultContext(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                HashMap allOpFaults = bEntry.getFaults();
                Iterator ops = allOpFaults.values().iterator();
                while (ops.hasNext()) {
                    ArrayList faults = (ArrayList)ops.next();
                    for (int j = 0; j < faults.size(); ++j) {
                        FaultInfo info = (FaultInfo)faults.get(j);
                        this.setFaultContext(info, symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(FaultInfo fault, SymbolTable symbolTable) {
        QName faultXmlType = null;
        Vector parts = new Vector();
        try {
            symbolTable.getParametersFromParts(parts, fault.getMessage().getOrderedParts(null), false, fault.getName(), null);
        }
        catch (IOException e) {
            // empty catch block
        }
        String exceptionClassName = null;
        for (int j = 0; j < parts.size(); ++j) {
            TypeEntry te = ((Parameter)parts.elementAt(j)).getType();
            TypeEntry elementTE = null;
            if (te instanceof Element) {
                elementTE = te;
                te = te.getRefType();
            }
            faultXmlType = te.getQName();
            if (te.getBaseType() != null || te.isSimpleType() || te.getDimensions().length() > 0 && te.getRefType().getBaseType() != null) continue;
            Boolean isComplexFault = (Boolean)te.getDynamicVar(COMPLEX_TYPE_FAULT);
            if (isComplexFault == null || !isComplexFault.booleanValue()) {
                te.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                if (elementTE != null) {
                    te.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                }
                HashSet derivedSet = com.cognos.org.apache.axis.wsdl.symbolTable.Utils.getDerivedTypes(te, symbolTable);
                Iterator derivedI = derivedSet.iterator();
                while (derivedI.hasNext()) {
                    TypeEntry derivedTE = (TypeEntry)derivedI.next();
                    derivedTE.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                }
                TypeEntry base = SchemaUtils.getComplexElementExtensionBase(te.getNode(), symbolTable);
                while (base != null) {
                    base.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                    base = SchemaUtils.getComplexElementExtensionBase(base.getNode(), symbolTable);
                }
            }
            exceptionClassName = te.getName();
        }
        MessageEntry me = symbolTable.getMessageEntry(fault.getMessage().getQName());
        if (me != null) {
            me.setDynamicVar(EXCEPTION_DATA_TYPE, faultXmlType);
            if (exceptionClassName != null) {
                me.setDynamicVar(COMPLEX_TYPE_FAULT, new Boolean(true));
                me.setDynamicVar(EXCEPTION_CLASS_NAME, exceptionClassName);
            } else {
                me.setDynamicVar(EXCEPTION_CLASS_NAME, this.emitter.getJavaName(me.getQName()));
            }
        }
    }

    protected void determineInterfaceNames(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                String seiName = null;
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
                seiName = ptEntry.getName();
                bEntry.setDynamicVar(JavaBindingWriter.INTERFACE_NAME, seiName);
            }
        }
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        HashSet<Type> anonTypes = new HashSet<Type>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            SymTabEntry entry;
            Vector<TypeEntry> v = new Vector<TypeEntry>((Vector)it.next());
            int index = 0;
            while (index < v.size()) {
                if (v.elementAt(index) instanceof MessageEntry) {
                    v.removeElementAt(index);
                    continue;
                }
                ++index;
            }
            if (v.size() <= 1) continue;
            boolean resolve = true;
            if (v.size() == 2 && (v.elementAt(0) instanceof Element && v.elementAt(1) instanceof Type || v.elementAt(1) instanceof Element && v.elementAt(0) instanceof Type)) {
                Element e = null;
                e = v.elementAt(0) instanceof Element ? (Element)v.elementAt(0) : (Element)v.elementAt(1);
                BooleanHolder forElement = new BooleanHolder();
                QName eType = Utils.getTypeQName(e.getNode(), forElement, false);
                if (eType != null && eType.equals(e.getQName()) && !forElement.value) {
                    resolve = false;
                }
            }
            if (resolve) {
                resolve = false;
                String name = null;
                for (int i = 0; i < v.size() && !resolve; ++i) {
                    entry = (SymTabEntry)v.elementAt(i);
                    if (entry instanceof MessageEntry || entry instanceof BindingEntry) continue;
                    if (name == null) {
                        name = entry.getName();
                        continue;
                    }
                    if (!name.equals(entry.getName())) continue;
                    resolve = true;
                }
            }
            if (!resolve) continue;
            boolean firstType = true;
            for (int i = 0; i < v.size(); ++i) {
                BindingEntry bEntry;
                entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof Element) {
                    entry.setName(this.mangleName(entry.getName(), "_ElemType"));
                    QName anonQName = new QName(entry.getQName().getNamespaceURI(), ">" + entry.getQName().getLocalPart());
                    Type anonType = symbolTable.getType(anonQName);
                    if (anonType == null) continue;
                    anonType.setName(entry.getName());
                    anonTypes.add(anonType);
                    continue;
                }
                if (entry instanceof TypeEntry) {
                    if (firstType) {
                        firstType = false;
                        Iterator types = symbolTable.getTypeIndex().values().iterator();
                        while (types.hasNext()) {
                            TypeEntry type = (TypeEntry)types.next();
                            if (type == entry || type.getBaseType() != null || !this.sameJavaClass(entry.getName(), type.getName())) continue;
                            v.add(type);
                        }
                    }
                    if (anonTypes.contains(entry)) continue;
                    entry.setName(this.mangleName(entry.getName(), "_Type"));
                    continue;
                }
                if (entry instanceof PortTypeEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Port"));
                    continue;
                }
                if (entry instanceof ServiceEntry) {
                    entry.setName(this.mangleName(entry.getName(), "_Service"));
                    continue;
                }
                if (!(entry instanceof BindingEntry) || !(bEntry = (BindingEntry)entry).hasLiteral()) continue;
                entry.setName(this.mangleName(entry.getName(), "_Binding"));
            }
        }
    }

    private String mangleName(String name, String mangle) {
        int index = name.indexOf("[");
        if (index >= 0) {
            String pre = name.substring(0, index);
            String post = name.substring(index);
            return pre + mangle + post;
        }
        return name + mangle;
    }

    private boolean sameJavaClass(String one, String two) {
        int index1 = one.indexOf("[");
        int index2 = two.indexOf("[");
        if (index1 > 0) {
            one = one.substring(0, index1);
        }
        if (index2 > 0) {
            two = two.substring(0, index2);
        }
        return one.equals(two);
    }

    protected void setAllReferencesToTrue() {
        Iterator it = this.symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (entry instanceof BindingEntry && ((BindingEntry)entry).getBindingType() != 0) {
                    entry.setIsReferenced(false);
                    continue;
                }
                entry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> unusedPortTypes = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> usedPortTypes = new Vector<PortTypeEntry>();
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bEntry.getBindingType() == 0) {
                    usedPortTypes.add(ptEntry);
                    if (!unusedPortTypes.contains(ptEntry)) continue;
                    unusedPortTypes.remove(ptEntry);
                    continue;
                }
                bEntry.setIsReferenced(false);
                if (usedPortTypes.contains(ptEntry)) continue;
                unusedPortTypes.add(ptEntry);
            }
        }
        for (int i = 0; i < unusedPortTypes.size(); ++i) {
            PortTypeEntry ptEntry = (PortTypeEntry)unusedPortTypes.get(i);
            ptEntry.setIsReferenced(false);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                if (!(entry instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)entry;
                Binding binding = bEntry.getBinding();
                PortTypeEntry ptEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = ptEntry.getPortType();
                Iterator operations = portType.getOperations().iterator();
                while (operations.hasNext()) {
                    Operation operation = (Operation)operations.next();
                    OperationType type = operation.getStyle();
                    String name = operation.getName();
                    Parameters parameters = bEntry.getParameters(operation);
                    if (type == OperationType.SOLICIT_RESPONSE) {
                        parameters.signature = "    // " + Messages.getMessage("invalidSolResp00", name);
                        System.err.println(Messages.getMessage("invalidSolResp00", name));
                        continue;
                    }
                    if (type == OperationType.NOTIFICATION) {
                        parameters.signature = "    // " + Messages.getMessage("invalidNotif00", name);
                        System.err.println(Messages.getMessage("invalidNotif00", name));
                        continue;
                    }
                    if (parameters == null) continue;
                    parameters.signature = this.constructSignature(parameters, name);
                }
            }
        }
    }

    private String constructSignature(Parameters parms, String opName) {
        String name = Utils.xmlNameToJava(opName);
        String ret = "void";
        if (parms != null && parms.returnParam != null) {
            ret = Utils.getParameterTypeName(parms.returnParam);
        }
        String signature = "    public " + ret + " " + name + "(";
        boolean needComma = false;
        for (int i = 0; parms != null && i < parms.list.size(); ++i) {
            Parameter p = (Parameter)parms.list.get(i);
            if (needComma) {
                signature = signature + ", ";
            } else {
                needComma = true;
            }
            String javifiedName = Utils.xmlNameToJava(p.getName());
            signature = p.getMode() == 1 ? signature + Utils.getParameterTypeName(p) + " " + javifiedName : signature + Utils.holder(p.getMIMEInfo(), p.getType(), this.emitter) + " " + javifiedName;
        }
        signature = signature + ") throws java.rmi.RemoteException";
        if (parms != null && parms.faults != null) {
            Iterator i = parms.faults.values().iterator();
            while (i.hasNext()) {
                Fault fault = (Fault)i.next();
                String exceptionName = Utils.getFullExceptionName(fault.getMessage(), this.symbolTable);
                if (exceptionName == null) continue;
                signature = signature + ", " + exceptionName;
            }
        }
        return signature;
    }

    protected void determineIfHoldersNeeded(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                if (!(v.get(i) instanceof BindingEntry)) continue;
                BindingEntry bEntry = (BindingEntry)v.get(i);
                Iterator operations = bEntry.getParameters().values().iterator();
                while (operations.hasNext()) {
                    Parameters parms = (Parameters)operations.next();
                    for (int j = 0; j < parms.list.size(); ++j) {
                        Type anonType;
                        QName anonQName;
                        Parameter p = (Parameter)parms.list.get(j);
                        if (p.getMode() == 1) continue;
                        TypeEntry typeEntry = p.getType();
                        typeEntry.setDynamicVar("Holder is needed", new Boolean(true));
                        if (!typeEntry.isSimpleType() && typeEntry.getRefType() != null) {
                            typeEntry.getRefType().setDynamicVar("Holder is needed", new Boolean(true));
                        }
                        if ((anonQName = SchemaUtils.getElementAnonQName(p.getType().getNode())) == null || (anonType = symbolTable.getType(anonQName)) == null) continue;
                        anonType.setDynamicVar("Holder is needed", new Boolean(true));
                    }
                }
            }
        }
    }

    public void setBaseTypeMapping(BaseTypeMapping btm) {
        this.btm = btm;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

                public String getBaseName(QName qNameIn) {
                    QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                    Class cls = this.defaultTM.getClassForQName(qName);
                    if (cls == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(cls.getName());
                }
            };
        }
        return this.btm;
    }

    protected class Writers
    implements Generator {
        Vector writers = new Vector();
        SymbolTable symbolTable = null;
        Generator baseWriter = null;
        SymTabEntry entry = null;
        Definition def = null;

        protected Writers() {
        }

        public void addGenerator(Class writer) {
            this.writers.add(writer);
        }

        public void addStuff(Generator baseWriter, SymTabEntry entry, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.entry = entry;
            this.symbolTable = symbolTable;
        }

        public void addStuff(Generator baseWriter, Definition def, SymbolTable symbolTable) {
            this.baseWriter = baseWriter;
            this.def = def;
            this.symbolTable = symbolTable;
        }

        public void generate() throws IOException {
            if (this.baseWriter != null) {
                this.baseWriter.generate();
            }
            Class[] formalArgs = null;
            Object[] actualArgs = null;
            if (this.entry != null) {
                formalArgs = new Class[]{class$com$cognos$org$apache$axis$wsdl$toJava$Emitter == null ? (class$com$cognos$org$apache$axis$wsdl$toJava$Emitter = JavaGeneratorFactory.class$("com.cognos.org.apache.axis.wsdl.toJava.Emitter")) : class$com$cognos$org$apache$axis$wsdl$toJava$Emitter, this.entry.getClass(), class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable = JavaGeneratorFactory.class$("com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{JavaGeneratorFactory.this.emitter, this.entry, this.symbolTable};
            } else {
                formalArgs = new Class[]{class$com$cognos$org$apache$axis$wsdl$toJava$Emitter == null ? (class$com$cognos$org$apache$axis$wsdl$toJava$Emitter = JavaGeneratorFactory.class$("com.cognos.org.apache.axis.wsdl.toJava.Emitter")) : class$com$cognos$org$apache$axis$wsdl$toJava$Emitter, class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable == null ? (class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable = JavaGeneratorFactory.class$("com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable")) : class$com$cognos$org$apache$axis$wsdl$symbolTable$SymbolTable};
                actualArgs = new Object[]{JavaGeneratorFactory.this.emitter, this.def, this.symbolTable};
            }
            for (int i = 0; i < this.writers.size(); ++i) {
                Class wClass = (Class)this.writers.get(i);
                Generator gen = null;
                try {
                    Constructor ctor = wClass.getConstructor(formalArgs);
                    gen = (Generator)ctor.newInstance(actualArgs);
                }
                catch (Throwable t) {
                    throw new IOException(Messages.getMessage("exception01", t.getMessage()));
                }
                gen.generate();
            }
        }
    }
}

