/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.utils.WSDLUtils;
import com.cognos.org.apache.axis.wsdl.symbolTable.BindingEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.ServiceEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaBindingWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaClassWriter;
import com.cognos.org.apache.axis.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class JavaServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "Locator", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends com.cognos.org.apache.axis.client.Service ";
    }

    protected String getImplementsText() {
        return "implements " + this.sEntry.getName() + ' ';
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(pw, service.getDocumentationElement());
        Vector<String> getPortIfaces = new Vector<String>();
        Vector<String> getPortStubClasses = new Vector<String>();
        Vector<String> getPortPortNames = new Vector<String>();
        boolean printGetPortNotice = false;
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId(portName)) {
                portName = Utils.xmlNameToJavaClass(portName);
            }
            String stubClass = bEntry.getName() + "Stub";
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            if (getPortIfaces.contains(bindingType)) {
                printGetPortNotice = true;
            }
            getPortIfaces.add(bindingType);
            getPortStubClasses.add(stubClass);
            getPortPortNames.add(portName);
            String address = WSDLUtils.getAddressFromPort(p);
            if (address == null) {
                throw new IOException(Messages.getMessage("emitFail02", portName, this.className));
            }
            try {
                new URL(address);
            }
            catch (MalformedURLException e) {
                throw new IOException(Messages.getMessage("emitFail03", new String[]{portName, this.className, address}));
            }
            this.writeAddressInfo(pw, portName, address, p);
            String wsddServiceName = portName + "WSDDServiceName";
            this.writeWSDDServiceNameInfo(pw, wsddServiceName, portName);
            this.writeGetPortName(pw, bindingType, portName);
            this.writeGetPortNameURL(pw, bindingType, portName, stubClass, wsddServiceName);
        }
        this.writeGetPortClass(pw, getPortIfaces, getPortStubClasses, getPortPortNames, printGetPortNotice);
        this.writeGetPortQNameClass(pw, getPortPortNames);
        this.writeGetServiceName(pw, this.sEntry.getQName());
        this.writeGetPorts(pw, getPortPortNames);
    }

    protected void writeAddressInfo(PrintWriter pw, String portName, String address, Port p) {
        pw.println();
        pw.println("    // " + Messages.getMessage("getProxy00", portName));
        this.writeComment(pw, p.getDocumentationElement());
        pw.println("    private final java.lang.String " + portName + "_address = \"" + address + "\";");
        pw.println();
        pw.println("    public java.lang.String get" + portName + "Address() {");
        pw.println("        return " + portName + "_address;");
        pw.println("    }");
        pw.println();
    }

    protected void writeWSDDServiceNameInfo(PrintWriter pw, String wsddServiceName, String portName) {
        pw.println("    // " + Messages.getMessage("wsddServiceName00"));
        pw.println("    private java.lang.String " + wsddServiceName + " = \"" + portName + "\";");
        pw.println();
        pw.println("    public java.lang.String get" + wsddServiceName + "() {");
        pw.println("        return " + wsddServiceName + ";");
        pw.println("    }");
        pw.println();
        pw.println("    public void set" + wsddServiceName + "(java.lang.String name) {");
        pw.println("        " + wsddServiceName + " = name;");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortName(PrintWriter pw, String bindingType, String portName) {
        pw.println("    public " + bindingType + " get" + portName + "() throws " + ServiceException.class.getName() + " {");
        pw.println("       java.net.URL endpoint;");
        pw.println("        try {");
        pw.println("            endpoint = new java.net.URL(" + portName + "_address);");
        pw.println("        }");
        pw.println("        catch (java.net.MalformedURLException e) {");
        pw.println("            throw new javax.xml.rpc.ServiceException(e);");
        pw.println("        }");
        pw.println("        return get" + portName + "(endpoint);");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortNameURL(PrintWriter pw, String bindingType, String portName, String stubClass, String wsddServiceName) {
        pw.println("    public " + bindingType + " get" + portName + "(java.net.URL portAddress) throws " + ServiceException.class.getName() + " {");
        pw.println("        try {");
        pw.println("            " + stubClass + " _stub = new " + stubClass + "(portAddress, this);");
        pw.println("            _stub.setPortName(get" + wsddServiceName + "());");
        pw.println("            return _stub;");
        pw.println("        }");
        pw.println("        catch (com.cognos.org.apache.axis.AxisFault e) {");
        pw.println("            return null;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortClass(PrintWriter pw, Vector getPortIfaces, Vector getPortStubClasses, Vector getPortPortNames, boolean printGetPortNotice) {
        pw.println("    /**");
        pw.println("     * " + Messages.getMessage("getPortDoc00"));
        pw.println("     * " + Messages.getMessage("getPortDoc01"));
        pw.println("     * " + Messages.getMessage("getPortDoc02"));
        if (printGetPortNotice) {
            pw.println("     * " + Messages.getMessage("getPortDoc03"));
            pw.println("     * " + Messages.getMessage("getPortDoc04"));
        }
        pw.println("     */");
        pw.println("    public java.rmi.Remote getPort(Class serviceEndpointInterface) throws " + ServiceException.class.getName() + " {");
        if (getPortIfaces.size() == 0) {
            pw.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        } else {
            pw.println("        try {");
            for (int i = 0; i < getPortIfaces.size(); ++i) {
                String iface = (String)getPortIfaces.get(i);
                String stubClass = (String)getPortStubClasses.get(i);
                String portName = (String)getPortPortNames.get(i);
                pw.println("            if (" + iface + ".class.isAssignableFrom(serviceEndpointInterface)) {");
                pw.println("                " + stubClass + " _stub = new " + stubClass + "(new java.net.URL(" + portName + "_address), this);");
                pw.println("                _stub.setPortName(get" + portName + "WSDDServiceName());");
                pw.println("                return _stub;");
                pw.println("            }");
            }
            pw.println("        }");
            pw.println("        catch (java.lang.Throwable t) {");
            pw.println("            throw new " + ServiceException.class.getName() + "(t);");
            pw.println("        }");
            pw.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        }
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortQNameClass(PrintWriter pw, Vector getPortPortNames) {
        pw.println("    /**");
        pw.println("     * " + Messages.getMessage("getPortDoc00"));
        pw.println("     * " + Messages.getMessage("getPortDoc01"));
        pw.println("     * " + Messages.getMessage("getPortDoc02"));
        pw.println("     */");
        pw.println("    public java.rmi.Remote getPort(javax.xml.namespace.QName portName, Class serviceEndpointInterface) throws " + ServiceException.class.getName() + " {");
        pw.println("        if (portName == null) {");
        pw.println("            return getPort(serviceEndpointInterface);");
        pw.println("        }");
        pw.println("        String inputPortName = portName.getLocalPart();");
        pw.print("        ");
        for (int i = 0; i < getPortPortNames.size(); ++i) {
            String portName = (String)getPortPortNames.get(i);
            pw.println("if (\"" + portName + "\".equals(inputPortName)) {");
            pw.println("            return get" + portName + "();");
            pw.println("        }");
            pw.print("        else ");
        }
        pw.println(" {");
        pw.println("            java.rmi.Remote _stub = getPort(serviceEndpointInterface);");
        pw.println("            ((com.cognos.org.apache.axis.client.Stub) _stub).setPortName(portName);");
        pw.println("            return _stub;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetServiceName(PrintWriter pw, QName qname) {
        pw.println("    public javax.xml.namespace.QName getServiceName() {");
        pw.println("        return " + Utils.getNewQName(qname) + ";");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPorts(PrintWriter pw, Vector portNames) {
        pw.println("    private java.util.HashSet ports = null;");
        pw.println();
        pw.println("    public java.util.Iterator getPorts() {");
        pw.println("        if (ports == null) {");
        pw.println("            ports = new java.util.HashSet();");
        for (int i = 0; i < portNames.size(); ++i) {
            pw.println("            ports.add(new javax.xml.namespace.QName(\"" + portNames.get(i) + "\"));");
        }
        pw.println("        }");
        pw.println("        return ports.iterator();");
        pw.println("    }");
        pw.println();
    }
}

