/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.attachments;

import com.cognos.org.apache.axis.components.image.ImageIOFactory;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.utils.Messages;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class ImageDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ImageDataSource.class.getName());
    public static final String CONTENT_TYPE = "image/jpeg";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayOutputStream os;

    public ImageDataSource(String name, Image data) {
        this(name, CONTENT_TYPE, data);
    }

    public ImageDataSource(String name, String contentType, Image data) {
        this.name = name;
        this.contentType = contentType == null ? CONTENT_TYPE : contentType;
        this.os = new ByteArrayOutputStream();
        try {
            if (data != null) {
                ImageIOFactory.getImageIO().saveImage(this.contentType, data, this.os);
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

