/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.description.TypeDesc;
import com.cognos.org.apache.axis.encoding.Deserializer;
import com.cognos.org.apache.axis.encoding.ser.BaseDeserializerFactory;
import com.cognos.org.apache.axis.encoding.ser.BeanDeserializer;
import com.cognos.org.apache.axis.encoding.ser.EnumDeserializer;
import com.cognos.org.apache.axis.utils.BeanPropertyDescriptor;
import com.cognos.org.apache.axis.utils.BeanUtils;
import com.cognos.org.apache.axis.utils.JavaUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class BeanDeserializerFactory
extends BaseDeserializerFactory {
    protected transient TypeDesc typeDesc = null;
    protected transient Map propertyMap = null;

    public BeanDeserializerFactory(Class javaType, QName xmlType) {
        super(BeanDeserializer.class, xmlType, javaType);
        if (JavaUtils.isEnumClass(javaType)) {
            this.deserClass = EnumDeserializer.class;
        }
        this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
        this.propertyMap = BeanDeserializerFactory.getProperties(javaType, this.typeDesc);
    }

    public static Map getProperties(Class javaType, TypeDesc typeDesc) {
        HashMap<String, BeanPropertyDescriptor> propertyMap = null;
        if (typeDesc != null) {
            propertyMap = typeDesc.getPropertyDescriptorMap();
        } else {
            BeanPropertyDescriptor[] pd = BeanUtils.getPd(javaType, null);
            propertyMap = new HashMap<String, BeanPropertyDescriptor>();
            for (int i = 0; i < pd.length; ++i) {
                BeanPropertyDescriptor descriptor = pd[i];
                propertyMap.put(descriptor.getName(), descriptor);
            }
        }
        return propertyMap;
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.deserClass == EnumDeserializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        return new BeanDeserializer(this.javaType, this.xmlType, this.typeDesc, this.propertyMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
        this.propertyMap = BeanDeserializerFactory.getProperties(this.javaType, this.typeDesc);
    }
}

