/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.encoding.Target;
import com.cognos.org.apache.axis.utils.BeanPropertyDescriptor;
import com.cognos.org.apache.axis.utils.JavaUtils;
import com.cognos.org.apache.axis.utils.Messages;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class BeanPropertyTarget
implements Target {
    protected static Log log = LogFactory.getLog(BeanPropertyTarget.class.getName());
    private Object object;
    private BeanPropertyDescriptor pd;
    private int index = -1;

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd) {
        this.object = object;
        this.pd = pd;
        this.index = -1;
    }

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd, int i) {
        this.object = object;
        this.pd = pd;
        this.index = i;
    }

    public void set(Object value) throws SAXException {
        try {
            if (this.index < 0) {
                this.pd.set(this.object, value);
            } else {
                this.pd.set(this.object, this.index, value);
            }
        }
        catch (Exception e) {
            try {
                Class<?> type = this.pd.getType();
                if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive() && type.isArray() && type.getComponentType().equals(Object.class)) {
                    type = Array.newInstance(JavaUtils.getWrapperClass(value.getClass().getComponentType()), 0).getClass();
                }
                if (JavaUtils.isConvertable(value, type)) {
                    value = JavaUtils.convert(value, type);
                    if (this.index < 0) {
                        this.pd.set(this.object, value);
                    } else {
                        this.pd.set(this.object, this.index, value);
                    }
                }
                if (this.index == 0 && value.getClass().isArray() && !type.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object item = JavaUtils.convert(Array.get(value, i), type);
                        this.pd.set(this.object, i, item);
                    }
                }
                throw e;
            }
            catch (Exception ex) {
                Throwable t;
                String field = this.pd.getName();
                if (this.index >= 0) {
                    field = field + "[" + this.index + "]";
                }
                if (log.isErrorEnabled()) {
                    String valueType = "null";
                    if (value != null) {
                        valueType = value.getClass().getName();
                    }
                    log.error((Object)Messages.getMessage("cantConvert02", new String[]{valueType, field, this.index >= 0 ? this.pd.getType().getComponentType().getName() : this.pd.getType().getName()}));
                }
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) != null) {
                    String classname = this.object.getClass().getName();
                    throw new SAXException(Messages.getMessage("cantConvert04", new String[]{classname, field, value == null ? null : value.toString(), t.getMessage()}));
                }
                throw new SAXException(ex);
            }
        }
    }
}

