/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.encoding.ser;

import com.cognos.org.apache.axis.encoding.ser.BaseDeserializerFactory;
import com.cognos.org.apache.axis.encoding.ser.SimpleDeserializer;
import com.cognos.org.apache.axis.utils.BeanPropertyDescriptor;
import com.cognos.org.apache.axis.utils.BeanUtils;
import com.cognos.org.apache.axis.utils.JavaUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;

public class SimpleDeserializerFactory
extends BaseDeserializerFactory {
    private static final Class[] STRING_STRING_CLASS = new Class[]{String.class, String.class};
    private static final Class[] STRING_CLASS = new Class[]{String.class};
    private transient Constructor constructor = null;
    private boolean isBasicType = false;

    public SimpleDeserializerFactory(Class javaType, QName xmlType) {
        super(SimpleDeserializer.class, xmlType, javaType);
        this.isBasicType = JavaUtils.isBasic(javaType);
        this.initConstructor(javaType);
    }

    private void initConstructor(Class javaType) {
        if (!this.isBasicType) {
            try {
                this.constructor = QName.class.isAssignableFrom(javaType) ? javaType.getDeclaredConstructor(STRING_STRING_CLASS) : javaType.getDeclaredConstructor(STRING_CLASS);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.constructor = javaType.getDeclaredConstructor(new Class[0]);
                    BeanPropertyDescriptor[] pds = BeanUtils.getPd(javaType);
                    if (pds != null && BeanUtils.getSpecificPD(pds, "_value") != null) {
                        return;
                    }
                    throw new IllegalArgumentException(e.toString());
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalArgumentException(ex.toString());
                }
            }
        }
    }

    public Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
        if (this.javaType == Object.class) {
            return null;
        }
        if (this.isBasicType) {
            return new SimpleDeserializer(this.javaType, this.xmlType);
        }
        SimpleDeserializer deser = (SimpleDeserializer)super.getDeserializerAs(mechanismType);
        if (deser != null) {
            deser.setConstructor(this.constructor);
        }
        return deser;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initConstructor(this.javaType);
    }
}

