/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.handlers.soap;

import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.Message;
import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.description.OperationDesc;
import com.cognos.org.apache.axis.handlers.BasicHandler;
import com.cognos.org.apache.axis.handlers.soap.SOAPService;
import com.cognos.org.apache.axis.message.SOAPEnvelope;
import com.cognos.org.apache.axis.message.SOAPHeaderElement;
import com.cognos.org.apache.axis.soap.SOAPConstants;
import com.cognos.org.apache.axis.utils.Messages;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class MustUnderstandChecker
extends BasicHandler {
    private static Log log = LogFactory.getLog(MustUnderstandChecker.class.getName());
    private SOAPService service = null;

    public MustUnderstandChecker(SOAPService service) {
        this.service = service;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        Message msg;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("semanticCheck00"));
        }
        if ((msg = msgContext.getCurrentMessage()) == null) {
            return;
        }
        SOAPEnvelope env = msg.getSOAPEnvelope();
        Vector headers = null;
        if (this.service != null) {
            ArrayList acts = this.service.getActors();
            headers = env.getHeadersByActor(acts);
        } else {
            headers = env.getHeaders();
        }
        Vector<SOAPHeaderElement> misunderstoodHeaders = null;
        Enumeration enumeration = headers.elements();
        while (enumeration.hasMoreElements()) {
            OperationDesc oper;
            SOAPHeaderElement header = (SOAPHeaderElement)enumeration.nextElement();
            if (msgContext != null && msgContext.getOperation() != null && (oper = msgContext.getOperation()).getParamByQName(header.getQName()) != null || !header.getMustUnderstand() || header.isProcessed()) continue;
            if (misunderstoodHeaders == null) {
                misunderstoodHeaders = new Vector<SOAPHeaderElement>();
            }
            misunderstoodHeaders.addElement(header);
        }
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        if (misunderstoodHeaders != null) {
            AxisFault fault = new AxisFault(soapConstants.getMustunderstandFaultQName(), null, null, null, null, null);
            StringBuffer whatWasMissUnderstood = new StringBuffer(256);
            enumeration = misunderstoodHeaders.elements();
            while (enumeration.hasMoreElements()) {
                SOAPHeaderElement badHeader = (SOAPHeaderElement)enumeration.nextElement();
                QName badQName = new QName(badHeader.getNamespaceURI(), badHeader.getName());
                if (whatWasMissUnderstood.length() != 0) {
                    whatWasMissUnderstood.append(", ");
                }
                whatWasMissUnderstood.append(badQName.toString());
                if (soapConstants != SOAPConstants.SOAP12_CONSTANTS) continue;
                SOAPHeaderElement newHeader = new SOAPHeaderElement("http://www.w3.org/2003/05/soap-envelope", "NotUnderstood");
                newHeader.addAttribute(null, "qname", badQName);
                fault.addHeader(newHeader);
            }
            fault.setFaultString(Messages.getMessage("noUnderstand00", whatWasMissUnderstood.toString()));
            throw fault;
        }
    }
}

