/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.transport.jms;

import com.cognos.org.apache.axis.AxisEngine;
import com.cognos.org.apache.axis.AxisFault;
import com.cognos.org.apache.axis.MessageContext;
import com.cognos.org.apache.axis.client.Call;
import com.cognos.org.apache.axis.client.Transport;
import com.cognos.org.apache.axis.components.jms.JMSVendorAdapter;
import com.cognos.org.apache.axis.components.jms.JMSVendorAdapterFactory;
import com.cognos.org.apache.axis.components.logger.LogFactory;
import com.cognos.org.apache.axis.transport.jms.JMSConnector;
import com.cognos.org.apache.axis.transport.jms.JMSConnectorManager;
import com.cognos.org.apache.axis.transport.jms.JMSURLHelper;
import com.cognos.org.apache.axis.utils.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class JMSTransport
extends Transport {
    protected static Log log = LogFactory.getLog(JMSTransport.class.getName());
    private static HashMap vendorConnectorPools = new HashMap();
    private HashMap defaultConnectorProps;
    private HashMap defaultConnectionFactoryProps;

    public JMSTransport() {
        this.transportName = "JMSTransport";
    }

    public JMSTransport(HashMap connectorProps, HashMap connectionFactoryProps) {
        this();
        this.defaultConnectorProps = connectorProps;
        this.defaultConnectionFactoryProps = connectionFactoryProps;
    }

    public void setupMessageContextImpl(MessageContext context, Call message, AxisEngine engine) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::setupMessageContextImpl");
        }
        JMSConnector connector = null;
        HashMap connectorProperties = null;
        HashMap connectionFactoryProperties = null;
        JMSVendorAdapter vendorAdapter = null;
        JMSURLHelper jmsurl = null;
        String username = message.getUsername();
        String password = message.getPassword();
        String endpointAddr = message.getTargetEndpointAddress();
        if (endpointAddr != null) {
            try {
                jmsurl = new JMSURLHelper(new URL(endpointAddr));
                String vendorId = jmsurl.getVendor();
                if (vendorId == null) {
                    vendorId = "JNDI";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JMSTransport.setupMessageContextImpl(): endpt=" + endpointAddr + ", vendor=" + vendorId));
                }
                if ((vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(vendorId)) == null) {
                    throw new AxisFault("cannotLoadAdapterClass:" + vendorId);
                }
                connectorProperties = vendorAdapter.getJMSConnectorProperties(jmsurl);
                connectionFactoryProperties = vendorAdapter.getJMSConnectionFactoryProperties(jmsurl);
            }
            catch (MalformedURLException e) {
                log.error((Object)Messages.getMessage("malformedURLException00"), (Throwable)e);
                throw new AxisFault(Messages.getMessage("malformedURLException00"), e);
            }
        } else {
            vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
            if (vendorAdapter == null) {
                throw new AxisFault("cannotLoadAdapterClass");
            }
            connectorProperties = this.defaultConnectorProps;
            connectionFactoryProperties = this.defaultConnectionFactoryProps;
        }
        try {
            connector = JMSConnectorManager.getInstance().getConnector(connectorProperties, connectionFactoryProperties, username, password, vendorAdapter);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("cannotConnectError"), (Throwable)e);
            if (e instanceof AxisFault) {
                throw (AxisFault)e;
            }
            throw new AxisFault("cannotConnect", e);
        }
        context.setProperty("transport.jms.Connector", connector);
        context.setProperty("transport.jms.VendorAdapter", vendorAdapter);
        vendorAdapter.setupMessageContext(context, message, jmsurl);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::setupMessageContextImpl");
        }
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::shutdown");
        }
        JMSTransport.closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::shutdown");
        }
    }

    public static void closeAllConnectors() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::closeAllConnectors");
        }
        JMSConnectorManager.getInstance().closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::closeAllConnectors");
        }
    }

    public static void closeMatchingJMSConnectors(String endpointAddr, String username, String password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::closeMatchingJMSConnectors");
        }
        try {
            JMSURLHelper jmsurl = new JMSURLHelper(new URL(endpointAddr));
            String vendorId = jmsurl.getVendor();
            JMSVendorAdapter vendorAdapter = null;
            if (vendorId == null) {
                vendorId = "JNDI";
            }
            if ((vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(vendorId)) == null) {
                return;
            }
            HashMap connectorProps = vendorAdapter.getJMSConnectorProperties(jmsurl);
            HashMap cfProps = vendorAdapter.getJMSConnectionFactoryProperties(jmsurl);
            JMSConnectorManager.getInstance().closeMatchingJMSConnectors(connectorProps, cfProps, username, password, vendorAdapter);
        }
        catch (MalformedURLException e) {
            log.warn((Object)Messages.getMessage("malformedURLException00"), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::closeMatchingJMSConnectors");
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JMSTransport.closeAllConnectors();
            }
        });
    }
}

