/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.utils;

import com.cognos.org.apache.axis.components.logger.LogFactory;
import java.util.Random;
import org.apache.commons.logging.Log;

public class SessionUtils {
    protected static Log log = LogFactory.getLog(SessionUtils.class.getName());
    protected static final int SESSION_ID_BYTES = 16;
    protected static Random random = null;
    protected static String randomClass = "java.security.SecureRandom";
    private static String thisHost = null;

    public static synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        SessionUtils.getRandom().nextBytes(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    public static synchronized Long generateSession() {
        return new Long(SessionUtils.getRandom().nextLong());
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(randomClass);
                random = (Random)clazz.newInstance();
            }
            catch (Exception e) {
                random = new Random();
            }
        }
        return random;
    }
}

