/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.wsdl.gen.Generator;
import com.cognos.org.apache.axis.wsdl.symbolTable.ServiceEntry;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaServiceIfaceWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaServiceImplWriter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaTestCaseWriter;
import java.io.IOException;
import javax.wsdl.Service;

public class JavaServiceWriter
implements Generator {
    protected Generator serviceIfaceWriter = null;
    protected Generator serviceImplWriter = null;
    protected Generator testCaseWriter = null;
    public static final String PORT_NAME = "port name";
    protected Emitter emitter;
    protected Service service;
    protected SymbolTable symbolTable;

    public JavaServiceWriter(Emitter emitter, Service service, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.service = service;
        this.symbolTable = symbolTable;
    }

    protected void setGenerators() {
        ServiceEntry sEntry = this.symbolTable.getServiceEntry(this.service.getQName());
        if (sEntry.isReferenced()) {
            this.serviceIfaceWriter = new JavaServiceIfaceWriter(this.emitter, sEntry, this.symbolTable);
            this.serviceImplWriter = new JavaServiceImplWriter(this.emitter, sEntry, this.symbolTable);
            if (this.emitter.isTestCaseWanted()) {
                this.testCaseWriter = new JavaTestCaseWriter(this.emitter, sEntry, this.symbolTable);
            }
        }
    }

    protected void postSetGenerators() {
        if (this.emitter.isDeploy()) {
            this.serviceIfaceWriter = null;
            this.serviceImplWriter = null;
        }
    }

    public void generate() throws IOException {
        this.setGenerators();
        this.postSetGenerators();
        if (this.serviceIfaceWriter != null) {
            this.serviceIfaceWriter.generate();
        }
        if (this.serviceImplWriter != null) {
            this.serviceImplWriter.generate();
        }
        if (this.testCaseWriter != null) {
            this.testCaseWriter.generate();
        }
    }
}

