/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.org.apache.axis.wsdl.toJava;

import com.cognos.org.apache.axis.utils.Messages;
import com.cognos.org.apache.axis.wsdl.symbolTable.SymbolTable;
import com.cognos.org.apache.axis.wsdl.toJava.Emitter;
import com.cognos.org.apache.axis.wsdl.toJava.JavaWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class JavaUndeployWriter
extends JavaWriter {
    protected Definition definition;

    public JavaUndeployWriter(Emitter emitter, Definition definition, SymbolTable notUsed) {
        super(emitter, "undeploy");
        this.definition = definition;
    }

    public void generate() throws IOException {
        if (this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected String getFileName() {
        String dir = this.emitter.getNamespaces().getAsDir(this.definition.getTargetNamespace());
        return dir + "undeploy.wsdd";
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        pw.println(Messages.getMessage("deploy01"));
        pw.println(Messages.getMessage("deploy02"));
        pw.println(Messages.getMessage("deploy04"));
        pw.println(Messages.getMessage("deploy05"));
        pw.println(Messages.getMessage("deploy06"));
        pw.println(Messages.getMessage("deploy08"));
        pw.println(Messages.getMessage("deploy09"));
        pw.println();
        pw.println("<undeployment");
        pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\">");
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeDeployServices(pw);
        pw.println("</undeployment>");
    }

    protected void writeDeployServices(PrintWriter pw) throws IOException {
        Map serviceMap = this.definition.getServices();
        for (Service myService : serviceMap.values()) {
            pw.println();
            pw.println("  <!-- " + Messages.getMessage("wsdlService00", myService.getQName().getLocalPart()) + " -->");
            pw.println();
            for (Port myPort : myService.getPorts().values()) {
                this.writeDeployPort(pw, myPort);
            }
        }
    }

    protected void writeDeployPort(PrintWriter pw, Port port) throws IOException {
        String serviceName = port.getName();
        pw.println("  <service name=\"" + serviceName + "\"/>");
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        return new PrintWriter(writer);
    }
}

