/*
 * Decompiled with CFR 0.152.
 */
package com.cognos;

import com.cognos.CRNConnect;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_Port;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.log4j.Logger;

public class CrnQuery {
    public static final int TYPE_UNKNOW = -1;
    public static final int TYPE_PACKAGE = 0;
    public static final int TYPE_FOLDER = 1;
    public static final int TYPE_QUERY = 2;
    public static final int TYPE_REPORT = 3;
    public static final int TYPE_URL = 4;
    public static final int TYPE_ANALYSIS = 5;
    public static final int TYPE_OUTPUT = 6;
    public static final int TYPE_REPORTVERSION = 7;
    public static final int TYPE_DOCUMENT = 8;
    public static final int TYPE_DASHBOARD = 9;
    private static final Logger logger;
    private ContentManagerService_Port cmService = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cognos.CrnQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public CrnQuery(String sendPoint) {
        ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
        try {
            this.cmService = cmServiceLocator.getcontentManagerService(new URL(sendPoint));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public ContentManagerService_Port getCMService() {
        return this.cmService;
    }

    public static boolean ValidCamPassport(ContentManagerService_Port cmServicePort, String CamPassport) {
        BiBusHeader bibus = new BiBusHeader();
        CAM cam = new CAM();
        CAMPassport camPass = new CAMPassport();
        camPass.setId(CamPassport);
        cam.setCAMPassport(camPass);
        bibus.setCAM(cam);
        ((Stub)cmServicePort).setHeader("", "biBusHeader", (Object)bibus);
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName};
        Sort[] sortArray = new Sort[]{new Sort()};
        try {
            BaseClass[] bc = cmServicePort.query(new SearchPathMultipleObject("~"), props, sortArray, new QueryOptions());
        }
        catch (Exception ex) {
            BiBusHeader theException = (BiBusHeader)((Stub)cmServicePort).getHeaderObject("", "biBusHeader");
            if (theException.getCAM().getException().getErrorCodeString().equals("camAuthUserRecoverable")) {
                logger.info((Object)"The user must login again");
                return false;
            }
            logger.info((Object)"Some other problem");
            return false;
        }
        logger.info((Object)"Passport is Valid");
        return true;
    }

    public void getValidpassport(ContentManagerService_Port cmServicePort, String passport) {
        BiBusHeader bibus = new BiBusHeader();
        CAM cam = new CAM();
        CAMPassport camPass = new CAMPassport();
        camPass.setId(passport);
        cam.setCAMPassport(camPass);
        bibus.setCAM(cam);
        ((Stub)cmServicePort).setHeader("", "biBusHeader", (Object)bibus);
    }

    public String[][] query(ContentManagerService_Port cms, String searchPath) {
        String[][] result = null;
        String output = new String();
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.hasChildren, PropEnum.objectClass, PropEnum.format, PropEnum.storeID};
        if (cms != null) {
            Sort[] sortArray = new Sort[]{new Sort()};
            try {
                BaseClass[] bc = cms.query(new SearchPathMultipleObject(searchPath), props, sortArray, new QueryOptions());
                if (bc == null) {
                    System.out.println("\n\nError occurred in function viewAll.");
                }
                if (bc.length <= 0) {
                    System.out.println("There are currently no published packages or reports.");
                }
                result = new String[bc.length][7];
                int i = 0;
                while (i < bc.length) {
                    String objectName = bc[i].getDefaultName().getValue();
                    String objectPath = bc[i].getSearchPath().getValue();
                    String objectClass = bc[i].getObjectClass().getValue().getValue();
                    int objectType = this.getType(objectClass);
                    int parent = 0;
                    String outFormat = "";
                    String storeid = "";
                    CrnQuery _tmp = this;
                    if (6 == objectType) {
                        outFormat = ((Output)bc[i]).getFormat().getValue();
                    } else if (8 == objectType || 9 == objectType) {
                        storeid = bc[i].getStoreID().getValue().getValue();
                    }
                    result[i] = new String[]{String.valueOf(i + 1), objectName, String.valueOf(objectType), objectPath, String.valueOf(parent), "0", outFormat, storeid};
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String queryAccountUserName(ContentManagerService_Port cms, String searchPath) {
        String result = null;
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.hasChildren, PropEnum.objectClass, PropEnum.userName};
        if (cms != null) {
            Sort[] sortArray = new Sort[]{new Sort()};
            try {
                BaseClass[] bc = cms.query(new SearchPathMultipleObject(searchPath), props, sortArray, new QueryOptions());
                if (bc == null) {
                    System.out.println("\n\nError occurred in function viewAll.");
                }
                if (bc.length <= 0) {
                    System.out.println("There are currently no published packages or reports.");
                }
                result = "";
                int i = 0;
                while (i < bc.length) {
                    result = ((Account)bc[i]).getUserName().getValue();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private int getType(String objectPath) {
        CrnQuery _tmp = this;
        int type = -1;
        if ("package".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp1 = this;
            type = 0;
        } else if ("folder".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp2 = this;
            type = 1;
        } else if ("query".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp3 = this;
            type = 2;
        } else if ("report".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp4 = this;
            type = 3;
        } else if ("url".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp5 = this;
            type = 4;
        } else if ("analysis".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp6 = this;
            type = 5;
        } else if ("output".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp7 = this;
            type = 6;
        } else if ("reportVersion".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp8 = this;
            type = 7;
        } else if ("document".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp9 = this;
            type = 8;
        } else if ("dashboard".equalsIgnoreCase(objectPath)) {
            CrnQuery _tmp10 = this;
            type = 9;
        }
        return type;
    }

    public void updateParent(String[][] result) {
        boolean parent = false;
        int i = 0;
        while (i < result.length) {
            if (Integer.parseInt(result[i][2]) == 0) {
                result[i][4] = "0";
                result[i][5] = "1";
            } else {
                String parentPath = null;
                int endIndex = result[i][3].lastIndexOf("]/") + 1;
                if (endIndex > 0) {
                    parentPath = result[i][3].substring(0, endIndex);
                }
                if (parentPath != null) {
                    int j = 0;
                    while (j < result.length) {
                        if (parentPath.equalsIgnoreCase(result[j][3])) {
                            result[i][4] = result[j][0];
                            result[j][5] = "1";
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public String logoff(ContentManagerService_Port cmlService) {
        try {
            cmlService.logoff();
        }
        catch (RemoteException remoteEx) {
            return remoteEx.toString();
        }
        return "Logoff successful.";
    }

    public static void main(String[] args) {
        String CM_URL = "http://localhost:9304/p2pd/servlet/dispatch";
        String userName = "admin";
        String pass = "admin1234";
        String nameSpace = "dbAuth";
        CRNConnect crn = new CRNConnect(CM_URL, userName, pass, nameSpace);
        String passport = crn.getPassPort();
        if (passport != null) {
            CrnQuery query = new CrnQuery(CM_URL);
            CrnQuery.ValidCamPassport(query.getCMService(), passport);
            String path1 = "~";
            String result = query.queryAccountUserName(query.getCMService(), path1);
            System.out.println(result);
        }
    }
}

