/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.crypto.IfxCHash;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoEngine;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEncPkt;
import com.informix.csm.crypto.IfxMACSecretKeys;
import com.informix.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;

class IfxCryptoSession {
    static final int CRYPTO_DATAMSG = 1;
    static final int CRYPTO_SWITCH1 = 2;
    static final int CRYPTO_SWITCH2 = 3;
    static final int CRYPTO_MAC = 4;
    static final int CRYPTO_PK = 5;
    static final int CRYPTO_CIPHERS = 6;
    static final int CRYPTO_MACKEY = 7;
    static final int CRYPTO_NEWPK = 8;
    static final int CRYPTO_NEWPKACK1 = 9;
    static final int CRYPTO_NEWPKACK2 = 10;
    static final int CRYPTO_USERINIT = 11;
    static final int CRYPTO_DEBUGEV = 12;
    static final int CRYPTO_MACKEYTIME = 13;
    static final int CRYPTO_MACKEYNAME = 14;
    static final int CRYPTO_MACKEYVALUE = 15;
    static final int CRYPTO_MACLEVELS = 16;
    static final int CRYPTO_ORMAC = 17;
    static final int ENC_ORIGINATOR = 1;
    static final int ENC_SWITCHCIPHER = 2;
    static final int ENC_SWITCHCIPHER_RESP = 4;
    static final int ENC_SWITCHSECRET = 8;
    static final int ENC_SWITCHSECRET_RESP = 16;
    static final int ENC_SWITCHSECRET_ACK = 32;
    static final int ENC_SWITCHSECRET_INP = 64;
    static final int ENC_TRACESET = 128;
    static final short ENC_MAC_OFF = 1;
    static final short ENC_MAC_LOW = 2;
    static final short ENC_MAC_MED = 3;
    static final short ENC_MAC_HIGH = 4;
    static final int ENC_MAX_ORMAC_SIZE = 16;
    static final int CRYPTO_MEMTR = 1;
    static final int CRYPTO_LOCKTR = 2;
    static final int CRYPTO_ERRORTR = 4;
    static final int CRYPTO_MEMLEAK = 8;
    static final int CRYPTO_HIGHMSGTR = 64;
    static final int CRYPTO_MEDMSGTR = 96;
    static final int CRYPTO_LOWHMSGTR = 112;
    static final int CRYPTO_HIGHINT = 1024;
    static final int CRYPTO_MEDINT = 1536;
    static final int CRYPTO_LOWINT = 1792;
    static final int CRYPTO_LOGMSG = 0x10000000;
    static final int CRYPTO_DEBUGACTIVE = 0x20000000;
    static final int CRYPTO_SELECTIVE = 0x40000000;
    static final int CRYPTO_SERVER = 1;
    static final int CryptoServerFlag = 1;
    static final int CRYPTO_INITIATOR = 1;
    static final int CRYPTO_ACCEPTOR = 2;
    static final int CRYPTO_NEITHER = 3;
    static final int ERR_NOMEM = -1;
    static final int ERR_RAND = -2;
    static final int ERR_DH = -3;
    static final int ERR_PUBLIC_KEY = -4;
    static final int ERR_ACCEPT_KEY = -5;
    static final int ERR_ENCRYPT = -6;
    static final int ERR_DECRYPT = -7;
    static final int ERR_BADFUN = -8;
    static final int ERR_NOTSUPPORTED = -9;
    static final int ERR_CIPHERSETUP = -10;
    static final int ERR_CLEANUP = -11;
    static final int ERR_MACKEY = -12;
    static final int ERR_CORRUPTMSG = -13;
    static final int ERR_LOCK = -14;
    static final int ERR_DEBUG = -15;
    static final int ERR_CIPHER = -16;
    static final int ERR_UNKNOWNPARM = -17;
    static final int ERR_SESSIONINIT = -18;
    static final int ERR_DUPCIPHER = -19;
    static final int ERR_NOCIPHERS = -20;
    static final int ERR_SWITCH = -21;
    static final int ERR_PARM = -22;
    static final int ERR_PARMTIME = -23;
    static final int ERR_PARMDEBUG = -24;
    static final int ERR_PARMMAC = -25;
    static final int ERR_NOMAC = -26;
    static final int ERR_MACLEVEL = -27;
    static final int ERR_MACFILE = -28;
    static final String s_crypto_enomem = "Memory Allocation Failed";
    static final String s_crypto_erand = "Random Generator Failed";
    static final String s_crypto_edh = "Diffie-Hellman Failure";
    static final String s_crypto_epkey = "Failure during public key generation";
    static final String s_crypto_eacceptkey = "Failure during acceptance of public key";
    static final String s_crypto_eencrypt = "Failure during encryption";
    static final String s_crypto_edecrypt = "Failure encountered during decryption";
    static final String s_crypto_unsupported = "Unsupported cipher/mode/option";
    static final String s_crypto_ecypsetup = "Failure during cipher setup";
    static final String s_crypto_ecleanup = "Failure during cleanup";
    static final String s_crypto_emackey = "Failure during MAC key generation";
    static final String s_crypto_ecorruptmsg = "Received corrupt message";
    static final String s_crypto_elock = "Failure during lock creation/destruction";
    static final String s_crypto_edebug = "Failure during debug setup";
    static final String s_crypto_ecipher = "Unknown cipher/mode requested";
    static final String s_crypto_eparm = "Unknown initialization parameter";
    static final String s_crypto_esession = "Session could not be initialized";
    static final String s_crypto_edup = "Duplicate cipher registered";
    static final String s_crypto_enegot = "No ciphers were registered or no common cipher could be negotiated";
    static final String s_crypto_eswitch = "Failure during cipher renegotiation";
    static final String s_crypto_eparme = "Failure during parameter processing";
    static final String s_crypto_eswitchparm = "Illegal switch parameter";
    static final String s_crypto_edebugparm = "Error with debug parameter";
    static final String s_crypto_emacparm = "Error with MAC parameter";
    static final String s_crypto_emacnegot = "Common MAC key could not be negotiated";
    static final String s_crypto_emaclevel = "Invalid MAC level entered";
    static final String s_crypto_emacfile = "MAC key file could not be read or is invalid";
    static final String s_crypto_unknown = "Unknown error";
    static final String s_csmenc_err_pack_buffer = "Can not pack output buffer";
    static final String s_csmenc_err_memalloc = "Memory allocation failure";
    static final String s_csmenc_err_savein_buffer = "Failure attempting to combine buffers";
    static final String s_csmenc_err_process_saved = "Unable to process a staged buffer";
    static final String s_csmenc_err_wrong_msgtype = "Received message type %d but expecting %d";
    static final String s_csmenc_err_abort = "CSM abort";
    static final String s_csmenc_err_auth_failed = "Authentication failed";
    private static Hashtable errorMessageHashtable = new Hashtable();
    IfxCryptoCtx cryptoCtx;
    IfxEncPkt encPkt;

    IfxCryptoSession() {
    }

    int csmCryptoInit(String csmInitString, long flags) throws IfxCsmException {
        int status = 0;
        if (this.cryptoCtx != null) {
            return status;
        }
        this.cryptoCtx = new IfxCryptoCtx();
        this.cryptoCtx.initContext(this, csmInitString);
        return status;
    }

    int csmCryptoDecrypt(IfxCsmBuffer inBuff, IfxCsmBuffer outBuff) throws IfxCsmException {
        int status = 0;
        this.encPkt.Decrypt.In = inBuff;
        status = this.decrypt(this.encPkt);
        if (status == 0) {
            this.encPkt.Decrypt.In.reset();
            outBuff.initialize(this.encPkt.Decrypt.Out);
        }
        return status;
    }

    int csmCryptoEncrypt(IfxCsmReadBuffer inBuff, IfxCsmBuffer outBuff) throws IfxCsmException {
        int status = 0;
        this.encPkt.Encrypt.In.initialize(inBuff);
        status = this.encrypt(this.encPkt);
        if (status == 0) {
            this.encPkt.Encrypt.In.reset();
            outBuff.initialize(this.encPkt.Encrypt.Out);
        }
        return status;
    }

    int csmCryptoInitSession(int originator, IfxCsmBuffer inBuff) throws IfxCsmException {
        int status = 0;
        IfxCsmBuffer ciphers = new IfxCsmBuffer();
        IfxCsmBuffer MACList = new IfxCsmBuffer();
        byte[] PublicKey = null;
        IfxMsgHdr msgHdr = new IfxMsgHdr();
        int CtlSize = 0;
        if (this.cryptoCtx.isDebugFlagSet(1536)) {
            // empty if block
        }
        this.encPkt = new IfxEncPkt(originator, this.cryptoCtx);
        PublicKey = IfxCryptoEngine.generatePublicKey(this.encPkt);
        status = IfxCipherElem.cryptoGetCiphers(ciphers, this.cryptoCtx);
        if (status == 0 && (status = IfxMACSecretKeys.cryptoGetMAC(MACList, this.cryptoCtx)) == 0) {
            CtlSize = PublicKey.length + 4 + ciphers.getCount() + 4 + MACList.getCount() + 4 + 4 + 4;
            if (this.encPkt.isFlagSet(128)) {
                CtlSize += this.cryptoCtx.DebugEV.length + 4;
            }
            IfxCsmBuffer ctlMsg = new IfxCsmBuffer(CtlSize);
            if (this.encPkt.isFlagSet(128)) {
                msgHdr.setMsgType(12);
                msgHdr.setMsgSize(this.cryptoCtx.DebugEV.length);
                ctlMsg.write(msgHdr.getCMsgHdr());
                ctlMsg.write(this.cryptoCtx.DebugEV);
            }
            msgHdr.setMsgType(6);
            msgHdr.setMsgSize(ciphers.getCount());
            ctlMsg.write(msgHdr.getCMsgHdr());
            ctlMsg.write(ciphers.toByteArray());
            msgHdr.setMsgType(16);
            msgHdr.setMsgSize(4);
            ctlMsg.write(msgHdr.getCMsgHdr());
            ctlMsg.write(IfxCryptoUtils.JavaToIfxInt(this.cryptoCtx.MacLevel, 4));
            msgHdr.setMsgType(7);
            msgHdr.setMsgSize(MACList.getCount());
            ctlMsg.write(msgHdr.getCMsgHdr());
            ctlMsg.write(MACList.toByteArray());
            msgHdr.setMsgType(5);
            msgHdr.setMsgSize(PublicKey.length);
            ctlMsg.write(msgHdr.getCMsgHdr());
            ctlMsg.write(PublicKey);
            if (this.encPkt.Encrypt.In.getCount() != 0) {
                status = -18;
            } else {
                this.encPkt.Encrypt.In = ctlMsg;
                status = this.encrypt(this.encPkt);
                if (status == 0) {
                    inBuff.initialize(this.encPkt.Encrypt.Out);
                    this.encPkt.Encrypt.In = new IfxCsmBuffer();
                    this.encPkt.Encrypt.Out = new IfxCsmBuffer();
                }
            }
        }
        return status;
    }

    int csmCryptoAcceptConnection(IfxCsmBuffer inToken) throws IfxCsmException {
        int status = 0;
        IfxMsgHdr msgHdr = new IfxMsgHdr();
        this.encPkt.Decrypt.In = inToken;
        status = this.decrypt(this.encPkt);
        if (status == 0) {
            this.encPkt.Decrypt.In = new IfxCsmBuffer();
            IfxCsmReadBuffer inBuff = new IfxCsmReadBuffer(this.encPkt.Decrypt.Out);
            while (inBuff.available() > 0) {
                msgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(inBuff, 4));
                switch (msgHdr.getType()) {
                    case 7: {
                        status = IfxMACSecretKeys.negotiateMac(this.encPkt, IfxCryptoUtils.readByteInputStream(inBuff, msgHdr.getMsgSize()), this.cryptoCtx);
                        break;
                    }
                    case 5: {
                        byte[] otherPK = IfxCryptoUtils.readByteInputStream(inBuff, msgHdr.getMsgSize());
                        byte[] secretKey = null;
                        secretKey = IfxCryptoEngine.acceptPublicKey(this.encPkt.DH, otherPK);
                        if (secretKey.length < otherPK.length) {
                            byte[] temp = new byte[otherPK.length];
                            System.arraycopy(secretKey, 0, temp, 0, secretKey.length);
                            secretKey = temp;
                        }
                        this.encPkt.Encrypt.SecretKey = secretKey;
                        this.encPkt.Decrypt.SecretKey = IfxCryptoUtils.createCopy(secretKey);
                        this.encPkt.DH = null;
                        break;
                    }
                    case 6: {
                        status = IfxCipherElem.negotiateCipher(this.encPkt, IfxCryptoUtils.readByteInputStream(inBuff, msgHdr.getMsgSize()), this.cryptoCtx);
                        break;
                    }
                    case 16: {
                        int MacFlags = IfxCryptoUtils.readInt(inBuff, 4);
                        if (IfxCryptoUtils.isFlagSet(MacFlags &= this.cryptoCtx.MacLevel, 8)) {
                            this.encPkt.NegotiatedMacLevel = (short)4;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(MacFlags, 4)) {
                            this.encPkt.NegotiatedMacLevel = (short)3;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(MacFlags, 2)) {
                            this.encPkt.NegotiatedMacLevel = (short)2;
                            break;
                        }
                        if (IfxCryptoUtils.isFlagSet(MacFlags, 1)) {
                            this.encPkt.NegotiatedMacLevel = 1;
                            break;
                        }
                        status = -26;
                        break;
                    }
                    case 12: {
                        byte[] otherDebugEV = IfxCryptoUtils.readByteInputStream(inBuff, msgHdr.getMsgSize());
                        if (!this.cryptoCtx.isDebugFlagSet(0x40000000) || this.cryptoCtx.DebugEV == null || !Arrays.equals(otherDebugEV, this.cryptoCtx.DebugEV)) break;
                        this.encPkt.setFlag(128);
                        break;
                    }
                    default: {
                        status = -13;
                    }
                }
                if (status == 0) continue;
            }
            this.encPkt.setFlag(4);
            this.encPkt.Encrypt.CurrentCipher = -1;
            this.encPkt.CipherSwitchTime = this.cryptoCtx.CipherSwitchTime;
            this.encPkt.SecretSwitchTime = this.cryptoCtx.SecretSwitchTime;
            this.encPkt.Encrypt.timeLastKeySwitch = this.encPkt.Decrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
            this.encPkt.Decrypt.timeLastCipherSwitch = this.encPkt.Decrypt.timeLastKeySwitch;
            this.encPkt.Encrypt.timeLastCipherSwitch = this.encPkt.Decrypt.timeLastKeySwitch;
        }
        return status;
    }

    static String csmCryptoErrDesc(int cryptoError) {
        String retVal = null;
        retVal = (String)errorMessageHashtable.get(cryptoError);
        if (retVal == null) {
            retVal = s_crypto_unknown;
        }
        return retVal;
    }

    static String csmCryptoErrDesc(int cryptoError, Exception ex) {
        return IfxCryptoSession.csmCryptoErrDesc(cryptoError) + "\n" + ex.toString();
    }

    static IfxCsmException getCsmErrException(int internalError, Exception ex) {
        return new IfxCsmException(-5010, IfxCryptoSession.csmCryptoErrDesc(internalError, ex));
    }

    static IfxCsmException getCsmErrException(int internalError) {
        return new IfxCsmException(-5010, IfxCryptoSession.csmCryptoErrDesc(internalError));
    }

    int encrypt(IfxEncPkt encPkt) throws IfxCsmException {
        int status;
        block35: {
            block37: {
                IfxCryptoEngine cryptoEngine;
                byte[] bufferedMsgByteArray;
                IfxMsgHdr tmpMsgHdr;
                int macType;
                byte[] macPad;
                IfxCsmBuffer bufferedMsg;
                block36: {
                    status = 0;
                    byte[] newPublicKey = null;
                    bufferedMsg = null;
                    macPad = new byte[]{};
                    macType = 0;
                    Object IV = null;
                    tmpMsgHdr = new IfxMsgHdr();
                    int calculatedMsgSize = 0;
                    if (encPkt.CipherSwitchTime > 0L && IfxCryptoUtils.getCurrentTimeinSec() > encPkt.Encrypt.timeLastCipherSwitch + encPkt.CipherSwitchTime) {
                        encPkt.setFlag(2);
                    }
                    if (encPkt.SecretSwitchTime > 0L && !encPkt.isFlagSet(64) && encPkt.DH == null && IfxCryptoUtils.getCurrentTimeinSec() > encPkt.Encrypt.timeLastKeySwitch + encPkt.SecretSwitchTime) {
                        encPkt.setFlag(8);
                    }
                    calculatedMsgSize = encPkt.Encrypt.In.getCount() + 4;
                    if (encPkt.isFlagSet(6)) {
                        calculatedMsgSize += 6;
                    }
                    if (encPkt.isFlagSet(8)) {
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        encPkt.setFlag(64);
                        newPublicKey = IfxCryptoEngine.generatePublicKey(encPkt.Encrypt);
                        calculatedMsgSize += 4 + newPublicKey.length;
                    }
                    if (encPkt.isFlagSet(16)) {
                        calculatedMsgSize += 4 + encPkt.Decrypt.PublicKey.length;
                    }
                    if (encPkt.isFlagSet(32)) {
                        calculatedMsgSize += 4;
                    }
                    bufferedMsg = new IfxCsmBuffer(calculatedMsgSize);
                    tmpMsgHdr.setMsgHdr(1, encPkt.Encrypt.In.getCount());
                    bufferedMsg.write(tmpMsgHdr.getCMsgHdr());
                    try {
                        encPkt.Encrypt.In.writeTo(bufferedMsg);
                    }
                    catch (IOException ex) {
                        status = -6;
                        break block35;
                    }
                    if (encPkt.isFlagSet(6)) {
                        int randInt = (int)Math.round(Math.random() * 127.0);
                        encPkt.Encrypt.CurrentCipher = randInt % encPkt.NegoaitedCipherList.size();
                        tmpMsgHdr.setMsgSize(2);
                        if (encPkt.isFlagSet(4)) {
                            tmpMsgHdr.setMsgType(2);
                        } else {
                            tmpMsgHdr.setMsgType(3);
                        }
                        bufferedMsg.write(tmpMsgHdr.getCMsgHdr());
                        bufferedMsg.write(IfxCryptoUtils.JavaToIfxInt(encPkt.Encrypt.CurrentCipher, 2));
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                    }
                    if (encPkt.isFlagSet(8)) {
                        tmpMsgHdr.setMsgType(8);
                        tmpMsgHdr.setMsgSize(newPublicKey.length);
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        bufferedMsg.write(tmpMsgHdr.getCMsgHdr());
                        bufferedMsg.write(newPublicKey);
                        newPublicKey = null;
                        encPkt.clearFlag(8);
                    }
                    if (encPkt.isFlagSet(16)) {
                        byte[] pubKey = encPkt.Decrypt.PublicKey;
                        tmpMsgHdr.setMsgType(9);
                        tmpMsgHdr.setMsgSize(pubKey.length);
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        bufferedMsg.write(tmpMsgHdr.getCMsgHdr());
                        bufferedMsg.write(pubKey);
                        encPkt.Decrypt.PublicKey = null;
                        encPkt.clearFlag(16);
                    }
                    if (encPkt.isFlagSet(32)) {
                        if (this.cryptoCtx.isDebugFlagSet(1024)) {
                            // empty if block
                        }
                        tmpMsgHdr.setMsgType(10);
                        tmpMsgHdr.setMsgSize(0);
                        bufferedMsg.write(tmpMsgHdr.getCMsgHdr());
                    }
                    bufferedMsgByteArray = bufferedMsg.toByteArray();
                    cryptoEngine = new IfxCryptoEngine(encPkt, 1);
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                    if (encPkt.Encrypt.MacLevel == 1) break block36;
                    status = IfxCHash.generateHash(encPkt.Encrypt.MAC, 36, encPkt.Encrypt.MacKey);
                    if (status != 0) break block35;
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                    if (encPkt.Encrypt.MacLevel == 4 || encPkt.Encrypt.MacLevel == 3 && bufferedMsg.getCount() > 16) {
                        macPad = IfxCryptoEngine.internalGenerateHMAC(encPkt.Encrypt.MAC.Hash, bufferedMsgByteArray);
                        macType = 4;
                    } else {
                        macPad = new byte[1];
                        System.arraycopy(encPkt.Encrypt.MAC.Hash, 0, macPad, 0, 1);
                        byte[] buggMsgArray = bufferedMsgByteArray;
                        for (int i = 0; i < buggMsgArray.length; ++i) {
                            macPad[0] = (byte)(macPad[0] ^ buggMsgArray[i]);
                        }
                        macType = 17;
                    }
                    if (this.cryptoCtx.isDebugFlagSet(64)) {
                        // empty if block
                    }
                }
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                cryptoEngine.initCipher();
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                int outLength = bufferedMsg.getCount() + 4 + macPad.length + cryptoEngine.getBlockSize();
                encPkt.Encrypt.Out = new IfxCsmBuffer(outLength);
                if (encPkt.Encrypt.MacLevel != 1) {
                    tmpMsgHdr.setMsgType(macType);
                    tmpMsgHdr.setMsgSize(macPad.length);
                    encPkt.Encrypt.Out.write(cryptoEngine.updateCipher(tmpMsgHdr.getCMsgHdr()));
                    if (macPad != null) {
                        encPkt.Encrypt.Out.write(cryptoEngine.updateCipher(macPad));
                    }
                }
                encPkt.Encrypt.Out.write(cryptoEngine.updateCipher(bufferedMsgByteArray));
                encPkt.Encrypt.Out.write(cryptoEngine.doFinal());
                if (this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
                if (!encPkt.isFlagSet(6)) break block37;
                status = IfxCipher.cryptoSwitchCipher(encPkt, encPkt.Encrypt, this.cryptoCtx);
                if (status != 0) break block35;
                encPkt.clearFlag(6);
            }
            if (encPkt.isFlagSet(32)) {
                if (this.cryptoCtx.isDebugFlagSet(1024)) {
                    // empty if block
                }
                encPkt.Encrypt.SecretKey = null;
                encPkt.Encrypt.SecretKey = encPkt.Encrypt.NextKey;
                encPkt.Encrypt.NextKey = null;
                encPkt.Encrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
                encPkt.clearFlag(96);
            }
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    int decrypt(IfxEncPkt encPkt) throws IfxCsmException {
        block28: {
            block31: {
                block34: {
                    block35: {
                        block32: {
                            block33: {
                                block30: {
                                    block29: {
                                        block27: {
                                            status = 0;
                                            IV = null;
                                            macPad = null;
                                            macType = false;
                                            tmpMsgHdr = new IfxMsgHdr();
                                            temp = null;
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            cryptoEngine = new IfxCryptoEngine(encPkt, 2);
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            cryptoEngine.initCipher();
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            temp = cryptoEngine.doFinal(encPkt.Decrypt.In.toByteArray());
                                            bisTemp = new ByteArrayInputStream(temp);
                                            if (this.cryptoCtx.isDebugFlagSet(64)) {
                                                // empty if block
                                            }
                                            tmpMsgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(bisTemp, 4));
                                            thisMsgSize = tmpMsgHdr.getMsgSize() + 4;
                                            if (thisMsgSize <= temp.length) break block27;
                                            status = -7;
                                            break block28;
                                        }
                                        if (encPkt.Decrypt.MacLevel == 1) break block29;
                                        status = IfxCHash.generateHash(encPkt.Decrypt.MAC, 36, encPkt.Decrypt.MacKey);
                                        if (status != 0) break block28;
                                        if (this.cryptoCtx.isDebugFlagSet(64)) {
                                            // empty if block
                                        }
                                    }
                                    if (encPkt.Decrypt.MacLevel != 1) break block30;
                                    if (tmpMsgHdr.getType() != 4 && tmpMsgHdr.getType() != 17) break block31;
                                    status = -7;
                                    break block28;
                                }
                                if (encPkt.Decrypt.MacLevel != 4 && (encPkt.Decrypt.MacLevel != 3 || temp.length - thisMsgSize <= 16)) break block32;
                                if (tmpMsgHdr.getType() == 4) break block33;
                                status = -7;
                                break block28;
                            }
                            macPad = IfxCryptoEngine.internalGenerateHMAC(encPkt.Decrypt.MAC.Hash, temp, thisMsgSize, temp.length - thisMsgSize);
                            break block34;
                        }
                        macPad = new byte[1];
                        if (tmpMsgHdr.getType() == 17) break block35;
                        status = -7;
                        break block28;
                    }
                    macPad[0] = encPkt.Decrypt.MAC.Hash[0];
                    for (i = thisMsgSize; i < temp.length; ++i) {
                        macPad[0] = (byte)(macPad[0] ^ temp[i]);
                    }
                }
                if ((this.cryptoCtx.DebugFlags & 64) > 0) {
                    // empty if block
                }
            }
            if (encPkt.Decrypt.MacLevel == 1) ** GOTO lbl64
            if (tmpMsgHdr.getMsgSize() != macPad.length || !IfxCryptoUtils.areArrayElemntsEqual(macPad, 0, temp, 4, macPad.length)) {
                status = -13;
            } else {
                bisTemp.skip(tmpMsgHdr.getMsgSize());
                tmpMsgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(bisTemp, 4));
lbl64:
                // 2 sources

                encPkt.Decrypt.Out.reset();
                while (true) {
                    if (this.cryptoCtx.isDebugFlagSet(1024)) {
                        // empty if block
                    }
                    switch (tmpMsgHdr.getType()) {
                        case 1: {
                            tempOut = new IfxCsmBuffer();
                            try {
                                encPkt.Decrypt.Out.writeTo(tempOut);
                            }
                            catch (Exception ex) {
                                status = -7;
                                break;
                            }
                            tempOut.write(IfxCryptoUtils.readByteInputStream(bisTemp, tmpMsgHdr.getMsgSize()));
                            encPkt.Decrypt.Out = null;
                            encPkt.Decrypt.Out = tempOut;
                            break;
                        }
                        case 3: {
                            encPkt.setFlag(4);
                        }
                        case 2: {
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            encPkt.Decrypt.CurrentCipher = IfxCryptoUtils.readInt(bisTemp, 2);
                            status = IfxCipher.cryptoSwitchCipher(encPkt, encPkt.Decrypt, this.cryptoCtx);
                            break;
                        }
                        case 8: {
                            DH = IfxCryptoEngine.generateDHKeyAgreement();
                            otherPublicKey = null;
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            otherPublicKey = IfxCryptoUtils.readByteInputStream(bisTemp, tmpMsgHdr.getMsgSize());
                            encPkt.Decrypt.PublicKey = IfxCryptoEngine.generatePublicKey(DH);
                            encPkt.Decrypt.NextKey = IfxCryptoEngine.acceptPublicKey(DH, otherPublicKey);
                            encPkt.setFlag(16);
                            DH = null;
                            break;
                        }
                        case 9: {
                            otherPublicKey = null;
                            otherPublicKey = IfxCryptoUtils.readByteInputStream(bisTemp, tmpMsgHdr.getMsgSize());
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            encPkt.Encrypt.NextKey = IfxCryptoEngine.acceptPublicKey(encPkt.Encrypt.DH, otherPublicKey);
                            encPkt.setFlag(32);
                            break;
                        }
                        case 10: {
                            if (this.cryptoCtx.isDebugFlagSet(1024)) {
                                // empty if block
                            }
                            encPkt.Decrypt.SecretKey = encPkt.Decrypt.NextKey;
                            encPkt.Decrypt.NextKey = null;
                            encPkt.Decrypt.timeLastKeySwitch = IfxCryptoUtils.getCurrentTimeinSec();
                            break;
                        }
                        default: {
                            status = -13;
                        }
                    }
                    if (status != 0 || bisTemp.available() <= 0) break;
                    tmpMsgHdr.setMsgHdr(IfxCryptoUtils.readByteInputStream(bisTemp, 4));
                }
                if (status != 0 || this.cryptoCtx.isDebugFlagSet(64)) {
                    // empty if block
                }
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(encPkt, "Decrypt", status);
        }
        temp = null;
        return status;
    }

    static {
        errorMessageHashtable.put(-1, s_crypto_enomem);
        errorMessageHashtable.put(-2, s_crypto_erand);
        errorMessageHashtable.put(-3, s_crypto_edh);
        errorMessageHashtable.put(-4, s_crypto_epkey);
        errorMessageHashtable.put(-5, s_crypto_eacceptkey);
        errorMessageHashtable.put(-6, s_crypto_eencrypt);
        errorMessageHashtable.put(-7, s_crypto_edecrypt);
        errorMessageHashtable.put(-8, s_crypto_unsupported);
        errorMessageHashtable.put(-9, s_crypto_unsupported);
        errorMessageHashtable.put(-10, s_crypto_ecypsetup);
        errorMessageHashtable.put(-11, s_crypto_ecleanup);
        errorMessageHashtable.put(-12, s_crypto_emackey);
        errorMessageHashtable.put(-13, s_crypto_ecorruptmsg);
        errorMessageHashtable.put(-14, s_crypto_elock);
        errorMessageHashtable.put(-15, s_crypto_edebug);
        errorMessageHashtable.put(-16, s_crypto_ecipher);
        errorMessageHashtable.put(-17, s_crypto_eparm);
        errorMessageHashtable.put(-18, s_crypto_esession);
        errorMessageHashtable.put(-19, s_crypto_edup);
        errorMessageHashtable.put(-20, s_crypto_enegot);
        errorMessageHashtable.put(-21, s_crypto_eswitch);
        errorMessageHashtable.put(-22, s_crypto_eparme);
        errorMessageHashtable.put(-23, s_crypto_eswitchparm);
        errorMessageHashtable.put(-24, s_crypto_edebugparm);
        errorMessageHashtable.put(-25, s_crypto_emacparm);
        errorMessageHashtable.put(-26, s_crypto_emacnegot);
        errorMessageHashtable.put(-27, s_crypto_emaclevel);
        errorMessageHashtable.put(-28, s_crypto_emacfile);
    }
}

