/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.crypto.IfxCryptoUtils;

class IfxMsgHdr {
    int MsgType;
    int MsgSize;
    public static final int ENC_CSM_HDR_TYPESIZE = 1;
    public static final int ENC_CSM_HDR_SIZESIZE = 3;
    public static final int ENC_CSM_HDRSIZE = 4;

    public IfxMsgHdr() {
    }

    public IfxMsgHdr(int msgType, int msgSize) {
        this.MsgType = msgType;
        this.MsgSize = msgSize;
    }

    int getType() {
        return this.MsgType;
    }

    int getMsgSize() {
        return this.MsgSize;
    }

    void setMsgHdr(byte[] b) {
        this.MsgType = IfxCryptoUtils.Ifx1ToJavaInt(b, 0);
        this.MsgSize = IfxCryptoUtils.Ifx3ToJavaInt(b, 1);
    }

    void setMsgHdr(int msgType, int msgSize) {
        this.setMsgType(msgType);
        this.setMsgSize(msgSize);
    }

    void setMsgType(int msgType) {
        this.MsgType = msgType;
    }

    void setMsgSize(int msgSize) {
        this.MsgSize = msgSize;
    }

    byte[] getCMsgType() {
        return IfxCryptoUtils.JavaToIfxInt(this.MsgType, 1);
    }

    byte[] getCMsgSize() {
        return IfxCryptoUtils.JavaToIfxInt(this.MsgSize, 3);
    }

    byte[] getCMsgHdr() {
        byte[] ret = new byte[4];
        System.arraycopy(this.getCMsgType(), 0, ret, 0, 1);
        System.arraycopy(this.getCMsgSize(), 0, ret, 1, 3);
        return ret;
    }
}

