/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.SqliDbg;
import com.informix.jdbc.IfmxPAM;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxDistinct;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPAMChallenge;
import com.informix.jdbc.IfxPAMResponse;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.memoryUtil;
import com.informix.util.stringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqli
implements IfxProtocol {
    private static final Object logger = Trace.getLoggerForClass(IfxSqli.class);
    private String routineDbName = null;
    private boolean descTrue = false;
    IfxResultSetMetaData desc;
    IfxResultSetMetaData idesc;
    private FileOutputStream BlobFd;
    private byte[] BlobBuffer;
    private short BufferOrStream;
    private int BlobWriteFailure;
    private int BlobWriteOffset;
    private int BlobRequestSize;
    private int amountRW;
    private String copyToFileName;
    private int copyToFileFlags;
    private int copyToFileMode;
    private int copyToFileOffset;
    private File copyToFileFd;
    private RandomAccessFile loFile;
    private short statementID = (short)-1;
    private short statementType;
    protected IfxSqliConnect conn;
    protected Trace trace;
    protected Trace protoTrace;
    protected SqliDbg sqliTrace;
    private String dbEncoding;
    private boolean isText;
    private boolean convText;
    private long serial8Inserted;
    private long bigSerialInserted;
    private short xcEvent = (short)-1;
    private short xcNewLevel = (short)-1;
    private short xcOldLevel = (short)-1;
    private boolean isReleased = true;
    private int tupleBufferSize = -1;
    private boolean typeSent = false;
    private int sqlcode;
    private int isamcode;
    private String SQLState;
    private String message;
    private SQLWarning warn;
    private SQLException exception;
    private String sqlerrm;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort;
    private boolean OpenDBStmt;
    private String serverVersion;
    private byte[] serverProtocol = null;
    private Vector<Integer> offsetVector = new Vector();
    private int totalTupleSize;
    private int curOffset;
    private int totalTuples;
    private int firstTuple;
    private int lastTuple;
    private int curRow = -1;
    private boolean doneCommit;
    private int Tupid;
    private int numberOfFetches = 0;
    private int numberOfTuplesReceived = 0;
    private int tupleSizeReceived = 0;
    private int fpHandle;
    private Vector<IfxObject> fpRet;
    private Vector<IfxObject> fpInput;
    private IfxFParam fparam;
    private boolean partialFParam;
    private int totalOutValues = 0;
    private int totalOutParams = 0;
    static final int IN = 0;
    static final int OUT = 1;
    static final int INOUT = 2;
    private short TxStmt;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    protected static final int INFX_BUFSIZE = 4096;
    protected static final int INFX_MAXBUFSIZE = Short.MAX_VALUE;
    protected static final int INFX_MAX_BIGBUFSIZE = Integer.MAX_VALUE;
    private final int INFX_MAXQUOTEDSTRINGSIZE = 65535;
    private IfxRowColumn rowColumn;
    private short SGK_statementType;
    private short SGK_statementID = (short)-1;
    private short SGK_TxStmt;
    private IfxResultSetMetaData SGK_desc = null;
    protected IfxRowColumn SGK_rowColumn;
    private Vector<Integer> SGK_offsetVector = new Vector();
    private int SGK_totalTupleSize;
    private int SGK_curOffset;
    private int SGK_totalTuples;
    private int SGK_curRow = -1;
    protected IfxDataOutputStream os;
    protected IfxDataInputStream is;
    protected boolean SQ_CLOSERecvd;
    private boolean SQ_CLOSESent;
    private boolean first = true;
    private Vector<String> DBList;
    boolean executeBatchInProgress;
    public ArrayList<Integer> batchRowStatus;
    private int batchCount;
    private int batchRowSize;
    private boolean userPAMAuthorized = false;
    private int putErrRowCount = 0;

    public IfxSqli(IfxSqliConnect conn_arg) {
        this.conn = conn_arg;
        this.sqliTrace = this.conn.asfconn.sqliTrace;
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(0, 0);
        this.os = this.conn.Ifxproto_send();
        this.is = this.conn.Ifxproto_receive();
        this.dbEncoding = this.conn.getdbEncoding();
        this.convText = this.conn.isConvText();
        if (TraceFlag.isTraceEnabled() && this.conn != null) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.err.println("IfxSqli: trace is NULL");
            }
            this.protoTrace = this.conn.getProtoTrace();
            if (this.protoTrace == null) {
                System.err.println("IfxSqli: Protocol trace is NULL");
            }
            if (this.trace != null) {
                this.trace.writeTrace(logger, 1, "IfxSqli: constructor() exited");
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getMetaData() called");
            this.trace.writeTrace(logger, 2, "   return desc");
        }
        return this.desc;
    }

    ResultSetMetaData getSGK_metaData() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getSGK_metaData() called");
            this.trace.writeTrace(logger, 2, "   return SGK_desc");
        }
        return this.SGK_desc;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    public void clearBatch() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clearBatch() called");
        }
        this.batchCount = 0;
        this.batchRowStatus = null;
        this.executeBatchInProgress = false;
    }

    @Override
    public void clear() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clear() called");
        }
        this.serial8Inserted = 0L;
        this.bigSerialInserted = 0L;
        this.xcEvent = (short)-1;
        this.xcNewLevel = (short)-1;
        this.xcOldLevel = (short)-1;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.OpenDBStmt = false;
        this.sqlerrm = null;
        for (int i = 0; i < 10; i = (int)((short)(i + 1))) {
            this.sqlerrd[i] = 0;
            if (i >= 8) continue;
            this.serverWarningsString.setCharAt(i, ' ');
        }
        this.serverWarningsShort = 0;
        this.tupleBufferSize = -1;
        this.resetTuples();
        this.doneCommit = false;
        this.warn = null;
        if (this.rowColumn != null) {
            this.rowColumn.clear();
            this.rowColumn = null;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clear() exited");
        }
    }

    private void resetTuples() {
        this.offsetVector.removeAllElements();
        this.offsetVector.setSize(500);
        this.offsetVector.setElementAt(0, 0);
        this.totalTupleSize = 0;
        this.curOffset = 0;
        this.curRow = -1;
        this.totalTuples = 0;
        this.Tupid = 0;
        if (this.rowColumn != null) {
            this.rowColumn.reset();
        }
    }

    private void resetSGKTuples() {
        this.SGK_offsetVector.removeAllElements();
        this.SGK_offsetVector.setSize(10);
        this.SGK_offsetVector.setElementAt(0, 0);
        this.SGK_totalTupleSize = 0;
        this.SGK_curOffset = 0;
        this.SGK_curRow = -1;
        this.SGK_totalTuples = 0;
        if (this.SGK_rowColumn != null) {
            this.SGK_rowColumn.reset();
        }
    }

    private void clearAll() {
        this.clear();
        this.isReleased = true;
        this.desc = null;
        this.idesc = null;
    }

    @Override
    public void executeBegin() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeBegin() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendBegin();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeBegin() exited");
        }
    }

    private void sendBegin() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBegin() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BEGIN");
            }
            this.os.writeSmallInt((short)35);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeBegin() exited");
        }
    }

    @Override
    public void executeCommit() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCommit() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCommit();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(true);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCommit() exited");
        }
    }

    private void sendCommit() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCommit() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_CMMTWORK");
            }
            this.os.writeSmallInt((short)19);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCommit() exited");
        }
    }

    @Override
    public void executeSavepoint(String savepointname, boolean uniqflag) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeSavepoint() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            this.initiateTransaction();
        }
        try {
            this.sendSavepoint(savepointname, uniqflag);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeSavepoint() exited");
        }
    }

    private void sendSavepoint(String savepointname, boolean uniqflag) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendSavepoint() called");
        }
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SQLISETSVPT");
                this.protoTrace.writeTrace(logger, 2, "\t\tSavepoint Name: " + savepointname);
                this.protoTrace.writeTrace(logger, 2, "\t\tUnique Flag : " + uniqflag);
            }
            this.os.writeSmallInt((short)137);
            this.os.writeChar(savePointNameBytes);
            if (uniqflag) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendSavepoint() exited");
        }
    }

    @Override
    public void executeReleaseSavepoint(String savepointname) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeSavepoint() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            this.initiateTransaction();
        }
        try {
            this.sendReleaseSavepoint(savepointname);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeReleaseSavepoint() exited");
        }
    }

    private void sendReleaseSavepoint(String savepointname) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendReleaseSavepoint() called");
        }
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\n\tSQ_SQLIRELSVPT");
                this.protoTrace.writeTrace(logger, 2, "\t\tSavepoint Name: " + savepointname);
            }
            this.os.writeSmallInt((short)138);
            this.os.writeChar(savePointNameBytes);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendReleaseSavepoint() exited");
        }
    }

    @Override
    public void executeRollbackSavepoint(String savepointname) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRollbackSavepoint() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            this.initiateTransaction();
        }
        try {
            this.sendRollbackSavepoint(savepointname);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRollbackSavepoint() exited");
        }
    }

    private void sendRollbackSavepoint(String savepointname) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRollbackSavepoint() called");
        }
        try {
            byte[] savePointNameBytes = this.os.getJavaToIfxChar(savepointname, this.dbEncoding);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SQLIRBACKSVPT");
                this.protoTrace.writeTrace(logger, 2, "\t\tSavepoint Name: " + savepointname);
            }
            this.os.writeSmallInt((short)139);
            this.os.writeChar(savePointNameBytes);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRollbackSavepoint() exited");
        }
    }

    @Override
    public void executeRollback() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRollback() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendRollback();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        this.conn.markCursorsToClosed(false);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRollback() exited");
        }
    }

    @Override
    public void executeGetDBList() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeDBList() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendGetDBList();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeDBList() exited");
        }
    }

    @Override
    public Vector<String> getDBList() {
        return this.DBList;
    }

    private void sendGetDBList() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendGetDbList() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_DBLIST");
            }
            this.os.writeSmallInt((short)26);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendGetDbList() exited");
        }
    }

    private void receiveDBList() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDBList() called");
        }
        try {
            this.DBList = new Vector();
            while (true) {
                String dbName = new String(this.is.readChar(this.dbEncoding));
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tName: ", "'" + dbName + "'");
                }
                if (dbName.length() != 0) {
                    boolean inserted = false;
                    for (int i = 0; i < this.DBList.size(); ++i) {
                        String lastDBname = this.DBList.elementAt(i);
                        if (dbName.compareToIgnoreCase(lastDBname) >= 0) continue;
                        this.DBList.insertElementAt(dbName, i);
                        inserted = true;
                        break;
                    }
                    if (inserted) continue;
                    this.DBList.insertElementAt(dbName, this.DBList.size());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDBList() exited");
        }
    }

    private void sendRollback() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRollback() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_RBWORK");
            }
            this.os.writeSmallInt((short)20);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tSavepoint: ", (short)0);
            }
            this.os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRollback() exited");
        }
    }

    @Override
    public void executeCommand(Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCommand() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut()) {
                this.initiateTransaction();
                this.sendPut((IfxPreparedStatement)stmt);
            } else {
                this.sendCommand((IfxStatement)stmt);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: END_TX_STMT, return error");
                    this.trace.writeTrace(logger, 3, "IfxSqli.executeCommand.sqlcode", this.sqlcode);
                }
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            } else if (stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut() && this.conn.TxState == 2 && this.conn.autoCommit) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: END_TX_STMT with IFX_USEPUT, return error");
                    this.trace.writeTrace(logger, 3, "IfxSqli.executeCommand.sqlcode", this.sqlcode);
                }
                if (this.sqlcode != -255) {
                    this.sendCommit();
                    this.conn.setTxEndState();
                }
            }
            throw e;
        }
        try {
            this.receiveMessage();
            if (this.SGK_desc != null) {
                String SGK_tabnm = IfxResultSetMetaData.parseTableName(((IfxStatement)stmt).commandString);
                for (int i = 1; i <= this.SGK_desc.getColumnCount(); ++i) {
                    this.SGK_desc.setTableName(i, SGK_tabnm);
                }
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: END_TX_STMT, return error");
                    this.trace.writeTrace(logger, 3, "IfxSqli.executeCommand.sqlcode", this.sqlcode);
                }
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            } else if (!this.conn.inXATransaction() && this.conn.db_use_log && this.conn.autoCommit) {
                try {
                    this.executeCommit();
                    this.conn.setTxEndState();
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            throw e;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(stmt));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (!this.conn.inXATransaction() && (this.conn.isCommitNeeded() || this.conn.db_use_log && this.conn.autoCommit && stmt instanceof IfxPreparedStatement && ((IfxPreparedStatement)stmt).usePut())) {
            this.executeCommit();
            this.conn.setTxEndState();
            this.doneCommit = true;
        }
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCommand() exited");
        }
    }

    private void sendCommand(IfxStatement stmt) throws SQLException {
        boolean tmpFlag = true;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCommand() called");
        }
        if (!this.conn.autoCommit && !stmt.commandString.trim().toLowerCase().startsWith("begin")) {
            this.initiateTransaction();
        }
        this.batchRowSize = stmt.BatchVector.size();
        if (stmt.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        if (stmt instanceof IfxPreparedStatement) {
            this.sendExecute(stmt);
        } else {
            String[] str = null;
            if (this.conn.isBatchUpdatePerSpec() && this.batchRowSize > 0 && this.executeBatchInProgress) {
                str = new String[this.batchRowSize];
                for (int k = 0; k < this.batchRowSize; ++k) {
                    str[k] = stmt.BatchVector.elementAt(k);
                }
            } else {
                str = new String[]{stmt.commandString};
                tmpFlag = false;
            }
            try {
                if (!this.conn.isRemove64KLimitSupported() && stmt.commandString.length() > 65535) {
                    throw IfxErrMsg.getSQLException(-79864, this.conn);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "C->S");
                }
                int j = 0;
                do {
                    String cmdString = str[j];
                    byte[] b = this.getJavaToIfxCharBytes(str[j++]);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_COMMAND");
                    }
                    this.os.writeSmallInt((short)1);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t# of values: ", 0);
                    }
                    this.os.writeSmallInt((short)0);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tCommand: " + cmdString);
                    }
                    this.os.writeChar(b);
                    this.SGK_desc = null;
                    this.SGK_rowColumn = null;
                    if (stmt.SGK_returnGeneratedKeys != 0) {
                        this.sendSGKPrepare(stmt);
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_NDESCRIBE");
                    }
                    this.os.writeSmallInt((short)22);
                    this.resetSGKTuples();
                    if (j == 1 && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                        this.sendSQBatchStart();
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_EXECUTE");
                    }
                    this.os.writeSmallInt((short)7);
                    if (j == this.batchRowSize && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                        this.sendSQBatchEnd();
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_RELEASE");
                    }
                    this.os.writeSmallInt((short)11);
                    this.isReleased = true;
                } while (this.conn.isBatchUpdatePerSpec() && j < this.batchRowSize && this.executeBatchInProgress);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw this.handleSocketException(e, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCommand() exited");
        }
    }

    private boolean sendBind(Vector<IfxObject> vector, ResultSetMetaData pmd, int inputvals, int si, int ei) throws SQLException {
        int blobCount = 0;
        int ord = 0;
        boolean sentIMPEXP = false;
        boolean checkIfxValException = false;
        Exception IfxValException = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBind(Vector) called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                if (si == 0) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "C->S");
                }
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BIND");
            }
            this.os.writeSmallInt((short)5);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tCount: ", inputvals);
            }
            this.os.writeSmallInt((short)inputvals);
            for (int i = si; i < ei; ++i) {
                byte[] bData;
                short type;
                IfxObject ival;
                block45: {
                    ival = null;
                    if (i < vector.size()) {
                        ival = vector.elementAt(i);
                    }
                    if (ival == null) {
                        ord = i % inputvals + 1;
                        type = 0;
                        if (pmd == null || !((IfxResultSetMetaData)pmd).hasDefaultValue(ord)) {
                            if (pmd != null) {
                                throw IfxErrMsg.getSQLException(-79823, ((IfxResultSetMetaData)pmd).getArgumentName(ord), (IfxConnection)this.conn);
                            }
                            throw IfxErrMsg.getSQLException(-79823, this.conn);
                        }
                        type = (short)((IfxResultSetMetaData)pmd).getIfxColumnType(ord);
                        this.os.writeSmallInt(type);
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, " sendBind(): SQL type: " + type);
                            if (i > 0) {
                                this.protoTrace.writeTrace(logger, 2, "");
                            }
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn #: ", i + 1);
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tType: ", type);
                        }
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tIndicator: ", -2);
                        }
                        this.os.writeSmallInt((short)-2);
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tPrecision: ", (short)0);
                        }
                        this.os.writeSmallInt((short)0);
                        continue;
                    }
                    type = (short)ival.getIfxType();
                    if (type == 11 || type == 12) {
                        if (((IfxBlob)ival).isIfxTextType()) {
                            type = 12;
                        }
                        if (!ival.isNull()) {
                            ++blobCount;
                        }
                    }
                    if (type == 46) {
                        sentIMPEXP = true;
                    }
                    this.os.writeSmallInt(type);
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, " sendBind(): SQL type: " + type);
                        if (i > 0) {
                            this.protoTrace.writeTrace(logger, 2, "");
                        }
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn #: ", i + 1);
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tType: ", type);
                    }
                    if (this.conn.isUSVER() && type > 18 && type != 52 && type != 53) {
                        String owner = null;
                        String name = null;
                        owner = ival.getExtendedOwner();
                        name = ival.getExtendedTypeName();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tExtendedOwner: ", owner);
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tExtendedTypeName: ", name);
                        }
                        if (owner == null) {
                            this.os.writeSmallInt((short)0);
                        } else {
                            this.os.writeChar(this.os.getJavaToIfxChar(owner));
                        }
                        this.os.writeChar(this.os.getJavaToIfxChar(name));
                    }
                    if (ival.isNull()) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tIndicator: ", -1);
                        }
                        this.os.writeSmallInt((short)-1);
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tPrecision: ", (short)0);
                        }
                        this.os.writeSmallInt((short)0);
                        continue;
                    }
                    bData = null;
                    try {
                        bData = ival.toIfx();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SQLException)) break block45;
                        SQLException e1 = (SQLException)e;
                        if (e1.getErrorCode() == -79783 || e1.getErrorCode() == -23103) {
                            this.os.writeSmallInt((short)-1);
                            this.os.writeSmallInt((short)0);
                            checkIfxValException = true;
                            IfxValException = e;
                            continue;
                        }
                        throw e;
                    }
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tIndicator: ", (short)0);
                }
                this.os.writeSmallInt((short)0);
                short shortVal = ival.getIfxType() != 5 || ival.getIfxType() == 5 && ival instanceof IfxDistinct ? ival.getEncodedLength() : (short)((IfxDecimal)ival).getScale();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tPrecision: ", shortVal);
                }
                this.os.writeSmallInt(shortVal);
                if (TraceFlag.isTraceEnabled()) {
                    String cname = ival.getClass().getName();
                    this.trace.writeTrace(logger, 2, "Classname: ", cname);
                }
                if (TraceFlag.isTraceEnabled()) {
                    if (type == 11 || type == 12 || type == 40 || type == 41) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tData (" + bData.length + " bytes): ");
                        this.protoTrace.writeTrace(logger, 2, bData, 'H');
                    } else if (type == 44) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tData (" + bData.length + " bytes): ");
                        this.protoTrace.writeTrace(logger, 2, bData, 'B');
                    } else {
                        String s = ival.toString();
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ", s);
                    }
                }
                this.os.writePadded(bData);
                if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                    this.conn.setDbName(ival.toString());
                }
                if (this.statementType != 31) continue;
                this.conn.setDbName(null);
            }
            if (checkIfxValException) {
                throw IfxValException;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (blobCount > 0 && sentIMPEXP) {
            this.receiveMessage();
        }
        if (blobCount > 0) {
            this.sendBlob(vector, blobCount, si, inputvals);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBind() exited");
        }
        return sentIMPEXP;
    }

    @Override
    public void executePrepare(Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executePrepare() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendPrepare((IfxStatement)stmt);
            this.receiveMessage();
            ((IfxStatement)stmt).setStatementType(this.statementType);
            if (this.SGK_desc != null) {
                this.SGK_desc.parseSetTableName(((IfxStatement)stmt).commandString);
            }
            if (this.desc != null) {
                this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (this.desc != null) {
            this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executePrepare() exited");
        }
    }

    private void sendPrepare(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendPrepare() called");
        }
        String s = stmt.commandString;
        try {
            byte[] b;
            byte[] byArray = b = this.conn.isOnLine5SER() ? this.os.getJavaToIfxChar(s, "NOENCODING") : this.getJavaToIfxCharBytes(s);
            if (!this.conn.isRemove64KLimitSupported() && s.length() > 65535) {
                throw IfxErrMsg.getSQLException(-79864, this.conn);
            }
            if (this.conn.db_use_log && !this.conn.autoCommit && this.conn.isBatchUpdatePerSpec() && stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                if (pstmt.BatchVector.size() > 0 && !pstmt.usePut()) {
                    this.initiateTransaction();
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_PREPARE");
            }
            this.os.writeSmallInt((short)2);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# qmarks: ", stmt.numqmarks);
            }
            this.os.writeSmallInt((short)stmt.numqmarks);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tCommand: " + s);
            }
            this.os.writeChar(b);
            this.SGK_desc = null;
            this.SGK_rowColumn = null;
            if (stmt.SGK_returnGeneratedKeys != 0) {
                this.sendSGKPrepare(stmt);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_NDESCRIBE");
            }
            this.os.writeSmallInt((short)22);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_WANTDONE");
            }
            this.os.writeSmallInt((short)49);
            this.isReleased = false;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendPrepare() exited");
        }
    }

    private void sendStatementExecute(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendStatementExecute() called");
        }
        this.sendExecute(stmt);
        this.receiveMessage();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendStatementExecute() exited");
        }
    }

    private void sendExecute(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExecute() called");
        }
        try {
            this.sendStatementID();
            if (!(stmt instanceof IfxPreparedStatement)) {
                this.resetSGKTuples();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EXECUTE");
                }
                this.os.writeSmallInt((short)7);
                return;
            }
            IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
            IfxResultSetMetaData pmd = pstmt.inputParamMeta;
            int qmarks = pstmt.getqmarks();
            boolean tmpFlag = true;
            if (!(this.conn.isBatchUpdatePerSpec() && stmt.executeBatchInProgress || pstmt.BatchVector.size() > 0 && !pstmt.executeBatchInProgress)) {
                Vector setValues = null;
                if (pstmt.BatchVector.size() == 0) {
                    setValues = pstmt.getVector();
                    tmpFlag = false;
                } else {
                    setValues = pstmt.BatchParamVector;
                }
                int valSize = setValues.size();
                for (int i = 0; i < qmarks && pstmt.BatchVector.size() == 0; ++i) {
                    IfxObject ival = null;
                    if (i < setValues.size()) {
                        ival = (IfxObject)setValues.elementAt(i);
                    }
                    if (ival != null) continue;
                    int ord = i % qmarks + 1;
                    if (pmd != null && pmd.hasDefaultValue(ord)) continue;
                    throw IfxErrMsg.getSQLException(-79823, pstmt.namedCalls == 0L ? " index = " + ord : pmd.getArgumentName(ord), (IfxConnection)this.conn);
                }
                if (qmarks > 0) {
                    this.sendBind(setValues, pmd, qmarks, 0, qmarks);
                }
            } else {
                if (this.conn.isBatchUpdatePerSpec() && stmt.executeBatchInProgress) {
                    int batchCnt = pstmt.BatchVector.size();
                    for (int j = 0; j < batchCnt; ++j) {
                        int startIdx = j * qmarks;
                        int endIdx = startIdx + qmarks;
                        boolean sentIMPEXP = false;
                        if (qmarks > 0) {
                            sentIMPEXP = this.sendBind(pstmt.BatchParamVector, pmd, qmarks, startIdx, endIdx);
                        }
                        if (j == 0 && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                            this.sendSQBatchStart();
                        }
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 1, "\tSQ_EXECUTE");
                        }
                        this.os.writeSmallInt((short)7);
                        if (j == batchCnt - 1 && this.conn.isSQBatchSupported() && this.conn.isANSI() && tmpFlag) {
                            this.sendSQBatchEnd();
                        }
                        if (sentIMPEXP) {
                            this.receiveMessage();
                        }
                        if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < (this.conn.isXPSVER8_40() ? Short.MAX_VALUE : this.conn.getMaxFetchBufSize())) continue;
                        this.receiveMessage();
                        this.sendStatementID();
                    }
                    return;
                }
                int numVals = pstmt.BatchParamVector.size();
                this.sendBind(pstmt.BatchParamVector, pmd, 0, numVals, numVals);
            }
            this.resetSGKTuples();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_EXECUTE");
            }
            this.os.writeSmallInt((short)7);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExecute() exited");
        }
    }

    @Override
    public void executeStatementQuery(Statement stmt) throws SQLException {
        this.executeStatementQuery(stmt, false, false, null);
    }

    @Override
    public void executeStatementQuery(Statement stmt, boolean withHold, boolean withReOptimization) throws SQLException {
        this.executeStatementQuery(stmt, withHold, withReOptimization, null);
    }

    @Override
    public void executeStatementQuery(Statement stmt, boolean withHold, boolean withReOptimization, ResultSetMetaData outputDesc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeStatementQuery() called");
        }
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(stmt instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        }
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && outputNumber > 0) {
            try {
                if (!this.conn.autoCommit) {
                    this.initiateTransaction();
                }
                this.sendStatementQuery((IfxStatement)stmt, withHold, withReOptimization, (IfxResultSetMetaData)outputDesc);
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        } else {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeStatementQuery() exited");
        }
    }

    private void sendStatementQuery(IfxStatement stmt, boolean withHold, boolean withReOptimization, IfxResultSetMetaData outputDesc) throws SQLException {
        if (stmt.currentResult != null) {
            stmt.currentResult.withHold = withHold;
        }
        this.sendQuery(stmt, withHold, withReOptimization, outputDesc);
        if (stmt.getResultSetType() == 1003) {
            boolean useOptofc;
            boolean bl = useOptofc = stmt instanceof IfxPreparedStatement && this.conn.optofc && stmt.getStatementType() == 2;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxSqli: resultset type is forward_only");
            }
            IfxResultSetMetaData fetchRsmd = null;
            if (stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                fetchRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
            }
            if (this.desc.hasVariableLengthColumns && !useOptofc) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: desc HAS variable length columns");
                }
                this.receiveMessage();
            }
            if (fetchRsmd != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: fetchRsmd is not null");
                }
                this.sendFetch(this.desc.hasVariableLengthColumns, fetchRsmd, stmt);
            } else if (useOptofc) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: sendStatementQuery() OPTOFC set for PreparedStatement, skipping fetch.");
                }
            } else {
                this.sendFetch(this.desc.hasVariableLengthColumns, this.desc, stmt);
            }
            stmt.cursorOpen = true;
        }
        this.receiveMessage();
    }

    private void sendType(IfxResultSetMetaData outputDesc, short direction, boolean typeSentCheck) throws SQLException {
        if (typeSentCheck && this.typeSent) {
            return;
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_RET_TYPE");
            }
            this.os.writeSmallInt((short)100);
            this.os.writeSmallInt(direction);
            this.os.writeSmallInt((short)this.desc.getColumnCount());
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tdirection: (1-FETCH, 0-PUT)", direction);
                this.protoTrace.writeTrace(logger, 2, "\tCount: ", this.desc.getColumnCount());
            }
            for (int i = 1; i <= this.desc.getColumnCount(); ++i) {
                IfxResultSetMetaData md;
                if (outputDesc != null && outputDesc != this.desc && outputDesc.getColumnCount() >= i && outputDesc.getIfxColumnType(i) != 49) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 99, "sendType(): from output parameter; i = " + i);
                        this.trace.writeTrace(logger, 99, "Type is " + outputDesc.getIfxColumnType(i));
                        this.trace.writeTrace(logger, 99, "Extended id is " + outputDesc.getColumnExtendedId(i));
                    }
                    md = outputDesc;
                    this.desc.setIfxColumnType(i, outputDesc.getIfxColumnType(i));
                    this.desc.setExtendedName(i, outputDesc.getExtendedName(i));
                    this.desc.setColumnExtendedId(i, outputDesc.getColumnExtendedId(i));
                    this.desc.setEncodedLength(i, outputDesc.getEncodedLength(i));
                } else {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 99, "sendType(): from describe; i = " + i);
                    }
                    md = this.desc;
                }
                short sqltype = (short)md.getIfxColumnType(i);
                boolean isVariableLength = md.isVariableLengthType(i);
                if (isVariableLength && sqltype != 13 && sqltype != 16) {
                    short xid = md.isDistinct(i) ? (short)md.getSourceType(i) : (short)md.getColumnExtendedId(i);
                    sqltype = xid == 3 ? (short)46 : (xid == 4 ? (short)47 : (xid == 1 ? (short)43 : (xid == 5 ? (short)45 : 44)));
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "sendType(): i = " + i + "; sqltype = " + sqltype);
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn #: ", i);
                    this.protoTrace.writeTrace(logger, 2, "\t\t\t\tType: ", sqltype);
                }
                this.os.writeSmallInt(sqltype);
                if (isVariableLength && sqltype != 13 && sqltype != 16) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\t\tExtendedOwnerName: ", md.getExtendedOwnerName(i));
                        this.protoTrace.writeTrace(logger, 2, "\t\t\t\tExtendedTypeName: ", md.getExtendedName(i));
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(md.getExtendedOwnerName(i)));
                    this.os.writeChar(this.os.getJavaToIfxChar(md.getExtendedName(i)));
                } else if (isVariableLength && sqltype == 43) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\t\tExtendedOwnerName: ", md.getExtendedOwnerName(i));
                        this.protoTrace.writeTrace(logger, 2, "\t\t\t\tExtendedTypeName: ", md.getExtendedName(i));
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\t\tLength: ", md.getEncodedLength(i));
                }
                this.os.writeInt(md.getEncodedLength(i));
            }
            this.typeSent = true;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendQuery(IfxStatement stmt, boolean withHold, boolean withReOptimization, IfxResultSetMetaData outputDesc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendQuery() called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "tupleBufferSize: " + this.tupleBufferSize);
        }
        try {
            int curstype;
            IfxPreparedStatement pstmt;
            String cursorname = stmt.getCursorName();
            byte[] cursorNameBytes = this.os.getJavaToIfxChar(cursorname, this.dbEncoding);
            this.sendStatementID();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_CURNAME");
            }
            this.os.writeSmallInt((short)3);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tCursor name: " + cursorname);
            }
            this.os.writeChar(cursorNameBytes);
            if (stmt instanceof IfxPreparedStatement && !(pstmt = (IfxPreparedStatement)stmt).usePut() && pstmt.inputvals > 0) {
                if (pstmt.inputvals == pstmt.numqmarks) {
                    this.sendBind(pstmt.getVector(), pstmt.inputParamMeta, pstmt.numqmarks, 0, pstmt.numqmarks);
                } else {
                    throw IfxErrMsg.getSQLException(-79823, this.conn);
                }
            }
            this.SQ_CLOSERecvd = false;
            this.SQ_CLOSESent = false;
            this.first = true;
            if (stmt.getAutoFree()) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_AUTOFREE");
                }
                this.os.writeSmallInt((short)108);
            }
            if ((curstype = stmt.getResultSetType()) == 1004) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_SCROLL");
                }
                this.os.writeSmallInt((short)24);
            }
            if (withHold && this.statementType != 56) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_HOLD");
                }
                this.os.writeSmallInt((short)43);
            }
            if (withReOptimization) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(1, "\tSQ_REOPTOPEN");
                }
                this.os.writeSmallInt((short)87);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_OPEN");
                }
                this.os.writeSmallInt((short)6);
            }
            if (this.conn.optofc && stmt instanceof IfxPreparedStatement && stmt.getStatementType() == 2 && curstype == 1003 && stmt.getResultSetConcurrency() == 1007) {
                if (this.statementType != 0 && this.statementID != -1) {
                    this.os.writeSmallInt((short)4);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tSQ_ID: ", this.statementID);
                    }
                    this.os.writeSmallInt(this.statementID);
                }
                if (this.desc.hasVariableLengthColumns) {
                    this.sendType(this.desc, (short)1, true);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_NFETCH");
                }
                this.os.writeSmallInt((short)9);
                int tupleBufferSize = this.getTupleBufferSize(stmt.getFetchBufferSize());
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple Buffer Size: ", tupleBufferSize);
                }
                if (this.conn.isXPSVER8_40() || this.conn.is2GBFetchBufferSupported()) {
                    this.os.writeInt(tupleBufferSize);
                } else {
                    this.os.writeSmallInt((short)tupleBufferSize);
                }
                if (this.conn.isFetchArr()) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tFetch Array Size: ", (short)0);
                    }
                    this.os.writeSmallInt((short)0);
                }
                if (this.rowColumn == null && this.desc != null) {
                    this.rowColumn = new IfxRowColumn(this.conn, this.desc, tupleBufferSize);
                    if (TraceFlag.isTraceEnabled()) {
                        this.rowColumn.setTrace(this.trace);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        stmt.cursorOpen = true;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendQuery() exited");
        }
    }

    @Override
    public void executeOpenDatabase(String dbName, int flags) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeOpenDatabase() called");
        }
        if (dbName == null) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            byte[] dbNameBytes = this.os.getJavaToIfxChar(dbName, this.dbEncoding);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_DBOPEN");
            }
            this.os.writeSmallInt((short)36);
            this.os.writeChar(dbNameBytes);
            this.os.writeSmallInt((short)flags);
            this.statementType = 1;
            this.receiveMessage();
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(dbName);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeOpenDatabase() exitted");
        }
    }

    @Override
    public void executeClose(Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeClose() called");
        }
        if (this.conn.isCommitNeeded() && !this.doneCommit) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "next call executeCommit()");
            }
            this.executeCommit();
            this.doneCommit = true;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "stmt cursorOpen was " + ((IfxStatement)stmt).cursorOpen);
        }
        if (((IfxStatement)stmt).cursorOpen) {
            if (!this.conn.lockSession()) {
                throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
            }
            ((IfxStatement)stmt).cursorOpen = false;
            if (!this.SQ_CLOSERecvd) {
                try {
                    this.sendClose((IfxStatement)stmt);
                    this.receiveMessage();
                }
                catch (SQLException e) {
                    this.conn.unlockSession();
                    throw e;
                }
                catch (Exception e) {
                    this.conn.unlockSession();
                    throw this.handleSocketException(e, this.conn);
                }
            }
            this.conn.unlockSession();
        }
        if (((IfxStatement)stmt).getAutoFree()) {
            this.clearAll();
        } else {
            this.clear();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeClose() exited");
        }
    }

    @Override
    public void executeRelease(int id) throws SQLException {
        this.statementID = (short)id;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            if (this.statementID != -1) {
                this.sendRelease(null);
                this.receiveMessage();
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRelease(int) exited");
        }
    }

    @Override
    public void executeRelease(Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRelease() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!((IfxStatement)stmt).getAutoFree() || this.conn.getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent || ((IfxStatement)stmt).getAutoFree() && !this.SQ_CLOSERecvd && !this.SQ_CLOSESent) {
            try {
                if (!this.isReleased && this.statementID != -1) {
                    this.sendRelease((IfxStatement)stmt);
                    this.statementID = (short)-1;
                    this.receiveMessage();
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
            catch (Exception e) {
                this.conn.unlockSession();
                throw this.handleSocketException(e, this.conn);
            }
        }
        this.conn.unlockSession();
        ((IfxStatement)stmt).cursorOpen = false;
        this.clearAll();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeRelease() exited");
        }
    }

    void executeFetch(Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFetch() called");
        }
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetch(false, this.desc, stmt);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFetch() exited");
        }
    }

    private void sendFetch(boolean sendRetType, IfxResultSetMetaData desc, Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendFetch() called");
        }
        int tupleBufferSize = this.getTupleBufferSize(((IfmxStatement)stmt).getFetchBufferSize());
        ++this.numberOfFetches;
        try {
            this.sendStatementID();
            if (sendRetType) {
                this.sendType(desc, (short)1, stmt instanceof IfxPreparedStatement);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_NFETCH");
            }
            this.os.writeSmallInt((short)9);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuple Buffer Size: ", tupleBufferSize);
            }
            if (this.conn.isXPSVER8_40() || this.conn.is2GBFetchBufferSupported()) {
                this.os.writeInt(tupleBufferSize);
            } else {
                this.os.writeSmallInt((short)tupleBufferSize);
            }
            if (this.conn.isFetchArr()) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tFetch Array Size: ", (short)0);
                }
                this.os.writeSmallInt((short)0);
            }
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, desc, tupleBufferSize);
                if (TraceFlag.isTraceEnabled()) {
                    this.rowColumn.setTrace(this.trace);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendFetch() exited");
        }
    }

    private void sendClose(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendClose() called");
        }
        try {
            this.sendStatementID();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tSQ_CLOSE");
            }
            this.os.writeSmallInt((short)10);
            this.SQ_CLOSESent = true;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendClose() exited");
        }
    }

    private void sendRelease(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRelease() called");
        }
        try {
            this.sendStatementID();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tSQ_RELEASE");
            }
            this.os.writeSmallInt((short)11);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendRelease() exited");
        }
    }

    @Override
    public void executeCloseDatabase() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCloseDatabase() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        String dbName = this.conn.getConnectionDbName();
        if (dbName != null && dbName.length() != 0) {
            this.conn.unlockSession();
            return;
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_DBCLOSE");
            }
            this.os.writeSmallInt((short)37);
            this.receiveMessage();
            this.conn.databaseClosed();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeCloseDatabase() exited");
        }
    }

    @Override
    public void executeExecute(Statement stmt, boolean holdable, boolean withReOptimization) throws SQLException {
        this.executeExecute(stmt, holdable, withReOptimization, null);
    }

    @Override
    public void executeExecute(Statement stmt, boolean holdable, boolean withReOptimization, ResultSetMetaData outputDesc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeExecute() called");
        }
        this.resetTuples();
        this.doneCommit = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!(stmt instanceof IfxPreparedStatement)) {
            try {
                this.sendPrepare((IfxStatement)stmt);
                this.receiveMessage();
                if (this.desc != null) {
                    this.desc.parseSetTableName(((IfxStatement)stmt).commandString);
                }
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
        }
        try {
            if (this.statementType == 2 || this.statementType == 56 && this.desc != null && this.desc.getColumnCount() > 0) {
                this.sendStatementQuery((IfxStatement)stmt, holdable, withReOptimization, (IfxResultSetMetaData)outputDesc);
            } else {
                this.sendStatementExecute((IfxStatement)stmt);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.TxStmt == 2) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: END_TX_STMT, return err");
                    this.trace.writeTrace(logger, 3, "IfxSqli.executeExecute.sqlcode", this.sqlcode);
                }
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            throw e;
        }
        this.conn.unlockSession();
        this.callsetDatabaseOpen(this.parseDbName(stmt));
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else if (this.conn.isCommitNeeded() && !this.isResultSet()) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeExecute() exited");
        }
    }

    public void receiveMessage() throws SQLException {
        short msg = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveMessage() called");
        }
        this.clearExceptions();
        try {
            this.flip();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
            }
            try {
                do {
                    if ((msg = this.is.readSmallInt()) == 56 && this.conn != null) {
                        this.conn.unlockSession();
                    }
                    if (this.dispatchMsg(msg)) continue;
                    break;
                } while (msg != 12 && msg != 56);
            }
            finally {
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
            }
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(this.handleSocketException(e, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveMessage() exited");
        }
    }

    public boolean dispatchMsg(int msg) throws Exception {
        boolean retval = true;
        switch (msg) {
            case 56: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EXIT");
                }
                this.sendExit();
                break;
            }
            case 8: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_DESCRIBE");
                }
                this.descTrue = true;
                this.receiveDescribe();
                break;
            }
            case 14: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_TUPLE");
                }
                this.receiveTuple();
                break;
            }
            case 25: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_TUPID");
                }
                this.receiveTupleId();
                break;
            }
            case 15: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_DONE");
                }
                this.receiveDone();
                break;
            }
            case 39: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                }
                if (this.isText && this.convText) {
                    this.receiveText();
                    break;
                }
                this.receiveBlob();
                break;
            }
            case 97: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_LODATA");
                }
                this.receiveLODATA();
                break;
            }
            case 13: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_ERR");
                }
                this.receiveError();
                break;
            }
            case 55: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_COST");
                }
                this.receiveCost();
                break;
            }
            case 94: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_INSERTDONE");
                }
                this.receiveInsertDone();
                break;
            }
            case 99: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_XACTSTAT");
                }
                this.receiveXactstat();
                break;
            }
            case 10: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_CLOSE");
                }
                this.SQ_CLOSERecvd = true;
                break;
            }
            case 81: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_INFO");
                }
                this.receiveInfo();
                break;
            }
            case 53: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_VERSION");
                }
                this.receiveVersion();
                break;
            }
            case 12: {
                if (!TraceFlag.isTraceEnabled()) break;
                this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                break;
            }
            case 101: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_GETROUTINE");
                }
                this.receiveHandle();
                break;
            }
            case 103: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FPROUTINE");
                }
                this.receiveFastPath();
                break;
            }
            case 98: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FILE");
                }
                this.receiveSQFILE();
                break;
            }
            case 26: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_DBLIST");
                }
                this.receiveDBList();
                break;
            }
            case 104: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FPARAM");
                }
                this.receiveFParam();
                break;
            }
            case 18: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_PUTERR");
                }
                this.receivePutErr();
                break;
            }
            case 86: {
                break;
            }
            case 125: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_IDESCRIBE");
                }
                this.receiveIDescribe();
                break;
            }
            case 126: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_PROTOCOLS");
                }
                this.receiveProtocols();
                break;
            }
            case 132: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_IFPDESCRIBE");
                }
                this.receiveIFPDescribe();
                break;
            }
            case 135: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_SGKDESCRIBE");
                }
                this.receiveSGKDescribe();
                break;
            }
            case 136: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_SGKTUPLE");
                }
                this.receiveSGKTuple();
                break;
            }
            default: {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t*** UNknown error message: " + msg + " ***\n");
                }
                this.setError(-408);
                retval = false;
            }
        }
        return retval;
    }

    protected void flip() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: flip() called");
        }
        try {
            this.sendEOT();
            if (this.sqliTrace != null) {
                this.sqliTrace.recordC2S();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: flip() exited");
        }
    }

    private void sendEOT(int traceLevelNum) throws IOException {
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, traceLevelNum, "\tSQ_EOT");
        }
        this.os.writeSmallInt((short)12);
        this.os.flush();
        this.os.setByteCntAtEOT();
    }

    private void sendEOT() throws IOException {
        this.sendEOT(1);
    }

    private void sendACK() throws IOException {
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_ACK");
        }
        this.os.writeSmallInt((short)128);
    }

    private boolean receiveEOT() throws IOException {
        boolean rv = true;
        short msg = this.is.readSmallInt();
        if (msg != 12) {
            rv = false;
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t*** UNEXPECTED SQLI MESSAGE: " + msg + " ***\n");
            }
        } else if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
        }
        return rv;
    }

    private void sendStatementID() throws IOException {
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_ID");
        }
        if (this.statementType == 0 && this.statementID == -1) {
            return;
        }
        this.os.writeSmallInt((short)4);
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 2, "\t\tID: ", this.statementID);
        }
        this.os.writeSmallInt(this.statementID);
    }

    public void sendSQBatchStart() throws IOException {
        if (this.conn != null && this.conn.isSQBatchSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BATCHSTART");
            }
            this.os.writeSmallInt((short)141);
        }
    }

    public void sendSQBatchEnd() throws IOException {
        if (this.conn != null && this.conn.isSQBatchSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BATCHEND");
            }
            this.os.writeSmallInt((short)142);
        }
    }

    private void sendExit() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExit() called");
        }
        if (this.conn != null) {
            this.conn.unlockSession();
        }
        if (this.conn != null && !this.conn.isASF()) {
            this.conn.setDatabaseOpen(false, this.serverWarningsShort);
        }
        this.conn.close();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExit() exited");
        }
    }

    private void callsetDatabaseOpen(String dbname) throws SQLException {
        if (this.OpenDBStmt) {
            this.conn.setDbName(dbname);
            this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            this.dbEncoding = this.conn.getdbEncoding();
        }
    }

    private void setError(int errcode) throws SQLException {
        throw IfxErrMsg.getSQLException(errcode, this.conn);
    }

    private void receiveDescribe() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDescribe() called");
        }
        short nfields = 0;
        int intVal = 0;
        String strtab = null;
        int ifxType = 0;
        int ifxExType = 0;
        int encLen = 0;
        int[] fieldIndex = null;
        try {
            this.statementType = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement Type: ", this.statementType);
            }
            this.statementID = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement ID: ", this.statementID);
            }
            intVal = this.is.readInt();
            this.setSQLerrd((short)3, intVal);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tEstimated Cost: ", intVal);
            }
            short tupleSize = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuplesize: ", (int)tupleSize);
            }
            nfields = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# of fields: ", (int)nfields);
            }
            this.desc = new IfxResultSetMetaData(nfields, this.conn);
            this.desc.setTupleSize(tupleSize);
            int stringTableSize = this.conn.is4ByteOffsetSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tString table: ", stringTableSize);
            }
            this.TxStmt = 0;
            if (this.statementType == 34) {
                this.TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.TxStmt = (short)2;
            }
            if (nfields > 0) {
                fieldIndex = new int[nfields];
                for (short i = 1; i <= nfields; i = (short)(i + 1)) {
                    short shortVal;
                    fieldIndex[i - 1] = this.conn.is4ByteOffsetSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t    Field Index: ", fieldIndex[i - 1]);
                    }
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Start Pos: ", intVal);
                        }
                        this.desc.setColumnStartPosition(i, intVal);
                    } else {
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Start Pos: ", shortVal);
                        }
                        this.desc.setColumnStartPosition(i, shortVal);
                    }
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn type: (" + IfxTypes.IfxTypeToName(shortVal) + ") ", shortVal);
                    }
                    this.desc.setIfxColumnType(i, shortVal);
                    ifxType = this.desc.getIfxColumnType(i);
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            if (intVal <= 26) {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Extended Builtin Id: (" + IfxTypes.IfxExTypeToName(intVal) + ") ", intVal);
                            } else {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Extended Id: ", intVal);
                            }
                        }
                        this.desc.setColumnExtendedId(i, intVal);
                        ifxExType = intVal;
                        String stringData = new String(this.is.readChar(this.dbEncoding));
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tOwner name: " + stringData);
                        }
                        this.desc.setExtendedOwnerName(i, stringData);
                        stringData = new String(this.is.readChar());
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tExtended name: " + stringData);
                        }
                        this.desc.setExtendedName(i, stringData);
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tReference: ", shortVal);
                        }
                        this.desc.setReference(i, shortVal);
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tAlignment: ", shortVal);
                        }
                        this.desc.setAlignment(i, shortVal);
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tSource type: ", intVal);
                        }
                        this.desc.setSourceType(i, intVal);
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", intVal);
                        }
                        this.desc.setEncodedLength(i, intVal);
                        encLen = intVal;
                    } else {
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", shortVal);
                        }
                        this.desc.setEncodedLength(i, shortVal);
                        encLen = intVal;
                    }
                    intVal = IfxTypes.IfxTypeToDecDigits(ifxType, ifxExType, encLen);
                    this.desc.setDecimalDigits(i, intVal);
                    intVal = IfxTypes.IfxTypeToRightDecimal(ifxType, ifxExType, encLen);
                    this.desc.setRightDecimal(i, intVal);
                }
                this.desc.setTextByteColumnCount();
            }
            if (stringTableSize > 0) {
                byte[] b = new byte[stringTableSize];
                this.is.readPadded(b);
                strtab = this.conn.ifxtojava.IfxToJavaChar(b, this.dbEncoding, this.conn.encoption);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tData in String table: ", strtab);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "Describe packet received");
        }
        if (strtab != null) {
            String colName = null;
            StringTokenizer itok = new StringTokenizer(strtab, "\u0000");
            for (short i = 0; i < nfields; i = (short)(i + 1)) {
                if (itok.hasMoreTokens()) {
                    colName = itok.nextToken();
                    this.desc.setColumnName(i + 1, colName);
                    continue;
                }
                this.desc.setColumnName(i + 1, null);
            }
        }
        if (this.conn != null) {
            this.desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDescribe() exited");
        }
    }

    void setSQLerrd(short i, int val) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: setSQLerrd() called");
        }
        try {
            this.sqlerrd[i] = val;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: setSQLerrd() exited");
        }
    }

    private void receiveInsertDone() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveInsertDone() called");
        }
        try {
            this.serial8Inserted = this.is.readLongInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSerial8: ", this.serial8Inserted);
            }
            if (this.conn.isBigintSupported()) {
                this.bigSerialInserted = this.is.readLongBigint();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tBigserial: ", this.bigSerialInserted);
                }
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveInsertDone() exited");
        }
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    @Override
    public long getBigSerialInserted() {
        return this.bigSerialInserted;
    }

    @Override
    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    private void receiveDone() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDone() called");
        }
        this.OpenDBStmt = false;
        try {
            if (this.executeBatchInProgress && this.batchRowStatus == null) {
                this.batchRowStatus = new ArrayList();
            }
            if (this.statementType == 1 || this.statementType == 12 || this.statementType == 38) {
                this.OpenDBStmt = true;
            }
            if (this.statementType == 31) {
                this.conn.databaseClosed();
            }
            short warnings = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tWarning: ", warnings);
            }
            this.setWarnings(warnings, this.OpenDBStmt);
            int intVal = this.is.readInt();
            if (this.executeBatchInProgress) {
                this.batchRowStatus.add(this.batchCount++, intVal);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# rows: ", intVal);
            }
            this.setSQLerrd((short)2, intVal);
            intVal = this.is.readInt();
            if (intVal == 0 && this.statementType == 2 && !this.descTrue) {
                this.SQLState = IfxMessage.getSQLSTATE(100);
                this.message = IfxMessage.getMessage(36007, this.conn.getclLocale());
                this.addWarning(100, this.message);
            }
            this.descTrue = false;
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tRowid: ", intVal);
            }
            this.setSQLerrd((short)5, intVal);
            intVal = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSerial id: ", intVal);
            }
            this.setSQLerrd((short)1, intVal);
            if (!this.OpenDBStmt && this.statementType == 31) {
                this.conn.setDatabaseOpen(this.OpenDBStmt, this.serverWarningsShort);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveDone() exited");
        }
    }

    @Override
    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    @Override
    public int getSerialInsert() {
        return this.sqlerrd[1];
    }

    int getISAMCode() {
        return this.isamcode;
    }

    @Override
    public int getNumberOfRowsProcessed() {
        return this.sqlerrd[2];
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    int getSQLStatementOffset() {
        return this.sqlerrd[4];
    }

    int getRowID() {
        return this.sqlerrd[5];
    }

    private void receiveCost() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveCost() called");
        }
        try {
            int intVal = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tEstimated #rows: ", intVal);
            }
            this.setSQLerrd((short)0, intVal);
            intVal = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tEstimated i/o: ", intVal);
            }
            this.setSQLerrd((short)3, intVal);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveCost() exited");
        }
    }

    private void receiveXactstat() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveXactstat() called");
        }
        try {
            this.xcEvent = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\txcEvent: ", this.xcEvent);
            }
            this.xcNewLevel = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\txcNewLevel: ", this.xcNewLevel);
            }
            this.xcOldLevel = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\txcOldLevel: ", this.xcOldLevel);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "XA State package received");
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveXactstat() exited");
        }
    }

    int getXCEvent() {
        return this.xcEvent;
    }

    int getNewLevel() {
        return this.xcNewLevel;
    }

    int getOldLevel() {
        return this.xcOldLevel;
    }

    private void receiveTuple() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveTuple() called");
            this.trace.writeTrace(logger, 2, "    totalTupleSize = " + this.totalTupleSize);
            this.trace.writeTrace(logger, 2, "    totalTuples = " + this.totalTuples);
        }
        ++this.numberOfTuplesReceived;
        try {
            int size;
            short warn = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tWarning: ", warn);
            }
            if ((size = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt()) > 0) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple Size :", size);
                }
                this.rowColumn.readTuple(this.is, this.totalTupleSize, size);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple data: ");
                    this.protoTrace.writeTrace(logger, 2, this.rowColumn.getTupleData(), this.totalTupleSize, 'B', size);
                }
                this.totalTupleSize += size;
                this.tupleSizeReceived = Math.max(size, this.tupleSizeReceived);
                if (++this.totalTuples >= this.offsetVector.size()) {
                    this.offsetVector.setSize(this.totalTuples + 100);
                }
                this.offsetVector.setElementAt(this.totalTupleSize, this.totalTuples);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveTuple(): tuple size = " + size);
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveTuple(): totalTupleSize = " + this.totalTupleSize);
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveTuple(): totalTuples = " + this.totalTuples);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveTuple() exited");
        }
    }

    public void addException(SQLException e) {
        if (this.exception == null) {
            this.exception = e;
        } else {
            this.exception.setNextException(e);
        }
    }

    private void addException(int sqlcode, String sqlerrm) {
        String locale = this.conn.getclLocale();
        SQLException e = null;
        String isamMessage = "";
        if (this.conn.appendIsam && this.isamcode != 0) {
            isamMessage = "(" + sqlcode + ") " + IfxMessage.getMessage(this.isamcode, null, locale) + "(" + this.isamcode + ")";
        }
        if (sqlcode == -9752 && this.conn.isNamedParametersSupported()) {
            String detailHandle = IfxMessage.getMessage(sqlcode, sqlerrm, locale) + ":" + sqlerrm + isamMessage;
            e = new SQLException(detailHandle, IfxMessage.getSQLSTATE(sqlcode), sqlcode);
        } else {
            e = sqlcode == -268 ? new SQLIntegrityConstraintViolationException(IfxMessage.getMessage(sqlcode, sqlerrm, locale) + isamMessage, IfxMessage.getSQLSTATE(sqlcode), sqlcode) : (sqlerrm != null && sqlerrm.length() > 0 ? new SQLException(IfxMessage.getMessage(sqlcode, sqlerrm, locale) + isamMessage, IfxMessage.getSQLSTATE(sqlcode), sqlcode) : IfxErrMsg.getSQLException(sqlcode, this.conn));
        }
        this.addException(e);
    }

    private void addException(String reason, String SQLState, int sqlcode) {
        String locale = this.conn.getclLocale();
        SQLException e = null;
        String isamMessage = "";
        if (this.conn.appendIsam && this.isamcode != 0) {
            isamMessage = "(" + sqlcode + ") " + IfxMessage.getMessage(this.isamcode, null, locale) + "(" + this.isamcode + ")";
        }
        e = reason == null || reason.trim().isEmpty() ? (SQLState == null || SQLState.trim().isEmpty() ? new SQLException(IfxMessage.getMessage(sqlcode, locale) + isamMessage, IfxMessage.getSQLSTATE(sqlcode), sqlcode) : new SQLException(IfxMessage.getMessage(sqlcode, locale) + isamMessage, SQLState, sqlcode)) : (SQLState == null || SQLState.trim().isEmpty() ? new SQLException(reason + isamMessage, "U0001", sqlcode) : new SQLException(reason + isamMessage, SQLState, sqlcode));
        this.addException(e);
    }

    public SQLException getExceptions() {
        return this.exception;
    }

    private void addWarning(SQLWarning w) {
        if (this.warn == null) {
            this.warn = w;
        } else {
            this.warn.setNextException(w);
        }
    }

    private void addWarning(int sqlcode, String message) {
        SQLWarning w = null;
        w = new SQLWarning(message, IfxMessage.getSQLSTATE(sqlcode), sqlcode);
        this.addWarning(w);
    }

    private void addWarning(String message, String sqlstate) {
        SQLWarning w = null;
        w = sqlstate != null ? IfxWarnMsg.getSQLWarning(sqlstate, message, this.conn) : IfxWarnMsg.getSQLWarning(message, this.conn);
        this.addWarning(w);
    }

    private void setWarnings(short w, boolean OpenDBStmt) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: setWarnings() called");
        }
        int set = 0;
        this.SQLState = null;
        if (this.conn.Noansiwarn) {
            w = (short)(w & 0xFFFFFFEF);
        }
        this.serverWarningsShort = w;
        for (int i = 1; i <= 6; i = (int)((short)(i + 1))) {
            set = w & 1;
            if (set == 1) {
                this.serverWarningsString.setCharAt(i, 'W');
                switch (i) {
                    case 1: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I01");
                            break;
                        }
                        this.addWarning(null, "01006");
                        break;
                    }
                    case 2: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I03");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 3: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I04");
                            break;
                        }
                        this.addWarning(null, "01003");
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        if (OpenDBStmt) {
                            this.addWarning(null, "01I10");
                            break;
                        }
                        this.addWarning(null, "01I11");
                    }
                }
            } else {
                this.serverWarningsString.setCharAt(i, ' ');
            }
            w = (short)(w >> 1);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: setWarnings() exited");
        }
    }

    @Override
    public void chainWarnings(SQLWarning cwarn) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: chainWarnings() called");
        }
        if (cwarn != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(cwarn);
            } else {
                this.warn = cwarn;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: chainWarnings() exited");
        }
    }

    @Override
    public void clearExceptions() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clearExceptions() called");
        }
        this.sqlcode = 0;
        this.isamcode = 0;
        this.SQLState = null;
        this.message = null;
        this.exception = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clearExceptions() exited");
        }
    }

    @Override
    public void clearWarnings() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clearWarnings() called");
        }
        this.SQLState = null;
        this.message = null;
        this.sqlcode = 0;
        this.isamcode = 0;
        this.warn = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: clearWarnings() exited");
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warn;
    }

    private void receivePutErr() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receivePutErr() called");
        }
        try {
            this.putErrRowCount = this.is.readInt();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.receiveError();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receivePutErr() exited");
        }
    }

    private void receiveError() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveError() called");
        }
        try {
            this.sqlcode = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSQLcode: ", this.sqlcode);
            }
            if (this.sqlcode == -619) {
                this.gobbleSmallInts(2);
                if (this.conn.isRemove64KLimitSupported()) {
                    this.gobbleSmallInts(1);
                }
                this.is.readChar();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "Error Code 619, resyncing data");
                }
                this.addException(this.sqlcode, null);
                return;
            }
            this.isamcode = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tISAM/RSAM error: ", this.isamcode);
            }
            this.setSQLerrd((short)1, this.isamcode);
            int shortVal = this.conn.isRemove64KLimitSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tOffset into statement: ", shortVal);
            }
            this.setSQLerrd((short)4, shortVal);
            this.conn.setSQLStatementOffset(shortVal);
            if (this.sqlcode != -368) {
                this.sqlerrm = this.is.readChar(this.dbEncoding).trim();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tsqlerrm: " + this.sqlerrm);
                }
            }
            if (this.sqlcode == 0 && !this.conn.isUSVER()) {
                this.sqlcode = -407;
                this.isamcode = 0;
                this.addException(this.sqlcode, null);
            } else if (this.sqlcode == 100) {
                this.SQLState = IfxMessage.getSQLSTATE(this.sqlcode);
                this.message = IfxMessage.getMessage(36007, this.conn.getclLocale());
                this.addWarning(this.sqlcode, this.message);
                if (this.conn.AnsiDb) {
                    this.setSQLerrd((short)2, 0);
                    if (this.batchRowStatus == null) {
                        this.batchRowStatus = new ArrayList();
                    }
                }
            } else if (this.sqlcode != 0 && this.sqlcode != -937) {
                this.addException(this.sqlcode, this.sqlerrm);
                if (this.isamcode != 0) {
                    this.addException(this.isamcode, null);
                }
                SQLException causeException = IfxErrMsg.getSQLException(this.isamcode, this.conn);
                IfxErrMsg.setSQLExceptionCause(this.exception, causeException);
            } else {
                byte[] b = new byte[5];
                this.is.readPadded(b);
                this.SQLState = this.conn.ifxtojava.IfxToJavaChar(b, this.conn.encoption);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tSQLState: ", this.SQLState);
                }
                this.message = this.is.readChar(this.dbEncoding);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tMI message:", this.message);
                }
                this.sqlerrm = null;
                if (this.sqlcode == 0) {
                    this.isamcode = 0;
                    this.addWarning(this.message, this.SQLState);
                } else {
                    this.addException(this.message, this.SQLState, this.sqlcode);
                    if (this.isamcode != 0) {
                        this.addException(this.isamcode, null);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception ee) {
            this.addException(-79716, null);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveError() exited");
        }
    }

    public int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    private void receiveTupleId() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveTupleId() called");
        }
        try {
            this.Tupid = this.is.readInt();
            if (this.getTupleCount() > 0) {
                this.firstTuple = this.Tupid;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple ID: ", this.firstTuple);
                }
                this.lastTuple = this.firstTuple + this.getTupleCount() - 1;
            } else {
                int n = this.Tupid;
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveTupleId() exited");
        }
    }

    void executeInfo(short regflag) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeInfo() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendInfo(regflag);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeInfo() exited");
        }
    }

    private void sendInfo(short regflag) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendInfo() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_INFO ", (short)81);
            }
            this.os.writeSmallInt((short)81);
            if (regflag != 0) {
                this.os.writeSmallInt((short)1);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tINFO_REQUEST");
                }
                this.os.writeSmallInt((short)0);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ", (short)0);
                }
            }
            this.os.writeSmallInt((short)0);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tINFO_DONE");
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendInfo() called");
        }
    }

    private void receiveInfo() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveInfo() called");
        }
        try {
            short message;
            block8: while ((message = this.is.readSmallInt()) > 0) {
                int length = this.is.readSmallInt();
                switch (message) {
                    case 2: {
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_VERSION");
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", length);
                        }
                        if (length < 4) {
                            this.setError(-408);
                            continue block8;
                        }
                        length -= 4;
                        continue block8;
                    }
                    case 3: {
                        int intVal;
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_TYPE");
                        }
                        int TypeList = 0;
                        for (int i = 0; i < length / 4; ++i) {
                            intVal = this.is.readInt();
                            if (TraceFlag.isTraceEnabled()) {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tData:  ", intVal);
                            }
                            TypeList |= intVal;
                        }
                        this.conn.setTypeList(TypeList);
                        continue block8;
                    }
                    case 4: {
                        int intVal;
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\tINFO_CAPABILITY");
                        }
                        int CapList = 0;
                        for (int i = 0; i < length / 4; ++i) {
                            intVal = this.is.readInt();
                            if (TraceFlag.isTraceEnabled()) {
                                this.protoTrace.writeTrace(logger, 2, "\t\t\tData:  ", intVal);
                            }
                            CapList |= intVal;
                        }
                        this.conn.setCapList(CapList);
                        continue block8;
                    }
                }
                this.gobbleChars(length);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveInfo() exited");
        }
    }

    @Override
    public void executeEnv(Properties EnvVars) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeEnv() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendEnv(EnvVars);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeEnv() exited");
        }
    }

    private void sendEnv(Properties EnvVars) throws SQLException {
        short totLen = 0;
        short nameLen = 0;
        short valueLen = 0;
        short LongNameLen = 0;
        short LongValueLen = 0;
        String name = null;
        String value = null;
        int len = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendEnv() called");
        }
        IfxDataOutputStream os = this.conn.Ifxproto_send();
        if (!this.conn.isASF()) {
            return;
        }
        totLen = 4;
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            nameLen = (short)name.length();
            valueLen = (short)value.length();
            len = nameLen & 1;
            if (len == 1) {
                nameLen = (short)(nameLen + 1);
            }
            if ((len = valueLen & 1) == 1) {
                valueLen = (short)(valueLen + 1);
            }
            totLen = (short)(totLen + (nameLen + valueLen + 4));
            if (nameLen > LongNameLen) {
                LongNameLen = nameLen;
            }
            if (valueLen <= LongValueLen) continue;
            LongValueLen = valueLen;
        }
        totLen = (short)(totLen + 2);
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_INFO ", (short)81);
            }
            os.writeSmallInt((short)81);
            os.writeSmallInt((short)6);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tINFO_ENV");
            }
            os.writeSmallInt(totLen);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t\tTotal Length: ", totLen);
            }
            os.writeSmallInt(LongNameLen);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t\tLong Name Length: ", LongNameLen);
            }
            os.writeSmallInt(LongValueLen);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t\tLong Value Length: ", LongValueLen);
            }
            e = EnvVars.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                value = EnvVars.getProperty(name);
                byte[] nameBytes = null;
                byte[] valueBytes = null;
                try {
                    nameBytes = os.getJavaToIfxChar(name, this.dbEncoding);
                    valueBytes = os.getJavaToIfxChar(value, this.dbEncoding);
                }
                catch (Exception ex) {
                    os.writeSmallInt((short)0);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tNull Terminator: ", (short)0);
                    }
                    os.writeSmallInt((short)0);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tINFO_DONE");
                    }
                    throw ex;
                }
                os.writeChar(nameBytes);
                os.writeChar(valueBytes);
                if (!TraceFlag.isTraceEnabled()) continue;
                this.protoTrace.writeTrace(logger, 2, "\t\t\t\"", name + "\"=\"" + value + "\"");
            }
            os.writeSmallInt((short)0);
            os.writeSmallInt((short)0);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tINFO_DONE");
            }
        }
        catch (Exception e2) {
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            throw this.handleSocketException(e2, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendEnv() called");
        }
    }

    private void gobbleChars(int length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: gobbleChars() called");
        }
        try {
            byte[] b = new byte[length];
            this.is.readPadded(b);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: gobbleChars() exited");
        }
    }

    private void gobbleSmallInts(int number) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: gobbleSmallInts() called");
        }
        try {
            for (int i = 0; i < number; ++i) {
                this.is.readSmallInt();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: gobbleSmallInts() exited");
        }
    }

    @Override
    public void executeVersion() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeVersion() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendVersion();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeVersion() exited");
        }
    }

    private void sendVersion() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendVersion() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_VERSION");
            }
            this.os.writeSmallInt((short)53);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendVersion() exited");
        }
    }

    private void receiveVersion() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveVersion() called");
        }
        try {
            this.serverVersion = new String(this.is.readChar());
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tServer Version: " + this.serverVersion);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveVersion() exited");
        }
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    int getTupleBufferSize(int fetchBufferSize) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupleBufferSize() called");
        }
        if (fetchBufferSize > 0) {
            return Math.min(fetchBufferSize, this.conn.getMaxFetchBufSize());
        }
        if (this.tupleBufferSize != -1) {
            return this.tupleBufferSize;
        }
        this.tupleBufferSize = this.desc.getTupleSize() <= 2048 ? 4096 : (this.desc.getTupleSize() <= 4096 ? 8192 : (int)this.desc.getTupleSize());
        if (this.conn.fetchBufSize > this.tupleBufferSize) {
            this.tupleBufferSize = this.conn.getCorrectedFetchBufSize();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupleBufferSize() exited");
        }
        return this.tupleBufferSize;
    }

    @Override
    public boolean isResultSet() throws SQLException {
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && outputNumber > 0;
    }

    @Override
    public int getTupleCount() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupleCount() called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "IfxSqli.getTupleCount(): size", this.totalTuples - (this.curRow + 1));
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupleCount() exited");
        }
        return this.totalTuples;
    }

    @Override
    public boolean getaRow(int direction, int count, int scrolltype, int isscrollcurs, Statement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getaRow() called");
        }
        if (direction != 1000 && count != 1) {
            throw IfxErrMsg.getSQLException(-79751, this.conn);
        }
        if (stmt.getResultSetType() == 1003) {
            this.conn.closeFinalizedBlobsOnServer();
        }
        if (isscrollcurs == 1 && (scrolltype == 6 || scrolltype == 1)) {
            if (this.getTupleCount() != 0) {
                this.repositionIfInTupleBuffer(count);
            }
            if (count == 0) {
                this.curRow = -1;
                return false;
            }
        }
        int tcount = this.getTupleCount() - (this.curRow + 1);
        if (isscrollcurs == 1) {
            if (!this.SQ_CLOSERecvd && (this.getNumberOfTuplesReceived() != 0 || this.first) && (tcount == 0 || scrolltype != 1 && scrolltype != 6)) {
                IfxResultSet currentRS = ((IfxStatement)stmt).currentResult;
                int fetchBufferSize = 0;
                if (currentRS.getFetchSize() != 0) {
                    fetchBufferSize = currentRS.calculateFetchBufferSize();
                }
                if (fetchBufferSize != 0) {
                    fetchBufferSize = Math.min(fetchBufferSize, this.conn.getMaxFetchBufSize());
                }
                this.executeScrollFetch(scrolltype, count, stmt, fetchBufferSize);
                tcount = this.getTupleCount() - (this.curRow + 1);
            }
        } else {
            if (!this.SQ_CLOSERecvd && !this.first) {
                return false;
            }
            if (!this.SQ_CLOSERecvd && this.first && tcount == 0) {
                this.executeFetch(stmt);
                ((IfxStatement)stmt).cursorOpen = true;
                tcount = this.getTupleCount() - (this.curRow + 1);
            }
        }
        if (tcount == 0) {
            if (isscrollcurs != 1 && this.conn.isCommitNeeded() && !this.doneCommit) {
                this.executeCommit();
                this.doneCommit = true;
            }
            this.first = false;
            return false;
        }
        ++this.curRow;
        if (isscrollcurs == 1 && count != this.getTupid() && (scrolltype == 6 || scrolltype == 1)) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.curOffset = this.offsetVector.elementAt(this.curRow);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "curRow = " + this.curRow);
            this.trace.writeTrace(logger, 1, "currOffset = " + this.curOffset);
        }
        this.rowColumn.setOffsetInTuple(this.curOffset);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getaRow() exited");
        }
        return true;
    }

    @Override
    public int getTupleSize() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupleSize() called");
        }
        return this.desc.getTupleSize();
    }

    private void repositionIfInTupleBuffer(int rowId) {
        this.curRow = rowId >= this.firstTuple && rowId <= this.lastTuple ? rowId - this.firstTuple - 1 : this.totalTuples - 1;
    }

    @Override
    public IfxObject getColumnInRow(int colIndex) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(colIndex, null);
    }

    IfxObject getColumnInRow(int colIndex, Calendar cal) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        return this.rowColumn.getColumn(colIndex, cal);
    }

    @Override
    public void loadColumnData(int colIndex, IfxObject val) throws SQLException {
        if (this.rowColumn == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        this.rowColumn.loadColumnData(colIndex, val);
    }

    private void sendBlob(Vector<IfxObject> vector, int count, int si, int inputvals) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBlob() called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 1");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BBIND");
            }
            this.os.writeSmallInt((short)41);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\t# of blobs: ", count);
            }
            this.os.writeSmallInt((short)count);
            this.os.flush();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        for (int i = 0; i < inputvals; ++i) {
            this.isText = false;
            IfxObject ival = vector.elementAt(si + i);
            short type = (short)ival.getIfxType();
            if (type == 12) {
                this.isText = true;
            }
            if (!(ival.isNull() || type != 11 && type != 12)) {
                IfxBlob BlobObject = (IfxBlob)ival;
                if (type == 11 || this.isText && !this.convText) {
                    if (BlobObject.isBlobByteType()) {
                        this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                    } else {
                        this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                    }
                } else if (BlobObject.isBlobByteType()) {
                    this.convTextBlobBuffer(BlobObject);
                    this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                } else {
                    this.convTextBlobStream(BlobObject);
                    this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                }
            }
            this.isText = false;
        }
        this.isText = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBlob() exited");
        }
    }

    private void convTextBlobStream(IfxBlob blobObj) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: convTextBlobStream() called ");
        }
        InputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempBlobFile = null;
        String from = this.conn.getclEncoding();
        String to = this.conn.getdbEncoding();
        try {
            int len;
            if (blobObj.getBlobLength() <= this.conn.getCodesetLobSize()) {
                in = blobObj.getBlobInputStream();
                out = new ByteArrayOutputStream();
            } else {
                in = blobObj.getBlobInputStream();
                tempBlobFile = new IfxTmpFile(this.conn);
                out = tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            in.close();
            if (tempBlobFile == null) {
                IfxByteArrayInputStream fin = new IfxByteArrayInputStream((ByteArrayOutputStream)out);
                blobObj.fromInputStream((InputStream)fin, ((ByteArrayOutputStream)out).size());
            } else {
                out.close();
                IfxInputStream fin = tempBlobFile.getInputStream();
                int fileLength = tempBlobFile.length();
                blobObj.fromInputStream((InputStream)fin, fileLength);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: convTextBlobStream() exited ");
        }
    }

    private void convTextBlobBuffer(IfxBlob blobObj) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: convTextBlobBuffer() called ");
        }
        IfxByteArrayInputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempBlobFile = null;
        String from = this.conn.getclEncoding();
        String to = this.conn.getdbEncoding();
        try {
            int len;
            in = new IfxByteArrayInputStream(blobObj.getBlobBuffer());
            if (blobObj.getBlobLength() <= this.conn.getCodesetLobSize()) {
                out = new ByteArrayOutputStream();
            } else {
                tempBlobFile = new IfxTmpFile(this.conn);
                out = tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            ((InputStream)in).close();
            blobObj.blobBuffer = null;
            if (tempBlobFile == null) {
                blobObj.setBlobBuffer(((ByteArrayOutputStream)out).toByteArray());
            } else {
                out.close();
                IfxInputStream fin = tempBlobFile.getInputStream();
                int fileLength = tempBlobFile.length();
                byte[] buf = new byte[fileLength];
                fin.read(buf, 0, fileLength);
                blobObj.setBlobBuffer(buf);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: convTextBlobBuffer() exited ");
        }
    }

    private void sendBytesBlob(IfxDataOutputStream os, byte[] buffer) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBytesBlob() called");
        }
        int dataLength = buffer.length;
        int dataOffset = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 2");
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.trace.writeTrace(logger, 3, "  sendBytesBlob(): datalength = ", dataLength);
        }
        while (dataLength > 0) {
            try {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                }
                os.writeSmallInt((short)39);
                if (dataLength > 1024) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 3.0");
                        this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (short)1024);
                    }
                    os.writeSmallInt((short)1024);
                    os.writePadded(buffer, dataOffset, 1024);
                    dataLength -= 1024;
                    dataOffset += 1024;
                    continue;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 3.1");
                    this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", dataLength);
                }
                os.writeSmallInt((short)dataLength);
                os.writePadded(buffer, dataOffset, dataLength);
                dataLength = 0;
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 4");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
            }
            os.writeSmallInt((short)39);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", 0);
            }
            os.writeSmallInt((short)0);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendBytesBlob() exited");
        }
    }

    private void sendStreamBlob(IfxDataOutputStream os, InputStream fd, int length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 5");
            this.trace.writeTrace(logger, 1, "IfxSqli: sendStreamBlob() called");
        }
        int dataLength = length;
        byte[] buffer = new byte[1024];
        int readLength = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "    sendStreamBlob():length = ", length);
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
        }
        while (dataLength > 0) {
            try {
                if (dataLength > 1024) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 6");
                    }
                    if ((readLength = fd.read(buffer, 0, 1024)) <= 0) break;
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                    }
                    os.writeSmallInt((short)39);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", readLength);
                    }
                    os.writeSmallInt((short)readLength);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                        this.protoTrace.writeTrace(logger, 2, buffer, 'H');
                    }
                    os.writePadded(buffer, 0, readLength);
                    dataLength -= readLength;
                    continue;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 7");
                }
                readLength = fd.read(buffer, 0, dataLength);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "sendStreamBlob().readLength: ", readLength);
                }
                if (readLength <= 0) break;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                }
                os.writeSmallInt((short)39);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", readLength);
                }
                os.writeSmallInt((short)readLength);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                    this.protoTrace.writeTrace(logger, 2, buffer, 'H');
                }
                os.writePadded(buffer, 0, readLength);
                dataLength -= readLength;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        if (fd instanceof IfxInputStream) {
            try {
                os.flush();
                fd.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "sendStreamBlob().dataLength: ", dataLength);
        }
        if (dataLength == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 8");
            }
            try {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_BLOB");
                }
                os.writeSmallInt((short)39);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", 0);
                }
                os.writeSmallInt((short)0);
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 9");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_FERR");
            }
            os.writeSmallInt((short)40);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.receiveMessage();
        }
        catch (SQLException e) {
            if (this.TxStmt == 2) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxBlob: END_TX_STMT, return error");
                }
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 10");
            }
            throw IfxErrMsg.getSQLException(-79752, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendStreamBlob() exited");
        }
    }

    @Override
    public void executeFetchBlob(IfxObject blobDesc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFetchBlob() called");
        }
        int bufferSize = this.convText ? this.conn.getCodesetLobSize() : this.conn.getBlobCacheSize();
        this.BlobFd = null;
        this.BlobBuffer = null;
        this.BlobWriteFailure = 0;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 10");
        }
        IfxBlob blobInfo = (IfxBlob)blobDesc;
        int blobLength = blobInfo.getBlobLength();
        short type = (short)blobDesc.getIfxType();
        this.isText = type == 12;
        if (bufferSize < 0 || bufferSize > 0 && blobLength <= bufferSize) {
            try {
                this.BlobBuffer = memoryUtil.allocateMemory(blobLength, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79753, e.toString(), (IfxConnection)this.conn);
            }
            blobInfo.setBlobBuffer(this.BlobBuffer);
            blobInfo.setBlobFileName();
            this.BufferOrStream = 0;
        } else {
            blobInfo.tempBlobFile = new IfxTmpFile(this.conn);
            try {
                this.BlobFd = blobInfo.tempBlobFile.getOutputStream();
                this.BlobBuffer = null;
                this.BufferOrStream = 1;
            }
            catch (Exception e) {
                if (bufferSize == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.BlobBuffer = memoryUtil.allocateMemory(blobLength, this.conn);
                this.BlobFd = null;
                blobInfo.setBlobBuffer(this.BlobBuffer);
                blobInfo.setBlobFileName();
                this.BufferOrStream = 0;
            }
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendFetchBlob((IfxBlob)blobDesc);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            try {
                if (this.BlobFd != null) {
                    this.BlobFd.close();
                }
            }
            catch (IOException i) {
                this.isText = false;
            }
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            try {
                this.BlobFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isText = false;
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (this.BlobFd != null) {
            try {
                this.BlobFd.close();
            }
            catch (IOException e) {
                this.isText = false;
                throw this.handleSocketException(e, this.conn);
            }
        }
        if (this.BlobWriteFailure == 1) {
            this.isText = false;
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        if (this.isText && this.convText) {
            this.fetchCodesetConvertedTextBlob(blobInfo);
        }
        this.isText = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFetchBlob() exited");
        }
    }

    private void fetchCodesetConvertedTextBlob(IfxBlob blobInfo) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: fetchCodesetConvertedTextBlob() called");
        }
        InputStream in = null;
        OutputStream out = null;
        String from = this.conn.getdbEncoding();
        String to = this.conn.getclEncoding();
        try {
            int len;
            if (blobInfo.getBlobLength() <= this.conn.getCodesetLobSize()) {
                in = new IfxByteArrayInputStream(blobInfo.blobBuffer);
                out = new ByteArrayOutputStream();
            } else {
                IfxTmpFile infile = blobInfo.tempBlobFile;
                in = infile.getInputStream();
                blobInfo.tempBlobFile = new IfxTmpFile(this.conn);
                out = blobInfo.tempBlobFile.getOutputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            if (blobInfo.getBlobLength() > this.conn.getCodesetLobSize()) {
                out.close();
            } else {
                this.BlobBuffer = ((ByteArrayOutputStream)out).toByteArray();
                blobInfo.setBlobBuffer(this.BlobBuffer);
            }
            in.close();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: fetchCodesetConvertedTextBlob() called");
        }
    }

    private void sendFetchBlob(IfxBlob blobDesc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 11");
            this.trace.writeTrace(logger, 1, "IfxSqli: sendFetchBlob() called");
        }
        try {
            this.sendStatementID();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_FETCHBLOB");
            }
            this.os.writeSmallInt((short)38);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tDescriptor:");
                this.protoTrace.writeTrace(logger, 2, blobDesc.toIfx(), 'H');
            }
            this.os.writePadded(blobDesc.toIfx());
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendFetchBlob() exited");
        }
    }

    private void receiveText() throws SQLException {
        int strtab;
        short datalen;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxClob() : - 13");
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveText() called");
        }
        byte[] blobBuffer = null;
        try {
            datalen = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (int)datalen);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            blobBuffer = new byte[datalen];
            strtab = this.is.readPadded(blobBuffer);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                this.protoTrace.writeTrace(logger, 2, blobBuffer, 'H');
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 13");
            }
            try {
                this.blobDataWrite(blobBuffer, this.BlobWriteOffset, strtab);
                this.BlobWriteOffset += strtab;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
        }
        if (strtab < datalen) {
            int remaining = 0;
            while (strtab < datalen) {
                try {
                    blobBuffer = new byte[datalen - strtab];
                    remaining = this.is.readPadded(blobBuffer);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(blobBuffer, this.BlobWriteOffset, remaining);
                        this.BlobWriteOffset += remaining;
                    }
                    catch (Exception e) {
                        this.BlobWriteFailure = 1;
                    }
                }
                strtab += remaining;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveText() exited");
        }
    }

    private void receiveBlob() throws SQLException {
        int strtab;
        short datalen;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 12");
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveBlob() called");
        }
        byte[] blobBuffer = null;
        try {
            datalen = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (int)datalen);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            blobBuffer = new byte[datalen];
            strtab = this.is.readPadded(blobBuffer);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                this.protoTrace.writeTrace(logger, 2, blobBuffer, 'H');
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (this.BlobWriteFailure == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 13");
            }
            try {
                this.blobDataWrite(blobBuffer, this.BlobWriteOffset, strtab);
                this.BlobWriteOffset += strtab;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
        }
        if (strtab < datalen) {
            int remaining = 0;
            while (strtab < datalen) {
                try {
                    blobBuffer = new byte[datalen - strtab];
                    remaining = this.is.readPadded(blobBuffer);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (this.BlobWriteFailure == 0) {
                    try {
                        this.blobDataWrite(blobBuffer, this.BlobWriteOffset, remaining);
                        this.BlobWriteOffset += remaining;
                    }
                    catch (Exception e) {
                        this.BlobWriteFailure = 1;
                    }
                }
                strtab += remaining;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveBlob() exited");
        }
    }

    private int blobDataWrite(byte[] buffer, int BlobWriteOffset, int length) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: blobDataWrite() called");
        }
        if (this.BufferOrStream == 1) {
            try {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 14");
                }
                this.BlobFd.write(buffer, 0, length);
            }
            catch (Exception e) {
                return 1;
            }
        } else {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "IfxSqli.IfxBlob() : - 15");
            }
            if (length > 0) {
                System.arraycopy(buffer, 0, this.BlobBuffer, BlobWriteOffset, length);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: blobDataWrite() exited");
        }
        return 0;
    }

    public void executeScrollFetch(int scrolltype, int index, Statement stmt, int fetchBufferSize) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeScrollFetch() called");
        }
        ++this.numberOfFetches;
        this.resetTuples();
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            IfxResultSetMetaData fetchRsmd = null;
            if (stmt != null && stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                fetchRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
            }
            boolean isPrepStmt = stmt instanceof IfxPreparedStatement;
            if (fetchRsmd != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli: fetchRsmd is not null");
                }
                this.sendScrollFetch(scrolltype, index, fetchRsmd, fetchBufferSize, isPrepStmt);
            } else {
                this.sendScrollFetch(scrolltype, index, this.desc, fetchBufferSize, isPrepStmt);
            }
            ((IfxStatement)stmt).cursorOpen = true;
            this.receiveMessage();
        }
        catch (SQLException e) {
            ((IfxStatement)stmt).cursorOpen = false;
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        int i = this.tupleSizeReceived;
        this.conn.unlockSession();
        ((IfxStatement)stmt).currentResult.setTupleSizeReceived(i);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeScrollFetch() exited");
        }
    }

    private void sendScrollFetch(int scrolltype, int index, IfxResultSetMetaData desc, int fetchBufferSize, boolean isPreparedStatement) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendScrollFetch() called");
        }
        int sendBufferSize = 0;
        sendBufferSize = fetchBufferSize != 0 ? fetchBufferSize : (this.tupleBufferSize = this.getTupleBufferSize(-1));
        try {
            this.sendStatementID();
            if (desc.hasVariableLengthColumns) {
                this.sendType(desc, (short)1, isPreparedStatement);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SFETCH");
            }
            this.os.writeSmallInt((short)23);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tDirection: ", scrolltype);
            }
            this.os.writeSmallInt((short)scrolltype);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tOffset: ", index);
            }
            this.os.writeInt(index);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuple Buffer Size: ", sendBufferSize);
            }
            if (this.conn.isXPSVER8_40() || this.conn.is2GBFetchBufferSupported()) {
                this.os.writeInt(sendBufferSize);
            } else {
                this.os.writeSmallInt((short)sendBufferSize);
            }
            if (this.rowColumn == null || this.rowColumn.getInitialSize() < sendBufferSize) {
                this.rowColumn = new IfxRowColumn(this.conn, desc, sendBufferSize);
                this.rowColumn.setTrace(this.trace);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendScrollFetch() exited");
        }
    }

    @Override
    public int getTupid() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getTupid() entered");
            this.trace.writeTrace(logger, 1, "IfxSqli: Tupid is  " + this.Tupid);
        }
        return this.Tupid + this.curRow;
    }

    public InputStream toClobStream(IfxSmBlob obj) throws SQLException {
        InputStream fd = null;
        String from = this.conn.getdbEncoding();
        String to = this.conn.getclEncoding();
        InputStream in = null;
        OutputStream out = null;
        IfxTmpFile tempClobFile = null;
        try {
            int len;
            IfxLobInputStream lobStream = (IfxLobInputStream)obj.toAsciiStream();
            int size = (int)lobStream.lobSize;
            int codesetSize = this.conn.getCodesetLobSize();
            byte[] BlobBuffer = null;
            if (size <= codesetSize) {
                try {
                    BlobBuffer = memoryUtil.allocateMemory((int)lobStream.lobSize, this.conn);
                    lobStream.read(BlobBuffer);
                    in = new ByteArrayInputStream(BlobBuffer);
                    out = new ByteArrayOutputStream();
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79753, e.toString(), (IfxConnection)this.conn);
                }
            }
            try {
                in = lobStream.getStream();
                tempClobFile = new IfxTmpFile(this.conn);
                out = tempClobFile.getOutputStream();
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, from));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, to));
            char[] buffer = new char[4096];
            while ((len = r.read(buffer)) != -1) {
                ((Writer)w).write(buffer, 0, len);
            }
            ((Reader)r).close();
            ((Writer)w).flush();
            ((Writer)w).close();
            in.close();
            if (size <= codesetSize) {
                fd = new IfxByteArrayInputStream((ByteArrayOutputStream)out);
            } else {
                out.close();
                fd = tempClobFile.getInputStream();
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        return fd;
    }

    @Override
    public Vector<IfxObject> executeFastPath(String signature, Vector<IfxObject> inParams, boolean request_fparam) throws SQLException {
        this.executeFastPath(signature, null, inParams, false, request_fparam);
        return this.fpRet;
    }

    @Override
    public void executeFastPath(String signature, Vector<IfxObject> inParams, boolean hasOutParameter, boolean request_fparam) throws SQLException {
        this.executeFastPath(signature, null, inParams, hasOutParameter, request_fparam);
    }

    public void executeFastPath(String signature, ResultSetMetaData pmd, Vector<IfxObject> inParams, boolean hasOutParameter, boolean request_fparam) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli.executeFastPath() called");
            this.trace.writeTrace(logger, 2, "    sign: " + signature);
            this.trace.writeTrace(logger, 2, "    hasOutParameter: " + hasOutParameter);
            this.trace.writeTrace(logger, 2, "    request_fparam: " + request_fparam);
        }
        if (this.fpRet != null) {
            this.fpRet.removeAllElements();
            this.fpRet = null;
        }
        if (this.fpInput != null) {
            this.fpInput.removeAllElements();
            this.fpInput = null;
        }
        if (signature == null || !this.conn.isUSVER()) {
            return;
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        if (!this.conn.autoCommit) {
            try {
                this.initiateTransaction();
            }
            catch (SQLException e) {
                this.conn.unlockSession();
                throw e;
            }
        }
        short xcNewLevelSave = this.xcNewLevel;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "  eFP() xcNewLevelSave: " + xcNewLevelSave);
        }
        try {
            this.getHandle(signature, request_fparam, hasOutParameter);
            this.checkFastPathExp(inParams, pmd);
            this.sendFastPath(this.fpHandle, pmd, inParams, request_fparam);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
                this.executeCommit();
                this.doneCommit = true;
            }
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "  exFP() conn.SendCommit: " + this.conn.SendCommit);
            this.trace.writeTrace(logger, 3, "  exFP() xcNewLevel: " + this.xcNewLevel);
        }
        if (this.conn.isCommitNeeded() && xcNewLevelSave < 1 && this.xcNewLevel == 1) {
            this.executeCommit();
            this.doneCommit = true;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFastPath() exited");
        }
    }

    @Override
    public Vector<IfxObject> getFPReturnVector() {
        return this.fpRet;
    }

    private void getHandle(String signature, boolean request_fparam, boolean hasOutParameter) throws SQLException {
        this.fpHandle = this.conn.getFPCacheRoutineId(signature);
        if (this.fpHandle != -1) {
            this.fparam = request_fparam ? this.conn.getFPCacheFParam(signature) : null;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "\tSQ_GETROUTINE (cached locally)");
                this.trace.writeTrace(logger, 2, "\t\tHandle (CACHED): ", this.fpHandle);
            }
        } else {
            try {
                this.partialFParam = false;
                if (request_fparam) {
                    this.fparam = new IfxFParam();
                    this.fparam.hasOutParameter = hasOutParameter;
                }
                if (this.conn.isNamedParametersSupported()) {
                    byte[] dbBytes = null;
                    int handleIx = signature.indexOf(94);
                    dbBytes = handleIx > 0 ? this.getJavaToIfxCharBytes(signature.substring(0, handleIx)) : this.getJavaToIfxCharBytes(signature);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "");
                        this.protoTrace.writeTrace(logger, 1, "C->S");
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_GETROUTINE");
                    }
                    this.os.writeSmallInt((short)101);
                    if (handleIx > 0) {
                        this.os.writeByte(1);
                        this.os.writeChar(dbBytes);
                        int handle = Integer.parseInt(signature.substring(handleIx + 1));
                        this.os.writeInt(handle);
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\tisRoutineById:  1");
                            this.protoTrace.writeTrace(logger, 2, "\tDbName: " + signature.substring(0, handleIx));
                            this.routineDbName = signature.substring(0, handleIx);
                            this.protoTrace.writeTrace(logger, 2, "\thandle id: " + handle);
                        }
                    } else {
                        this.os.writeByte(0);
                        this.os.writeChar(dbBytes);
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\tisRoutineById:  0");
                            this.protoTrace.writeTrace(logger, 2, "\t\tSignature: ", signature);
                        }
                    }
                } else {
                    byte[] dbBytes = this.getJavaToIfxCharBytes(signature);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "");
                        this.protoTrace.writeTrace(logger, 1, "C->S");
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_GETROUTINE");
                    }
                    this.os.writeSmallInt((short)101);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tSignature: ", signature);
                    }
                    this.os.writeChar(dbBytes);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\tfparam: " + request_fparam);
                }
                if (request_fparam) {
                    this.os.writeSmallInt((short)1);
                } else {
                    this.os.writeSmallInt((short)0);
                }
                this.receiveMessage();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw this.handleSocketException(e, this.conn);
            }
            this.conn.setFPCacheInfo(this.fpHandle, signature, this.fparam);
        }
    }

    private void sendFastPath(int handle, ResultSetMetaData pmd, Vector<IfxObject> inParams, boolean request_fparam) throws SQLException {
        int paramCount = this.conn.isNamedParametersSupported() && pmd != null ? pmd.getColumnCount() : (inParams != null ? inParams.size() : 0);
        if (inParams != null) {
            this.fpInput = (Vector)inParams.clone();
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_EXFPROUTINE");
            }
            this.os.writeSmallInt((short)102);
            if (this.conn.isNamedParametersSupported()) {
                if (this.routineDbName != null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\tDbName: ", this.routineDbName);
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(this.routineDbName));
                } else {
                    this.os.writeChar(this.os.getJavaToIfxChar(""));
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFastPath Handle: ", handle);
            }
            this.os.writeInt(handle);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tParam Count: ", paramCount);
            }
            this.os.writeSmallInt((short)paramCount);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tfparam: " + request_fparam);
            }
            if (request_fparam) {
                this.os.writeSmallInt((short)1);
            } else {
                this.os.writeSmallInt((short)0);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (paramCount != 0) {
            this.sendBind(inParams, pmd, paramCount, 0, paramCount);
        }
        if (request_fparam) {
            this.sendFParam();
        }
    }

    private void receiveFastPath() throws SQLException {
        this.fpRet = new Vector();
        try {
            short numParams = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tReturn Count: ", numParams);
            }
            if (this.fparam != null && this.fparam.colInfoArray.length < numParams) {
                throw IfxErrMsg.getSQLException(-79716, "receiveFastPath colInfoArray too small", (IfxConnection)this.conn);
            }
            for (short count = 0; count < numParams; count = (short)(count + 1)) {
                short prec;
                IfxColumnInfo colInfo = new IfxColumnInfo();
                if (this.fparam != null) {
                    this.fparam.colInfoArray[count] = colInfo;
                }
                int type = this.is.readSmallInt();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\n");
                    this.protoTrace.writeTrace(logger, 2, "\t\t    Return value #: " + (count + 1));
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tType: ", type);
                }
                if ((type & 0x800) > 0) {
                    colInfo.IsDistinct = true;
                }
                colInfo.SQLtype = type &= 0xFF;
                if (type >= 18 && type != 52 && type != 53 || colInfo.IsDistinct) {
                    colInfo.ExtendedOwner = new String(this.is.readChar());
                    colInfo.ExtendedName = new String(this.is.readChar());
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tOwner: ", colInfo.ExtendedOwner);
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tExtended: ", colInfo.ExtendedName);
                    }
                }
                type = this.cleanUpFPTypeInfo(count, type, colInfo);
                colInfo.Nullable = 1;
                short ind = this.is.readSmallInt();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tIndicator: ", ind);
                }
                if ((prec = this.is.readSmallInt()) != 0 && colInfo.ColLength == 0) {
                    colInfo.ColLength = prec;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tPrecision: ", prec);
                }
                IfxObject obj = IfxValue.makeInstance(this.conn, colInfo);
                obj.setConnection(this.conn);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "receiveFastPath() IfxObject instantiated: " + obj.getClass().getName());
                }
                if (ind == -1) {
                    obj.nullify();
                    this.fpRet.addElement(obj);
                    continue;
                }
                switch (type) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        obj.fromString(this.is.readChar(this.dbEncoding));
                        break;
                    }
                    case 2: 
                    case 6: {
                        obj.fromInt(this.is.readInt());
                        break;
                    }
                    case 7: {
                        obj.fromDate(this.is.readDate());
                        break;
                    }
                    case 1: {
                        obj.fromShort(this.is.readSmallInt());
                        break;
                    }
                    case 17: 
                    case 18: {
                        obj.fromLong(this.is.readLongInt());
                        break;
                    }
                    case 4: {
                        obj.fromFloat(this.is.readReal(prec));
                        break;
                    }
                    case 3: {
                        obj.fromDouble(this.is.readDouble(prec));
                        break;
                    }
                    case 5: 
                    case 8: {
                        obj.fromDecimal(this.is.readDecimal(prec));
                        break;
                    }
                    case 14: {
                        byte startCode = Interval.getStartCode(prec);
                        if (startCode == 0 || startCode == 2) {
                            obj.fromIntervalYM((IntervalYM)this.is.readInterval(prec));
                            break;
                        }
                        obj.fromIntervalDF((IntervalDF)this.is.readInterval(prec));
                        break;
                    }
                    case 10: {
                        if (IfxDateTime.getStartCode(prec) >= 6 && IfxDateTime.getEndCode(prec) <= 10) {
                            obj.fromTimestamp(this.is.readDateTime(prec));
                            Time tm = obj.toTime();
                            obj.fromTime(tm);
                            break;
                        }
                        ((IfxDateTime)obj).fromIfx(this.is.readRawDateTime(prec), prec);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 44: {
                        int datalen = this.is.readInt();
                        if (datalen <= 0) break;
                        int udtOffSet = 5;
                        byte[] b = new byte[datalen + udtOffSet];
                        b[0] = 0;
                        byte[] bInt = JavaToIfxType.JavaToIfxInt(datalen);
                        System.arraycopy(bInt, 0, b, 1, 4);
                        this.is.readPadded(b, udtOffSet, datalen);
                        if (colInfo.ExtendedId == 11 || colInfo.ExtendedId == 10) {
                            ((IfxSmBlob)obj).fromIfxFP(b);
                            break;
                        }
                        obj.fromIfx(b);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        int datalen = this.is.readShort();
                        datalen = this.is.readInt();
                        if (datalen <= 0) break;
                        byte[] b = new byte[datalen + 4];
                        byte[] bInt = JavaToIfxType.JavaToIfxInt(datalen);
                        System.arraycopy(bInt, 0, b, 0, 4);
                        this.is.read(b, 4, datalen);
                        obj.fromIfx(b);
                        break;
                    }
                    case 11: 
                    case 12: {
                        byte[] descriptor = new byte[56];
                        for (int i = 0; i < 56; ++i) {
                            descriptor[i] = this.is.readByte();
                        }
                        obj.fromIfx(descriptor);
                        break;
                    }
                    case 52: 
                    case 53: {
                        obj.fromLong(this.is.readLongBigint());
                        break;
                    }
                    default: {
                        if (!TraceFlag.isTraceEnabled()) break;
                        this.protoTrace.writeTrace(logger, 2, " *** Unsupported data found: " + type);
                    }
                }
                if (TraceFlag.isTraceEnabled() && (type <= 18 || colInfo.ExtendedId == 1 || colInfo.ExtendedId == 5) && type != 12 && type != 11) {
                    String s = obj.toString();
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ", s);
                    this.protoTrace.writeTrace(logger, 2, "");
                }
                this.fpRet.addElement(obj);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private int cleanUpFPTypeInfo(int count, int type, IfxColumnInfo colInfo) {
        boolean thisIsOutParam = false;
        int argIndex = -1;
        int retIndex = -1;
        if (this.fparam != null) {
            if (count < this.fparam.numberOfOutParams) {
                thisIsOutParam = true;
                argIndex = this.fparam.outParamSequence[count];
            } else {
                retIndex = count - this.fparam.numberOfOutParams;
            }
        }
        if (type == 45) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 5;
        } else if (type == 43) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 1;
        } else if (type == 102) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 10;
        } else if (type == 101) {
            type = 44;
            colInfo.SQLtype = 44;
            colInfo.ExtendedId = 11;
        } else if (this.fparam != null) {
            colInfo.ExtendedId = thisIsOutParam ? this.fparam.argType[argIndex].xid : this.fparam.retType[retIndex].xid;
        }
        if (thisIsOutParam) {
            IfxObject obj = this.fpInput.elementAt(argIndex);
            String name = obj.getExtendedTypeName();
            if (name != null && name.trim().length() != 0) {
                colInfo.ExtendedName = name;
            }
            if (type == 40 || type == 41) {
                if (obj instanceof IfxRow) {
                    type = 22;
                    colInfo.SQLtype = 22;
                } else if (obj instanceof IfxCollection) {
                    type = 20;
                    colInfo.SQLtype = 20;
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 2, "\t\t\t *** New type: ", colInfo.SQLtype);
            this.protoTrace.writeTrace(logger, 2, "\t\t\t *** New xid: ", colInfo.ExtendedId);
            this.protoTrace.writeTrace(logger, 2, "\t\t\t *** New xid name: ", colInfo.ExtendedName);
        }
        return type;
    }

    private void receiveHandle() throws SQLException {
        try {
            if (this.conn.isNamedParametersSupported()) {
                this.routineDbName = this.is.readChar();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tDbName: ", this.routineDbName);
                }
            }
            this.fpHandle = this.is.readInt();
            if (this.idesc != null) {
                this.idesc.routineDbName = this.routineDbName;
                this.idesc.fpHandle = this.fpHandle;
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\t Handle: ", this.fpHandle);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveFParam() throws SQLException {
        this.totalOutValues = 0;
        this.totalOutParams = 0;
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.receiveFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            byte b;
            this.fparam.funcState = this.is.readLong();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFuncState: ", Long.toHexString(this.fparam.funcState));
            }
            this.fparam.request = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tRequest: ", this.fparam.request);
            }
            this.fparam.isDone = (b = this.is.readByte()) != 0;
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tisDone: ", this.fparam.isDone);
            }
            if (this.partialFParam) {
                return;
            }
            this.fparam.id = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tid: ", this.fparam.id);
            }
            this.fparam.row = this.is.readLong();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\trow: ", this.fparam.row);
            }
            this.fparam.colid = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tcolid: ", this.fparam.colid);
            }
            this.fparam.nrets = this.is.readShort();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tNumber of return values: ", this.fparam.nrets);
            }
            if (this.fparam.nrets > 0) {
                this.fparam.retNull = new boolean[this.fparam.nrets];
                this.fparam.retType = new IfxFParam.FPTypeInfo[this.fparam.nrets];
                this.readFPTypeInfo(false, this.fparam.nrets, this.fparam.retNull, this.fparam.retType, "Return", this.fparam.outParamSequence);
                this.totalOutValues = this.fparam.nrets;
            }
            this.fparam.nargs = this.is.readShort();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\n\t\tNumber of parameters: ", this.fparam.nargs);
            }
            boolean hasParameterNames = false;
            boolean isUDRUnique = false;
            if (this.conn.isNamedParametersSupported()) {
                short namedFlags = this.is.readSmallInt();
                hasParameterNames = (namedFlags & 1) != 0;
                boolean bl = isUDRUnique = (namedFlags & 2) != 0;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tnamed Flags: ", (int)namedFlags);
                }
            }
            if (this.fparam.nargs > 0) {
                this.fparam.argNull = new boolean[this.fparam.nargs];
                this.fparam.argType = new IfxFParam.FPTypeInfo[this.fparam.nargs];
                this.fparam.outParamSequence = new int[this.fparam.nargs];
                this.readFPTypeInfo(hasParameterNames, this.fparam.nargs, this.fparam.argNull, this.fparam.argType, "Parameter", this.fparam.outParamSequence);
            }
            if (this.fparam.hasOutParameter && !this.conn.isMultipleUdrOutSupported()) {
                ++this.totalOutValues;
                this.totalOutParams = 1;
                this.fparam.outParamSequence[0] = this.fparam.nargs - 1;
            }
            this.fparam.numberOfOutParams = this.totalOutParams;
            this.fparam.colInfoArray = new IfxColumnInfo[this.totalOutValues];
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.partialFParam = true;
    }

    private void readFPTypeInfo(boolean hasParameterNames, int count, boolean[] argNull, IfxFParam.FPTypeInfo[] typeInfo, String header, int[] outParamSequence) throws SQLException {
        try {
            for (int i = 0; i < count; ++i) {
                byte b;
                typeInfo[i] = new IfxFParam.FPTypeInfo();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t    " + header + " Type #: " + (i + 1));
                }
                if (hasParameterNames) {
                    byte argFlags = this.is.readByte();
                    String argName = this.is.readChar();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\targument flags: ", argFlags);
                        this.protoTrace.writeTrace(logger, 2, "\t\t\targument Name: ", argName);
                    }
                }
                argNull[i] = (b = this.is.readByte()) != 0;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\targNull: ", argNull[i]);
                }
                typeInfo[i].type = this.is.readShort();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\ttype: ", typeInfo[i].type);
                }
                typeInfo[i].xid = this.is.readInt();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\txid: ", typeInfo[i].xid);
                }
                if (!this.conn.is902()) continue;
                typeInfo[i].len = this.is.readInt();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tlength: ", typeInfo[i].len);
                }
                typeInfo[i].precision = this.is.readShort();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tprecision: ", typeInfo[i].precision);
                }
                typeInfo[i].scale = this.is.readShort();
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t\tscale: ", typeInfo[i].scale);
                }
                if (!this.conn.isMultipleUdrOutSupported() || header != "Parameter") continue;
                typeInfo[i].mode = this.is.readShort();
                if (typeInfo[i].mode == 1) {
                    ++this.totalOutValues;
                    ++this.totalOutParams;
                    outParamSequence[this.totalOutParams - 1] = i;
                }
                if (!TraceFlag.isTraceEnabled()) continue;
                this.protoTrace.writeTrace(logger, 2, "\t\t\tmode: ", typeInfo[i].mode);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendFParam() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendFParam() called");
        }
        if (this.fparam == null) {
            throw IfxErrMsg.getSQLException(-79716, "IfxSqli.sendFParam() fparam is null", (IfxConnection)this.conn);
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_FPARAM");
            }
            this.os.writeSmallInt((short)104);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\tfuncState: " + Long.toHexString(this.fparam.funcState));
            }
            this.os.writeLong(this.fparam.funcState);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\trequest: " + this.fparam.request);
            }
            this.os.writeInt(this.fparam.request);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tisDone: ", this.fparam.isDone);
            }
            if (this.fparam.isDone) {
                this.os.writeByte(0);
            } else {
                this.os.writeByte(1);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public IfxFParam getFParam() {
        return this.fparam;
    }

    @Override
    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes) throws SQLException {
        this.BlobBuffer = buffer;
        this.BlobRequestSize = nbytes;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)0, lofd, nbytes, 0);
    }

    @Override
    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes, int offset) throws SQLException {
        this.BlobBuffer = buffer;
        this.BlobRequestSize = nbytes;
        this.BlobFd = null;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 0;
        this.BlobWriteFailure = 0;
        this.amountRW = 0;
        return this.doLoData((short)1, lofd, nbytes, offset);
    }

    @Override
    public int executeReadSmBlob(int lofd, FileOutputStream fileFd, int nbytes) throws SQLException {
        this.BlobBuffer = null;
        this.BlobRequestSize = nbytes;
        this.BlobFd = fileFd;
        this.BlobWriteOffset = 0;
        this.BufferOrStream = 1;
        this.amountRW = 0;
        return this.doLoData((short)0, lofd, nbytes, 0);
    }

    private int doLoData(short subCom, int loFd, int dataLength, int off) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: doLoData() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData(subCom, loFd, dataLength, off);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: doLoData() exited");
        }
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int loFd, byte[] buffer) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmartBlob(int loFd, byte[] buffer) called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmBlob(,) exited");
        }
        return this.executeWriteSmBlob(loFd, buffer, 0, buffer == null ? 0 : buffer.length);
    }

    @Override
    public int executeWriteSmBlob(int loFd, byte[] buffer, int offset, int length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmartBlob(int loFd, byte[] buffer,int offset, int length) called");
        }
        int dataLength = length;
        int dataOffset = offset;
        int size = 0;
        this.amountRW = 0;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, loFd, dataLength, 0);
            while (dataLength > 0) {
                try {
                    size = dataLength < 32000 ? dataLength : 32000;
                    this.os.writeSmallInt((short)size);
                    this.os.writePadded(buffer, dataOffset, size);
                    dataLength -= size;
                    dataOffset += size;
                }
                catch (Exception e) {
                    SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
                    sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                    throw sqlException;
                }
            }
            this.os.flush();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmBlob(,,,) exited");
        }
        return this.amountRW;
    }

    @Override
    public int executeWriteSmBlob(int loFd, InputStream fin, int length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmBlob(int loFd, InputStream fd, int length) called");
        }
        InputStream fd = fin instanceof IfxLobInputStream ? ((IfxLobInputStream)fin).getStream() : fin;
        int dataLength = length;
        int size = 0;
        this.amountRW = 0;
        int readLength = 0;
        byte[] buffer = new byte[32000];
        boolean readFault = false;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendLoData((short)2, loFd, dataLength, 0);
            while (dataLength > 0) {
                try {
                    size = dataLength < 32000 ? dataLength : 32000;
                    readLength = fd.read(buffer, 0, size);
                    if (readLength <= 0) {
                        readFault = true;
                        readLength = size;
                    }
                    this.os.writeSmallInt((short)readLength);
                    this.os.writePadded(buffer, 0, readLength);
                    dataLength -= readLength;
                }
                catch (Exception e) {
                    readFault = true;
                }
            }
            this.receiveMessage();
            if (readFault) {
                throw IfxErrMsg.getSQLException(-79752, this.conn);
            }
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli:executeWriteSmBlob() exited");
        }
        return this.amountRW;
    }

    private void sendLoData(short subCom, int loFd, int length, int off) throws SQLException {
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_LODATA");
            }
            this.os.writeSmallInt((short)97);
            if (TraceFlag.isTraceEnabled()) {
                if (subCom == 0) {
                    this.protoTrace.writeTrace(logger, 2, "\tLO_READ");
                } else if (subCom == 1) {
                    this.protoTrace.writeTrace(logger, 2, "\tLO_READWITHSEEK");
                } else if (subCom == 2) {
                    this.protoTrace.writeTrace(logger, 2, "\tLO_WRITE");
                }
            }
            this.os.writeSmallInt(subCom);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tLO_FD: ", loFd);
            }
            this.os.writeSmallInt((short)loFd);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tNo. of Bytes: ", length);
            }
            this.os.writeInt(length);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\tR_W_BUFSIZE: ", (short)32000);
            }
            this.os.writeSmallInt((short)32000);
            if (subCom == 1) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\toffset: ", off);
                }
                this.os.writeLongInt(off);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\twhence:  IfxSmartBlob.LO_SEEK_CUR");
                }
                this.os.writeSmallInt((short)1);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveLODATA() throws SQLException {
        short optype = 0;
        int fileSize = 0;
        try {
            optype = this.is.readSmallInt();
            fileSize = this.is.readInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tOpType : ", optype);
                this.protoTrace.writeTrace(logger, 1, "\tTotal Size : ", fileSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (optype == 2) {
            if (fileSize < 0) {
                this.isamcode = fileSize;
                this.amountRW = -1;
                this.setSQLerrd((short)1, this.isamcode);
                this.addException(IfxErrMsg.getSQLException(-9810, this.conn));
                this.addException(this.isamcode, null);
            } else {
                this.amountRW = fileSize;
            }
            return;
        }
        if (fileSize < 1) {
            try {
                short s = this.is.readSmallInt();
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            this.amountRW = 0;
            return;
        }
        byte[] readBuffer = null;
        if (this.BlobRequestSize > fileSize) {
            this.BlobRequestSize = fileSize;
        }
        short size = 0;
        while (this.BlobRequestSize > 0) {
            try {
                size = this.is.readSmallInt();
                if (size < 0) {
                    this.amountRW = -1;
                    return;
                }
                readBuffer = new byte[size];
                int n = this.is.readPadded(readBuffer);
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
            if (this.BlobWriteFailure != 0) continue;
            try {
                this.blobDataWrite(readBuffer, this.BlobWriteOffset, size);
                this.BlobWriteOffset += size;
            }
            catch (Exception e) {
                this.BlobWriteFailure = 1;
            }
            this.amountRW += size;
            this.BlobRequestSize -= size;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "\tNo. of Bytes Read : ", this.amountRW);
        }
    }

    private void receiveSQFILE() throws SQLException {
        short optype = -1;
        byte[] buf = null;
        int bufSize = -1;
        long readAmount = 0L;
        int message = -1;
        int err = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSQFILE() called");
        }
        try {
            optype = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\tOpType : ", optype);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        switch (optype) {
            case 0: {
                try {
                    short length = this.is.readSmallInt();
                    byte[] b = new byte[length];
                    this.is.readPadded(b);
                    this.copyToFileName = stringUtil.getString(b, this.dbEncoding);
                    this.copyToFileMode = this.is.readInt();
                    this.copyToFileFlags = this.is.readInt();
                    this.copyToFileOffset = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\tFile Name : ", this.copyToFileName);
                    this.protoTrace.writeTrace(logger, 1, "\t\tMode ", this.copyToFileMode);
                    this.protoTrace.writeTrace(logger, 1, "\t\tFlags ", this.copyToFileFlags);
                    this.protoTrace.writeTrace(logger, 1, "\t\tOffset ", this.copyToFileOffset);
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                try {
                    this.copyToFileFd = new File(this.copyToFileName);
                }
                catch (NullPointerException e) {
                    this.copyToFileFd = null;
                    this.sendSQFILEError(2);
                    break;
                }
                try {
                    if ((this.copyToFileFlags & 0x10) != 0) {
                        if (!this.copyToFileFd.exists()) {
                            this.copyToFileFd = null;
                            this.sendSQFILEError(2);
                            break;
                        }
                        this.copyToFileFd.setReadOnly();
                    }
                    if ((this.copyToFileFlags & 1) == 0 || !this.copyToFileFd.exists()) break;
                    this.copyToFileFd = null;
                    this.sendSQFILEError(17);
                    break;
                }
                catch (SecurityException e) {
                    throw this.handleSocketException(e, this.conn);
                }
            }
            case 2: {
                long totalSize;
                message = 0;
                long nbytes = 0L;
                try {
                    bufSize = this.is.readSmallInt();
                    readAmount = this.is.readInt();
                    message = this.is.readSmallInt();
                }
                catch (Exception e) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\tChunk Size ", bufSize);
                    this.protoTrace.writeTrace(logger, 1, "\t\tAmount to Read ", readAmount);
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "r");
                    totalSize = this.loFile.length();
                }
                catch (IOException e) {
                    this.sendSQFILEError(9);
                    break;
                }
                if ((long)this.copyToFileOffset > totalSize) {
                    this.sendSQFILEError(9);
                    break;
                }
                try {
                    buf = new byte[bufSize];
                }
                catch (Exception e) {
                    this.sendSQFILEError(-406);
                    break;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "C->S");
                }
                try {
                    this.os.writeSmallInt((short)106);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_FILE_READ");
                }
                readAmount = readAmount == -1L ? totalSize - (long)this.copyToFileOffset : (totalSize - (long)this.copyToFileOffset < readAmount ? totalSize - (long)this.copyToFileOffset : readAmount);
                try {
                    this.os.writeInt((int)readAmount);
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tAmount", readAmount);
                }
                try {
                    this.loFile.seek(this.copyToFileOffset);
                }
                catch (IOException e) {
                    this.sendSQFILEError(29);
                    break;
                }
                int size = 0;
                try {
                    while (readAmount > 0L) {
                        nbytes = (long)bufSize < readAmount ? (long)bufSize : readAmount;
                        try {
                            size = this.loFile.read(buf, 0, (int)nbytes);
                        }
                        catch (Exception io) {
                            break;
                        }
                        this.os.writeSmallInt((short)106);
                        this.os.writeSmallInt((short)size);
                        this.os.writePadded(buf, 0, size);
                        readAmount -= (long)size;
                    }
                }
                catch (Exception e) {
                    throw this.handleSocketException(e, this.conn);
                }
                if (readAmount <= 0L) break;
                this.sendSQFILEError(5);
                break;
            }
            case 3: {
                if (this.copyToFileFd == null) {
                    this.sendSQFILEError(9);
                    break;
                }
                err = 0;
                try {
                    this.loFile = new RandomAccessFile(this.copyToFileFd, "rw");
                    if ((this.copyToFileFlags & 2) != 0) {
                        if (this.copyToFileOffset != 0) {
                            this.loFile.seek(this.copyToFileOffset);
                        } else {
                            this.loFile.seek(this.loFile.length());
                        }
                    }
                }
                catch (Exception e) {
                    this.sendSQFILEError(13);
                    break;
                }
                try {
                    while (true) {
                        short s = this.is.readSmallInt();
                        message = s;
                        if (s == 107) {
                            bufSize = this.is.readSmallInt();
                            byte[] buffer = new byte[bufSize];
                            this.is.readPadded(buffer);
                            if ((this.copyToFileFlags & 0x80) != 0) {
                                this.loFile.writeChars(new String(buffer));
                                continue;
                            }
                            this.loFile.write(buffer, 0, bufSize);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    err = 2;
                    break;
                }
                try {
                    if (message == 13) {
                        err = this.is.readSmallInt();
                    }
                    if (err != 0) {
                        this.sendSQFILEError(err);
                        break;
                    }
                    long TotalSize = this.loFile.length();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_FILE_WRITE");
                        this.protoTrace.writeTrace(logger, 1, "\t\tTotal Size:" + TotalSize);
                    }
                    this.os.writeSmallInt((short)107);
                    this.os.writeInt((int)TotalSize);
                    break;
                }
                catch (IOException e) {
                    throw this.handleSocketException(e, this.conn);
                }
            }
            case 1: {
                try {
                    message = this.is.readSmallInt();
                }
                catch (IOException e) {
                    message = 0;
                }
                if (message != 12) {
                    this.sendSQFILEError(-408);
                    break;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
                try {
                    if (this.copyToFileFd == null || this.loFile == null) break;
                    this.loFile.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
        }
        this.flip();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSQFILE() exit");
        }
    }

    @Override
    public void executeProtocols(byte[] protocols) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeProtocols() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendProtocols(protocols);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeProtocols() exited");
        }
    }

    private void sendProtocols(byte[] protocols) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendProtocols() called");
        }
        if (protocols == null || protocols.length == 0) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_PROTOCOLS");
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: " + protocols.length);
                this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                this.protoTrace.writeTrace(logger, 2, protocols, 'H');
            }
            this.os.writeSmallInt((short)126);
            this.os.writeSmallInt((short)protocols.length);
            this.os.writePadded(protocols);
            this.os.flush();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendProtocols() exited");
        }
    }

    private void receiveProtocols() throws SQLException {
        short datalen;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveProtocols() called");
        }
        try {
            datalen = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tSize: ", (int)datalen);
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        try {
            this.serverProtocol = new byte[datalen];
            int strtab = this.is.readPadded(this.serverProtocol);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tData:");
                this.protoTrace.writeTrace(logger, 2, this.serverProtocol, 'H');
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveProtocols() exited");
        }
    }

    @Override
    public byte[] getProtocols() {
        return this.serverProtocol;
    }

    private void sendSQFILEError(int error) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_ERR");
            this.protoTrace.writeTrace(logger, 1, "\tSQL error : " + error);
            this.protoTrace.writeTrace(logger, 1, "\tISAM/RSAM error : 0");
            this.protoTrace.writeTrace(logger, 1, "\tOffset  : 0");
            this.protoTrace.writeTrace(logger, 1, "\tError message  : 0");
        }
        try {
            this.os.writeSmallInt((short)13);
            this.os.writeSmallInt((short)error);
            this.os.writeSmallInt((short)0);
            this.os.writeSmallInt((short)0);
            if (this.conn.isRemove64KLimitSupported()) {
                this.os.writeSmallInt((short)0);
            }
            this.os.writeSmallInt((short)0);
        }
        catch (IOException e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void sendPut(IfxPreparedStatement pstmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendPut() called");
        }
        IfxResultSetMetaData putRsmd = (IfxResultSetMetaData)pstmt.getOutPutMetaData();
        if (pstmt.executeBatchInProgress) {
            this.executeBatchInProgress = true;
        }
        try {
            if (!pstmt.cursorOpen) {
                this.sendQuery(pstmt, false, false, null);
            } else {
                this.sendStatementID();
            }
            if (!putRsmd.hasVariableLengthColumns && putRsmd.textByteColumnCount <= 0) {
                byte[] rowArray = null;
                byte[] bData = pstmt.getAllRows();
                while ((rowArray = pstmt.getNextRowBatch(bData)) != null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tFixed Row Size:");
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_PUT");
                    }
                    this.os.writeSmallInt((short)17);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\tTupleSize: ", this.desc.getTupleSize());
                    }
                    if (!this.conn.isUSVER()) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, "os.writeSmallInt(tupleSize)");
                        }
                        this.os.writeSmallInt(this.desc.getTupleSize());
                    } else {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, "os.writeInt(tupleSize)");
                        }
                        this.os.writeInt(this.getTupleSize());
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tCount: ", pstmt.getNumRowsCurrBatch());
                    }
                    if (this.conn.isXPSVER8_40()) {
                        this.os.writeInt(pstmt.getNumRowsCurrBatch());
                    } else {
                        this.os.writeSmallInt((short)pstmt.getNumRowsCurrBatch());
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ");
                        this.protoTrace.writeTrace(logger, 2, rowArray, 0, 'B', rowArray.length);
                    }
                    this.os.write(rowArray);
                    if (!this.executeBatchInProgress) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                }
            } else {
                if (putRsmd.textByteColumnCount > 0 && TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tRow with Text/Bytes Columns");
                }
                if (putRsmd.hasVariableLengthColumns) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tvar-size rows");
                    }
                    this.sendType((IfxResultSetMetaData)pstmt.getOutPutMetaData(), (short)0, true);
                }
                for (int i = 0; i < pstmt.getBatchCount(); ++i) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_PUT");
                    }
                    this.os.writeSmallInt((short)17);
                    byte[] bData = pstmt.getNextRow();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\tTupleSize: ", bData.length);
                    }
                    if (!this.conn.isUSVER()) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, "os.writeSmallInt((short) bData.length)");
                        }
                        this.os.writeSmallInt((short)bData.length);
                    } else {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, "os.writeInt( bData.length)");
                        }
                        this.os.writeInt(bData.length);
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\tCount: ", 1);
                    }
                    if (this.conn.isXPSVER8_40()) {
                        this.os.writeInt(1);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tData: ");
                        this.protoTrace.writeTrace(logger, 2, bData, 0, 'B', bData.length);
                    }
                    this.os.writePadded(bData);
                    for (int j = i * putRsmd.textByteColumnCount; j < i * putRsmd.textByteColumnCount + putRsmd.textByteColumnCount; ++j) {
                        IfxBlob BlobObject;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 2, "i: " + i + " j: " + j + " textByteColumnCount: " + putRsmd.textByteColumnCount);
                            this.trace.writeTrace(logger, 2, "BlobArraySize: " + pstmt.getIfxBlobArraySize());
                        }
                        if ((BlobObject = pstmt.getIfxBlobAt(j)) == null) continue;
                        if (BlobObject.isBlobByteType()) {
                            this.sendBytesBlob(this.os, BlobObject.getBlobBuffer());
                            continue;
                        }
                        this.sendStreamBlob(this.os, BlobObject.getBlobInputStream(), BlobObject.getBlobLength());
                    }
                    if (((IfxResultSetMetaData)pstmt.getOutPutMetaData()).usingIMPEXP()) {
                        this.receiveMessage();
                    }
                    if (!this.executeBatchInProgress || this.os.getBytesSentSinceLastEOT() < (this.conn.isXPSVER8_40() ? Short.MAX_VALUE : this.conn.getMaxFetchBufSize())) continue;
                    this.receiveMessage();
                    this.sendStatementID();
                    if (!putRsmd.hasVariableLengthColumns) continue;
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tvar-size rows");
                    }
                    this.sendType((IfxResultSetMetaData)pstmt.getOutPutMetaData(), (short)0, true);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendPut() exited");
        }
    }

    String parseDbName(Statement stmt) {
        String token = null;
        String dbName = null;
        try {
            String sql = ((IfxStatement)stmt).commandString;
            StringTokenizer tok = new StringTokenizer(sql, " ");
            token = tok.nextToken();
            if (token.equalsIgnoreCase("CLOSE")) {
                if (token.equalsIgnoreCase("DATABASE")) {
                    dbName = null;
                }
            } else if (token.equalsIgnoreCase("DATABASE")) {
                dbName = tok.nextToken();
            } else if (token.equalsIgnoreCase("CREATE") && (token = tok.nextToken()).equalsIgnoreCase("DATABASE")) {
                String tok1 = tok.nextToken();
                if (tok1.equalsIgnoreCase("IF")) {
                    for (int i = 0; i < 3; ++i) {
                        tok1 = tok.nextToken();
                    }
                }
                dbName = tok1;
            }
        }
        catch (Exception e) {
            dbName = null;
        }
        if (dbName != null && dbName.endsWith(";")) {
            dbName = dbName.substring(0, dbName.length() - 1);
        }
        return dbName;
    }

    @Override
    public int incRefCount(byte[] locator) throws SQLException {
        return 0;
    }

    @Override
    public int decRefCount(byte[] locator) throws SQLException {
        return 0;
    }

    protected void setIsReleased(boolean val) {
        this.isReleased = val;
    }

    int getStatementID() {
        return this.statementID;
    }

    void initiateTransaction() throws SQLException {
        if (!this.conn.inXATransaction() && this.conn.db_use_log && !this.conn.AnsiDb && this.TxStmt != 1 && this.conn.TxState == 1) {
            this.sendBegin();
            this.receiveMessage();
            this.conn.setTxBeginState();
        }
        if (this.conn.AnsiDb && !this.conn.autoCommit && !this.conn.inXATransaction()) {
            this.conn.TxState = (short)2;
        }
    }

    @Override
    public IfxResultSetMetaData executeDescribeInput() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeDescribeInput() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCIDescribe();
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeDescribeInput() exited");
        }
        return this.idesc;
    }

    private void sendCIDescribe() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCIDescribe() called");
        }
        try {
            this.sendStatementID();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_CIDESCRIBE");
            }
            this.os.writeSmallInt((short)124);
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExecute() exited");
        }
    }

    private void receiveIDescribe() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveIDescribe() called");
        }
        this.recvIDescribe(false);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IDescribe packet received");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveIDescribe() exited");
        }
    }

    private void recvIDescribe(boolean isFastPath) throws SQLException {
        short nparameters = 0;
        int intVal = 0;
        try {
            nparameters = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# of parameters: ", (int)nparameters);
            }
            this.idesc = new IfxResultSetMetaData(nparameters, this.conn);
            boolean hasParameterNames = false;
            boolean isUDRUnique = false;
            int numberArguments = -1;
            if (this.conn.isNamedParametersSupported() && nparameters != 0) {
                short namedFlags = this.is.readSmallInt();
                hasParameterNames = (namedFlags & 1) != 0;
                boolean bl = isUDRUnique = (namedFlags & 2) != 0;
                if (!isFastPath && hasParameterNames) {
                    numberArguments = this.is.readSmallInt();
                }
                this.idesc.namedFlags = namedFlags;
                this.idesc.numArgsRoutine = numberArguments;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tnamed Flags: ", (int)namedFlags);
                    this.protoTrace.writeTrace(logger, 2, "\t\tnumberArguments: ", numberArguments);
                }
            }
            if (nparameters > 0) {
                for (short i = 1; i <= nparameters; i = (short)(i + 1)) {
                    if (hasParameterNames) {
                        byte argFlags = this.is.readByte();
                        String argName = this.is.readChar();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\targument flags: ", argFlags);
                            this.protoTrace.writeTrace(logger, 2, "\t\t\targument Name: ", argName);
                        }
                        this.idesc.setArgumentFlags(i, argFlags);
                        this.idesc.setArgumentName(i, argName);
                    }
                    short shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tParameter type: ", shortVal);
                    }
                    this.idesc.setIfxColumnType(i, shortVal);
                    intVal = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tParameter Extended Id: ", intVal);
                    }
                    this.idesc.setColumnExtendedId(i, intVal);
                    String stringData = new String(this.is.readChar());
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tOwner name: " + stringData);
                    }
                    this.idesc.setExtendedOwnerName(i, stringData);
                    stringData = new String(this.is.readChar());
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tExtended Type Name: " + stringData);
                    }
                    this.idesc.setExtendedName(i, stringData);
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tReference: ", shortVal);
                    }
                    this.idesc.setReference(i, shortVal);
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tAlignment: ", shortVal);
                    }
                    this.idesc.setAlignment(i, shortVal);
                    intVal = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tSource type: ", intVal);
                    }
                    this.idesc.setSourceType(i, intVal);
                    intVal = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", intVal);
                    }
                    this.idesc.setEncodedLength(i, intVal);
                    if (!isFastPath) continue;
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tParameter mode: ", intVal);
                    }
                    this.idesc.setMode(i, shortVal);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    private void receiveSGKDescribe() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSGKDescribe() called");
        }
        short nfields = 0;
        int intVal = 0;
        String strtab = null;
        int[] fieldIndex = null;
        try {
            this.SGK_statementType = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement Type: ", this.statementType);
            }
            this.SGK_statementID = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tStatement ID: ", this.statementID);
            }
            intVal = this.is.readInt();
            this.setSQLerrd((short)3, intVal);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tEstimated Cost: ", intVal);
            }
            short tupleSize = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tTuplesize: ", (int)tupleSize);
            }
            nfields = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\t# of fields: ", (int)nfields);
            }
            this.SGK_desc = new IfxResultSetMetaData(nfields, this.conn);
            this.SGK_desc.setTupleSize(tupleSize);
            int stringTableSize = this.conn.is4ByteOffsetSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tString table: ", stringTableSize);
            }
            this.SGK_TxStmt = 0;
            if (this.statementType == 34) {
                this.SGK_TxStmt = 1;
            } else if (this.statementType == 35 || this.statementType == 36) {
                this.SGK_TxStmt = (short)2;
            }
            if (nfields > 0) {
                fieldIndex = new int[nfields];
                for (short i = 1; i <= nfields; i = (short)(i + 1)) {
                    short shortVal;
                    fieldIndex[i - 1] = this.conn.is4ByteOffsetSupported() ? this.is.readInt() : (int)this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t    Field Index: ", fieldIndex[i - 1]);
                    }
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Start Pos: ", intVal);
                        }
                        this.SGK_desc.setColumnStartPosition(i, intVal);
                    } else {
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Start Pos: ", shortVal);
                        }
                        this.SGK_desc.setColumnStartPosition(i, shortVal);
                    }
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn type: ", shortVal);
                    }
                    this.SGK_desc.setIfxColumnType(i, shortVal);
                    if (this.conn.isUSVER()) {
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tColumn Extended Id: ", intVal);
                        }
                        this.SGK_desc.setColumnExtendedId(i, intVal);
                        String stringData = new String(this.is.readChar(this.dbEncoding));
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tOwner name: " + stringData);
                        }
                        this.SGK_desc.setExtendedOwnerName(i, stringData);
                        stringData = new String(this.is.readChar());
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tExtended name: " + stringData);
                        }
                        this.SGK_desc.setExtendedName(i, stringData);
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tReference: ", shortVal);
                        }
                        this.SGK_desc.setReference(i, shortVal);
                        shortVal = this.is.readSmallInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tAlignment: ", shortVal);
                        }
                        this.SGK_desc.setAlignment(i, shortVal);
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tSource type: ", intVal);
                        }
                        this.SGK_desc.setSourceType(i, intVal);
                        intVal = this.is.readInt();
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", intVal);
                        }
                        this.SGK_desc.setEncodedLength(i, intVal);
                        continue;
                    }
                    shortVal = this.is.readSmallInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tLength: ", shortVal);
                    }
                    this.SGK_desc.setEncodedLength(i, shortVal);
                }
                this.SGK_desc.setTextByteColumnCount();
            }
            if (stringTableSize > 0) {
                byte[] b = new byte[stringTableSize];
                this.is.readPadded(b);
                strtab = this.conn.ifxtojava.IfxToJavaChar(b, this.dbEncoding, this.conn.encoption);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tData in String table: ", strtab);
                }
            }
            int SGK_tupleBufferSize = 100;
            this.SGK_rowColumn = new IfxRowColumn(this.conn, this.SGK_desc, 100);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "Describe packet received");
        }
        if (strtab != null) {
            String colName = null;
            StringTokenizer itok = new StringTokenizer(strtab, "\u0000");
            for (short i = 0; i < nfields; i = (short)(i + 1)) {
                if (itok.hasMoreTokens()) {
                    colName = itok.nextToken();
                    this.SGK_desc.setColumnName(i + 1, colName);
                    continue;
                }
                this.SGK_desc.setColumnName(i + 1, null);
            }
        }
        if (this.conn != null) {
            this.SGK_desc.setDelimIdent(this.conn.isDelimIdentSet());
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "SGKDescribe packet received");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSGKDescribe() exited");
        }
    }

    private void receiveSGKTuple() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSGKTuple() called");
            this.trace.writeTrace(logger, 2, "    totalTupleSize = " + this.SGK_totalTupleSize);
            this.trace.writeTrace(logger, 2, "    totalTuples = " + this.SGK_totalTuples);
        }
        try {
            short warn = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tWarning: ", warn);
            }
            int size = this.conn.isUSVER() ? this.is.readInt() : (int)this.is.readSmallInt();
            if (this.SGK_rowColumn == null) {
                throw IfxErrMsg.getSQLException(-79716, "No SGK_DESCRIBE", (IfxConnection)this.conn);
            }
            if (size > 0) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple Size :", size);
                }
                this.SGK_rowColumn.readTuple(this.is, this.SGK_totalTupleSize, size);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tTuple data: ");
                    this.protoTrace.writeTrace(logger, 2, this.SGK_rowColumn.getTupleData(), this.SGK_totalTupleSize, 'B', size);
                }
                this.SGK_totalTupleSize += size;
                if (++this.SGK_totalTuples >= this.SGK_offsetVector.size()) {
                    this.SGK_offsetVector.setSize(this.SGK_totalTuples + 100);
                    this.SGK_offsetVector.setElementAt(0, 0);
                }
                this.SGK_offsetVector.setElementAt(this.SGK_totalTupleSize, this.SGK_totalTuples);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveSGKTuple(): tuple size = " + size);
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveSGKTuple(): totalTupleSize = " + this.SGK_totalTupleSize);
                    this.trace.writeTrace(logger, 2, "IfxSqli:receiveSGKTuple(): totalTuples = " + this.SGK_totalTuples);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveSGKTuple() exited");
        }
    }

    private String acceptPrivateServerChallenge() {
        try {
            short msg;
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
            }
            if ((msg = this.is.readSmallInt()) == 129) {
                short fileXNameLength = this.is.readSmallInt();
                byte[] fileNameMessage = new byte[fileXNameLength];
                this.is.readPadded(fileNameMessage, 0, fileXNameLength);
                String fileXName = this.conn.ifxtojava.IfxToJavaChar(fileNameMessage, this.conn.encoption);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_CHALLENGE");
                    this.protoTrace.writeTrace(logger, 1, "\tfileXNameLength=" + fileXNameLength);
                    if (fileXNameLength > 0) {
                        this.protoTrace.writeTrace(logger, 1, "\tfileXName=" + fileXName);
                    }
                }
                FileInputStream fInStream = new FileInputStream(fileXName);
                DataInputStream fileXInput = new DataInputStream(fInStream);
                String fileYName = fileXInput.readLine();
                byte[] intZbuf = new byte[256];
                fileXInput.read(intZbuf, 0, 256);
                fileXInput.close();
                fInStream.close();
                FileOutputStream fOutStream = new FileOutputStream(fileYName);
                fOutStream.write(intZbuf);
                fOutStream.close();
                this.receiveEOT();
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
                return fileYName;
            }
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
            }
            this.setError(-408);
            return null;
        }
        catch (SQLException e) {
            this.addException(e);
            return null;
        }
        catch (Exception e) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
            return null;
        }
    }

    private boolean sendPrivateServerResponse(String fileYName) {
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "C->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_RESPONSE");
                this.protoTrace.writeTrace(logger, 1, "\tfileYNameLength=" + fileYName.length());
                if (fileYName.length() > 0) {
                    this.protoTrace.writeTrace(logger, 1, "\tfileYName=" + fileYName);
                }
            }
            this.os.writeSmallInt((short)130);
            this.os.writeSmallInt((short)fileYName.length());
            byte[] b = this.conn.javatoifx.JavaToIfxChar(fileYName, this.conn.encoption);
            this.os.writePadded(b, 2, b.length - 2);
            this.flip();
            this.clearExceptions();
            short msg = this.is.readSmallInt();
            if (msg == 127) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_ACCEPT");
                }
                if ((msg = this.is.readSmallInt()) == 12) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                    }
                    return true;
                }
            } else if (msg == 56) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EXIT");
                }
            } else if (msg == 12) {
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "");
                    this.protoTrace.writeTrace(logger, 1, "S->C");
                    this.protoTrace.writeTrace(logger, 1, "\tSQ_EOT");
                }
            } else if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
                this.protoTrace.writeTrace(logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
            }
            return false;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                this.addException((SQLException)e);
            } else {
                this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
            }
            return false;
        }
    }

    @Override
    public boolean handlePrivateServerExchange() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: handlePrivateServerExchange() called");
        }
        try {
            this.sendACK();
            this.flip();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        this.clearExceptions();
        String fileYName = this.acceptPrivateServerChallenge();
        if (fileYName == null) {
            return false;
        }
        boolean flag = this.sendPrivateServerResponse(fileYName);
        if (this.sqliTrace != null) {
            this.sqliTrace.recordS2C();
        }
        return flag;
    }

    @Override
    public void handlePAMAuthentication(String PAMClientClassName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: handlePAMAuthentication() called");
        }
        IfmxPAM userPAMInterface = null;
        if (PAMClientClassName != null) {
            try {
                Class<?> c = Class.forName(PAMClientClassName);
                userPAMInterface = (IfmxPAM)c.newInstance();
            }
            catch (Exception e) {
                throw this.handleSocketException(e, this.conn);
            }
        }
        boolean done = false;
        IfxPAMChallenge challengeMessage = null;
        IfxPAMResponse responseMessage = null;
        try {
            this.sendACK();
            this.flip();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        while (!this.userPAMAuthorized && !done) {
            boolean responseRequired;
            challengeMessage = this.readPAMChallengeMessage();
            if (this.userPAMAuthorized) {
                done = true;
                continue;
            }
            if (challengeMessage == null) {
                done = true;
                continue;
            }
            if (PAMClientClassName == null) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            switch (challengeMessage.getChallengeType()) {
                case 3: 
                case 4: {
                    responseRequired = false;
                    break;
                }
                default: {
                    responseRequired = true;
                }
            }
            responseMessage = userPAMInterface.IfxPAM(challengeMessage);
            if (responseMessage.getTerminateConnection()) {
                this.sendExit();
                done = true;
                continue;
            }
            if (!responseRequired) continue;
            this.sendPAMResponseMessage(responseMessage);
        }
        if (!this.userPAMAuthorized && done) {
            throw IfxErrMsg.getSQLException(-79885, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: handlePAMAuthentication() exiting");
        }
    }

    private IfxPAMChallenge readPAMChallengeMessage() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: readPAMChallengeMessage() called");
        }
        byte[] message = new byte[513];
        IfxPAMChallenge returnValue = null;
        this.clearExceptions();
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
            }
            short msg = this.is.readSmallInt();
            switch (msg) {
                case 56: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_EXIT");
                    }
                    this.sendExit();
                    break;
                }
                case 127: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_ACCEPT");
                    }
                    this.userPAMAuthorized = true;
                    this.receiveEOT();
                    break;
                }
                case 129: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tSQ_CHALLENGE");
                    }
                    short messageStyle = this.is.readSmallInt();
                    short messageLength = this.is.readSmallInt();
                    this.is.readPadded(message, 0, messageLength);
                    returnValue = new IfxPAMChallenge(this.conn.ifxtojava.IfxToJavaChar(message, this.conn.encoption), messageStyle);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\tMessageType=" + messageStyle);
                        this.protoTrace.writeTrace(logger, 1, "\tMessageLength=" + messageLength);
                        if (messageLength > 0) {
                            this.protoTrace.writeTrace(logger, 1, "\tMessage=" + returnValue.getChallenge());
                        }
                    }
                    this.receiveEOT();
                    break;
                }
                default: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t*** Unknown error message: " + msg + " ***\n");
                    }
                    this.setError(-408);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: readPAMChallengeMessage() exited");
        }
        return returnValue;
    }

    private void sendPAMResponseMessage(IfxPAMResponse r) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendPAMResponseMessage() called");
        }
        String responseString = r.getResponse();
        short msgLen = 0;
        if (r != null && responseString != null) {
            if (responseString.length() > 512) {
                throw IfxErrMsg.getSQLException(-79886, this.conn);
            }
            msgLen = (short)responseString.length();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.protoTrace.writeTrace(logger, 1, "");
            this.protoTrace.writeTrace(logger, 1, "C->S");
            this.protoTrace.writeTrace(logger, 1, "\tSQ_RESPONSE");
            this.protoTrace.writeTrace(logger, 2, "\t\tMESSAGE LENGTH: " + msgLen);
            this.protoTrace.writeTrace(logger, 2, "\t\tData:");
            if (r.challengeResponse == null || r.challengeResponse.length() == 0) {
                this.protoTrace.writeTrace(logger, 2, "<null>");
            } else {
                this.protoTrace.writeTrace(logger, 2, r.challengeResponse);
            }
        }
        try {
            this.os.writeSmallInt((short)130);
            this.os.writeSmallInt(msgLen);
            if (msgLen != 0) {
                byte[] b = this.conn.javatoifx.JavaToIfxChar(r.challengeResponse, this.conn.encoption);
                this.os.writePadded(b, 2, b.length - 2);
            }
            this.sendEOT();
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
    }

    @Override
    public IfxResultSetMetaData executeFPDescribe(String signature, boolean isProc, String procName, int numargs) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeFPDescribe() called");
        }
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendCFPDescribe(signature, isProc, procName, numargs);
            this.receiveMessage();
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: executeDescribeInput() exited");
        }
        return this.idesc;
    }

    private void sendCFPDescribe(String signature, boolean isProc, String procName, int numargs) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendCFPDescribe() called");
        }
        try {
            if (this.conn.isNamedParametersSupported()) {
                byte[] dbBytes = null;
                int handleIx = signature.indexOf(94);
                dbBytes = handleIx > 0 ? this.os.getJavaToIfxChar(signature.substring(0, handleIx)) : this.os.getJavaToIfxChar(procName);
                this.os.writeSmallInt((short)131);
                if (handleIx > 0) {
                    this.os.writeByte(1);
                    this.os.writeChar(dbBytes);
                    int handle = Integer.parseInt(signature.substring(handleIx + 1));
                    this.os.writeInt(handle);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\tisRoutineById:  1");
                        this.protoTrace.writeTrace(logger, 2, "\tDbName: " + signature.substring(0, handleIx));
                        this.routineDbName = signature.substring(0, handleIx);
                        this.protoTrace.writeTrace(logger, 2, "\thandle id: " + handle);
                    }
                } else {
                    this.os.writeByte(0);
                    if (isProc) {
                        this.os.writeSmallInt((short)0);
                    } else {
                        this.os.writeSmallInt((short)1);
                    }
                    this.os.writeChar(dbBytes);
                    this.os.writeInt(numargs);
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t Procedure: " + (isProc ? "true" : "false"));
                        this.protoTrace.writeTrace(logger, 2, "\t\t Name     : " + procName);
                        this.protoTrace.writeTrace(logger, 2, "\t\t NumArgs  : " + numargs);
                    }
                }
            } else {
                byte[] dbBytes = this.os.getJavaToIfxChar(procName);
                this.os.writeSmallInt((short)131);
                if (isProc) {
                    this.os.writeSmallInt((short)0);
                } else {
                    this.os.writeSmallInt((short)1);
                }
                this.os.writeChar(dbBytes);
                this.os.writeInt(numargs);
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\t Procedure: " + (isProc ? "true" : "false"));
                    this.protoTrace.writeTrace(logger, 2, "\t\t Name     : " + procName);
                    this.protoTrace.writeTrace(logger, 2, "\t\t NumArgs  : " + numargs);
                }
            }
            this.sendEOT();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendExecute() exited");
        }
    }

    private void receiveIFPDescribe() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveIFPDescribe() called");
        }
        try {
            this.recvIDescribe(true);
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(IfxErrMsg.getSQLException(-79716, this.conn));
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IFPDescribe packet received");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: receiveIFPDescribe() exited");
        }
    }

    public boolean getNextSGKRow() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getNextSGKRow() called");
        }
        int tcount = this.SGK_totalTuples - (this.SGK_curRow + 1);
        int tupleCount = this.SGK_totalTuples;
        if (tcount == 0) {
            return false;
        }
        ++this.SGK_curRow;
        this.SGK_curOffset = this.SGK_offsetVector.elementAt(this.SGK_curRow);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "SGK_curRow = " + this.SGK_curRow);
            this.trace.writeTrace(logger, 1, "SGK_currOffset = " + this.SGK_curOffset);
        }
        this.SGK_rowColumn.setOffsetInTuple(this.SGK_curOffset);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: getNextSGKRow() exited");
        }
        return true;
    }

    private void sendSGKPrepare(IfxStatement stmt) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendSGKPrepare() called");
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\tSQ_SGKPREPARE");
            }
            this.os.writeSmallInt((short)134);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\t\treturnGeneratedKey: " + stmt.SGK_returnGeneratedKeys);
            }
            this.os.writeSmallInt(stmt.SGK_returnGeneratedKeys);
            if (stmt.SGK_returnGeneratedKeys == 2) {
                int nkeys = 0;
                if (stmt.SGK_indexes != null) {
                    nkeys = stmt.SGK_indexes.length;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\t# keys: " + nkeys);
                }
                this.os.writeSmallInt((short)nkeys);
                for (int i = 0; i < nkeys; ++i) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\t\tindex: " + stmt.SGK_indexes[i]);
                    }
                    this.os.writeSmallInt((short)stmt.SGK_indexes[i]);
                }
            } else if (stmt.SGK_returnGeneratedKeys == 3) {
                int nkeys = 0;
                if (stmt.SGK_names != null) {
                    nkeys = stmt.SGK_names.length;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 1, "\t\t# keys: " + nkeys);
                }
                this.os.writeSmallInt((short)nkeys);
                for (int i = 0; i < nkeys; ++i) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 1, "\t\t\tname: " + stmt.SGK_names[i]);
                    }
                    this.os.writeChar(this.os.getJavaToIfxChar(stmt.SGK_names[i]));
                }
            }
        }
        catch (Exception e) {
            throw this.handleSocketException(e, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: sendSGKPrepare() exited");
        }
    }

    public int getNumberOfFetches() {
        return this.numberOfFetches;
    }

    protected int getNumberOfTuplesReceived() {
        return this.numberOfTuplesReceived;
    }

    private SQLException handleSocketException(Exception e, IfxSqliConnect conn) {
        if (conn != null) {
            conn.isOpen = false;
            conn.socketTimedOut = true;
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        SQLException SQLe = IfxErrMsg.getSQLException(-79716, e.toString(), (IfxConnection)conn);
        IfxErrMsg.setSQLExceptionCause(SQLe, e);
        return SQLe;
    }

    private void checkFastPathExp(Vector<IfxObject> exVector, ResultSetMetaData pmd) throws SQLException {
        int paramCount = this.conn.isNamedParametersSupported() && pmd != null ? pmd.getColumnCount() : (exVector != null ? exVector.size() : 0);
        for (int i = 0; i < paramCount; ++i) {
            IfxObject ival = null;
            if (i < exVector.size()) {
                ival = exVector.elementAt(i);
            }
            if (ival != null) continue;
            int ord = i % paramCount + 1;
            if (pmd != null && ((IfxResultSetMetaData)pmd).hasDefaultValue(ord)) {
                return;
            }
            throw IfxErrMsg.getSQLException(-79823, ((IfxResultSetMetaData)pmd).getArgumentName(ord), (IfxConnection)this.conn);
        }
    }

    private byte[] getJavaToIfxCharBytes(String s) throws IOException, SQLException {
        if (this.conn.isRemove64KLimitSupported()) {
            return this.os.getJavaToIfx4BytesChar(s, this.dbEncoding);
        }
        return this.os.getJavaToIfxChar(s, this.dbEncoding);
    }

    public int getPutErrRowCount() {
        return this.putErrRowCount;
    }

    public void clearPutErrRowCount() {
    }
}

