/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final Object logger = Trace.getLoggerForClass(IfxVarChar.class);
    private static final int MAXVCLEN = 255;
    protected String value;
    private String valueTrimmed;
    private String trailing_trimmed;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String varchar) throws SQLException {
        this.setIfxType(13);
        this.value = varchar;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String dbEnc = this.conn.getdbEncoding();
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, dbEnc, ((IfxSqliConnect)this.conn).encoption);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            if (this.isNull()) {
                byte[] b = ((IfxSqliConnect)this.conn).isVarcharVarLenSupported() ? new byte[2] : new byte[this.encodedLength + 1];
                memoryUtil.byfill(b, (byte)0);
                b[0] = 1;
                return b;
            }
            String dbEnc = this.conn.getdbEncoding();
            byte[] bData = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxVarChar(this.value, dbEnc, this.encodedLength, ((IfxSqliConnect)this.conn).encoption);
            if (((IfxSqliConnect)this.conn).isVarcharVarLenSupported()) {
                int len = 1 + (0xFF & bData[0]);
                byte[] temp = new byte[len];
                System.arraycopy(bData, 0, temp, 0, len);
                return temp;
            }
            return bData;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, String dbEnc) throws SQLException {
        this.fromIfx(b, 0, b.length, dbEnc);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, String dbEnc) throws SQLException {
        try {
            int datalength = b[offset] & 0xFF;
            if (datalength == 1 && b[offset + 1] == 0) {
                this.value = null;
                this.nullify();
                return;
            }
            if (datalength == 0) {
                this.value = new String("");
            } else {
                IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                this.value = IfxToJavaType.IfxToJavaChar(b, offset + 1, datalength, dbEnc, ((IfxSqliConnect)this.conn).encoption);
            }
            this.unnullify();
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        int datalength = b[offset] & 0xFF;
        String dbEnc = this.conn.getdbEncoding();
        if (length > 0) {
            datalength = Math.min(datalength, length);
        }
        if (((IfxSqliConnect)this.conn).isOnLine5SER()) {
            dbEnc = "NOENCODING";
        }
        this.fromIfx(b, offset, length, dbEnc);
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxVarChar.toBytes() called");
        }
        byte[] b = null;
        if (this.value == null) {
            this.nullify();
        } else {
            try {
                String cliEnc = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] temp = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, cliEnc, ((IfxSqliConnect)this.conn).encoption);
                int x = temp.length;
                b = new byte[x - 2];
                System.arraycopy(temp, 2, b, 0, x - 2);
            }
            catch (Exception e) {
                this.value = null;
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxVarChar.toBytes() exited");
        }
        return b;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromString(String str) throws SQLException {
        this.fromString(str, false);
    }

    @Override
    public void fromString(String str, boolean trimString) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.clearWarning();
            String nstr = null;
            nstr = trimString ? str.trim() : str;
            this.value = nstr.length() > 255 ? nstr.substring(0, 255) : nstr;
            this.unnullify();
        }
    }

    @Override
    public void fromBytes(byte[] str) throws SQLException {
        block7: {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxVarChar.fromBytes() called");
            }
            if (str == null) {
                this.nullify();
            } else {
                try {
                    int byte_len = str.length;
                    if (str.length > 255) {
                        byte_len = 255;
                    }
                    String dbEnc = this.conn.getdbEncoding();
                    IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                    this.value = IfxToJavaType.IfxToJavaChar(str, 0, byte_len, dbEnc, ((IfxSqliConnect)this.conn).encoption);
                    this.unnullify();
                }
                catch (Exception e) {
                    this.value = null;
                    if (!(e instanceof IOException)) break block7;
                    throw IfxErrMsg.getSQLException(-79783, this.conn);
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxVarChar.fromBytes() exited");
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte b;
        if (this.isNull()) {
            return 0;
        }
        try {
            b = Byte.parseByte(this.value);
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return b;
    }

    @Override
    public void fromByte(Byte b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromByte((byte)b);
        }
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        this.value = String.valueOf(b);
        this.unnullify();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("1") || this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    @Override
    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)b);
        }
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        this.value = b ? "true" : "false";
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            this.trimIfxVarChar(this.value);
            Integer I = Integer.parseInt(this.valueTrimmed);
            return I;
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    private void trimIfxVarChar(String s) {
        int i;
        if (s == null) {
            this.value = s;
            this.valueTrimmed = s;
            this.nullify();
            return;
        }
        this.value = s;
        int length = s.length();
        for (i = length - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        this.valueTrimmed = i != length - 1 ? s.substring(0, ++i) : s;
        if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
            this.trailing_trimmed = this.valueTrimmed;
        }
        length = this.valueTrimmed.length();
        for (i = 0; i < length && s.charAt(i) == ' '; ++i) {
        }
        if (i != 0) {
            this.valueTrimmed = this.valueTrimmed.substring(i, length);
        }
        this.unnullify();
    }

    @Override
    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.fromInt((int)I);
        }
    }

    @Override
    public void fromInt(int I) throws SQLException {
        this.value = Integer.toString(I);
        this.unnullify();
    }

    @Override
    public void fromDecimal(BigDecimal B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short S = new Short(this.value);
            return S;
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
        }
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromLong((long)val);
        }
    }

    @Override
    public void fromLong(long val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float F = Float.valueOf(this.value);
        return F.floatValue();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromFloat(val.floatValue());
        }
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    @Override
    public Date toDate() throws SQLException {
        Date d = null;
        if (this.isNull()) {
            return null;
        }
        try {
            d = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return d;
    }

    @Override
    public void fromDate(Date val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = dateUtil.convertDateStr(val, this.conn);
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        Time t;
        long nmillis = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean isTime = true;
            Object Tobj = dateUtil.convertDateTimeObj(this.value, this.conn, isTime);
            nmillis = ((java.util.Date)Tobj).getTime();
            t = new Time(nmillis);
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return t;
    }

    @Override
    public void fromTime(Time val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            long nmillis = val.getTime();
            this.value = dateUtil.convertDateTimeStr(val, this.conn, nmillis);
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        Timestamp t;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean isTime = false;
            t = (Timestamp)dateUtil.convertDateTimeObj(this.value, this.conn, isTime);
        }
        catch (Exception e) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + e.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return t;
    }

    @Override
    public void fromTimestamp(Timestamp val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            long nmillis = val.getTime();
            this.value = dateUtil.convertDateTimeStr(val, this.conn, nmillis);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double D = Double.valueOf(this.value);
        return D;
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromDouble((double)val);
        }
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.value = String.valueOf(val);
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigD;
        if (this.isNull()) {
            return null;
        }
        try {
            bigD = new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return bigD;
    }

    public void fromBigDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar otherVarChar = (IfxVarChar)other;
        if (otherVarChar.isNull()) {
            return false;
        }
        return this.value.equals(otherVarChar.value);
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        byte[] byteArray;
        if (this.isNull()) {
            return null;
        }
        try {
            String dbEnc = this.conn.getdbEncoding();
            byteArray = dbEnc != null ? this.value.getBytes(dbEnc) : this.value.getBytes();
        }
        catch (IOException e) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public void fromAsciiStream(InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromAsciiStream(x, (int)length);
    }

    @Override
    public void fromAsciiStream(InputStream x, int length) throws SQLException {
        this.writeTrace(3, "IfxVarChar: fromAsciiStream()");
        if (x != null) {
            if (length == 0) {
                this.value = "";
            } else {
                try {
                    if (length < 0) {
                        length = x.available();
                    }
                    byte[] b = new byte[length];
                    int offset = 0;
                    this.writeTrace(3, "IfxChar: fromAsciiStream(): length = " + length);
                    do {
                        int readLen = x.read(b, offset, length);
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): readLen=" + readLen);
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): length = " + (length -= readLen));
                        this.writeTrace(3, "IfxVarChar: fromAsciiStream(): offset =" + (offset += readLen));
                    } while (length > 0);
                    this.value = new String(b);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.writeTrace(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream x, long length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    @Override
    public void fromInputStream(InputStream x, int length) throws SQLException {
        this.fromAsciiStream(x, length);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromCharacterStream(reader, (int)length);
    }

    @Override
    public void fromCharacterStream(Reader x, int length) throws SQLException {
        if (length < 0) {
            throw IfxErrMsg.getSQLException(-79716, "Cannot read from Reader/InputStream into a CHAR field w/o a length specified", this.conn);
        }
        this.writeTrace(3, "IfxVarChar: fromCharacterStream()");
        if (x != null) {
            this.writeTrace(3, "IfxVarChar: fromCharacterStream():length =" + length);
            if (length == 0) {
                this.value = "";
            } else {
                char[] b = new char[length];
                int offset = 0;
                try {
                    do {
                        int readLen = x.read(b, offset, length);
                        this.writeTrace(3, "IfxVarChar: fromcharacterStream():readLen=" + readLen);
                        this.writeTrace(3, "IfxVarChar: fromCharacterStream():length=" + (length -= readLen));
                        this.writeTrace(3, "IfxVarChar: fromCharacterStream():offset=" + (offset += readLen));
                    } while (length > 0);
                }
                catch (Exception e) {
                    throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                }
                this.value = new String(b);
                this.writeTrace(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.writeTrace(99, "IfxVarChar: toCharacterStream()");
        this.writeTrace(3, "IfxVarChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }
}

