/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Manifest;

public class Version2 {
    private static final String BUILD_INFORMATION_FILE = "/META-INF/MANIFEST.MF";
    private static final int majorVersion;
    private static final int minorVersion;
    private static final int serviceVersion;
    private static final Date buildDate;
    private static final int buildNumber;

    public static void main(String[] args) {
        System.out.println("IBM Informix JDBC Driver");
        System.out.println("Build-Version: " + majorVersion + '.' + minorVersion + '.' + serviceVersion);
        System.out.println("Build-Number: " + buildNumber);
        System.out.println("Build-Date: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(buildDate));
    }

    public static int getMajorVerision() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static int getServiceVersion() {
        return serviceVersion;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int major = 0;
        int minor = 0;
        int service = 0;
        int build = 0;
        Date date = null;
        try {
            Enumeration<URL> resources = Version2.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest m = new Manifest(resources.nextElement().openStream());
                if (m.getMainAttributes().getValue("Implementation-Title") == null || !m.getMainAttributes().getValue("Implementation-Title").equals("Informix JDBC Driver")) continue;
                String version = m.getMainAttributes().getValue("Implementation-Version");
                String[] versionSplit = version.split("\\.");
                if (versionSplit.length != 3 && versionSplit.length != 4) {
                    throw new RuntimeException("Incorrect number of properties for utm.version in file:  /META-INF/MANIFEST.MF");
                }
                major = Integer.parseInt(versionSplit[0]);
                minor = Integer.parseInt(versionSplit[1]);
                service = Integer.parseInt(versionSplit[2]);
                date = dateFormat.parse(m.getMainAttributes().getValue("Build-Date"));
                String buildString = m.getMainAttributes().getValue("Build-Number");
                build = Integer.parseInt(buildString);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        majorVersion = major;
        minorVersion = minor;
        serviceVersion = service;
        buildDate = date;
        buildNumber = build;
    }
}

