/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class Decimal {
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    public static final String digChar = "0123456789";
    public static final int DEC_T_SIZE = 22;
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    protected short dec_exp = 0;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts = 0;
    protected byte[] dec_dgts;
    protected int lenOfFirstField;
    protected short precStored;
    protected byte pdigs = 0;
    protected byte pscale = 0;
    protected boolean timestamp = false;
    protected byte startCode = 0;
    protected byte endCode = (byte)15;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    public static Hashtable<Integer, Integer> TU_Exp_Table = new Hashtable(12, 1.0f);

    public Decimal() {
    }

    public Decimal(short exp, short pos, short ndgts, byte[] d) {
        this.dec_exp = exp;
        this.dec_pos = pos;
        this.dec_ndgts = ndgts;
        if (d != null) {
            this.dec_dgts = d;
        } else {
            this.dec_dgts = new byte[ndgts > 0 ? ndgts : (short)1];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(byte[] cp) {
        byte[] cpd = new byte[cp.length - 2];
        for (int i = 2; i < cp.length; ++i) {
            cpd[i - 2] = cp[i];
        }
        this.init(cpd, 0, cpd.length, (short)0);
    }

    public Decimal(byte[] cp, short prec) {
        this.init(cp, 0, cp.length, prec);
    }

    public Decimal(byte[] cp, int offset, int length, short prec) {
        this.init(cp, offset, length, prec);
    }

    public Decimal(byte[] cp, short prec, boolean ts) {
        this.timestamp = ts;
        this.init(cp, 0, cp.length, prec);
    }

    public Decimal(byte[] cp, int offset, int length, short prec, boolean ts) {
        this.timestamp = ts;
        this.init(cp, offset, length, prec);
    }

    public Decimal(String num) {
        int i;
        int first = 0;
        int exp = 0;
        int buflen = num.length();
        boolean decPt = false;
        int upnxt = 0;
        this.dec_pos = 1;
        char nxt = num.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
        } else if (nxt == '+') {
            ++first;
        }
        if (first > 0) {
            --buflen;
        }
        for (i = first; i < num.length() && num.charAt(i) != '.'; ++i) {
            ++exp;
        }
        if (i != num.length()) {
            decPt = true;
            --buflen;
            exp += this.extractExponent(num, i);
        }
        if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        if (buflen % 2 == 1) {
            ++buflen;
        }
        byte[] unpack = new byte[buflen];
        Decimal.byfill(unpack, (byte)0);
        for (i = 0; i < num.length() && num.charAt(i) != 'E'; ++i) {
            int ind = digChar.indexOf(num.charAt(i));
            if (ind == -1) continue;
            unpack[upnxt] = (byte)ind;
            ++upnxt;
        }
        this.dec_ndgts = (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        for (int j = 0; j < this.dec_dgts.length; ++j) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50 && this.dec_dgts[15] < 99) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] temp = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(temp, 0, this.dec_dgts, 0);
        }
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(String num, short inPrec) {
        int i;
        int first = 0;
        int exp = 0;
        int buflen = num.length();
        boolean decPt = false;
        int upnxt = 0;
        this.dec_pos = 1;
        char nxt = num.charAt(0);
        if (nxt == '-') {
            this.dec_pos = 0;
            ++first;
        } else if (nxt == '+') {
            ++first;
        }
        if (first > 0) {
            --buflen;
        }
        for (i = first; i < num.length() && num.charAt(i) != '.'; ++i) {
            ++exp;
        }
        if (i != num.length()) {
            decPt = true;
            --buflen;
            exp += this.extractExponent(num, i);
        }
        if (exp % 2 != 0) {
            ++buflen;
            this.dec_exp = (short)((exp + 1) / 2);
            upnxt = 1;
        } else {
            this.dec_exp = (short)(exp / 2);
        }
        if (buflen % 2 == 1) {
            ++buflen;
        }
        byte[] unpack = new byte[buflen];
        Decimal.byfill(unpack, (byte)0);
        for (i = 0; i < num.length() && num.charAt(i) != 'E'; ++i) {
            int ind = digChar.indexOf(num.charAt(i));
            if (ind == -1) continue;
            unpack[upnxt] = (byte)ind;
            ++upnxt;
        }
        this.dec_ndgts = (short)(buflen / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        for (int j = 0; j < this.dec_dgts.length; ++j) {
            this.dec_dgts[j] = (byte)(unpack[2 * j] * 10 + unpack[2 * j + 1]);
        }
        if (this.dec_ndgts > 16 && this.dec_dgts[16] >= 50) {
            this.dec_dgts[15] = (byte)(this.dec_dgts[15] + 1);
            byte[] temp = this.dec_dgts;
            this.dec_dgts = new byte[16];
            this.dec_ndgts = (short)16;
            Decimal.bycopy(temp, 0, this.dec_dgts, 0);
        }
        this.dec_exp = (short)((Decimal.tuLen(inPrec) + 10 - Decimal.tuEnd((byte)inPrec) + 1) / 2);
        this.computePrecision();
        this.computeScale();
    }

    public Decimal(BigDecimal n) {
        this(n.toString());
        this.pscale = (byte)n.scale();
    }

    public Decimal(boolean sign, byte[] b, int blen, short inPrec) {
        this.dec_pos = sign ? (short)0 : 1;
        this.dec_ndgts = (short)blen;
        this.dec_exp = (short)((Decimal.tuLen(inPrec) + 10 - Decimal.tuEnd((byte)inPrec) + 1) / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        System.arraycopy(b, 0, this.dec_dgts, 0, this.dec_ndgts);
    }

    public Decimal(int yyyy, int mo, int dd, int hh, int mm, int ss, int fffff) {
        this.dec_pos = 1;
        if (yyyy != 0) {
            this.dec_ndgts = (short)10;
            this.dec_exp = (short)7;
            this.dec_dgts = new byte[this.dec_ndgts];
            this.dec_dgts[0] = (byte)(yyyy / 100);
            this.dec_dgts[1] = (byte)(yyyy % 100);
            this.dec_dgts[2] = (byte)mo;
            this.dec_dgts[3] = (byte)dd;
            this.dec_dgts[4] = (byte)hh;
            this.dec_dgts[5] = (byte)mm;
            this.dec_dgts[6] = (byte)ss;
            this.dec_dgts[7] = (byte)(fffff / 1000);
            this.dec_dgts[8] = (byte)(fffff % 1000 / 10);
            this.dec_dgts[9] = (byte)(fffff % 10 * 10);
        } else {
            this.dec_ndgts = (short)3;
            this.dec_exp = (short)3;
            this.dec_dgts = new byte[this.dec_ndgts];
            this.dec_dgts[0] = (byte)hh;
            this.dec_dgts[1] = (byte)mm;
            this.dec_dgts[2] = (byte)ss;
        }
    }

    public final void setTimestampQualifier(short qualifier) {
        this.setT();
        this.precStored = qualifier;
        this.unpackPrecision(qualifier);
    }

    public final void setT() {
        this.timestamp = true;
    }

    public final void unpackPrecision(short prec) {
        this.pdigs = (byte)(prec >> 8);
        if (!this.timestamp) {
            this.pscale = (byte)(prec & 0xFF);
        } else {
            byte code = (byte)(prec & 0xF);
            if (code > 10) {
                this.pscale = (byte)(code - 10);
            } else {
                code = 0;
            }
            byte code2 = (byte)(prec & 0xFF);
            this.startCode = (byte)(code2 >> 4 & 0xF);
            this.endCode = (byte)(code2 & 0xF);
            this.lenOfFirstField = Decimal.tuFLen(prec);
        }
    }

    protected void computePrecision() {
        this.pdigs = (byte)(this.dec_ndgts * 2);
    }

    protected void computeScale() {
        this.pscale = (byte)((this.dec_ndgts - this.dec_exp) * 2);
    }

    public byte[] getPrecision() {
        byte[] prec = new byte[]{this.pdigs, this.pscale};
        return prec;
    }

    protected void init(byte[] cp, int offset, int length, short prec) {
        if (cp[offset] == 0 && cp[offset + 1] == 0) {
            return;
        }
        this.precStored = prec;
        this.unpackPrecision(prec);
        this.dec_dgts = new byte[length - 1];
        Decimal.bycopy(cp, offset + 1, this.dec_dgts, 0);
        short expon = cp[offset];
        this.dec_pos = 1;
        if ((expon & 0x80) == 0) {
            Decimal.decComplement(this.dec_dgts, 0);
            expon = (short)(expon ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = expon = (short)((expon & 0x7F) - 64);
        boolean allZero = true;
        for (int i = 1; i < length; ++i) {
            if (cp[offset + i] == 0) continue;
            allZero = false;
            break;
        }
        this.dec_ndgts = allZero ? (short)0 : (short)(length - 1);
        if (this.pdigs == 0) {
            this.computePrecision();
        }
        if (this.pscale == 0) {
            this.computeScale();
        }
    }

    protected int extractExponent(String num, int start) {
        int i;
        int exp = 0;
        boolean sign = true;
        for (i = start; i < num.length() && num.charAt(i) != 'E'; ++i) {
        }
        if (i == num.length()) {
            return exp;
        }
        if (num.charAt(++i) == '+') {
            ++i;
        } else if (num.charAt(i) == '-') {
            ++i;
            sign = false;
        }
        for (int j = i; j < num.length(); ++j) {
            exp = exp * 10 + digChar.indexOf(num.charAt(j));
        }
        return sign ? exp : -exp;
    }

    public static byte[] byfill(byte[] b, byte f) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = f;
        }
        return b;
    }

    public static char[] charfill(char[] b, int from, int to, char f) {
        for (int i = from; i <= to && i < b.length; ++i) {
            b[i] = f;
        }
        return b;
    }

    public static void bycopy(byte[] from, int fromStart, byte[] to, int toStart) {
        int j = toStart;
        for (int i = fromStart; i < from.length && j < to.length; ++i, ++j) {
            to[j] = from[i];
        }
    }

    public static void charcopy(char[] from, int fromStart, int fromEnd, char[] to, int toStart) {
        int j = toStart;
        for (int i = fromStart; i < from.length && i <= fromEnd && j < to.length; ++i, ++j) {
            to[j] = from[i];
        }
    }

    public static byte[] decComplement(byte[] b, int start) {
        int digit = 100;
        for (int bp = b.length - 1; bp >= start; --bp) {
            if (b[bp] == 0 && digit == 100) continue;
            b[bp] = (byte)(digit - b[bp]);
            digit = 99;
        }
        return b;
    }

    public byte[] javaToIfx() {
        byte[] cp = new byte[this.dec_ndgts + 3];
        boolean bp = false;
        Decimal.byfill(cp, (byte)0);
        int len = this.dec_ndgts + 1;
        cp[0] = (byte)(len >> 8 & 0xFF);
        cp[1] = (byte)(len & 0xFF);
        if (this.dec_pos == -1) {
            return cp;
        }
        cp[2] = (byte)(this.dec_exp + 64 & 0x7F);
        Decimal.bycopy(this.dec_dgts, 0, cp, 3);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                cp[2] = (byte)(cp[2] | 0x80);
            } else {
                Decimal.decComplement(cp, 3);
                cp[2] = (byte)(cp[2] ^ 0x7F);
            }
        } else {
            cp[2] = (byte)(cp[2] | 0x80);
        }
        return cp;
    }

    public byte[] javaToDec_t() {
        int len;
        byte[] b = new byte[22];
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_exp), 0, b, 0, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_pos), 0, b, 2, 2);
        System.arraycopy(JavaToIfxType.JavaToIfxSmallInt(this.dec_ndgts), 0, b, 4, 2);
        if (this.dec_dgts == null) {
            this.dec_dgts = new byte[16];
            Decimal.byfill(this.dec_dgts, (byte)0);
        }
        if ((len = this.dec_dgts.length) > 16) {
            len = 16;
        }
        System.arraycopy(this.dec_dgts, 0, b, 6, len);
        return b;
    }

    public static Decimal dec_tToJava(byte[] b) {
        byte[] bExp = new byte[2];
        byte[] bPos = new byte[2];
        byte[] bNdgts = new byte[2];
        byte[] bDgts = new byte[16];
        System.arraycopy(b, 0, bExp, 0, 2);
        System.arraycopy(b, 2, bPos, 0, 2);
        System.arraycopy(b, 4, bNdgts, 0, 2);
        System.arraycopy(b, 6, bDgts, 0, 16);
        short dec_exp = IfxToJavaType.IfxToJavaSmallInt(bExp);
        short dec_pos = IfxToJavaType.IfxToJavaSmallInt(bPos);
        short dec_ndgts = IfxToJavaType.IfxToJavaSmallInt(bNdgts);
        return new Decimal(dec_exp, dec_pos, dec_ndgts, bDgts);
    }

    public char[] sigdigToChar() {
        char[] digits = new char[this.dec_ndgts * 2];
        for (int i = 0; i < this.dec_ndgts; ++i) {
            digits[i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            digits[i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
        }
        return digits;
    }

    public int sigdigToInt(int from, int to) {
        int val = 0;
        for (int i = from; i <= to; ++i) {
            val = val * 100 + this.dec_dgts[i];
        }
        return val;
    }

    public BigDecimal numericValue() {
        if (this.dec_pos == -1) {
            return new BigDecimal("");
        }
        BigDecimal num = new BigDecimal(this.stringValue());
        return num;
    }

    public boolean isNull() {
        return this.dec_pos == -1;
    }

    public final Double doubleValue() {
        return new Double(this.numericValue().doubleValue());
    }

    public final Float floatValue() {
        return new Float(this.numericValue().floatValue());
    }

    public String stringValue() {
        char[] buf;
        if (this.dec_pos == -1) {
            return "";
        }
        int exp = this.dec_exp * 2;
        int whereDot = -1;
        if (this.dec_ndgts <= 0 && this.dec_exp == 0) {
            return "0.0";
        }
        char[] sigDig = this.sigdigToChar();
        if (exp > 0) {
            if (exp <= sigDig.length) {
                buf = new char[sigDig.length + 2];
                Decimal.charcopy(sigDig, 0, exp - 1, buf, 1);
                buf[exp + 1] = 46;
                if (exp != sigDig.length) {
                    Decimal.charcopy(sigDig, exp, sigDig.length - 1, buf, exp + 2);
                }
            } else {
                buf = new char[exp + 2];
                Decimal.charcopy(sigDig, 0, sigDig.length - 1, buf, 1);
                Decimal.charfill(buf, sigDig.length + 1, exp, '0');
                buf[exp + 1] = 46;
            }
        } else {
            buf = new char[(exp *= -1) + sigDig.length + 3];
            buf[1] = 48;
            buf[2] = 46;
            Decimal.charfill(buf, 3, exp + 2, '0');
            Decimal.charcopy(sigDig, 0, sigDig.length, buf, exp + 3);
        }
        char[] tbuf = Decimal.trimZerosFB(buf, 1);
        tbuf[0] = this.dec_pos == 1 ? 48 : 45;
        return new String(tbuf);
    }

    protected static char[] trimZerosFB(char[] ibuf, int start) {
        int right;
        int left;
        for (left = start; left < ibuf.length && ibuf[left] == '0'; ++left) {
        }
        if (left == ibuf.length) {
            char[] obuf2 = new char[2];
            obuf2[1] = 48;
            return obuf2;
        }
        for (right = ibuf.length - 1; right >= left && ibuf[right] == '0'; --right) {
        }
        char[] obuf = new char[right - left + 2];
        int j = 1;
        int i = left;
        while (i <= right) {
            obuf[j] = ibuf[i];
            ++i;
            ++j;
        }
        return obuf;
    }

    public static byte[] fromBindToTuple(byte[] bindFormat, int newLength) {
        byte[] b = new byte[newLength];
        Decimal.byfill(b, (byte)0);
        if (bindFormat.length - 2 < newLength) {
            newLength = bindFormat.length - 2;
        }
        System.arraycopy(bindFormat, 2, b, 0, newLength);
        return b;
    }

    public static byte tuEnd(byte c) {
        byte b = (byte)(c & 0xF);
        return b;
    }

    public static byte tuStart(byte c) {
        byte b = (byte)(c >> 4 & 0xF);
        return b;
    }

    public static byte tuLen(short c) {
        byte b = (byte)(c >> 8 & 0xFF);
        return b;
    }

    public static byte[] encodeDateTimePrecision(byte[] b, byte s, byte e) {
        b[0] = (byte)(e - s + (s == 0 ? 4 : 2));
        b[1] = (byte)(s << 4 | e);
        return b;
    }

    public static byte[] encodeIntervalPrecision(byte[] b, byte len, byte s, byte e) {
        b[0] = (byte)(e - s + len);
        b[1] = (byte)(s << 4 | e);
        return b;
    }

    public static int tuFLen(short len) {
        byte b1 = Decimal.tuLen(len);
        byte b2 = Decimal.tuEnd((byte)len);
        byte b3 = Decimal.tuStart((byte)len);
        int i = b1 - (b2 - b3);
        return i;
    }

    public Timestamp timestampValue() {
        return this.timestampValue(null);
    }

    public Timestamp timestampValue(Calendar cal) {
        Calendar wireCal;
        if (!this.timestamp) {
            return null;
        }
        if (this.dec_pos == -1) {
            return null;
        }
        int[] timeData = new int[7];
        for (int i = 0; i < 7; ++i) {
            timeData[i] = 0;
        }
        this.fromIfxToArray(timeData);
        if (timeData[0] == 0 || timeData[1] == 0 || timeData[2] == 0) {
            if (timeData[0] == 0) {
                timeData[0] = 1700;
            }
            if (timeData[1] == 0) {
                GregorianCalendar now = new GregorianCalendar();
                timeData[1] = now.get(2) + 1;
            }
            if (timeData[2] == 0) {
                timeData[2] = 1;
            }
        }
        if ((wireCal = cal) == null) {
            wireCal = localCalendar.get();
        }
        wireCal.set(timeData[0], timeData[1] - 1, timeData[2], timeData[3], timeData[4], timeData[5]);
        long lTime = wireCal.getTimeInMillis();
        Timestamp ts = new Timestamp(lTime);
        ts.setNanos(timeData[6]);
        return ts;
    }

    String timestampStringValue() {
        if (this.dec_pos == -1) {
            return null;
        }
        int[] timeData = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.fromIfxToArray(timeData);
        return Decimal.toString(this.precStored, timeData);
    }

    private static String toString(short qual, int[] data) {
        StringBuffer retval = new StringBuffer();
        byte endCode = Interval.getEndCode(qual);
        byte startCode = Interval.getStartCode(qual);
        if (startCode == 0) {
            retval.append(data[0]);
            if (endCode > 0) {
                retval.append(Interval.dtdelim[0]);
            }
        }
        if (startCode <= 2 && endCode >= 2) {
            if (data[1] < 10) {
                retval.append('0');
            }
            retval.append(data[1]);
            if (endCode > 2) {
                retval.append(Interval.dtdelim[1]);
            }
        }
        if (startCode <= 4 && endCode >= 4) {
            if (data[2] < 10) {
                retval.append('0');
            }
            retval.append(data[2]);
            if (endCode > 4) {
                retval.append(Interval.dtdelim[2]);
            }
        }
        if (startCode <= 6 && endCode >= 6) {
            if (data[3] < 10) {
                retval.append('0');
            }
            retval.append(data[3]);
            if (endCode > 6) {
                retval.append(Interval.dtdelim[3]);
            }
        }
        if (startCode <= 8 && endCode >= 8) {
            if (data[4] < 10) {
                retval.append('0');
            }
            retval.append(data[4]);
            if (endCode > 8) {
                retval.append(Interval.dtdelim[4]);
            }
        }
        if (startCode <= 10 && endCode >= 10) {
            if (data[5] < 10) {
                retval.append('0');
            }
            retval.append(data[5]);
        }
        if (endCode > 10) {
            retval.append(Interval.dtdelim[5]);
            int numDigsNeeded = endCode - 10;
            String fracData = Integer.toString(1000000000 + data[6]);
            fracData = fracData.substring(1, numDigsNeeded + 1);
            retval.append(fracData);
        }
        return retval.toString();
    }

    public Interval intervalValue() {
        int index;
        int start = Interval.getStartCode(this.precStored);
        byte end = Interval.getEndCode(this.precStored);
        int[] invFields = new int[7];
        for (index = 0; index < 7; ++index) {
            invFields[index] = 0;
        }
        this.fromIfxToArray(invFields);
        index = start > 10 ? 6 : start / 2;
        long total = 0L;
        long nanos = 0L;
        int i = start;
        while (i < 11) {
            switch (i) {
                case 0: {
                    total += (long)invFields[index] * 12L;
                    break;
                }
                case 2: {
                    total += (long)invFields[index];
                    break;
                }
                case 4: {
                    total += (long)invFields[index] * 86400L;
                    break;
                }
                case 6: {
                    total += (long)invFields[index] * 3600L;
                    break;
                }
                case 8: {
                    total += (long)invFields[index] * 60L;
                    break;
                }
                case 10: {
                    total += (long)invFields[index];
                    break;
                }
            }
            i += 2;
            ++index;
        }
        nanos = invFields[6];
        if (this.dec_pos == 0) {
            total *= -1L;
            nanos *= -1L;
        }
        Interval inv = null;
        try {
            inv = start >= 4 ? new IntervalDF(total, nanos, this.precStored) : new IntervalYM((int)total, this.precStored);
        }
        catch (Exception e) {
            return null;
        }
        return inv;
    }

    void fromIfxToArray(int[] dataArray) {
        short len = Interval.getLength(this.precStored);
        byte start = Interval.getStartCode(this.precStored);
        byte end = Interval.getEndCode(this.precStored);
        short flen = (short)(len - (end - start));
        byte currentField = 0;
        int currentValue = 0;
        int dtbufIndex = 0;
        int dataIndex = 0;
        dataIndex = start > 10 ? 6 : start / 2;
        for (int i = this.dec_ndgts - 1; i > 0 && this.dec_dgts[i] == 0; --i) {
            this.dec_ndgts = (short)(this.dec_ndgts - 1);
        }
        int bexpon = (len + 10 - end + 1) / 2;
        byte[] dtbuf = new byte[16];
        Decimal.byfill(dtbuf, (byte)0);
        if (this.dec_ndgts > 0 && bexpon >= this.dec_exp) {
            System.arraycopy(this.dec_dgts, 0, dtbuf, bexpon - this.dec_exp, this.dec_ndgts);
        }
        if ((currentField = start) != 12) {
            int i = flen / 2;
            if ((flen & 1) > 0) {
                ++i;
            }
            while (dtbufIndex < i) {
                currentValue *= 100;
                currentValue += dtbuf[dtbufIndex];
                ++dtbufIndex;
            }
            currentField = (byte)(currentField + 2);
            dataArray[dataIndex++] = currentValue;
        }
        while (currentField <= end && currentField <= 10) {
            dataArray[dataIndex++] = dtbuf[dtbufIndex];
            currentField = (byte)(currentField + 2);
            ++dtbufIndex;
        }
        currentValue = 0;
        if (end > 10) {
            for (currentField = 11; currentField <= end; currentField = (byte)(currentField + 2)) {
                currentValue *= 100;
                currentValue += dtbuf[dtbufIndex];
                ++dtbufIndex;
            }
            int fractionNumber = 15 - end - 1 + 4;
            if ((fractionNumber & 1) == 0) {
                ++fractionNumber;
            }
            for (int i = 0; i < fractionNumber; ++i) {
                currentValue *= 10;
            }
            dataArray[dataIndex] = currentValue;
        }
    }

    public static Decimal numericToDecimal(BigDecimal n) {
        return new Decimal(n);
    }

    static {
        TU_Exp_Table.put(0, 5);
        TU_Exp_Table.put(2, 4);
        TU_Exp_Table.put(4, 3);
        TU_Exp_Table.put(6, 2);
        TU_Exp_Table.put(8, 1);
        TU_Exp_Table.put(10, 0);
        TU_Exp_Table.put(11, -1);
        TU_Exp_Table.put(12, -1);
        TU_Exp_Table.put(13, -2);
        TU_Exp_Table.put(14, -2);
        TU_Exp_Table.put(15, -3);
    }
}

