/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildInformation {
    private static final String BUILD_INFORMATION_FILE = "buildInformation.properties";
    private final String version;
    private final String buildEngineHostName;
    private final String buildEngineId;
    private final String buildLabel;
    private final String buildType;
    private final String repositoryAddress;

    public BuildInformation() {
        InputStream is = BuildInformation.class.getResourceAsStream(BUILD_INFORMATION_FILE);
        if (is != null) {
            Properties buildProperties = new Properties();
            try {
                buildProperties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.version = buildProperties.getProperty("version");
            this.buildEngineHostName = buildProperties.getProperty("buildEngineHostName");
            this.buildEngineId = buildProperties.getProperty("buildEngineId");
            this.buildLabel = buildProperties.getProperty("buildLabel");
            this.buildType = buildProperties.getProperty("buildType");
            this.repositoryAddress = buildProperties.getProperty("repositoryAddress");
        } else {
            this.version = "0.0.0";
            this.buildEngineHostName = "";
            this.buildEngineId = "";
            this.buildLabel = "";
            this.buildType = "";
            this.repositoryAddress = "";
        }
    }

    public static void main(String[] args) {
        BuildInformation buildInfo = new BuildInformation();
        System.out.println("Informix JDBC Version = " + buildInfo.getVersion());
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildEngineHostName() {
        return this.buildEngineHostName;
    }

    public String getBuildEngineId() {
        return this.buildEngineId;
    }

    public String getBuildLabel() {
        return this.buildLabel;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BuildInformation [version=");
        builder.append(this.version);
        builder.append(", buildEngineHostName=");
        builder.append(this.buildEngineHostName);
        builder.append(", buildEngineId=");
        builder.append(this.buildEngineId);
        builder.append(", buildLabel=");
        builder.append(this.buildLabel);
        builder.append(", buildType=");
        builder.append(this.buildType);
        builder.append(", repositoryAddress=");
        builder.append(this.repositoryAddress);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildEngineHostName == null ? 0 : this.buildEngineHostName.hashCode());
        result = 31 * result + (this.buildEngineId == null ? 0 : this.buildEngineId.hashCode());
        result = 31 * result + (this.buildLabel == null ? 0 : this.buildLabel.hashCode());
        result = 31 * result + (this.buildType == null ? 0 : this.buildType.hashCode());
        result = 31 * result + (this.repositoryAddress == null ? 0 : this.repositoryAddress.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildInformation other = (BuildInformation)obj;
        if (this.buildEngineHostName == null ? other.buildEngineHostName != null : !this.buildEngineHostName.equals(other.buildEngineHostName)) {
            return false;
        }
        if (this.buildEngineId == null ? other.buildEngineId != null : !this.buildEngineId.equals(other.buildEngineId)) {
            return false;
        }
        if (this.buildLabel == null ? other.buildLabel != null : !this.buildLabel.equals(other.buildLabel)) {
            return false;
        }
        if (this.buildType == null ? other.buildType != null : !this.buildType.equals(other.buildType)) {
            return false;
        }
        if (this.repositoryAddress == null ? other.repositoryAddress != null : !this.repositoryAddress.equals(other.repositoryAddress)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

