/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInteger
extends IfxObject {
    private int value;
    public static final int IFX_INT_NULL = Integer.MIN_VALUE;

    IfxInteger() {
        this.setIfxType(2);
    }

    public IfxInteger(int i) {
        this.value = i;
        this.setIfxType(2);
        this.unnullify();
    }

    IfxInteger(Integer I) {
        this.value = I;
        this.setIfxType(2);
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[]{-128, 0, 0, 0};
            return b;
        }
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        this.value = IfxToJavaType.IfxToJavaInt(b, offset);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromInt(int val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long val) throws SQLException {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    @Override
    public void fromLong(Long val) throws SQLException {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.clearWarning();
        this.value = (int)val;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        this.clearWarning();
        if (val == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = val.intValue();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    @Override
    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    @Override
    public void fromBoolean(boolean val) throws SQLException {
        this.value = val ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.value);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null || str == "") {
            this.nullify();
        } else {
            this.value = Integer.valueOf(str.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxInteger && this.value == ((IfxInteger)other).value;
    }

    @Override
    public short getEncodedLength() {
        short encodedLength = 2560;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "IfxInteger ecodedLength = " + encodedLength);
        }
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Integer.MIN_VALUE;
    }
}

