/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected static final short MODE_READ_WRITE = 0;
    protected static final short MODE_RW_BUFF = 1;
    protected static final short MODE_CLIENT_ONLY = 2;
    protected IfxSmartBlob smb = null;
    protected IfxLocator locatorPointer = null;
    protected IfxConnection conn = null;
    protected boolean isBlob_loaded = false;
    protected IfxTmpFile tempBlobFile = null;
    protected InputStream blobStream = null;
    protected byte[] blobBuffer = null;
    protected String BlobFileName;
    protected long blobSize = 0L;
    protected short ifxType;
    private boolean isFreed = false;
    protected int smartBlobMode = 0;

    protected IfxLob() {
    }

    protected IfxLob(IfxConnection con) throws SQLException {
        this.conn = con;
        this.locatorPointer = new IfxLocator(con);
        IfxLobDescriptor loDesc = new IfxLobDescriptor(this.conn);
        this.smb = new IfxSmartBlob(this.conn);
        this.smb.IfxLoCreate(loDesc, 8, this.locatorPointer);
    }

    protected IfxLob(Connection conn, InputStream fin, int length) throws SQLException {
        this.conn = (IfxConnection)conn;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, InputStream fin, int length, String sbspaceName) throws SQLException {
        this.conn = (IfxConnection)conn;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        loDesc.setSbspace(sbspaceName);
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        this.conn = (IfxConnection)conn;
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        this.lobFromBuffer(buffer, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer, String sbspaceName) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        loDesc.setSbspace(sbspaceName);
        this.lobFromBuffer(buffer, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer, IfxLobDescriptor loDesc) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        this.lobFromBuffer(buffer, length, loDesc);
    }

    private void lobFromStream(InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(loDesc, 8, this.locatorPointer);
            if (length > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), fin, length);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException e) {
            this.smb = null;
            throw e;
        }
    }

    private void lobFromBuffer(byte[] buffer, int length, IfxLobDescriptor loDesc) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(loDesc, 8, this.locatorPointer);
            if (length > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), buffer);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException e) {
            this.smb = null;
            throw e;
        }
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.checkIfFreed();
        if (this.smb == null) {
            return this.locatorPointer;
        }
        return this.smb.locator;
    }

    protected void setLocator(IfxLocator locator) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.locator = locator;
        } else {
            this.locatorPointer = locator;
        }
    }

    protected void setIfxLobType(short type) {
        this.ifxType = type;
    }

    protected void setSize(long size) {
        this.blobSize = size;
    }

    protected void setConnection(IfxConnection conn) {
        this.conn = conn;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    protected void setMode(int mode) {
        this.smartBlobMode = mode;
    }

    protected byte[] getBytes() throws SQLException {
        long size = this.smb.IfxLoSize(this.smb.getHandle());
        return this.getPortion(1L, size, size);
    }

    protected byte[] getPortion(long position, long length) throws SQLException {
        if (this.blobBuffer != null) {
            return this.getPortion(position, length, this.blobBuffer.length);
        }
        if (this.tempBlobFile != null) {
            return this.getPortion(position, length, this.blobSize);
        }
        if (this.smb != null) {
            return this.getPortion(position, length, this.smb.IfxLoSize(this.smb.getHandle()));
        }
        return new byte[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPortion(long position, long length, long totalLength) throws SQLException {
        if (position < 1L || length <= 0L) {
            return new byte[0];
        }
        if (length - position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length is greater than Interger.MAX_VALUE");
        }
        if (position > totalLength) {
            throw new IllegalArgumentException("Position cannot be greater than the LOB total length");
        }
        try {
            if (!this.isBlob_loaded) {
                this.loadSmBlob();
            }
        }
        catch (Exception e) {
            return null;
        }
        long pos = position - 1L;
        int len = (int)length;
        if (pos + length > totalLength) {
            len = (int)(totalLength - pos);
        }
        byte[] buffer = new byte[len];
        if (this.blobBuffer != null) {
            System.arraycopy(this.blobBuffer, (int)pos, buffer, 0, len);
            return buffer;
        }
        if (this.tempBlobFile != null) {
            try (InputStream fd = this.tempBlobFile.getInputStream();){
                if (pos > 0L) {
                    fd.skip(pos);
                }
                fd.read(buffer, 0, len);
            }
            catch (Exception e) {
                return null;
            }
            try {
                if (this.ifxType != 3 && this.ifxType != 2) return buffer;
                this.isBlob_loaded = false;
                this.tempBlobFile.close();
                this.tempBlobFile = null;
                return buffer;
            }
            catch (Exception e) {
                return null;
            }
        }
        this.smb.seek(this.smb.getHandle(), pos, 0);
        this.smb.IfxLoRead(this.smb.getHandle(), buffer, len);
        return buffer;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        return this.getStream(0L, -1L);
    }

    protected InputStream getStream(long pos, long length) throws SQLException {
        this.checkIfFreed();
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream lobStream = null;
                lobStream = length == -1L ? (this.blobSize > 0L ? new IfxLobInputStream(this.conn, this.getLocator(), this.blobSize) : new IfxLobInputStream(this.conn, this.getLocator())) : new IfxLobInputStream(this.conn, this.getLocator(), length);
                lobStream.skip(pos);
                return lobStream;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            try {
                return this.tempBlobFile.getInputStream();
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(e, -79716, this.conn);
            }
        }
        return new ByteArrayInputStream(this.blobBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkIfFreed();
        if (pos < 0L) throw IfxErrMsg.getSQLException(-80052, this.conn);
        if (length < 1L) {
            throw IfxErrMsg.getSQLException(-80052, this.conn);
        }
        if (pos > this.blobSize) throw IfxErrMsg.getSQLException(-80052, this.conn);
        if (pos + length > this.blobSize) {
            throw IfxErrMsg.getSQLException(-80052, this.conn);
        }
        try (InputStream iStream = this.getStream();){
            int len = (int)length;
            byte[] b = new byte[len];
            iStream.skip(pos);
            iStream.read(b);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(b, 0, len);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716, this.conn);
        }
    }

    protected void setStream(InputStream fin, int length) throws SQLException {
        this.checkIfFreed();
        this.blobBuffer = null;
        if (length > 0) {
            this.smb.IfxLoWrite(this.smb.getHandle(), fin, length);
        }
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
    }

    protected int setBuffer(byte[] buffer) throws SQLException {
        return this.setBuffer(buffer, 0, buffer == null ? 0 : buffer.length);
    }

    protected int setBuffer(byte[] buffer, int offset, int length) throws SQLException {
        this.checkIfFreed();
        int n = 0;
        if (buffer.length > 0 && length > 0) {
            n = this.smb.IfxLoWrite(this.smb.getHandle(), buffer, offset, length);
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        return n;
    }

    public long seek(long offset, int whence) throws SQLException {
        this.checkIfFreed();
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.seek(this.smb.getHandle(), offset, whence);
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public long where() throws SQLException {
        this.checkIfFreed();
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoTell(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public IfxLoStat getLoStat() throws SQLException {
        this.checkIfFreed();
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoGetStat(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public void truncate(long size) throws SQLException {
        this.checkIfFreed();
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.IfxLoTruncate(this.smb.getHandle(), size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.smb != null && this.smb.getHandle() != -1) {
            IfxConnection ifxConnection = this.conn;
            synchronized (ifxConnection) {
                this.smb.IfxLoClose(this.smb.getHandle());
            }
        }
        this.smb = null;
    }

    protected void loadSmBlob() throws SQLException {
        IfxOutputStream BlobFd = null;
        this.tempBlobFile = null;
        this.blobBuffer = null;
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        if (this.blobSize == 0L) {
            this.blobBuffer = new byte[0];
            return;
        }
        int bufferSize = this.conn.getBlobCacheSize();
        if (bufferSize < 0 || bufferSize > 0 && this.blobSize <= (long)bufferSize) {
            this.blobBuffer = new byte[(int)this.blobSize];
        } else {
            try {
                this.tempBlobFile = new IfxTmpFile(this.conn);
                BlobFd = this.tempBlobFile.getOutputStream();
            }
            catch (Exception e) {
                if (bufferSize == 0) {
                    throw IfxErrMsg.getSQLException(e, -79774, this.conn);
                }
                this.blobBuffer = new byte[(int)this.blobSize];
                BlobFd = null;
                this.tempBlobFile = null;
            }
        }
        try {
            if (this.blobBuffer == null) {
                this.smb.seek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), BlobFd, (int)this.blobSize);
                ((OutputStream)BlobFd).close();
            } else {
                this.smb.seek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), this.blobBuffer, (int)this.blobSize);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716, this.conn);
        }
        this.isBlob_loaded = true;
    }

    protected void verifySmbMode() throws SQLException {
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
    }

    protected void free() throws SQLException {
        try {
            this.close();
            if (this.locatorPointer != null) {
                this.locatorPointer.free();
            }
            if (this.tempBlobFile != null) {
                this.tempBlobFile.close();
            }
            if (this.blobStream != null) {
                this.blobStream.close();
            }
            if (this.blobBuffer != null) {
                this.blobBuffer = null;
            }
            this.isFreed = true;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    protected void checkIfFreed() throws SQLException {
        if (this.isFreed) {
            throw IfxErrMsg.getSQLException(-80051, this.conn);
        }
    }
}

