/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxPreparedStatement;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxNativeSQL;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxParameterMetaData;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.lang.IfxSQLType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxByteArrayOutputStream;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxPreparedStatement
extends IfxStatement
implements IfmxPreparedStatement {
    private static final Object logger = Trace.getLoggerForClass(IfxPreparedStatement.class);
    String baseStatement = null;
    protected Vector<IfxObject> vector = new Vector();
    IfxResultSetMetaData rsmd = null;
    private boolean canUsePut = false;
    private boolean isPrepared = false;
    private boolean usePut = false;
    private IfxByteArrayOutputStream bStream = null;
    int batchCount = 0;
    private static final int ONE = 1;
    private static final int MAX_CHARCOL_SIZE = Short.MAX_VALUE;
    private int[] putIndexArray;
    private int curRow = 0;
    private int numRowsCurrBatch = 0;
    private Vector<IfxObject> textObjArray = new Vector();
    private int textObjArrayIdx;
    private IfxResultSetMetaData outputRsmd = null;
    private boolean calledexecuteQuery = false;
    private static final int INIT_IDX_SIZE = 1000;
    private static final int INC_IDX_SIZE = 1000;
    int inputvals;
    boolean hasOutParameter = false;
    protected long ordinalCalls = 0L;
    protected long namedCalls = 0L;
    IfxResultSetMetaData inputParamMeta = null;
    private static String cstr = null;

    static void initializeCstr() {
        char[] bstr = new char[Short.MAX_VALUE];
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            bstr[i] = 32;
        }
        cstr = new String(bstr);
    }

    IfxPreparedStatement(IfxConnection myconn) throws SQLException {
        super(myconn);
        this.poolable = true;
    }

    IfxPreparedStatement(IfxConnection myconn, String sql) throws SQLException {
        super(myconn);
        this.processSQL(myconn, sql);
        this.poolable = true;
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, int autoGeneratedKeys) throws SQLException {
        super(myconn);
        if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement(String, int)invalid return generated key value");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxPreparedStatement(String, int)", this.jconn);
        }
        this.processSQL(myconn, sql);
        this.poolable = true;
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, int[] columnIndexes) throws SQLException {
        super(myconn);
        if (columnIndexes == null || columnIndexes.length <= 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement(String, int[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxPreparedStatement(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        this.processSQL(myconn, sql);
        this.poolable = true;
    }

    IfxPreparedStatement(IfxConnection myconn, String sql, String[] columnNames) throws SQLException {
        super(myconn);
        if (columnNames == null || columnNames.length <= 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement(String, String[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxPreparedStatement(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        this.processSQL(myconn, sql);
        this.poolable = true;
    }

    void setSqlString(String sql) throws SQLException {
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        this.baseStatement = sql;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        this.commandString = IfxNativeSQL.parseSQLString(this.jconn, sql);
        if (this.numqmarks > 0) {
            this.vector.setSize(this.numqmarks);
        }
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
    }

    private void processSQL(IfxConnection myconn, String sql) throws SQLException {
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, myconn);
        }
        this.baseStatement = sql;
        if (this instanceof IfxCallableStatement) {
            this.setqmarks(this.cntqmarks(sql, "="));
        } else {
            this.setqmarks(this.cntqmarks(sql));
        }
        this.commandString = IfxNativeSQL.parseSQLString(this.jconn, sql);
        this.setupExecutePrepare();
        if (this.BatchVector.size() > 0) {
            this.clearBatch();
        }
        this.calledexecuteQuery = false;
    }

    void setupExecutePrepare() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setupPrepare()");
        }
        this.isPrepared = true;
        this.prot.executePrepare(this);
        if (this.numqmarks > 0 && !this.executeBatchInProgress) {
            this.vector.setSize(this.numqmarks);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "Stetement Type: " + this.getStatementType());
            this.trace.writeTrace(logger, 2, "numqmarks: " + this.numqmarks);
            this.trace.writeTrace(logger, 2, "columnCount: " + this.rsmd.getColumnCount());
            this.trace.writeTrace(logger, 2, "((IfxSqliConnect)jconn).getUsePut(): " + ((IfxSqliConnect)this.jconn).getUsePut());
        }
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).getUsePut() && this.getStatementType() == 6 && this.numqmarks == this.rsmd.getColumnCount()) {
            this.canUsePut = true;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement: canUsePut is set to true");
            }
            this.outputRsmd = new IfxResultSetMetaData(this.rsmd);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "canUsePut value: " + this.canUsePut + ", numqmarks: " + this.numqmarks + ", rsmd.getColumnCount(): " + this.rsmd.getColumnCount());
        }
    }

    Vector<IfxObject> getVector() {
        return this.vector;
    }

    List<IfxObject> getBatchParamVector() {
        return this.BatchParamVector;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.calledexecuteQuery = true;
        return this.executeQueryImpl(this.isRsHoldable(), false);
    }

    @Override
    public ResultSet executeQuery(boolean withHold) throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.calledexecuteQuery = true;
        return this.executeQueryImpl(withHold, false);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        return this.executeUpdateImpl();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.isRsHoldable());
    }

    boolean execute(boolean holdable) throws SQLException {
        if (this.jconn == null || this.jconn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.calledexecuteQuery = true;
        return this.executeImpl(holdable, false);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, int returnKeys) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public ResultSet executeQuery(String sql, boolean withhold) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, int returnKeys) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw IfxErrMsg.getSQLException(-79729, this.jconn);
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.get(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setNull: obj reused");
                }
                val.clear();
            } else {
                val = IfxValue.makeInstance(this.jconn, this.getColumnInfo(i), sqlType);
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setNull for " + i + " type: " + val.getClass().getName());
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setNull(int i, int sqlType, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.get(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setNull: obj reused");
                }
                val.clear();
            } else {
                val = ifxType == 14 ? IfxValue.makeInstanceFromIfxType(this.jconn, ifxType, "YM") : IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setNull(int i, int sqlType, String name) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setNull: obj reused");
                }
                val.clear();
            } else {
                val = IfxValue.makeInstance(this.jconn, this.getColumnInfo(i), sqlType, name);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    protected void setNull(int i, int sqlType, int ifxType, String name) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setNull: obj reused");
                }
                val.clear();
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.setExtendedTypeName(name);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBigDecimal: obj reused");
                }
                val.clear();
                val.fromDecimal(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x, int ifxType) throws SQLException {
        this.setBigDecimal(i, x);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBoolean: obj reused");
                }
                val.clear();
                val.fromBoolean(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBoolean() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBoolean() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBoolean(int i, boolean x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBoolean: obj reused");
                }
                val.clear();
                val.fromBoolean(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBoolean(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBoolean() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setByte: obj reused");
                }
                val.clear();
                val.fromByte(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setByte() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setByte() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setByte(int i, byte x, int ifxType) throws SQLException {
        this.setByte(i, x);
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setShort: obj reused");
                }
                val.clear();
                val.fromShort(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setShort() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setShort() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setShort(int i, short x, int ifxType) throws SQLException {
        this.setShort(i, x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut || this.canUsePut) {
                if (val == null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "setInt: calling makeInstance()");
                    }
                    val = IfxValue.makeInstance(this.jconn, this.getColumnInfo(i));
                    val.fromInt(x);
                    this.set(i, val);
                } else {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "setInt: obj reused");
                    }
                    val.fromInt(x);
                }
            } else {
                this.set(i, new IfxInteger(x));
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setInt() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setInt() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setInt(int i, int x, int ifxType) throws SQLException {
        this.setInt(i, x);
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setLong: obj reused");
                }
                val.clear();
                val.fromLong(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setLong() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setLong() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setLong(int i, long x, int ifxType) throws SQLException {
        this.setLong(i, x);
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setFloat: obj reused");
                }
                val.clear();
                val.fromFloat(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setFloat() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setFloat() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setFloat(int i, float x, int ifxType) throws SQLException {
        this.setFloat(i, x);
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setDouble: obj reused");
                }
                val.clear();
                val.fromDouble(x);
            } else {
                val = !this.hasOutParameter ? IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i)) : IfxValue.makeInstance(this.jconn, x, null);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setDouble() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setDouble() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setDouble(int i, double x, int ifxType) throws SQLException {
        this.setDouble(i, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "IfxPreparedStatement.setString() entered");
                this.trace.writeTrace(logger, 2, "usePut is: " + this.usePut);
                this.trace.writeTrace(logger, 2, "i: " + i + "numqmarks: " + this.numqmarks);
            }
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setString: obj reused");
                }
                val.clear();
                val.fromString(x);
            } else {
                IfxColumnInfo ci = this.getColumnInfo(i);
                val = this.usePut || ci != null && (ci.SQLtype == 12 || ci.SQLtype > 18) ? IfxValue.makeInstance(this.jconn, x, ci) : IfxValue.makeInstance(this.jconn, x, null);
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setString()-- " + val.getClass().getName());
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setString() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setString() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement.setString() exited");
        }
    }

    @Override
    public void setString(int i, String x, int ifxType) throws SQLException {
        if (ifxType == 46 || ifxType == 43 || ifxType == 13) {
            try {
                this.checkParameterIndex(i, this.numqmarks);
                IfxObject val = this.vector.elementAt(i - 1);
                if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "setString: obj reused");
                    }
                    val.clear();
                    val.fromString(x);
                }
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromString(x);
                this.set(i, val);
            }
            catch (SQLException e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setString() exception");
                }
                throw e;
            }
            catch (Exception e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setString() exception");
                }
                throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
            }
        } else {
            this.setString(i, x);
        }
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBytes: obj reused");
                }
                val.clear();
                val.fromBytes(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBytes() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBytes() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBytes(int i, byte[] x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBytes: obj reused");
                }
                val.clear();
                val.fromBytes(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBytes(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNull() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setDate: obj reused");
                }
                val.clear();
                val.fromDate(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setDate() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setDate() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setDate(int i, Date x, int ifxType) throws SQLException {
        this.setDate(i, x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setTime: obj reused");
                }
                val.clear();
                val.fromTime(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setTime() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setTime() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setTime(int i, Time x, int ifxType) throws SQLException {
        this.setTime(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setTimestamp: obj reused");
                }
                val.clear();
                val.fromTimestamp(x);
            } else {
                IfxColumnInfo colInfo = this.getColumnInfo(i);
                val = IfxValue.makeInstance(this.jconn, x, colInfo);
                if (!(this.statementType != 6 && this.statementType != 4 || this.usePut || val.ifxType != 10 || colInfo == null || this.jconn.isDirect())) {
                    IfxDateTime dt = (IfxDateTime)val;
                    byte dataDefEndCode = IfxDateTime.getEndCode(dt.getEncodedLength());
                    byte colDefEndCode = IfxDateTime.getEndCode((short)colInfo.ColLength);
                    if (dt.truncateDataForPut(colDefEndCode)) {
                        this.chainWarnings(new DataTruncation(i, true, true, dataDefEndCode, colDefEndCode));
                    }
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setTimestamp()exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setTimestamp()exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x, int ifxType) throws SQLException {
        this.setTimestamp(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setAsciiStream: obj reused");
                }
                val.clear();
                val.fromAsciiStream(x, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setAsciiStream(): length = ", length);
                }
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromAsciiStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setUnicodeStream(int,InputStream,int).", this.jconn);
    }

    @Override
    public void setBinaryStream(int paramterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(paramterIndex, x, length, -1);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length, int ifxType) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (x == null) {
            IfxObject val = this.vector.elementAt(i - 1);
            if (val == null) {
                this.setNull(i, -2);
            } else {
                this.setNull(i, val.getJDBCType());
            }
            return;
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBinaryStream: obj reused");
                }
                val.clear();
                val.fromBinaryStream(x, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setBinaryStream(): length = ", length);
                }
                val = ifxType < 0 ? IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i)) : IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBinaryStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setInterval(int i, Interval x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (x instanceof IntervalYM) {
            this.setIntervalYM(i, (IntervalYM)x);
        } else if (x instanceof IntervalDF) {
            this.setIntervalDF(i, (IntervalDF)x);
        }
    }

    @Override
    public void setIntervalYM(int i, IntervalYM x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setIntervalYM: obj reused");
                }
                val.clear();
                val.fromIntervalYM(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIntervalYM() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIntervalYM() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setIntervalDF(int i, IntervalDF x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setIntervalDF: obj reused");
                }
                val.clear();
                val.fromIntervalDF(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIfxIntervalDF() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIntervalDF() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.vector = new Vector();
            this.vector.setSize(this.numqmarks);
            this.inputvals = 0;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement.setObject(int, Object, targetSQLType, scale entered");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            IfxColumnInfo colinfo = this.getColumnInfo(i);
            if (colinfo != null) {
                String str = colinfo.ExtendedName;
                String afterToken = "";
                int index = str.indexOf(40);
                if (index > 0) {
                    str = str.substring(index + 1, str.length() - 1);
                    StringTokenizer strToken = new StringTokenizer(str);
                    while (strToken.hasMoreElements()) {
                        afterToken = strToken.nextToken();
                        if (afterToken.equalsIgnoreCase("int8") || afterToken.equalsIgnoreCase("serial8")) {
                            this.jconn.setIsBigInt(false);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (afterToken.equalsIgnoreCase("bigint")) {
                            this.jconn.setIsBigInt(true);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (!afterToken.equalsIgnoreCase("bigserial")) continue;
                        this.jconn.setIsBigInt(false);
                        this.jconn.setIsBigSerial(true);
                        break;
                    }
                }
            }
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setObject: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                DataTruncation dt;
                if (targetSqlType == 6 && !this.jconn.getMapFloat()) {
                    targetSqlType = 7;
                }
                val = targetSqlType == 2001 || targetSqlType == 2000 || targetSqlType == -1 || targetSqlType == -5 ? IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i), scale, targetSqlType) : IfxValue.makeInstance(this.jconn, x, null, scale, targetSqlType);
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception: ");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement.setObject(int, Object, targetSQLType, scale exited");
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement.setObject(int, Object, targetSQLType");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            IfxColumnInfo colinfo = this.getColumnInfo(i);
            if (colinfo != null) {
                String str = colinfo.ExtendedName;
                String afterToken = "";
                int index = str.indexOf(40);
                if (index > 0) {
                    str = str.substring(index + 1, str.length() - 1);
                    StringTokenizer strToken = new StringTokenizer(str);
                    while (strToken.hasMoreElements()) {
                        afterToken = strToken.nextToken();
                        if (afterToken.equalsIgnoreCase("int8") || afterToken.equalsIgnoreCase("serial8")) {
                            this.jconn.setIsBigInt(false);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (afterToken.equalsIgnoreCase("bigint")) {
                            this.jconn.setIsBigInt(true);
                            this.jconn.setIsBigSerial(false);
                            break;
                        }
                        if (!afterToken.equalsIgnoreCase("bigserial")) continue;
                        this.jconn.setIsBigInt(false);
                        this.jconn.setIsBigSerial(true);
                        break;
                    }
                }
            }
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setObject: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                DataTruncation dt;
                boolean mapFloat = this.jconn.getMapFloat();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object, int) called");
                    this.trace.writeTrace(logger, 3, "    setObject(): col # = ", i);
                    this.trace.writeTrace(logger, 3, "    setObject(): type = ", targetSqlType);
                    if (x == null) {
                        this.trace.writeTrace(logger, 3, "    object is null");
                    } else {
                        this.trace.writeTrace(logger, 3, "    object type is" + x.getClass().getName());
                    }
                    this.trace.writeTrace(logger, 3, "    mapFloat = " + mapFloat);
                }
                if (targetSqlType == 6 && !mapFloat) {
                    targetSqlType = 7;
                }
                if (targetSqlType == 2001 || targetSqlType == 2000 || targetSqlType == -1 || targetSqlType == -5) {
                    val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i), targetSqlType);
                } else {
                    val = IfxValue.makeInstance(this.jconn, x, null, targetSqlType);
                    if (x instanceof Integer) {
                        val = new IfxInteger((Integer)((Number)x).intValue());
                    }
                }
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after makeInstance");
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() before set");
                }
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after set");
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception: " + e.toString());
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object, targetSQLType) leaving");
        }
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object) entered");
            if (x != null) {
                this.trace.writeTrace(logger, 3, "    setObject() Class name = ", x.getClass().getName());
            }
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setObject: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                DataTruncation dt;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() before makeInstance");
                    if (x != null) {
                        this.trace.writeTrace(logger, 3, "    object type is" + x.getClass().getName());
                    }
                }
                IfxColumnInfo ifxColumnInfo = this.getColumnInfo(i);
                val = IfxValue.makeInstance(this.jconn, x, ifxColumnInfo);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after makeInstance");
                }
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() before set");
                }
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, " after fromObject, val = " + val.toString());
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after set");
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object) leaving");
        }
    }

    protected void setObject(int i, Object x, String name) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object, name) entered");
            if (x != null) {
                this.trace.writeTrace(logger, 3, "    setObject() Class name = ", x.getClass().getName());
            }
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setObject: obj reused");
                }
                val.clear();
                val.fromObject(x, name);
            } else {
                DataTruncation dt;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() before makeInstance");
                    if (x != null) {
                        this.trace.writeTrace(logger, 3, "    object type is" + x.getClass().getName());
                    }
                }
                val = IfxValue.makeInstance(this.jconn, x, name, this.getColumnInfo(i));
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after makeInstance");
                }
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() before set");
                }
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, " after fromObject, val = " + val.toString());
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setObject() after set");
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setObject() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setObject(int, Object) leaving");
        }
    }

    @Override
    public void IfxSetObject(int i, Object x, int scale, int ifxType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:IfxSetObject(int, Object, scale, ifxType) entered");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSetObject: obj reused");
                }
                val.clear();
                val.fromObject(x, scale);
            } else {
                DataTruncation dt;
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x, scale);
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:IfxSetObject() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:IfxSetObject() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:IfxSetObject(int, Object, scale, ifxType) exited");
        }
    }

    @Override
    public void IfxSetObject(int i, Object x, int ifxType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:IfxSetObject(int, Object, ifxType) entered");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxSetObject: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                val.fromObject(x);
                DataTruncation dt = val.getWarning();
                if (dt != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:IfxSetObject() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:IfxSetObject() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:IfxSetObject(int, Object, ifxType) entered");
        }
    }

    void set(int i, IfxObject v) throws SQLException {
        boolean hadvalue = false;
        int index = i;
        IfxObject obj = this.vector.elementAt(index - 1);
        if (!(obj == null || this.usePut && obj instanceof IfxBlob)) {
            obj = null;
            hadvalue = true;
        }
        this.vector.setElementAt(v, index - 1);
        if (!hadvalue) {
            ++this.inputvals;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "set, inputvals: " + this.inputvals);
            this.trace.writeTrace(logger, 3, "canUsePut: " + this.canUsePut);
        }
        if (this.canUsePut) {
            if (this.rsmd.needSvrConv(i)) {
                this.setIfxColumnInfo(i, v);
            }
            if (this.rsmd.isDistinct(i) && v.ifxType == 46) {
                this.setIfxColumnInfo(i, v);
                this.outputRsmd.setSourceType(i, v.extendedID);
            }
        }
    }

    protected void checkParameterIndex(int i, int qmarks) throws SQLException {
        if (i > qmarks || i < 1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "IfxPreparedStatement: set() index of input values exceeds qmarks");
            }
            throw IfxErrMsg.getSQLException(-79749, this.jconn);
        }
        ++this.ordinalCalls;
        if (this.namedCalls != this.ordinalCalls && this.namedCalls != 0L) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "IfxPreparedStatement: specifying parameters by both names and ordinals");
            }
            throw IfxErrMsg.getSQLException(-79888, this.jconn);
        }
    }

    private int cntqmarks(String s) {
        return this.cntqmarks(s, null);
    }

    private int cntqmarks(String s, String separator) {
        int sepIdx;
        s = this.parsedSql(s);
        if (separator != null && (sepIdx = s.indexOf(separator)) != -1) {
            s = s.substring(sepIdx);
        }
        boolean S_NORMAL = false;
        boolean S_SINGLE_QUOTES = true;
        int S_DBL_QUOTES = 2;
        int S_ERROR = 3;
        int scanState = 0;
        int numQmarks = 0;
        block16: for (int scanIdx = 0; scanIdx < s.length() && scanState != 3; ++scanIdx) {
            char chr = s.charAt(scanIdx);
            int nextChr = 32;
            if (scanIdx + 1 < s.length()) {
                nextChr = s.charAt(scanIdx + 1);
            }
            switch (scanState) {
                case 0: {
                    switch (chr) {
                        case '?': {
                            ++numQmarks;
                            continue block16;
                        }
                        case '\'': {
                            scanState = 1;
                            continue block16;
                        }
                        case '\"': {
                            scanState = 2;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    switch (chr) {
                        case '\'': {
                            if (nextChr == 39) {
                                ++scanIdx;
                                continue block16;
                            }
                            scanState = 0;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 2: {
                    switch (chr) {
                        case '\"': {
                            if (nextChr == 34) {
                                ++scanIdx;
                                continue block16;
                            }
                            scanState = 0;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                default: {
                    scanState = 3;
                }
            }
        }
        if (scanState != 0) {
            scanState = 3;
        }
        if (TraceFlag.isTraceEnabled()) {
            if (scanState == 3) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:total cntqmarks(): Query format if incorrect");
            }
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:total cntqmarks(): is " + numQmarks);
        }
        return numQmarks;
    }

    private String parsedSql(String s) {
        char nextchr;
        char chr;
        int scanIdx;
        boolean start_comment_found = false;
        boolean end_comment_found = false;
        int startIdx = 0;
        int endIdx = 0;
        for (scanIdx = 0; scanIdx < s.length() - 1; ++scanIdx) {
            chr = s.charAt(scanIdx);
            nextchr = s.charAt(scanIdx + 1);
            if (chr != '/' || nextchr != '*') continue;
            start_comment_found = true;
            startIdx = scanIdx;
            break;
        }
        if (start_comment_found) {
            for (scanIdx = startIdx + 2; scanIdx < s.length() - 1; ++scanIdx) {
                chr = s.charAt(scanIdx);
                nextchr = s.charAt(scanIdx + 1);
                if (chr != '*' || nextchr != '/') continue;
                endIdx = scanIdx;
                end_comment_found = true;
                break;
            }
        }
        if (start_comment_found && end_comment_found) {
            return s.substring(0, startIdx) + s.substring(endIdx + 2);
        }
        return s;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.addBatch(String).", this.jconn);
    }

    @Override
    public void addBatch() throws SQLException {
        int blob_rec_cnt = 0;
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:addBatch()");
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        if (this.hasOutParameter) {
            throw IfxErrMsg.getSQLException(-79820, this.jconn);
        }
        if (!this.canUsePut) {
            if (this.currentResult != null && !((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                this.currentResult.closePrev();
                this.currentResult = null;
            }
            this.commandString = this.commandString.trim();
            if (!this.commandString.endsWith(";")) {
                this.commandString = this.commandString + ";";
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:commandString is " + this.commandString);
            }
            this.BatchVector.addElement(this.commandString);
            if (this.jconn.isDirect()) {
                int inputcount = this.vector.size();
                for (int i = inputcount - this.numqmarks; i < inputcount; ++i) {
                    this.BatchParamVector.addElement(this.vector.get(i));
                }
                return;
            }
            IfxObject ival = null;
            for (int i = 0; i < this.numqmarks; ++i) {
                ival = this.vector.get(i);
                if (!(ival != null || this instanceof IfxCallableStatement && this.namedCalls != 0L && this.inputParamMeta.hasDefaultValue(i + 1))) {
                    throw IfxErrMsg.getSQLException(-79823, "index = " + (i + 1), this.jconn);
                }
                this.BatchParamVector.add(ival);
            }
        } else {
            IfxObject ival;
            int i;
            if (!this.usePut) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "initialize structures for usePut");
                }
                this.usePut = true;
                this.bStream = new IfxByteArrayOutputStream(((IfxSqli)this.prot).getTupleBufferSize(this.getFetchSize()));
                this.batchCount = 0;
                if (this.rsmd.hasVariableLengthColumns || this.rsmd.textByteColumnCount > 0) {
                    this.putIndexArray = new int[1000];
                    this.putIndexArray[0] = 0;
                }
                if (this.rsmd.textByteColumnCount > 0) {
                    this.textObjArray.setSize(100);
                    this.textObjArrayIdx = 0;
                }
                for (i = 0; i < this.inputvals; ++i) {
                    int ifxTargetType;
                    ival = this.vector.get(i);
                    int ifxSourceType = ival.getIfxType();
                    if (ifxSourceType != 0 || ifxSourceType == (ifxTargetType = this.rsmd.getIfxColumnType(i + 1))) continue;
                    IfxObject newVal = IfxValue.makeInstance(this.jconn, ival.toString(), this.rsmd.getColumnInfo(i + 1));
                    if (this.rsmd.isDistinct(i + 1) && newVal.extendedID == 1) {
                        this.outputRsmd.setExtendedOwnerName(i + 1, "informix");
                    }
                    this.set(i + 1, newVal);
                    this.vector.setElementAt(newVal, i);
                }
            }
            if (this.inputvals != this.numqmarks) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "IfxPrepStmt: number of input values(" + this.inputvals + ") does not match qmarks(" + this.numqmarks + ")");
                }
                throw IfxErrMsg.getSQLException(-79749, this.jconn);
            }
            for (i = 0; i < this.inputvals; ++i) {
                ival = this.vector.get(i);
                int type = this.outputRsmd.getIfxColumnType(i + 1);
                if (ival instanceof IfxBlob) {
                    ++blob_rec_cnt;
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "Instance is: " + ival.getClass().getName());
                    this.trace.writeTrace(logger, 2, "Column type is: " + type);
                }
                switch (type) {
                    case 0: 
                    case 13: 
                    case 15: 
                    case 16: {
                        String s = ival.toString();
                        if (s == null && this.outputRsmd.getColumnLength(i + 1) == 1 && !this.rsmd.hasVariableLengthColumns && this.rsmd.textByteColumnCount <= 0) {
                            ival.fromString(" ");
                        }
                        if (s == null) break;
                        String str = s;
                        int colLen = this.outputRsmd.getColumnLength(i + 1);
                        if (s.length() > colLen && this.jconn.isANSI()) {
                            throw IfxErrMsg.getSQLException(-1279, this.jconn);
                        }
                        if ((type == 13 || type == 16) && ((IfxSqliConnect)this.jconn).isVarcharVarLenSupported()) {
                            if (s.length() > colLen) {
                                str = s.substring(0, colLen);
                            }
                        } else if (s.length() > colLen) {
                            str = s.substring(0, colLen);
                        } else {
                            if (cstr == null) {
                                IfxPreparedStatement.initializeCstr();
                            }
                            str = str + cstr.substring(0, colLen - str.length());
                        }
                        ival.fromString(str);
                        if (!TraceFlag.isTraceEnabled()) break;
                        this.trace.writeTrace(logger, 1, "colLen: " + colLen);
                        this.trace.writeTrace(logger, 1, "ival: " + ival.toString());
                        break;
                    }
                    case 11: 
                    case 12: {
                        if (this.textObjArray.size() <= this.textObjArrayIdx) {
                            this.textObjArray.setSize(this.textObjArrayIdx + 100);
                        }
                        if (((IfxBlob)ival).isBlobLoaded() || ival.isNull()) {
                            this.textObjArray.setElementAt(null, this.textObjArrayIdx++);
                            break;
                        }
                        this.textObjArray.setElementAt(ival, this.textObjArrayIdx++);
                        if (!TraceFlag.isTraceEnabled()) break;
                        this.trace.writeTrace(logger, 2, "textObjArrayIdx: " + this.textObjArrayIdx);
                        break;
                    }
                }
                short len = (short)this.outputRsmd.getEncodedLength(i + 1);
                ival.setEncodedLength(len);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "len: " + len);
                }
                byte[] bData = ival.toIfxTuple();
                this.bStream.write(bData, 0, bData.length);
                if (!this.rsmd.hasVariableLengthColumns && this.rsmd.textByteColumnCount <= 0) {
                    int startPos = this.outputRsmd.getColumnStartPosition(i + 1);
                    int colLength = 0;
                    colLength = i + 1 < this.inputvals ? this.outputRsmd.getColumnStartPosition(i + 2) - startPos : this.rsmd.getTupleSize() - startPos;
                    for (int j = bData.length; j < colLength; ++j) {
                        this.bStream.write(0);
                    }
                }
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 2, bData.length + " bytes written to put buffer");
            }
            if (this.outputRsmd.hasVariableLengthColumns || this.outputRsmd.textByteColumnCount > 0) {
                if (this.putIndexArray.length < this.batchCount + 2) {
                    int[] temp = new int[this.putIndexArray.length + 1000];
                    System.arraycopy(this.putIndexArray, 0, temp, 0, this.putIndexArray.length);
                    this.putIndexArray = temp;
                }
                this.putIndexArray[++this.batchCount] = this.bStream.getCount();
            } else {
                if ((this.prot.getTupleSize() & 1) >= 1) {
                    this.bStream.write(0);
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "row padded");
                    }
                }
                ++this.batchCount;
            }
            this.inputvals -= blob_rec_cnt;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int retval;
        int[] statusArray = null;
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:executeBatch()");
            this.trace.writeTrace(logger, 2, "usePut value: " + this.usePut + ", numqmarks: " + this.numqmarks + ", rsmd.getColumnCount(): " + this.rsmd.getColumnCount());
        }
        this.executeBatchInProgress = true;
        int outputNumber = 0;
        if (this.rsmd != null) {
            outputNumber = this.rsmd.getColumnCount();
        }
        if (this.statementType == 2 || this.statementType == 56 && outputNumber > 0) {
            SQLException e = IfxErrMsg.getSQLException(-260, this.jconn);
            this.executeBatchInProgress = false;
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
        }
        if (!this.usePut) {
            String cmdString = this.commandString;
            this.commandString = "";
            if (this.currentResult != null && !((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                this.currentResult.closePrev();
                this.currentResult = null;
            }
            if (this.BatchVector.isEmpty()) {
                return new int[0];
            }
            if (this.jconn.isDirect()) {
                this.vector.clear();
                this.vector.addAll(this.BatchParamVector);
                this.BatchParamVector.clear();
            }
            if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                this.commandString = cmdString;
            } else {
                StringBuilder strbuff = new StringBuilder(this.commandString);
                for (int i = 0; i < this.BatchVector.size(); ++i) {
                    strbuff = strbuff.append((String)this.BatchVector.elementAt(i));
                }
                this.commandString = strbuff.toString();
                this.setqmarks(this.cntqmarks(this.commandString));
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxStatement:commandString is " + this.commandString);
                }
                this.inputvals = this.numqmarks;
            }
            if (!((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                this.setupExecutePrepare();
            }
            this.commandString = cmdString;
        } else {
            if (this.batchCount == 0) {
                return new int[0];
            }
            this.curRow = 0;
        }
        if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
            try {
                retval = this.executeUpdateImpl();
            }
            catch (SQLException e) {
                IfxSqli prot = (IfxSqli)this.prot;
                ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
                if (BatchRowStatus != null) {
                    statusArray = new int[BatchRowStatus.size()];
                    for (int k = 0; k < BatchRowStatus.size(); ++k) {
                        statusArray[k] = BatchRowStatus.get(k);
                    }
                    prot.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray, e.getCause());
                }
                statusArray = new int[prot.getPutErrRowCount()];
                for (int k = 0; k < statusArray.length; ++k) {
                    statusArray[k] = 1;
                }
                prot.clearPutErrRowCount();
                this.clearBatch();
                throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray, e.getCause());
            }
        }
        try {
            retval = this.executeUpdateImpl();
        }
        catch (SQLException e) {
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0], e.getCause());
        }
        if (this.jconn.isDirect()) {
            statusArray = new int[this.BatchVector.size()];
            statusArray[0] = retval;
            for (int k = 1; k < this.BatchVector.size(); ++k) {
                statusArray[k] = -2;
            }
            this.clearBatch();
            this.executeBatchInProgress = false;
            return statusArray;
        }
        IfxSqli prot = (IfxSqli)this.prot;
        ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
        if (!this.usePut) {
            int k;
            if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                if (BatchRowStatus != null) {
                    statusArray = new int[BatchRowStatus.size()];
                    for (k = 0; k < BatchRowStatus.size(); ++k) {
                        statusArray[k] = BatchRowStatus.get(k);
                    }
                }
            } else {
                statusArray = new int[this.BatchVector.size()];
                statusArray[0] = retval;
                for (k = 1; k < this.BatchVector.size(); ++k) {
                    statusArray[k] = -2;
                }
            }
        } else {
            int k;
            statusArray = new int[this.batchCount];
            int rowCount = 0;
            for (k = 0; k < BatchRowStatus.size(); ++k) {
                rowCount += BatchRowStatus.get(k).intValue();
            }
            statusArray[0] = rowCount;
            for (k = 1; k < this.batchCount; ++k) {
                statusArray[k] = -2;
            }
        }
        if (BatchRowStatus != null) {
            BatchRowStatus.clear();
        }
        if (!this.usePut && !((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
            this.numqmarks /= this.BatchVector.size();
        }
        this.clearBatch();
        return statusArray;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStatement:clearBatch()");
        }
        if (this.usePut) {
            this.bStream.reset();
            this.batchCount = 0;
            this.curRow = 0;
            this.textObjArrayIdx = 0;
        } else {
            this.BatchVector.clear();
            if (this.vector.size() > this.numqmarks) {
                int i;
                int vsize = this.vector.size();
                for (i = vsize - this.numqmarks; i < vsize; ++i) {
                    IfxObject val = this.vector.get(i);
                    this.vector.setElementAt(val, i + this.numqmarks - vsize);
                }
                for (i = vsize; i > this.numqmarks; --i) {
                    this.vector.removeElementAt(i - 1);
                }
            }
        }
        if (this.BatchParamVector != null) {
            this.BatchParamVector.clear();
        }
        this.scrubBatch();
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setCharacterStream: obj reused");
                }
                val.clear();
                val.fromCharacterStream(x, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setCharacterStream():length = ", length);
                }
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setCharacterStream: obj reused");
                }
                val.clear();
                val.fromCharacterStream(x, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setCharacterStream(): length = ", length);
                }
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromCharacterStream(x, length);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": PreparedStatement.setRef(int,Ref).", this.jconn);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setInt: obj reused");
                }
                val.clear();
                val.fromBlob(x);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setBlob(): length = ", x.length());
                }
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBlob(int i, Blob x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setInt: obj reused");
                }
                val.clear();
                val.fromBlob(x);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setBlob(): length = ", x.length());
                }
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromBlob(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setInt: obj reused");
                }
                val.clear();
                val.fromClob(x);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setClob(): length = ", x.length());
                }
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClob() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClob() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setClob(int i, Clob x, int ifxType) throws SQLException {
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setInt: obj reused");
                }
                val.clear();
                val.fromClob(x);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setClob(): length = ", x.length());
                }
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromClob(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClob() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClob() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setArray() called");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setArray: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, this.getColumnInfo(i));
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() SQLException");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() Exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setArray(int i, Array x, int ifxType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setArray() called");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setArray: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, ifxType);
                val.fromObject(x);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() SQLException");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() Exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    protected void setArray(int i, Array x, String collectionType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxPreparedStatement:setArray() called");
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setArray: obj reused");
                }
                val.clear();
                val.fromObject((Object)x, collectionType);
            } else {
                val = IfxValue.makeInstanceFromIfxType(this.jconn, 21);
                val.fromObject((Object)x, collectionType);
                this.set(i, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() SQLException");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setArray() Exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal, int ifxType) throws SQLException {
        long tm = x.getTime();
        Time gwt = new Time(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTime(parameterIndex, gwt, ifxType);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.rsmd;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Calendar ltc = Calendar.getInstance();
        ltc.setTime(x);
        if (cal == null) {
            cal = ltc;
        }
        long ut = tm + (long)cal.get(15) + (long)cal.get(16);
        long lt = ut - (long)ltc.get(15) - (long)ltc.get(16);
        Date gwt = new Date(lt);
        this.setDate(parameterIndex, gwt);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal, int ifxType) throws SQLException {
        this.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.setTimestamp(parameterIndex, x);
        int indexBatch = this.vector.size() - this.getqmarks() + parameterIndex - 1;
        IfxDateTime val = (IfxDateTime)this.vector.elementAt(indexBatch);
        val.dbCalendar = cal;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal, int ifxType) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        long tm = x.getTime();
        Timestamp gwt = new Timestamp(tm - (long)cal.get(15) - (long)cal.get(16));
        this.setTimestamp(parameterIndex, gwt, ifxType);
    }

    private IfxColumnInfo getColumnInfo(int colindex) throws SQLException {
        if (this.rsmd == null && !this.hasOutParameter && TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:getColumnInfo() statement not prepared");
        }
        if (this.canUsePut) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "outputRsmd used");
                IfxColumnInfo colinfo = this.outputRsmd.getColumnInfo(colindex);
                if (colinfo == null) {
                    this.trace.writeTrace(logger, 2, " colinfo is null");
                    throw IfxErrMsg.getSQLException(-79716, ": IfxPreparedStatement.getColumnInfo()", this.jconn);
                }
                this.trace.writeTrace(logger, 2, " colinfo is not null");
            }
            if (this.outputRsmd.getColumnInfo(colindex) == null) {
                throw IfxErrMsg.getSQLException(-79716, ": IfxPreparedStatement.getColumnInfo()", this.jconn);
            }
            return this.outputRsmd.getColumnInfo(colindex);
        }
        if (!this.jconn.isDirect() && (this.hasOutParameter || ((IfxSqliConnect)this.jconn).isDescribeInputSupported())) {
            try {
                if (this.inputParamMeta == null && !this.hasOutParameter) {
                    this.setInputParameterMetaData();
                    if (this.inputParamMeta == null) {
                        throw IfxErrMsg.getSQLException(-79716, ": IfxPreparedStatement.getColumnInfo()", this.jconn);
                    }
                    if (this.rsmd != null) {
                        for (int i = 1; i <= this.inputParamMeta.getColumnCount() && i <= this.rsmd.getColumnCount(); ++i) {
                            IfxColumnInfo infoFromRsmd = this.rsmd.getColumnInfo(i);
                            IfxColumnInfo infoFromInpmd = this.inputParamMeta.getColumnInfo(i);
                            if (infoFromInpmd.ExtendedName.indexOf("lob") == -1 || !infoFromInpmd.ExtendedName.equals(infoFromRsmd.ExtendedName)) continue;
                            infoFromInpmd.TableName = infoFromRsmd.TableName;
                            infoFromInpmd.ColName = infoFromRsmd.ColName;
                        }
                    }
                }
                if (this.inputParamMeta == null || colindex > this.inputParamMeta.getColumnCount()) {
                    return null;
                }
                IfxColumnInfo columnInfo = this.inputParamMeta.getColumnInfo(colindex);
                if (columnInfo.SQLtype == 51) {
                    columnInfo = null;
                }
                return columnInfo;
            }
            catch (Exception ex) {
                SQLException sqlException = IfxErrMsg.getSQLException(-79716, ex.toString(), this.jconn);
                sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, ex);
                throw sqlException;
            }
        }
        if (this.getStatementType() != 6 && this.getStatementType() != 33 && this.getStatementType() != 7 && this.getStatementType() != 4) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement.getColumnInfo: null returned");
            }
            return null;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "getColumnInfo, colindex is: " + colindex);
            this.trace.writeTrace(logger, 2, "command is: " + this.commandString);
        }
        if (this.rsmd == null || colindex > this.rsmd.getColumnCount()) {
            return null;
        }
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "rsmd used");
                IfxColumnInfo colinfo = this.rsmd.getColumnInfo(colindex);
                if (colinfo == null) {
                    this.trace.writeTrace(logger, 2, " colinfo is null");
                } else {
                    this.trace.writeTrace(logger, 2, " colinfo is not null");
                }
            }
            return this.rsmd.getColumnInfo(colindex);
        }
        catch (SQLException e) {
            return null;
        }
    }

    boolean usePut() {
        return this.usePut;
    }

    byte[] getAllRows() {
        return this.bStream.toByteArray();
    }

    byte[] getNextRow() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "getNextRow() called: " + this.curRow);
        }
        int begin = this.putIndexArray[this.curRow];
        int end = this.putIndexArray[this.curRow + 1];
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "begin: " + begin + " end: " + end);
        }
        ++this.curRow;
        return this.bStream.toByteArray(begin, end - begin);
    }

    byte[] getNextRowBatch(byte[] bData) {
        byte[] currBatchArray = null;
        this.numRowsCurrBatch = 0;
        if (this.curRow >= this.batchCount) {
            return null;
        }
        int bytesPerRow = bData.length / this.batchCount;
        this.numRowsCurrBatch = this.batchCount - this.curRow;
        if (this.numRowsCurrBatch * bytesPerRow > ((IfxSqliConnect)this.jconn).getMaxFetchBufSize()) {
            this.numRowsCurrBatch = (((IfxSqliConnect)this.jconn).isXPSVER8_40() ? Short.MAX_VALUE : ((IfxSqliConnect)this.jconn).getMaxFetchBufSize()) / bytesPerRow;
        }
        if (this.jconn.isXPSVER8_40()) {
            if (this.numRowsCurrBatch > Integer.MAX_VALUE) {
                this.numRowsCurrBatch = Integer.MAX_VALUE;
            }
        } else if (this.numRowsCurrBatch > Short.MAX_VALUE) {
            this.numRowsCurrBatch = Short.MAX_VALUE;
        }
        currBatchArray = this.bStream.toByteArray(this.curRow * bytesPerRow, this.numRowsCurrBatch * bytesPerRow);
        this.curRow += this.numRowsCurrBatch;
        return currBatchArray;
    }

    int getNumRowsCurrBatch() {
        return this.numRowsCurrBatch;
    }

    IfxBlob getIfxBlobAt(int i) {
        return (IfxBlob)this.textObjArray.elementAt(i);
    }

    int getBatchCount() {
        return this.batchCount;
    }

    int getIfxBlobArraySize() {
        return this.textObjArray.size();
    }

    void setIfxColumnInfo(int column, IfxObject obj) throws SQLException {
        this.outputRsmd.setIfxColumnType(column, obj.ifxType);
        this.outputRsmd.setExtendedName(column, obj.extendedName);
        this.outputRsmd.setColumnExtendedId(column, obj.extendedID);
        this.outputRsmd.setEncodedLength(column, obj.encodedLength);
    }

    ResultSetMetaData getOutPutMetaData() {
        return this.outputRsmd;
    }

    @Override
    public void setBindColType(int colIndex, int sqltype) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColType() called. ");
        }
        if (sqltype == 6 && !this.jconn.getMapFloat()) {
            sqltype = 7;
        }
        int ifxtype = IfxTypes.FromJDBCToIfxType(sqltype);
        this.setBindColIfxType(colIndex, ifxtype);
    }

    @Override
    public void setBindColType(int colIndex, int sqltype, int scale) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColType() called. ");
        }
        this.setBindColType(colIndex, sqltype);
    }

    @Override
    public void setBindColIfxType(int colIndex, int ifxtype, int scale) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColIfxType() called. ");
        }
        this.bindAllAttributes(colIndex, ifxtype, scale, "");
    }

    @Override
    public void setBindColType(int colIndex, int sqltype, String name) throws SQLException {
        int ifxtype;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColType() called. ");
        }
        if (name != null && sqltype != 2003 && sqltype != 2000 && sqltype != 2002 && sqltype != 2001) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        if (name == null) {
            throw IfxErrMsg.getSQLException(-79825, this.jconn);
        }
        if (this.ambiguousSQLType(sqltype)) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        if (sqltype == 6 && !this.jconn.getMapFloat()) {
            sqltype = 7;
        }
        if ((ifxtype = IfxTypes.FromJDBCToIfxType(sqltype)) == 49) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        this.bindAllAttributes(colIndex, ifxtype, 0, name);
    }

    @Override
    public void setBindColIfxType(int colIndex, int ifxtype, String name) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColIfxType() called. ");
        }
        if (!IfxTypes.isComplexType(ifxtype) && ifxtype != 40 && ifxtype != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        if (name == null) {
            throw IfxErrMsg.getSQLException(-79825, this.jconn);
        }
        this.bindAllAttributes(colIndex, ifxtype, 0, name);
    }

    @Override
    public void setBindColIfxType(int colIndex, int ifxtype) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBindColIfxType() called. ");
            this.trace.writeTrace(logger, 2, "ifxtype is " + ifxtype);
        }
        this.bindAllAttributes(colIndex, ifxtype, 0, "");
    }

    private void validateBindCol(int colIndex) throws SQLException {
        if (colIndex < 1 || colIndex > this.rsmd.getColumnCount()) {
            throw IfxErrMsg.getSQLException(-79703, this.jconn);
        }
        if (this.getStatementType() != 2) {
            throw IfxErrMsg.getSQLException(-79750, this.jconn);
        }
        if (this.calledexecuteQuery) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "validateBindCol() : currentResult is not null. ");
            }
            throw IfxErrMsg.getSQLException(-79813, this.jconn);
        }
    }

    private void bindAllAttributes(int colIndex, int ifxtype, int scale, String name) throws SQLException {
        int srctype = -1;
        this.validateBindCol(colIndex);
        if (this.outputRsmd == null) {
            this.outputRsmd = new IfxResultSetMetaData(this.rsmd);
        }
        if (this.rsmd.isVariableLengthType(colIndex)) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "bindAllAttributes() : isvariableLength is true");
                this.trace.writeTrace(logger, 99, "bindAllAttributes() : ifxtype is " + ifxtype);
            }
            switch (ifxtype) {
                case 101: {
                    this.outputRsmd.setIfxColumnType(colIndex, ifxtype);
                    this.outputRsmd.setExtendedName(colIndex, "");
                    this.outputRsmd.setColumnExtendedId(colIndex, 11);
                    this.outputRsmd.setEncodedLength(colIndex, 72);
                    srctype = 2;
                    break;
                }
                case 102: {
                    this.outputRsmd.setIfxColumnType(colIndex, ifxtype);
                    this.outputRsmd.setExtendedName(colIndex, "");
                    this.outputRsmd.setColumnExtendedId(colIndex, 10);
                    this.outputRsmd.setEncodedLength(colIndex, 72);
                    srctype = 2;
                    break;
                }
                case 45: {
                    this.outputRsmd.setIfxColumnType(colIndex, 45);
                    this.outputRsmd.setExtendedName(colIndex, "");
                    this.outputRsmd.setColumnExtendedId(colIndex, 5);
                    this.outputRsmd.setEncodedLength(colIndex, 1);
                    srctype = 5;
                    break;
                }
                case 43: {
                    this.outputRsmd.setIfxColumnType(colIndex, 43);
                    this.outputRsmd.setExtendedName(colIndex, "");
                    this.outputRsmd.setColumnExtendedId(colIndex, 1);
                    srctype = 1;
                    break;
                }
                case 40: 
                case 41: {
                    this.outputRsmd.setIfxColumnType(colIndex, ifxtype);
                    this.outputRsmd.setExtendedName(colIndex, name);
                    this.outputRsmd.setColumnExtendedId(colIndex, 2);
                    srctype = 2;
                    break;
                }
                case 46: {
                    this.outputRsmd.setIfxColumnType(colIndex, ifxtype);
                    this.outputRsmd.setColumnExtendedId(colIndex, 3);
                    srctype = 3;
                    break;
                }
                default: {
                    this.outputRsmd.setIfxColumnType(colIndex, ifxtype);
                }
            }
            if (this.rsmd.isDistinct(colIndex)) {
                this.outputRsmd.setSourceType(colIndex, srctype);
            }
            if (scale != 0) {
                this.outputRsmd.setEncodedLength(colIndex, scale);
            }
        }
    }

    protected boolean ambiguousSQLType(int sqltype) {
        return sqltype == 2001 || sqltype == 2000 || sqltype == 0 || sqltype == 2003;
    }

    @Override
    public void clearBindColType() throws SQLException {
        if (this.outputRsmd != null) {
            this.outputRsmd = null;
        }
    }

    public IfxProtocol getResultSetProtocol() {
        return this.prot;
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setURL(int, URL)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxPreparedStatement.setURL(int, URL)", this.jconn);
    }

    private void setInputParameterMetaData() throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.inputParamMeta = this.prot.executeDescribeInput();
    }

    private void setOutputParameterMetaData(String signature, boolean isProc, String procName, int numParams) throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        this.inputParamMeta = this.prot.executeFPDescribe(signature, isProc, procName, numParams);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (((IfxSqliConnect)this.jconn).isDescribeInputSupported()) {
            try {
                if (this.inputParamMeta == null) {
                    this.setInputParameterMetaData();
                }
                return new IfxParameterMetaData(this.inputParamMeta);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception ex) {
                throw IfxErrMsg.getSQLException(ex, -79716, this.jconn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:getParameterMetaData()not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.getParameterMetaData()", this.jconn);
    }

    protected ParameterMetaData getParameterMetaData(String signature, boolean isProc, String procName, int numParams) throws SQLException {
        if (((IfxSqliConnect)this.jconn).isFPDescribeSupported()) {
            try {
                if (this.inputParamMeta == null) {
                    this.setOutputParameterMetaData(signature, isProc, procName, numParams);
                }
                IfxParameterMetaData parameterMetaDataClassInstance = new IfxParameterMetaData(this.inputParamMeta);
                return parameterMetaDataClassInstance;
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -674) {
                    throw ex;
                }
                throw IfxErrMsg.getSQLException(-79700, ": IfxPreparedStatement.getParameterMetaData() " + ex.getErrorCode(), this.jconn);
            }
            catch (Exception ex) {
                throw IfxErrMsg.getSQLException(-79700, ": IfxPreparedStatement.getParameterMetaData()", this.jconn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:getParameterMetaData()not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.getParameterMetaData()", this.jconn);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setAsciiStream: obj reused");
                }
                val.clear();
                val.fromAsciiStream(x, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setAsciiStream(): length = ", length);
                }
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setAsciiStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (x == null) {
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (val == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.setNull(parameterIndex, val.getJDBCType());
            }
            return;
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBinaryStream: obj reused");
                }
                val.clear();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBinaryStream: obj cleared");
                }
                val.fromBinaryStream(x, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, x, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBinaryStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBinaryStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob(int, InputStream ,long)");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (inputStream == null) {
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (val == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.setNull(parameterIndex, val.getJDBCType());
            }
            return;
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBlob: obj reused");
                }
                val.clear();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setBlob: obj cleared");
                }
                val.fromBinaryStream(inputStream, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, inputStream, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setBlob() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxPreparedStatement:setCharacterStream():length = ", length);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setCharacterStream: obj reused");
                }
                val.clear();
                val.fromCharacterStream(reader, length);
            } else {
                val = IfxValue.makeInstance(this.jconn, reader, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setCharacterStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClob(int, Reader)");
        }
        this.setClob(parameterIndex, reader, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(parameterIndex, this.numqmarks);
            IfxObject val = this.vector.elementAt(parameterIndex - 1);
            if (this.usePut && val != null && !(val instanceof IfxBlob)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setClobFromStream: obj reused");
                }
                val.clear();
                val.fromCharacterStream(reader, length);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 99, "setClobFromStream():length = ", length);
                }
                val = IfxValue.makeInstance(this.jconn, reader, length, this.getColumnInfo(parameterIndex));
                this.set(parameterIndex, val);
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "setClobFromStream() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setClobFromStream() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNCharacterStream(int,Reader)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNCharacterStream(int,Reader)", this.jconn);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNCharacterStream(int,Reader,long)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNCharacterStream(int,Reader,long)", this.jconn);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNClob(int,NClob)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,NClob)", this.jconn);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNClob(int,Reader)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,Reader)", this.jconn);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNClob(int,Reader, long)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNClob(int,Reader, long)", this.jconn);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setNString(int,String)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setNString(int,String)", this.jconn);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setRowId(int, RowId)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setRowId(int, RowId)", this.jconn);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setSQLXML(int, SQLXML)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxPreparedStatement.setSQLXML(int, SQLXML)", this.jconn);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw IfxErrMsg.getSQLException(-80053, this.jconn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public void closeCursor() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxPreparedStatement.closeCursor() called");
        }
        if (this.cursorOpen) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "cursor is open");
            }
            this.prot.executeClose(this);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxPreparedStatement.closeCursor() exited");
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeWithKey(null);
    }

    protected void superClose() throws SQLException {
        super.close();
    }

    @Override
    public void setIfxBSONObject(int i, IfxBSONObject x) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            this.checkParameterIndex(i, this.numqmarks);
            IfxObject val = this.vector.elementAt(i - 1);
            if (this.usePut && val != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "setIfxBSONObject: obj reused");
                }
                val.clear();
                val.fromObject(x);
            } else {
                DataTruncation dt;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "    setIfxBSONObject() before makeInstance");
                    if (x != null) {
                        this.trace.writeTrace(logger, 3, "    object type is" + x.getClass().getName());
                    }
                }
                IfxColumnInfo ifxColumnInfo = this.getColumnInfo(i);
                val = IfxValue.makeInstance(this.jconn, (Object)x, ifxColumnInfo);
                if (TraceFlag.isTraceEnabled()) {
                    val.setTrace(this.trace);
                }
                if ((dt = val.getWarning()) != null) {
                    this.chainWarnings(new DataTruncation(i, false, true, dt.getDataSize(), dt.getTransferSize()));
                }
                this.set(i, val);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, " after fromObject, val = " + val.toString());
                }
            }
        }
        catch (SQLException e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIfxBSONObject() exception");
            }
            throw e;
        }
        catch (Exception e) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxPreparedStatement:setIfxBSONObject() exception");
            }
            throw IfxErrMsg.getSQLException(e, -79716, this.jconn);
        }
    }

    @Override
    public ResultSet executeQuery(boolean withHold, boolean withReOptimization) throws SQLException {
        if (!this.isPrepared) {
            throw IfxErrMsg.getSQLException(-79727, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.calledexecuteQuery = true;
        return this.executeQueryImpl(withHold, withReOptimization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String key) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxPreparedStatement.close() called");
        }
        if (this.Closed) {
            return;
        }
        if (!this.poolable || this.pool.getMaximumEntries() == 0) {
            super.close();
            return;
        }
        IfxPreparedStatement previous = null;
        PreparedStatementCache preparedStatementCache = this.pool;
        synchronized (preparedStatementCache) {
            if (this.Closed) {
                return;
            }
            this.clearParameters();
            if (this.currentResult != null) {
                this.currentResult.close();
            }
            if ((previous = this.pool.put(key == null ? this.baseStatement : key, this)) != null && previous != this) {
                previous.setPoolable(false);
            } else {
                previous = null;
            }
        }
        if (previous != null) {
            previous.superClose();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxPreparedStatement.close() exited");
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, this.getSqlType(targetSqlType));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, this.getSqlType(targetSqlType), scaleOrLength);
    }

    int getSqlType(SQLType sqlType) throws SQLException {
        if (sqlType.getVendor().equals(JDBCType.ARRAY.getVendor())) {
            return sqlType.getVendorTypeNumber();
        }
        if (sqlType.getVendor().equals(IfxSQLType.ARRAY.getVendor())) {
            return IfxTypes.FromIfxToJDBCType(sqlType.getVendorTypeNumber());
        }
        throw IfxErrMsg.getSQLException(80504, this.jconn, sqlType.getVendor());
    }
}

