/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLob;
import com.informix.util.IfxByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

class IfxSmartLobOutputStream
extends OutputStream {
    private IfxByteArrayOutputStream buffer;
    private IfxLob ifxLobRef;
    private long currentPosition;

    IfxConnection getConnection() {
        if (this.ifxLobRef != null) {
            return this.ifxLobRef.conn;
        }
        return null;
    }

    IfxSmartLobOutputStream(IfxLob ifxLob, long pos) {
        this.buffer = new IfxByteArrayOutputStream();
        this.ifxLobRef = ifxLob;
        this.currentPosition = pos;
    }

    IfxSmartLobOutputStream(IfxLob ifxLob, int size, long pos) {
        this.buffer = new IfxByteArrayOutputStream(size);
        this.ifxLobRef = ifxLob;
        this.currentPosition = pos;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.getCount() > 0) {
            this.flush();
        }
        super.close();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.setStream(this.currentPosition, new ByteArrayInputStream(this.buffer.getBuffer()), this.buffer.getCount());
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
        this.currentPosition += (long)this.buffer.getCount();
        this.buffer.reset();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }

    private void setStream(long pos, InputStream in, int length) throws SQLException {
        this.ifxLobRef.smb.seek(this.ifxLobRef.smb.getHandle(), pos, 0);
        this.ifxLobRef.setStream(in, length);
    }
}

