/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public class IfxTmpFile {
    private File tempFile = null;
    private String fileName = null;
    private int refCount = 0;
    private final String locale;

    IfxTmpFile(IfxConnection conn) throws SQLException {
        this.locale = conn.getclLocale();
        try {
            File tmpf;
            String tmpDirName = conn.getJDBCTempDir();
            if (tmpDirName == null || tmpDirName.length() == 0) {
                tmpDirName = System.getProperty("user.dir");
            }
            final File tmpDir = new File(tmpDirName);
            this.tempFile = tmpf = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile("IfxTmpFile_", "", tmpDir);
                }
            });
            if (tmpf != null) {
                this.fileName = tmpf.getPath();
                ((IfxSqliConnect)conn).addToFileList(this.tempFile);
            }
        }
        catch (Exception e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.locale);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected synchronized int incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        File fd = new File(IfxTmpFile.this.fileName);
                        fd.delete();
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }

    int length() throws PrivilegedActionException {
        final File tempFileDo = this.tempFile;
        Integer length = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws IOException {
                return (int)tempFileDo.length();
            }
        });
        return length;
    }

    InputStream getInputStream() throws PrivilegedActionException {
        final IfxTmpFile thisDo = this;
        return AccessController.doPrivileged(new PrivilegedExceptionAction<IfxInputStream>(){

            @Override
            public IfxInputStream run() throws IOException {
                IfxInputStream tmpStreamDo = new IfxInputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
    }

    IfxOutputStream getOutputStream() throws PrivilegedActionException {
        final IfxTmpFile thisDo = this;
        return AccessController.doPrivileged(new PrivilegedExceptionAction<IfxOutputStream>(){

            @Override
            public IfxOutputStream run() throws IOException {
                IfxOutputStream tmpStreamDo = new IfxOutputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
    }
}

