/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IntervalDF
extends Interval {
    protected long seconds;
    protected long nanos;
    String locale = null;
    protected static final int NanosPerSecond = 1000000000;
    protected static final int MilliPerSecond = 1000;
    protected static final int SecondsPerMinute = 60;
    protected static final int SecondsPerHour = 3600;
    protected static final int SecondsPerDay = 86400;

    public IntervalDF() throws SQLException {
        this.setQualifier((byte)4, (byte)15);
    }

    public IntervalDF(Connection conn) throws SQLException {
        this();
        this.setConnection(conn);
    }

    public IntervalDF(Timestamp t1, Timestamp t2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(t1, t2);
    }

    public IntervalDF(Timestamp t1, Timestamp t2, Connection conn) throws SQLException {
        this(t1, t2);
        this.setConnection(conn);
    }

    public IntervalDF(long seconds, long nanos) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(seconds, nanos);
    }

    public IntervalDF(long seconds, long nanos, Connection conn) throws SQLException {
        this(seconds, nanos);
        this.setConnection(conn);
    }

    public IntervalDF(long seconds, long nanos, short qual) throws SQLException {
        this.setQualifier(qual);
        this.set(seconds, nanos);
    }

    public IntervalDF(long seconds, long nanos, short qual, Connection conn) throws SQLException {
        this(seconds, nanos, qual);
        this.setConnection(conn);
    }

    public IntervalDF(String str) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(str);
    }

    public IntervalDF(String str, Connection conn) throws SQLException {
        this(str);
        this.setConnection(conn);
    }

    public IntervalDF(String str, short qual) throws SQLException {
        this.setQualifier(qual);
        this.set(str);
    }

    public IntervalDF(String str, short qual, Connection conn) throws SQLException {
        this(str, qual);
        this.set(str);
        this.setConnection(conn);
    }

    public IntervalDF(String str, int len, byte startCode, byte endCode) throws SQLException {
        this.setQualifier((byte)len, startCode, endCode);
        this.set(str);
    }

    public IntervalDF(String str, byte startCode, byte endCode) throws SQLException {
        this.setQualifier((byte)2, startCode, endCode);
        this.set(str);
    }

    public IntervalDF(String str, int len, byte startCode, byte endCode, Connection conn) throws SQLException {
        this(str, len, startCode, endCode);
        this.setConnection(conn);
    }

    public void set(Timestamp t1, Timestamp t2) {
        long t1_seconds = t1.getTime() / 1000L;
        long t2_seconds = t2.getTime() / 1000L;
        long seconds = t1_seconds - t2_seconds;
        long nanos = t1.getNanos() - t2.getNanos();
        this.set(seconds, nanos);
    }

    public void set(long seconds, long nanos) {
        if (seconds < 0L) {
            if (nanos > 0L) {
                ++seconds;
                nanos -= 1000000000L;
            }
        } else if (nanos < 0L && seconds > 0L) {
            --seconds;
            nanos += 1000000000L;
        }
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public void set(String str) throws SQLException {
        this.fromString(str);
    }

    public String toString() {
        int insertIdx;
        long secs = this.seconds;
        long nans = this.nanos;
        StringBuilder retval = new StringBuilder();
        short qual = this.getQualifier();
        int endCode = IntervalDF.getEndCode(qual);
        byte startCode = IntervalDF.getStartCode(qual);
        boolean intervalNegative = false;
        if (this.seconds < 0L || this.seconds == 0L && this.nanos < 0L) {
            intervalNegative = true;
            secs = -this.seconds;
            nans = -nans;
        }
        if (startCode == 4) {
            long days = secs / 86400L;
            secs %= 86400L;
            retval.append(days);
            if (endCode > 4) {
                retval.append(dtdelim[2]);
            }
        }
        if (startCode <= 6 && endCode >= 6) {
            long hours = secs / 3600L;
            secs %= 3600L;
            if (hours < 10L) {
                retval.append('0');
            }
            retval.append(hours);
            if (endCode > 6) {
                retval.append(dtdelim[3]);
            }
        }
        if (startCode <= 8 && endCode >= 8) {
            long mins = secs / 60L;
            secs %= 60L;
            if (mins < 10L) {
                retval.append('0');
            }
            retval.append(mins);
            if (endCode > 8) {
                retval.append(dtdelim[4]);
            }
        }
        if (startCode <= 10 && endCode >= 10) {
            if (secs < 10L) {
                retval.append('0');
            }
            retval.append(secs);
        }
        if (endCode > 10) {
            retval.append(dtdelim[5]);
            if (nans == 0L) {
                for (int i = 11; i <= endCode; ++i) {
                    retval.append('0');
                }
            } else {
                int i;
                int numDigsNeeded = endCode - 10;
                int numDigs = 0;
                long scale = 100000000L;
                for (i = 11; i <= endCode && nans != 0L; ++i) {
                    if (nans < scale) {
                        retval.append('0');
                        ++numDigs;
                    } else {
                        retval.append((long)((int)nans) / scale);
                        ++numDigs;
                        nans %= scale;
                    }
                    scale /= 10L;
                }
                for (i = numDigs; i < numDigsNeeded; ++i) {
                    retval.append('0');
                }
            }
        }
        int lastPos = retval.length() - 1;
        for (insertIdx = 0; insertIdx < lastPos && retval.charAt(insertIdx) == '0' && Character.isDigit(retval.charAt(insertIdx + 1)); ++insertIdx) {
            retval.setCharAt(insertIdx, ' ');
        }
        if (intervalNegative) {
            retval.insert(insertIdx, '-');
        }
        return retval.toString();
    }

    public void fromString(String str) throws SQLException {
        if (str == null) {
            return;
        }
        short qual = this.getQualifier();
        str = str.trim();
        boolean isNegative = false;
        if (str.length() > 0 && (str.charAt(0) == '-' || str.charAt(0) == '+')) {
            if (str.length() == 1) {
                throw IfxErrMsg.getLocSQLException(-79706, this.locale);
            }
            if (str.charAt(0) == '-') {
                isNegative = true;
            }
            str = str.substring(1);
        }
        int[] data = this.stringToUnits(str, qual);
        this.seconds = (long)data[2] * 86400L;
        this.seconds += (long)data[3] * 3600L;
        this.seconds += (long)data[4] * 60L;
        this.seconds += (long)data[5];
        this.nanos = data[6];
        if (isNegative) {
            this.seconds = -this.seconds;
            this.nanos = -this.nanos;
        }
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoSeconds() {
        return this.nanos;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (int)(this.nanos ^ this.nanos >>> 32);
        result = 31 * result + (int)(this.seconds ^ this.seconds >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalDF other = (IntervalDF)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.nanos != other.nanos) {
            return false;
        }
        return this.seconds == other.seconds;
    }

    public boolean greaterThan(IntervalDF other) {
        boolean retval = false;
        if (other != null) {
            long otherSeconds = other.getSeconds();
            retval = this.seconds > otherSeconds ? true : this.seconds == otherSeconds && this.nanos > other.getNanoSeconds();
        }
        return retval;
    }

    public boolean lessThan(IntervalDF other) {
        boolean retval = false;
        if (other != null) {
            long otherSeconds = other.getSeconds();
            retval = this.seconds < otherSeconds ? true : this.seconds == otherSeconds && this.nanos < other.getNanoSeconds();
        }
        return retval;
    }

    private void setQualifier(byte startCode, byte endCode) throws SQLException {
        this.setQualifier((byte)2, startCode, endCode);
    }

    public void setQualifier(byte len, byte startCode, byte endCode) throws SQLException {
        if (startCode < 4 || endCode < 4 || startCode > endCode) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = (short)(endCode - startCode + len << 8 | startCode << 4 | endCode);
    }

    public void setQualifier(short qualifier) throws SQLException {
        byte endCode;
        byte startCode = IntervalDF.getStartCode(qualifier);
        if (startCode > (endCode = IntervalDF.getEndCode(qualifier)) && startCode == 12 && endCode == 11) {
            endCode = startCode;
        }
        if (startCode < 4 || endCode < 4 || startCode > endCode) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = qualifier;
    }
}

