/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.icbc.api.internal.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    public String getAttributeName() {
        return "secure";
    }
}

