/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.methods.HttpExecutionAware;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalClientExec;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalState;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import java.io.IOException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> resultFuture;
    private final InternalClientExec exec;
    private final InternalState state;

    public DefaultClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpClientContext localContext, BasicFuture<T> resultFuture, NHttpClientConnectionManager connmgr, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy, InternalClientExec exec) {
        super(log, localContext, resultFuture, connmgr, connReuseStrategy, keepaliveStrategy);
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.resultFuture = resultFuture;
        this.exec = exec;
        this.state = new InternalState(this.getId(), requestProducer, responseConsumer, localContext);
    }

    @Override
    void releaseResources() {
        try {
            this.requestProducer.close();
        }
        catch (IOException ex) {
            this.log.debug((Object)"I/O error closing request producer", (Throwable)ex);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException ex) {
            this.log.debug((Object)"I/O error closing response consumer", (Throwable)ex);
        }
    }

    @Override
    void executionFailed(Exception ex) {
        this.requestProducer.failed(ex);
        this.responseConsumer.failed(ex);
    }

    @Override
    boolean executionCancelled() {
        boolean cancelled = this.responseConsumer.cancel();
        T result = this.responseConsumer.getResult();
        Exception ex = this.responseConsumer.getException();
        if (ex != null) {
            this.resultFuture.failed(ex);
        } else if (result != null) {
            this.resultFuture.completed(result);
        } else {
            this.resultFuture.cancel();
        }
        return cancelled;
    }

    public void start() throws HttpException, IOException {
        HttpHost target = this.requestProducer.getTarget();
        HttpRequest original = this.requestProducer.generateRequest();
        if (original instanceof HttpExecutionAware) {
            ((HttpExecutionAware)((Object)original)).setCancellable(this);
        }
        this.exec.prepare(target, original, this.state, this);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.exec.generateRequest(this.state, this);
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.exec.produceContent(this.state, encoder, ioctrl);
    }

    @Override
    public void requestCompleted() {
        this.exec.requestCompleted(this.state, this);
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        this.exec.responseReceived(response, this.state, this);
    }

    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.exec.consumeContent(this.state, decoder, ioctrl);
        if (!decoder.isCompleted() && this.responseConsumer.isDone()) {
            this.markConnectionNonReusable();
            try {
                this.markCompleted();
                this.releaseConnection();
                this.resultFuture.cancel();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void responseCompleted() throws IOException, HttpException {
        this.exec.responseCompleted(this.state, this);
        if (this.state.getFinalResponse() != null || this.resultFuture.isDone()) {
            try {
                this.markCompleted();
                this.releaseConnection();
                T result = this.responseConsumer.getResult();
                Exception ex = this.responseConsumer.getException();
                if (ex == null) {
                    this.resultFuture.completed(result);
                }
                this.resultFuture.failed(ex);
            }
            finally {
                this.close();
            }
        } else {
            NHttpClientConnection localConn = this.getConnection();
            if (localConn != null && !localConn.isOpen()) {
                this.releaseConnection();
                localConn = null;
            }
            if (localConn != null) {
                localConn.requestOutput();
            } else {
                this.requestConnection();
            }
        }
    }

    @Override
    public void inputTerminated() {
        if (!this.isCompleted()) {
            this.requestConnection();
        } else {
            this.close();
        }
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

