/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.EntityAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseProducer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

public class BasicAsyncResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncResponseProducer(HttpResponse response, HttpAsyncContentProducer producer) {
        Args.notNull(response, "HTTP response");
        Args.notNull(producer, "HTTP content producer");
        this.response = response;
        this.producer = producer;
    }

    public BasicAsyncResponseProducer(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        this.response = response;
        HttpEntity entity = response.getEntity();
        this.producer = entity != null ? (entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)entity) : new EntityAsyncContentProducer(entity)) : null;
    }

    public HttpResponse generateResponse() {
        return this.response;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(encoder, ioctrl);
            if (encoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    public void responseCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.response);
        if (this.producer != null) {
            buf.append(" ").append(this.producer);
        }
        return buf.toString();
    }
}

