/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        Boolean value = (Boolean)object;
        if (value == null) {
            out.writeNull(SerializerFeature.WriteNullBooleanAsFalse);
            return;
        }
        if (value.booleanValue()) {
            out.write("true");
        } else {
            out.write("false");
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Boolean boolObj;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            boolObj = Boolean.TRUE;
        } else if (lexer.token() == 7) {
            lexer.nextToken(16);
            boolObj = Boolean.FALSE;
        } else if (lexer.token() == 2) {
            int intValue = lexer.intValue();
            lexer.nextToken(16);
            boolObj = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
        } else {
            Object value = parser.parse();
            if (value == null) {
                return null;
            }
            boolObj = TypeUtils.castToBoolean(value);
        }
        if (clazz == AtomicBoolean.class) {
            return (T)new AtomicBoolean(boolObj);
        }
        return (T)boolObj;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

